/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.Message;
import oracle.ojc.interfaces.ErrorInfo;
import oracle.ojc.interfaces.Storage;

public final class Warning
extends Message {
    static final int MAX_WARNING_INDEX = 1000;
    static BitSet defaults;
    static BitSet warnings;

    Warning(Storage storage, ErrorInfo message, int pos) {
        super(storage, message, pos);
    }

    Warning(Storage storage, ErrorInfo message, int pos, String s1) {
        super(storage, message, pos, s1);
    }

    Warning(Storage storage, ErrorInfo message, int pos, String s1, String s2) {
        super(storage, message, pos, s1, s2);
    }

    Warning(Storage storage, ErrorInfo message, int pos, String s1, String s2, String s3) {
        super(storage, message, pos, s1, s2, s3);
    }

    public static void defaultWarning(int number) {
        warnings.set(number, defaults.get(number));
    }

    public static void enableWarning(int number) {
        if (number < 1000) {
            warnings.set(number);
        }
    }

    public static void disableWarning(int number) {
        if (number < 1000) {
            warnings.clear(number);
        }
    }

    public static void defaultAllWarnings() {
        warnings = (BitSet)defaults.clone();
    }

    public static void enableAllWarnings() {
        warnings.set(0, 1000);
    }

    public static void disableAllWarnings() {
        warnings.clear();
    }

    public static boolean isEmpty() {
        return warnings.isEmpty();
    }

    public static boolean isEnabled(int number) {
        return warnings.get(number);
    }

    static {
        warnings = new BitSet(1000);
        Warning.disableAllWarnings();
        defaults = (BitSet)warnings.clone();
    }
}

