/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.IdentifierList;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.PackageSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.StorageScope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.TypeVariableSymbol;
import oracle.ojc.compiler.UnresolvedSymbol;

final class UnresolvedClassSymbol
extends ClassSymbol {
    UnresolvedClassSymbol baseQualifier;
    IdentifierList qualifierList;
    Symbol[] declList;
    TypeVariableList typeVariableList;
    static final /* synthetic */ boolean $assertionsDisabled;

    UnresolvedClassSymbol(UnresolvedSymbol unresolvedSymbol, TypeVariableList typeVariableList, Scope currentScope) {
        super(unresolvedSymbol.pos, unresolvedSymbol.identifier, (byte)10, (short)0, null);
        int size;
        this.qualifierList = unresolvedSymbol.qualifierList;
        this.scope = currentScope;
        this.typeVariableList = typeVariableList;
        if (currentScope.declList != null && (size = currentScope.declList.size()) > 0) {
            this.declList = currentScope.declList.toArray(new Symbol[size]);
        }
    }

    UnresolvedClassSymbol(String qualifiedName, TypeVariableList typeVariableList, Scope currentScope) {
        super(0, null, (byte)10, (short)0, null);
        int size;
        int index;
        IdentifierList last = null;
        while ((index = qualifiedName.indexOf(46)) >= 0) {
            IdentifierList il = new IdentifierList(0, Identifier.getIdentifier(qualifiedName.substring(0, index)));
            if (last == null) {
                last = this.qualifierList = il;
            } else {
                last.next = il;
                last = il;
            }
            qualifiedName = qualifiedName.substring(index + 1);
        }
        this.identifier = Identifier.getIdentifier(qualifiedName);
        this.scope = currentScope;
        this.typeVariableList = typeVariableList;
        if (currentScope.declList != null && (size = currentScope.declList.size()) > 0) {
            this.declList = currentScope.declList.toArray(new Symbol[size]);
        }
    }

    UnresolvedClassSymbol(IdentifierList qualifierList, Identifier identifier, TypeVariableList typeVariableList, Scope currentScope) {
        super(0, identifier, (byte)10, (short)0, null);
        int size;
        this.qualifierList = qualifierList;
        this.scope = currentScope;
        this.typeVariableList = typeVariableList;
        if (currentScope.declList != null && (size = currentScope.declList.size()) > 0) {
            this.declList = currentScope.declList.toArray(new Symbol[size]);
        }
    }

    UnresolvedClassSymbol(UnresolvedClassSymbol baseQualifier, IdentifierList qualifierList, Identifier identifier, TypeVariableList typeVariableList) {
        super(0, identifier, (byte)10, (short)0, null);
        this.baseQualifier = baseQualifier;
        this.qualifierList = qualifierList;
        this.typeVariableList = typeVariableList;
    }

    public String toString() {
        if (this.qualifierList != null) {
            StringBuffer sb = new StringBuffer(this.qualifierList.toString());
            sb.append('.');
            sb.append(this.identifier.name);
            return sb.toString();
        }
        return this.identifier.toString();
    }

    boolean isErroneous() {
        return false;
    }

    String errorName() {
        return this.identifier.toString();
    }

    boolean isUnresolvedType() {
        return true;
    }

    void resolveActualTypeParameters(Parser parser, int pos, boolean mustBePublic) {
        TypeVariableList tvl = this.typeVariableList;
        while (tvl != null) {
            TypeSymbol typeSymbol = tvl.typeVariable.refSymbol;
            if (typeSymbol != null && !typeSymbol.isTypeParameter()) {
                tvl.typeVariable.refSymbol = typeSymbol.resolveType(parser, tvl.typeVariable.pos, mustBePublic, true, false, true);
            }
            tvl = tvl.next;
        }
    }

    TypeSymbol resolveType(Parser parser, int pos, boolean mustBePublic, boolean checkActualTypeParameters, boolean lazy) {
        return this.resolveType(parser, pos, mustBePublic, checkActualTypeParameters, lazy, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TypeSymbol resolveType(Parser parser, int pos, boolean mustBePublic, boolean checkActualTypeParameters, boolean lazy, boolean checkAccess) {
        RawClassSymbol classSymbol;
        PackageScope packageScope;
        Symbol[] dl;
        boolean classQualifier;
        Scope scope;
        ParameterizedClassSymbol outerClass;
        Symbol symbol;
        block53: {
            IdentifierList il;
            block51: {
                Scope scp;
                block50: {
                    if (this.baseQualifier != null) {
                        symbol = this.baseQualifier.resolveType(parser, pos, mustBePublic, checkActualTypeParameters, false);
                        if (symbol == TypeSymbol.errorSymbol) {
                            return ParameterizedClassSymbol.errorClass;
                        }
                        outerClass = (ParameterizedClassSymbol)symbol;
                        this.scope = scope = outerClass.getClassScope();
                    } else {
                        outerClass = null;
                        scope = this.scope;
                    }
                    classQualifier = false;
                    dl = null;
                    il = this.qualifierList;
                    try {
                        if (il == null) {
                            dl = this.declList;
                            if (!$assertionsDisabled && scope.declList != null) {
                                throw new AssertionError();
                            }
                            scope.enterDeclarations(dl);
                            scp = scope;
                            break block50;
                        }
                        symbol = scope.lookupSpecificSymbol(il.identifier, 32, false);
                        if (symbol != null) break block51;
                        parser.findSourceFileForIdentifier(parser.currentPackageScope, il.identifier);
                        symbol = parser.globalScope.lookupSpecificSymbol(il.identifier, 16, false);
                        while (true) {
                            PackageSymbol packageSymbol;
                            if (symbol == null) {
                                symbol = scope.lookupSpecificSymbolInScope(il.identifier, 32, false);
                                if (symbol != null) break block51;
                                if (il == this.qualifierList) {
                                    scope = parser.globalScope;
                                }
                                packageScope = new PackageScope(parser, (StorageScope)scope);
                                packageSymbol = new PackageSymbol(pos, il.identifier, packageScope);
                                scope.enterSymbol(packageSymbol);
                                packageScope.packageSymbol = packageSymbol;
                                packageScope.readPackage();
                                scope = packageScope;
                            } else {
                                packageSymbol = (PackageSymbol)symbol;
                                scope = packageSymbol.packageScope;
                            }
                            il = il.next;
                            if (il != null) {
                                symbol = scope.lookupSpecificSymbolInScope(il.identifier, 16, false);
                                continue;
                            }
                            break block51;
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var22_28 = null;
                        if (dl != null) {
                            this.scope.removeDeclarations(dl);
                        }
                        throw throwable;
                    }
                }
                while (scp.kind >= 2) {
                    if (scp.kind == 2) {
                        classSymbol = ((ClassScope)scp).classSymbol;
                        if (classSymbol.isErroneous()) {
                            ParameterizedClassSymbol parameterizedClassSymbol = ParameterizedClassSymbol.errorClass;
                            Object var22_21 = null;
                            if (dl == null) return parameterizedClassSymbol;
                            this.scope.removeDeclarations(dl);
                            return parameterizedClassSymbol;
                        }
                        classSymbol.resolveType(parser, 0, false, false, false);
                    }
                    if ((symbol = scp.lookupSpecificSymbolInScope(this.identifier, 32, false)) != null && symbol instanceof TypeParameterSymbol) {
                        TypeParameterSymbol tps = (TypeParameterSymbol)symbol;
                        if (tps.definingSymbol != null && !tps.isMethodTypeParameter() && parser.isInStaticContext(tps)) {
                            parser.error(Message.errorUndefinedThis, pos, tps.isErroneous(), tps.errorName());
                        }
                        if (!tps.isMethodTypeParameter() && parser.currentClassSymbol != null && parser.currentClassSymbol.isInnerClass() && tps.definingSymbol != null && parser.currentClassSymbol != tps.definingSymbol) {
                            parser.currentClassSymbol.symbolFlags = (byte)(parser.currentClassSymbol.symbolFlags | 8);
                        }
                        TypeParameterSymbol typeParameterSymbol = tps;
                        Object var22_22 = null;
                        if (dl == null) return typeParameterSymbol;
                        this.scope.removeDeclarations(dl);
                        return typeParameterSymbol;
                    }
                    scp = scp.getOuterScope();
                }
                break block53;
            }
            while (il != null) {
                symbol = scope.lookupSpecificSymbol(il.identifier, 32, false);
                if (symbol == null) {
                    parser.error(Message.errorNotFound, il.pos, false, Message.classString + " " + il.identifier.toString(), "");
                    ParameterizedClassSymbol parameterizedClassSymbol = ParameterizedClassSymbol.errorClass;
                    Object var22_23 = null;
                    if (dl == null) return parameterizedClassSymbol;
                    this.scope.removeDeclarations(dl);
                    return parameterizedClassSymbol;
                }
                classSymbol = ((ClassSymbol)symbol).getClassSymbol();
                classSymbol.resolveType(parser, pos, false, false, false);
                if (outerClass != null) {
                    outerClass = ParameterizedClassSymbol.getParameterizedClassSymbol(classSymbol, null, outerClass);
                }
                scope = classSymbol.classScope;
                classQualifier = true;
                il = il.next;
            }
        }
        while (scope.kind >= 2) {
            if (scope.kind == 2) {
                classSymbol = ((ClassScope)scope).classSymbol;
                if (classSymbol.isAnonymousInnerClass() && classSymbol.getSuperClassSymbol() instanceof UnresolvedClassSymbol) {
                    symbol = classSymbol.classScope.lookupSpecificSymbolInScope(this.identifier, 32, false);
                } else {
                    classSymbol.resolveType(parser, 0, false, false, false);
                    symbol = classSymbol.lookupSpecificSymbolInClass(parser, this.identifier, 32, false);
                }
            } else {
                symbol = scope.lookupSpecificSymbolInScope(this.identifier, 32, false);
            }
            if (symbol != null && symbol instanceof RawClassSymbol) {
                classSymbol = (RawClassSymbol)symbol;
                if (!lazy) {
                    classSymbol.resolveType(parser, 0, mustBePublic, checkActualTypeParameters, lazy);
                }
                if (classSymbol.isLocalInnerClass() && 0 <= pos && pos < classSymbol.pos && classSymbol.isInnerClass(parser.currentMethodSymbol)) {
                    parser.error(Message.errorNotFound, pos, false, symbol.errorName(), Message.inString + " " + parser.currentMethodSymbol.errorName());
                }
                if (checkAccess) {
                    this.checkClassAccess(parser, classSymbol, pos);
                }
                if (this.qualifierList == null && this.scope != null) {
                    if (classSymbol.isInnerClass() && !classSymbol.isLocalInnerClass()) {
                        scope = this.scope;
                        while (scope.kind > 2) {
                            scope = scope.getOuterScope();
                        }
                        if (scope.kind == 2 && !((ClassScope)scope).classSymbol.isAnonymousInnerClass()) {
                            parser.addAmbiguityCheck(((ClassScope)scope).classSymbol, classSymbol);
                        }
                    }
                    classSymbol.checkForAmbigousImport(parser, pos, this.scope, (short)32);
                }
                if (dl != null) {
                    this.scope.removeDeclarations(dl);
                    dl = null;
                }
                this.resolveActualTypeParameters(parser, pos, mustBePublic);
                ParameterizedClassSymbol pcs = ParameterizedClassSymbol.getParameterizedClassSymbol(classSymbol, this.typeVariableList, outerClass);
                pcs.pos = pos;
                if (checkActualTypeParameters) {
                    pcs.checkActualTypeParameters(parser, pos);
                }
                ParameterizedClassSymbol parameterizedClassSymbol = pcs;
                Object var22_24 = null;
                if (dl == null) return parameterizedClassSymbol;
                this.scope.removeDeclarations(dl);
                return parameterizedClassSymbol;
            }
            scope = scope.getOuterScope();
        }
        if (classQualifier && scope.kind < 2) {
            String errorString = parser.currentMethodSymbol != null && !parser.currentMethodSymbol.isErroneous() ? Message.inString + " " + parser.currentMethodSymbol.errorName() : (parser.currentClassSymbol != null ? Message.inString + " " + parser.currentClassSymbol.errorName() : "");
            parser.error(Message.errorNotFound, pos, false, Message.classString + " " + this.identifier.toString(), errorString);
            ParameterizedClassSymbol parameterizedClassSymbol = ParameterizedClassSymbol.errorClass;
            Object var22_25 = null;
            if (dl == null) return parameterizedClassSymbol;
            this.scope.removeDeclarations(dl);
            return parameterizedClassSymbol;
        }
        symbol = scope.lookupSpecificSymbol(this.identifier, 32, this.qualifierList != null);
        if (symbol != null) {
            classSymbol = (RawClassSymbol)symbol;
        } else {
            classSymbol = new RawClassSymbol(pos, this.identifier, 0, null, null, true, false);
            scope.enterSymbol(classSymbol);
        }
        classSymbol.resolveType(parser, pos, false, false, lazy);
        if (mustBePublic && classSymbol.getTopLevelClass().scope != parser.currentPackageScope && (classSymbol.access & 1) == 0) {
            packageScope = (PackageScope)classSymbol.getTopLevelClass().scope;
            parser.error(Message.errorNotPublic, pos, classSymbol.isErroneous(), classSymbol.errorName(), packageScope.packageSymbol.errorName());
        } else if (checkAccess) {
            this.checkClassAccess(parser, classSymbol, pos);
        }
        if (this.qualifierList == null) {
            if (classSymbol.isInnerClass() && !classSymbol.isLocalInnerClass()) {
                scope = this.scope;
                while (scope.kind > 2) {
                    scope = scope.getOuterScope();
                }
                if (scope.kind == 2) {
                    parser.addAmbiguityCheck(((ClassScope)scope).classSymbol, classSymbol);
                }
            }
            classSymbol.checkForAmbigousImport(parser, pos, this.scope, (short)32);
        }
        if (classSymbol.isErroneous()) {
            ParameterizedClassSymbol parameterizedClassSymbol = ParameterizedClassSymbol.errorClass;
            Object var22_26 = null;
            if (dl == null) return parameterizedClassSymbol;
            this.scope.removeDeclarations(dl);
            return parameterizedClassSymbol;
        }
        Object var22_27 = null;
        if (dl != null) {
            this.scope.removeDeclarations(dl);
        }
        this.resolveActualTypeParameters(parser, pos, mustBePublic);
        ParameterizedClassSymbol pcs = ParameterizedClassSymbol.getParameterizedClassSymbol(classSymbol, this.typeVariableList, outerClass);
        pcs.pos = pos;
        if (checkActualTypeParameters) {
            pcs.checkActualTypeParameters(parser, pos);
        }
        return pcs;
    }

    private void checkClassAccess(Parser parser, RawClassSymbol classSymbol, int pos) {
        if (this.qualifierList != null && parser.currentClassSymbol != null && parser.currentClassSymbol.isCompiled() && (classSymbol.access & 1) == 0 && !classSymbol.isAccessible(parser.currentClassSymbol)) {
            parser.error(Message.errorAccessError, pos, classSymbol.isErroneous(), classSymbol.errorName());
        }
    }

    void changeScope(Scope scope) {
        this.scope = scope;
        if (this.baseQualifier != null) {
            this.baseQualifier.changeScope(scope);
        }
        TypeVariableList tvl = this.typeVariableList;
        while (tvl != null) {
            tvl.typeVariable.changeScope(scope);
            tvl = tvl.next;
        }
    }

    TypeSymbol replaceUnresolvedTypeParameters(TypeParameterList tpl) {
        if (this.baseQualifier == null && this.qualifierList == null && this.typeVariableList == null) {
            while (tpl != null) {
                if (this.identifier == tpl.typeParameter.identifier) {
                    return tpl.typeParameter;
                }
                tpl = tpl.next;
            }
        } else {
            if (this.baseQualifier != null) {
                this.baseQualifier = (UnresolvedClassSymbol)this.baseQualifier.replaceUnresolvedTypeParameters(tpl);
            }
            TypeVariableList tvl = this.typeVariableList;
            while (tvl != null) {
                tvl.typeVariable = (TypeVariableSymbol)tvl.typeVariable.replaceUnresolvedTypeParameters(tpl);
                tvl = tvl.next;
            }
        }
        return this;
    }

    TypeSymbol replaceTypeParameters(TypeParameterList tpl) {
        if (this.baseQualifier != null) {
            this.baseQualifier = (UnresolvedClassSymbol)this.baseQualifier.replaceTypeParameters(tpl);
        }
        TypeVariableList tvl = this.typeVariableList;
        while (tvl != null) {
            tvl.typeVariable = (TypeVariableSymbol)tvl.typeVariable.replaceTypeParameters(tpl);
            tvl = tvl.next;
        }
        return this;
    }

    RawClassSymbol getClassSymbol() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    ClassSymbol getSuperClassSymbol() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    ClassSymbol getInterface(RawClassSymbol interfaceSymbol) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    ImplementationList getImplementationList() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    void checkForOutOfPackageInnerClasses(ConstantPool constantPool, RawClassSymbol outerClass) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    static {
        $assertionsDisabled = !UnresolvedClassSymbol.class.desiredAssertionStatus();
    }
}

