/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnaryExpression;

final class UnaryPlusExpression
extends UnaryExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    UnaryPlusExpression(int pos, Expression operand) {
        super((byte)38, pos, operand);
    }

    Expression foldExpression() {
        if (this.operand.kind == 2) {
            return this.operand;
        }
        return this;
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol primitiveType;
        Expression op = this.operand.resolveAndCheck(parser);
        TypeSymbol typeSymbol = op.getType();
        if (!(typeSymbol.isNumericType() || parser.parsingAtLeastOneFive && typeSymbol.isReferenceType() && (primitiveType = BoxingExpression.getPrimitiveType(parser, typeSymbol)) != null && primitiveType.isNumericType())) {
            Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, typeSymbol.isErroneous(), this.toString(), typeSymbol.errorName());
            return new ErrorExpression(error);
        }
        return op.promoteType(parser, TypeSymbol.unaryNumericPromotion(parser, typeSymbol));
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return "+";
    }

    static {
        $assertionsDisabled = !UnaryPlusExpression.class.desiredAssertionStatus();
    }
}

