/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.NullConstantExpression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.TryStatement;
import oracle.ojc.compiler.TypeSymbol;

final class ThrowStatement
extends Statement {
    Expression throwExpr;

    ThrowStatement(StatementList parent, int pos, Expression throwExpr) {
        super(parent, pos, (byte)16);
        this.throwExpr = throwExpr;
    }

    private boolean checkConstructorThrowsLists(RawClassSymbol classSymbol, ClassSymbol thrownClass) {
        MethodSymbol constructorSymbol = (MethodSymbol)classSymbol.classScope.lookupSymbolInScope(Identifier.initializerIdentifier, false);
        while (constructorSymbol != null) {
            if (!constructorSymbol.checkThrowsList(thrownClass)) {
                return false;
            }
            constructorSymbol = constructorSymbol.nextWithSameName;
        }
        return true;
    }

    void resolveAndCheck(Parser parser) {
        ClassSymbol thrownClass;
        Expression expr = this.throwExpr.resolveAndCheck(parser);
        TypeSymbol exprType = expr.getType();
        byte typeKind = exprType.typeKind;
        if (typeKind != 10) {
            parser.error(Message.errorIncompatibleTypes, expr.pos, typeKind == 0, exprType.errorName(), parser.javaLangThrowableSymbol.errorName());
            thrownClass = parser.javaLangThrowableSymbol;
        } else if (expr instanceof NullConstantExpression) {
            thrownClass = parser.javaLangNullPointerExceptionSymbol;
        } else {
            thrownClass = (ClassSymbol)exprType;
            if (!thrownClass.isErroneous()) {
                if (!thrownClass.equalTo(parser.javaLangThrowableSymbol) && !parser.javaLangThrowableSymbol.isSuperclass(thrownClass)) {
                    parser.error(Message.errorIncompatibleTypes, expr.pos, false, thrownClass.errorName(), parser.javaLangThrowableSymbol.errorName());
                }
                if (!TryStatement.catchesType(parser, thrownClass) && thrownClass.isCheckedException(parser)) {
                    if (parser.currentMethodSymbol.identifier == Identifier.dynamicInitializerIdentifier) {
                        if (!this.checkConstructorThrowsLists(parser.currentClassSymbol, thrownClass)) {
                            parser.error(Message.errorUnreportedException, expr.pos, false, thrownClass.errorName());
                        }
                    } else if (!parser.currentMethodSymbol.checkThrowsList(thrownClass)) {
                        parser.error(Message.errorUnreportedException, expr.pos, false, thrownClass.errorName());
                    }
                }
            }
        }
        this.throwExpr = expr;
        this.parent.updateDefUseSetsAfterThrow(parser, thrownClass);
        if (!parser.suspendDataFlowChecking && !parser.currentMethodSymbol.isConstructor()) {
            if (parser.exitDefSet == null) {
                parser.exitDefSet = (BitSet)parser.defSet.clone();
            } else {
                parser.exitDefSet.or(parser.defSet);
            }
        }
        this.setLastStatement();
        if (this.next != null && this.next.isCodeStatement()) {
            parser.error(Message.errorUnreachableStatement, this.next.pos, false);
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        this.throwExpr.generateByteCode(byteCodeGenerator);
        byteCodeGenerator.generate_8((byte)-65);
        byteCodeGenerator.decOpStackHeight(1);
    }

    boolean isLoopExitStatement() {
        return true;
    }

    boolean canReachNextStatement(boolean strict) {
        return false;
    }
}

