/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ThisExpression;
import oracle.ojc.compiler.TypeSymbol;

final class SuperExpression
extends ThisExpression {
    Expression outerClassExpr;
    static final /* synthetic */ boolean $assertionsDisabled;

    SuperExpression(int pos, RawClassSymbol classSymbol, Expression outerClassExpr) {
        super(pos, classSymbol);
        this.outerClassExpr = outerClassExpr;
    }

    Expression resolveAndCheck(Parser parser) {
        if (parser.currentMethodSymbol != null && (parser.currentMethodSymbol.access & 8) != 0 || parser.currentFieldSymbol != null && (parser.currentFieldSymbol.access & 8) != 0) {
            Error error = parser.error(Message.errorUndefinedThis, this.pos, false, "'super'");
            return new ErrorExpression(error);
        }
        if (this.outerClassSymbol != null) {
            if (!$assertionsDisabled && this.outerClassExpr != null) {
                throw new AssertionError();
            }
            TypeSymbol outerType = this.outerClassSymbol.resolveType(parser, this.pos, true, true, false);
            if (outerType.typeKind != 10) {
                Error error = parser.error(Message.errorObjectRequired, this.pos, outerType.isErroneous(), outerType.errorName());
                return new ErrorExpression(error);
            }
            this.outerClassSymbol = ((ClassSymbol)outerType).getClassSymbol();
            if (this.classSymbol.equalTo(this.outerClassSymbol)) {
                this.outerClassSymbol = null;
                this.setType(this.classSymbol.getSuperClassSymbol());
            } else {
                if (!this.classSymbol.isInnerClass((RawClassSymbol)this.outerClassSymbol)) {
                    Error error = parser.error(Message.errorIllegalQualifier, this.pos, false, "'super'");
                    return new ErrorExpression(error);
                }
                RawClassSymbol innerClass = this.classSymbol;
                while (!innerClass.equalTo(this.outerClassSymbol) && innerClass.isInnerClass()) {
                    if ((innerClass.access & 8) != 0) {
                        Error error = parser.error(Message.errorUndefinedThis, this.pos, false, "'super'");
                        return new ErrorExpression(error);
                    }
                    innerClass = innerClass.getOuterClass();
                }
                this.setType(((RawClassSymbol)this.outerClassSymbol).getSuperClassSymbol());
            }
        } else {
            if (this.outerClassExpr != null) {
                this.outerClassExpr = this.outerClassExpr.resolveAndCheck(parser);
            }
            if (this.classSymbol.getSuperClassSymbol() == null) {
                Error error = parser.error(Message.errorNoSuperclass, this.pos, false);
                return new ErrorExpression(error);
            }
            this.setType(this.classSymbol.getSuperClassSymbol());
        }
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (!byteCodeGenerator.parser.currentMethodSymbol.isConstructor() || this.outerClassSymbol == null) {
            byteCodeGenerator.loadLocalVariable(this.getType(), (short)0);
        }
        if (this.outerClassSymbol != null) {
            byteCodeGenerator.generateOuterClassFieldAccessor((RawClassSymbol)this.outerClassSymbol, this.classSymbol, true);
        } else if (this.outerClassExpr != null) {
            this.outerClassExpr.generateByteCode(byteCodeGenerator);
        }
    }

    static {
        $assertionsDisabled = !SuperExpression.class.desiredAssertionStatus();
    }
}

