/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

final class StringConstantExpression
extends ConstantExpression {
    char[] sval;

    StringConstantExpression(int pos, TypeSymbol stringType, char[] sval) {
        super(pos, stringType);
        this.sval = sval;
    }

    Expression copyConstantExpression(int newPos) {
        return new StringConstantExpression(newPos, this.getType(), this.sval);
    }

    Expression resolveAndCheck(Parser parser) {
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        byteCodeGenerator.generateStringConst(this.sval);
        byteCodeGenerator.incOpStackHeight(1);
    }
}

