/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.HashSet;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.IdentifierList;
import oracle.ojc.compiler.ImportSymbol;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.PackageScope;
import oracle.ojc.compiler.PackageSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnresolvedClassSymbol;

abstract class StorageScope
extends Scope {
    StorageScope(byte kind, int size, Parser parser) {
        super(kind, size, parser);
    }

    ClassSymbol lookupClass(String internalName) {
        Scope scope;
        int lastIndex = 0;
        int index = internalName.indexOf(47, lastIndex);
        Scope scope2 = scope = index < 0 ? this : this.parser.globalScope;
        while (true) {
            PackageSymbol packageSymbol;
            Symbol symbol;
            Identifier identifier;
            String name;
            if (index < 0) {
                index = internalName.indexOf(36, lastIndex);
                name = index > 0 ? internalName.substring(lastIndex, index) : internalName.substring(lastIndex);
                identifier = Identifier.getIdentifier(name);
                symbol = scope.lookupSpecificSymbolInScope(identifier, 32, true);
                if (symbol == null) {
                    symbol = new RawClassSymbol(0, identifier, 0, null, null, false, false);
                    scope.enterSymbol(symbol);
                }
                RawClassSymbol classSymbol = (RawClassSymbol)symbol;
                if (index < 0) {
                    return ParameterizedClassSymbol.getParameterizedClassSymbol(classSymbol, null, null);
                }
                scope = classSymbol.classScope;
                if (scope == null) {
                    return null;
                }
                lastIndex = index + 1;
                while (true) {
                    if ((index = internalName.indexOf(36, lastIndex)) < 0) {
                        name = internalName.substring(lastIndex);
                        identifier = Identifier.getIdentifier(name);
                        symbol = scope.lookupSpecificSymbolInScope(identifier, 32, true);
                        if (symbol == null) {
                            return null;
                        }
                        return ParameterizedClassSymbol.getParameterizedClassSymbol((RawClassSymbol)symbol, null, null);
                    }
                    name = internalName.substring(lastIndex, index);
                    identifier = Identifier.getIdentifier(name);
                    symbol = scope.lookupSpecificSymbolInScope(identifier, 32, true);
                    if (symbol == null) {
                        return null;
                    }
                    classSymbol = (RawClassSymbol)symbol;
                    scope = classSymbol.classScope;
                    if (scope == null) {
                        return null;
                    }
                    lastIndex = index + 1;
                }
            }
            name = internalName.substring(lastIndex, index);
            identifier = Identifier.getIdentifier(name);
            symbol = scope.lookupSpecificSymbolInScope(identifier, 16, true);
            if (symbol == null) {
                PackageScope packageScope = new PackageScope(this.parser, (StorageScope)scope);
                packageScope.packageSymbol = packageSymbol = new PackageSymbol(0, identifier, packageScope);
                packageScope.readPackage();
                scope.enterSymbol(packageSymbol);
                scope = packageScope;
            } else {
                packageSymbol = (PackageSymbol)symbol;
                scope = packageSymbol.packageScope;
            }
            lastIndex = index + 1;
            index = internalName.indexOf(47, lastIndex);
        }
    }

    private UnresolvedClassSymbol UnresolvedTypeOfInnerClass(String internalName, Scope scope) {
        String name;
        int index;
        IdentifierList qualifierLast = null;
        IdentifierList qualifierList = null;
        int lastIndex = 0;
        while ((index = internalName.indexOf(36, lastIndex)) >= 0) {
            name = internalName.substring(lastIndex, index);
            if (Character.isDigit(name.charAt(0))) {
                return null;
            }
            IdentifierList il = new IdentifierList(0, Identifier.getIdentifier(name));
            if (qualifierList == null) {
                qualifierList = qualifierLast = il;
            } else {
                qualifierLast.next = il;
                qualifierLast = il;
            }
            lastIndex = index + 1;
        }
        name = internalName.substring(lastIndex);
        if (Character.isDigit(name.charAt(0))) {
            return null;
        }
        Identifier identifier = Identifier.getIdentifier(name);
        return new UnresolvedClassSymbol(qualifierList, identifier, null, scope);
    }

    ClassSymbol enterClass(String internalName) {
        Scope scope = this.parser.globalScope;
        int lastIndex = 0;
        while (true) {
            PackageSymbol packageSymbol;
            Symbol symbol;
            Identifier identifier;
            String name;
            int index;
            if ((index = internalName.indexOf(47, lastIndex)) < 0) {
                index = internalName.indexOf(36, lastIndex);
                name = index > 0 ? internalName.substring(lastIndex, index) : internalName.substring(lastIndex);
                identifier = Identifier.getIdentifier(name);
                symbol = scope.lookupSpecificSymbolInScope(identifier, 32, true);
                if (symbol == null) {
                    if (scope == this.parser.globalScope && this.parser.unnamedPackageScope != null) {
                        scope = this.parser.unnamedPackageScope;
                        symbol = scope.lookupSpecificSymbolInScope(identifier, 32, true);
                        if (symbol == null) {
                            scope = this.parser.globalScope;
                            symbol = new RawClassSymbol(0, identifier, 0, null, null, false, false);
                            scope.enterSymbol(symbol);
                        }
                    } else {
                        symbol = new RawClassSymbol(0, identifier, 0, null, null, false, false);
                        scope.enterSymbol(symbol);
                    }
                }
                RawClassSymbol classSymbol = (RawClassSymbol)symbol;
                if (index < 0) {
                    return classSymbol;
                }
                if (classSymbol.classScope == null) {
                    return this.UnresolvedTypeOfInnerClass(internalName.substring(lastIndex), scope);
                }
                scope = classSymbol.classScope;
                lastIndex = index + 1;
                while (true) {
                    if ((index = internalName.indexOf(36, lastIndex)) < 0) {
                        name = internalName.substring(lastIndex);
                        if (Character.isDigit(name.charAt(0))) {
                            return null;
                        }
                        identifier = Identifier.getIdentifier(name);
                        symbol = scope.lookupSpecificSymbolInScope(identifier, 32, true);
                        if (symbol == null) {
                            return null;
                        }
                        return ParameterizedClassSymbol.getParameterizedClassSymbol((RawClassSymbol)symbol, null, null);
                    }
                    name = internalName.substring(lastIndex, index);
                    if (Character.isDigit(name.charAt(0))) {
                        return null;
                    }
                    identifier = Identifier.getIdentifier(name);
                    symbol = scope.lookupSpecificSymbolInScope(identifier, 32, true);
                    if (symbol == null) {
                        return null;
                    }
                    classSymbol = (RawClassSymbol)symbol;
                    if (classSymbol.classScope == null) {
                        return this.UnresolvedTypeOfInnerClass(internalName.substring(lastIndex), scope);
                    }
                    scope = classSymbol.classScope;
                    lastIndex = index + 1;
                }
            }
            name = internalName.substring(lastIndex, index);
            identifier = Identifier.getIdentifier(name);
            symbol = scope.lookupSymbolInScope(identifier, true);
            if (symbol == null || (symbol.kind & 0x10) == 0) {
                PackageScope packageScope = new PackageScope(this.parser, (StorageScope)scope);
                packageScope.packageSymbol = packageSymbol = new PackageSymbol(0, identifier, packageScope);
                packageScope.readPackage();
                scope.enterSymbol(packageSymbol);
            } else {
                packageSymbol = (PackageSymbol)symbol;
            }
            scope = packageSymbol.packageScope;
            lastIndex = index + 1;
        }
    }

    TypeSymbol lookupSignature(char[] signature, int start) {
        TypeSymbol typeSymbol;
        int dimension = 0;
        int idx = start;
        block13: while (true) {
            char c = signature[idx];
            switch (c) {
                default: {
                    return null;
                }
                case 'L': {
                    int firstIdx = idx + 1;
                    while (signature[idx] != ';') {
                        ++idx;
                    }
                    String str = new String(signature, firstIdx, idx - firstIdx);
                    typeSymbol = this.lookupClass(str);
                    if (typeSymbol != null) break block13;
                    typeSymbol = this.enterClass(str);
                    break block13;
                }
                case '[': {
                    do {
                        ++dimension;
                    } while (signature[++idx] == '[');
                    continue block13;
                }
                case 'V': {
                    typeSymbol = TypeSymbol.voidSymbol;
                    break block13;
                }
                case 'I': {
                    typeSymbol = TypeSymbol.intSymbol;
                    break block13;
                }
                case 'J': {
                    typeSymbol = TypeSymbol.longSymbol;
                    break block13;
                }
                case 'Z': {
                    typeSymbol = TypeSymbol.booleanSymbol;
                    break block13;
                }
                case 'B': {
                    typeSymbol = TypeSymbol.byteSymbol;
                    break block13;
                }
                case 'C': {
                    typeSymbol = TypeSymbol.charSymbol;
                    break block13;
                }
                case 'S': {
                    typeSymbol = TypeSymbol.shortSymbol;
                    break block13;
                }
                case 'F': {
                    typeSymbol = TypeSymbol.floatSymbol;
                    break block13;
                }
                case 'D': {
                    typeSymbol = TypeSymbol.doubleSymbol;
                    break block13;
                }
            }
            break;
        }
        if (dimension > 0) {
            typeSymbol = ArraySymbol.getArrayType(typeSymbol, dimension);
        }
        return typeSymbol;
    }

    ImportSymbol lookupImportSymbol(Identifier identifier, byte kind) {
        Symbol symbol = super.lookupSpecificSymbolInScope(identifier, 4, false);
        if (symbol != null) {
            kind = (byte)(kind | 4);
            do {
                if (symbol.kind != kind) continue;
                return this.getExplicitImportIfAvailable((ImportSymbol)symbol, -1);
            } while ((symbol = symbol.nextHashed) != null);
        }
        return null;
    }

    boolean isAmbigousImport(Identifier identifier, short kind) {
        Symbol[] symbolTable = (Symbol[])this.symbolTable;
        int hash = identifier.hashCode() & symbolTable.length - 1;
        boolean explicitStaticFound = false;
        boolean explicitFound = false;
        HashSet<RawClassSymbol> methodList = null;
        int found = 0;
        int innerFound = 0;
        int staticFound = 0;
        kind = (short)(kind | 4);
        Symbol symbol = symbolTable[hash];
        while (symbol != null) {
            ImportSymbol impSym;
            if (identifier == symbol.identifier && (symbol.kind & kind) == kind && (impSym = (ImportSymbol)symbol).resolveAndCheck(this.parser, null)) {
                if ((impSym.flags & 0xC) == 0) {
                    if ((impSym.flags & 2) != 0) {
                        explicitStaticFound = true;
                    } else {
                        explicitFound = true;
                    }
                } else if ((impSym.flags & 2) != 0) {
                    if ((kind & 8) != 0) {
                        if (methodList == null) {
                            methodList = new HashSet<RawClassSymbol>();
                        }
                        methodList.add(((MethodSymbol)impSym.importedSymbol).definingClass);
                    } else {
                        ++staticFound;
                    }
                } else if ((impSym.flags & 8) != 0) {
                    ++innerFound;
                } else {
                    ++found;
                }
            }
            symbol = symbol.nextHashed;
        }
        if (explicitFound) {
            return explicitFound & explicitStaticFound;
        }
        if (explicitStaticFound) {
            return found > 0;
        }
        if (methodList != null) {
            staticFound = methodList.size();
        }
        if (found == 0) {
            return staticFound + innerFound > 1;
        }
        return staticFound + found > 1;
    }

    private ImportSymbol getExplicitImportIfAvailable(ImportSymbol impSymbol, int symbolKind) {
        Symbol sym = impSymbol.nextHashed;
        while (sym != null) {
            if (sym.identifier == impSymbol.identifier && (sym.kind & 4) != 0 && (sym.kind & symbolKind) != 0) {
                ImportSymbol impSym = (ImportSymbol)sym;
                if ((impSym.flags & 0xC) == 0) {
                    return impSym;
                }
            }
            sym = sym.nextHashed;
        }
        return impSymbol;
    }

    Symbol lookupSymbolInScope(Identifier identifier, boolean ignoreImports) {
        Symbol symbol;
        block3: {
            ImportSymbol impSym;
            do {
                symbol = super.lookupSymbolInScope(identifier, ignoreImports);
                if (!ignoreImports && symbol != null && (symbol.kind & 4) != 0) {
                    impSym = (ImportSymbol)symbol;
                    if ((impSym.flags & 8) != 0 && (symbol = super.lookupSymbolInScope(identifier, true)) == null) {
                        symbol = this.getExplicitImportIfAvailable(impSym, -1);
                    }
                }
                if (symbol == null || (symbol.kind & 4) == 0) break block3;
                impSym = (ImportSymbol)symbol;
                impSym.used = true;
            } while (!impSym.resolveAndCheck(this.parser, this));
            return impSym.importedSymbol;
        }
        return symbol;
    }

    Symbol lookupSpecificSymbolInScope(Identifier identifier, int symbolKind, boolean ignoreImports) {
        Symbol symbol;
        block3: {
            ImportSymbol impSym;
            do {
                symbol = super.lookupSpecificSymbolInScope(identifier, symbolKind, ignoreImports);
                if (!ignoreImports && symbol != null && (symbol.kind & 4) != 0) {
                    impSym = (ImportSymbol)symbol;
                    if ((impSym.flags & 0xC) != 0 && (symbol = super.lookupSpecificSymbolInScope(identifier, symbolKind, true)) == null) {
                        symbol = this.getExplicitImportIfAvailable(impSym, symbolKind);
                    }
                }
                if (symbol == null || (symbol.kind & 4) == 0) break block3;
                impSym = (ImportSymbol)symbol;
                impSym.used = true;
            } while (!impSym.resolveAndCheck(this.parser, this));
            return impSym.importedSymbol;
        }
        return symbol;
    }
}

