/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.ExpressionStatement;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.Statement;

final class StatementList {
    Statement parent;
    Statement first;
    Statement last;
    static final /* synthetic */ boolean $assertionsDisabled;

    StatementList() {
    }

    void add(Statement statement) {
        if (this.first == null) {
            this.first = this.last = statement;
        } else {
            this.last.next = statement;
            statement.prev = this.last;
            this.last = statement;
        }
    }

    void remove(Statement statement) {
        if (statement == this.first) {
            this.first = statement.next;
        } else {
            statement.prev.next = statement.next;
        }
        if (statement == this.last) {
            this.last = statement.prev;
        } else {
            statement.next.prev = statement.prev;
        }
    }

    void merge(StatementList list) {
        Statement stmt;
        while ((stmt = list.first) != null) {
            list.first = stmt.next;
            stmt.parent = this;
            this.add(stmt);
        }
    }

    void resolveAndCheck(Parser parser) {
        Statement statement = this.first;
        while (statement != null) {
            parser.currentStatement = statement;
            ++parser.estimatedLineCount;
            statement.resolveAndCheck(parser);
            statement = statement.next;
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (!$assertionsDisabled && byteCodeGenerator.getOpStackHeight() != 0) {
            throw new AssertionError();
        }
        boolean errorFound = byteCodeGenerator.parser.errorFound;
        Statement statement = this.first;
        while (statement != null) {
            Statement currentStatement;
            if (errorFound && byteCodeGenerator.parser.errorStatements.containsKey(statement)) {
                Error error = (Error)byteCodeGenerator.parser.errorStatements.get(statement);
                ErrorExpression expr = new ErrorExpression(error);
                currentStatement = new ExpressionStatement(statement.parent, statement.pos, expr);
            } else {
                currentStatement = statement;
            }
            byteCodeGenerator.parser.currentStatement = currentStatement;
            if (currentStatement.pos != 0) {
                byteCodeGenerator.generateLineNumber(Scanner.positionToLine(currentStatement.pos));
            }
            currentStatement.generateByteCode(byteCodeGenerator);
            if (!$assertionsDisabled && byteCodeGenerator.getOpStackHeight() != 0) {
                throw new AssertionError();
            }
            statement = statement.next;
        }
        byteCodeGenerator.parser.currentStatement = null;
    }

    boolean isLoopExitStatement() {
        if (this.last != null) {
            return this.last.isLoopExitStatement();
        }
        return false;
    }

    boolean canReachNextStatement(boolean strict) {
        if (this.last != null) {
            return this.last.canReachNextStatement(strict);
        }
        return true;
    }

    void updateDefUseSetsAfterReturn(Parser parser) {
        if (this.parent != null) {
            this.parent.updateDefUseSetsAfterReturn(parser);
        }
    }

    void updateDefUseSetsAfterThrow(Parser parser, ClassSymbol thrownClass) {
        if (this.parent != null) {
            this.parent.updateDefUseSetsAfterThrow(parser, thrownClass);
        }
    }

    void updateDefUseSetsAfterBreak(Parser parser, LabelSymbol labelSymbol) {
        if (this.parent != null) {
            this.parent.updateDefUseSetsAfterBreak(parser, labelSymbol);
        }
    }

    void updateDefUseSetsAfterContinue(Parser parser, LabelSymbol labelSymbol) {
        if (this.parent != null) {
            this.parent.updateDefUseSetsAfterContinue(parser, labelSymbol);
        }
    }

    int getEndOfStatement() {
        if (this.parent != null) {
            return this.parent.getEndOfStatement();
        }
        return 0;
    }

    static {
        $assertionsDisabled = !StatementList.class.desiredAssertionStatus();
    }
}

