/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.Collections;
import java.util.Comparator;
import oracle.ojc.compiler.AutoUnboxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.TrySyncList;
import oracle.ojc.compiler.TypeSymbol;

abstract class Statement {
    static final byte SK_EMPTY = 0;
    static final byte SK_EXPRESSION = 1;
    static final byte SK_IF = 2;
    static final byte SK_IF_ELSE = 3;
    static final byte SK_SWITCH = 4;
    static final byte SK_CASE = 5;
    static final byte SK_DEFAULT = 6;
    static final byte SK_LABEL = 7;
    static final byte SK_LABELED = 8;
    static final byte SK_BREAK = 9;
    static final byte SK_CONTINUE = 10;
    static final byte SK_FOR = 11;
    static final byte SK_WHILE = 12;
    static final byte SK_DO = 13;
    static final byte SK_RETURN = 14;
    static final byte SK_SYNCHRONIZED = 15;
    static final byte SK_THROW = 16;
    static final byte SK_TRY = 17;
    static final byte SK_ASSERT = 18;
    static final byte SK_FIELDINITIALIZATION = 19;
    static final byte SK_DYNAMICINITIALIZATION = 20;
    static final byte SK_ENDOFSCOPE = 21;
    static final byte SK_LOCALVARINITIALIZATION = 22;
    byte kind;
    int pos;
    StatementList parent;
    Statement next;
    Statement prev;

    Statement(StatementList parent, int pos, byte kind) {
        this.parent = parent;
        this.pos = pos;
        this.kind = kind;
    }

    void insertBefore(Statement statement) {
        Statement p;
        statement.prev = p = this.prev;
        statement.next = this;
        if (p != null) {
            p.next = statement;
        } else {
            this.parent.first = statement;
        }
        this.prev = statement;
    }

    void insertAfter(Statement statement) {
        Statement n;
        statement.next = n = this.next;
        statement.prev = this;
        if (n != null) {
            n.prev = statement;
        } else {
            this.parent.last = statement;
        }
        this.next = statement;
    }

    abstract void resolveAndCheck(Parser var1);

    abstract void generateByteCode(ByteCodeGenerator var1);

    boolean isCodeStatement() {
        return true;
    }

    boolean isLoopExitStatement() {
        return false;
    }

    boolean canReachNextStatement(boolean strict) {
        return true;
    }

    void setLastStatement() {
        if (this.parent.parent == null || this.parent.parent.kind != 4) {
            this.parent.last = this;
        }
    }

    void updateDefUseSetsAfterReturn(Parser parser) {
        this.parent.updateDefUseSetsAfterReturn(parser);
    }

    void updateDefUseSetsAfterThrow(Parser parser, ClassSymbol thrownClass) {
        this.parent.updateDefUseSetsAfterThrow(parser, thrownClass);
    }

    void updateDefUseSetsAfterBreak(Parser parser, LabelSymbol labelSymbol) {
        this.parent.updateDefUseSetsAfterBreak(parser, labelSymbol);
    }

    void updateDefUseSetsAfterContinue(Parser parser, LabelSymbol labelSymbol) {
        this.parent.updateDefUseSetsAfterContinue(parser, labelSymbol);
    }

    protected Expression checkForBooleanExpression(Parser parser, Expression expr, int usedPos) {
        TypeSymbol exprType = expr.getType();
        byte typeKind = exprType.typeKind;
        if (typeKind != 2) {
            if (parser.parsingAtLeastOneFive && exprType.equalTo(parser.javaLangBooleanSymbol)) {
                return new AutoUnboxingExpression(expr, TypeSymbol.booleanSymbol);
            }
            Error error = parser.error(Message.errorIncompatibleTypes, usedPos, typeKind == 0, exprType.errorName(), "boolean");
            return new ErrorExpression(error);
        }
        return expr;
    }

    int getEndOfStatement() {
        int endPos = 0;
        if (this.next != null) {
            endPos = this.next.pos;
        }
        if (endPos > 0) {
            return endPos - 1;
        }
        endPos = this.parent.getEndOfStatement();
        if (endPos > 0) {
            return endPos - 1;
        }
        return 0;
    }

    protected void generateExceptionHandlers(ByteCodeGenerator byteCodeGenerator, short startPC, short endPC, short handlerPC, TrySyncList tryRec, short catchIndex) {
        if (tryRec.trySyncExcludeRanges == null) {
            byteCodeGenerator.generateExceptionHandler(startPC, endPC, handlerPC, catchIndex);
            return;
        }
        Collections.sort(tryRec.trySyncExcludeRanges, new Comparator(){

            public int compare(Object o1, Object o2) {
                short[] s1 = (short[])o1;
                short[] s2 = (short[])o2;
                return s1[0] - s2[0];
            }
        });
        for (int x = 0; x < tryRec.trySyncExcludeRanges.size(); ++x) {
            short[] range = (short[])tryRec.trySyncExcludeRanges.get(x);
            if (startPC > range[0]) continue;
            if (endPC < range[0]) break;
            if (startPC != range[0]) {
                byteCodeGenerator.generateExceptionHandler(startPC, range[0], handlerPC, catchIndex);
            }
            startPC = range[1];
        }
        if (startPC < endPC) {
            byteCodeGenerator.generateExceptionHandler(startPC, endPC, handlerPC, catchIndex);
        }
    }
}

