/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.CastExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.TypeSymbol;

abstract class ShiftExpression
extends BinaryExpression {
    ShiftExpression(byte kind, int pos, Expression leftOperand, Expression rightOperand) {
        super(kind, pos, leftOperand, rightOperand);
    }

    Expression resolveAndCheck(Parser parser) {
        TypeSymbol primitiveType;
        Expression leftOp = this.leftOperand.resolveAndCheck(parser);
        Expression rightOp = this.rightOperand.resolveAndCheck(parser);
        TypeSymbol leftOpType = leftOp.getType();
        if ((leftOpType.typeClass & 0xC) == 0) {
            if (parser.parsingAtLeastOneFive && (primitiveType = BoxingExpression.getPrimitiveType(parser, leftOpType)) != null && (primitiveType.typeClass & 0xC) != 0) {
                leftOp = leftOp.promoteType(parser, primitiveType);
                leftOpType = primitiveType;
            } else {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, leftOpType.isErroneous(), this.toString(), leftOpType.errorName());
                return new ErrorExpression(error);
            }
        }
        TypeSymbol typeSymbol = TypeSymbol.unaryNumericPromotion(parser, leftOpType);
        this.setType(typeSymbol);
        this.leftOperand = leftOp.promoteType(parser, typeSymbol);
        TypeSymbol rightOpType = rightOp.getType();
        if ((rightOpType.typeClass & 0xC) == 0) {
            if (parser.parsingAtLeastOneFive && (primitiveType = BoxingExpression.getPrimitiveType(parser, rightOpType)) != null && (primitiveType.typeClass & 0xC) != 0) {
                rightOp = rightOp.promoteType(parser, primitiveType);
                rightOpType = primitiveType;
            } else {
                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, rightOpType.isErroneous(), this.toString(), rightOpType.errorName());
                return new ErrorExpression(error);
            }
        }
        if (rightOpType == TypeSymbol.intSymbol) {
            this.rightOperand = rightOp;
        } else {
            CastExpression expr = new CastExpression(this.pos, rightOp, TypeSymbol.intSymbol);
            if (rightOp.kind == 2) {
                this.rightOperand = ((Expression)expr).resolveAndCheck(parser);
            } else {
                expr.setType(TypeSymbol.intSymbol);
                this.rightOperand = expr;
            }
        }
        return this.foldExpression();
    }
}

