/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImportDescriptor;
import oracle.ojc.compiler.ImportSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.PackageSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scope;
import oracle.ojc.compiler.StorageScope;
import oracle.ojc.compiler.Symbol;

final class PackageScope
extends StorageScope {
    private static final int PACKAGE_SYMBOLTABLE_SIZE = 64;
    StorageScope outerScope;
    PackageSymbol packageSymbol;
    private boolean readFromDisk;
    static final /* synthetic */ boolean $assertionsDisabled;

    PackageScope(Parser parser, StorageScope outerScope) {
        super((byte)1, 64, parser);
        if (!$assertionsDisabled && outerScope == null) {
            throw new AssertionError();
        }
        this.outerScope = outerScope;
    }

    void importPackage(ImportDescriptor importDescriptor, int pos, boolean explicitImport) {
        if (!this.readPackage() && explicitImport) {
            this.parser.error(Message.errorDirectoryAccessError, pos, false, this.packageSymbol.errorName());
        }
        Symbol[] symbolTable = (Symbol[])this.symbolTable;
        for (int i = 0; i < symbolTable.length; ++i) {
            Symbol symbol = symbolTable[i];
            while (symbol != null) {
                if ((symbol.kind & 0x24) == 32) {
                    ImportSymbol importSymbol;
                    RawClassSymbol classSymbol = (RawClassSymbol)symbol;
                    if (explicitImport) {
                        ImportSymbol checkSymbol = this.parser.currentPackageScope.lookupImportSymbol(classSymbol.identifier, (byte)32);
                        if (checkSymbol != null) {
                            if (checkSymbol.importedSymbol == classSymbol) {
                                this.parser.warning(null, Message.warningDuplicateImport, pos, checkSymbol.errorName());
                            } else if ((checkSymbol.flags & 4) != 0) {
                                importSymbol = new ImportSymbol(0, classSymbol, importDescriptor);
                                importSymbol.flags = (byte)(importSymbol.flags | 5);
                                importDescriptor.importSymbolList.add(importSymbol);
                                this.parser.currentPackageScope.enterSymbol(importSymbol);
                            }
                        } else if (this.parser.currentPackageScope.lookupSpecificSymbolInScope(classSymbol.identifier, 32, false) == null) {
                            importSymbol = new ImportSymbol(0, classSymbol, importDescriptor);
                            importSymbol.flags = (byte)(importSymbol.flags | 5);
                            importDescriptor.importSymbolList.add(importSymbol);
                            this.parser.currentPackageScope.enterSymbol(importSymbol);
                        }
                    } else {
                        importSymbol = new ImportSymbol(0, classSymbol, importDescriptor);
                        importSymbol.flags = (byte)(importSymbol.flags | 4);
                        this.parser.currentPackageScope.enterSymbol(importSymbol);
                    }
                }
                symbol = symbol.nextHashed;
            }
        }
    }

    boolean readPackage() {
        RawClassSymbol symbol;
        Identifier identifier;
        int i;
        if (this.readFromDisk) {
            return true;
        }
        this.readFromDisk = true;
        boolean foundPackage = false;
        ArrayList identifierList = this.parser.options.findClassesInPackage(this.packageSymbol);
        if (identifierList != null) {
            foundPackage = true;
            i = identifierList.size();
            while (--i >= 0) {
                identifier = (Identifier)identifierList.get(i);
                if (this.lookupSymbolInScope(identifier, false) != null || identifier.toString().lastIndexOf(36) > 0) continue;
                symbol = new RawClassSymbol(0, identifier, 1, null, null, false, false);
                this.enterSymbol(symbol);
            }
        }
        if ((identifierList = this.parser.options.findSourcesInPackage(this.packageSymbol)) != null) {
            foundPackage = true;
            i = identifierList.size();
            while (--i >= 0) {
                identifier = (Identifier)identifierList.get(i);
                if (this.lookupSymbolInScope(identifier, false) != null) continue;
                symbol = new RawClassSymbol(0, identifier, 1, null, null, false, false);
                this.enterSymbol(symbol);
            }
        }
        return foundPackage;
    }

    Symbol lookupSymbol(Identifier identifier, boolean ignoreImports) {
        Symbol symbol = this.lookupSymbolInScope(identifier, ignoreImports);
        if (symbol != null) {
            return symbol;
        }
        return this.parser.globalScope.lookupSymbol(identifier, ignoreImports);
    }

    Symbol lookupSpecificSymbol(Identifier identifier, int symbolKind, boolean ignoreImports) {
        Symbol symbol = this.lookupSpecificSymbolInScope(identifier, symbolKind, ignoreImports);
        if (symbol != null) {
            return symbol;
        }
        return this.parser.globalScope.lookupSpecificSymbol(identifier, symbolKind, ignoreImports);
    }

    String errorName() {
        return this.packageSymbol.errorName();
    }

    boolean isSubScopeOf(Scope scope) {
        if (this == scope) {
            return true;
        }
        return this.outerScope.isSubScopeOf(scope);
    }

    Scope getOuterScope() {
        return this.outerScope;
    }

    static {
        $assertionsDisabled = !PackageScope.class.desiredAssertionStatus();
    }
}

