/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import java.util.BitSet;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.Parser;

final class OJCDEBUG {
    private static Identifier className;
    private static Identifier methodName;

    OJCDEBUG() {
    }

    private static boolean doDebug(Parser parser) {
        if (className != null && parser.currentClassSymbol.identifier != className) {
            return false;
        }
        return methodName == null || parser.currentMethodSymbol.identifier == methodName;
    }

    static void releaseStatics() {
        className = null;
        methodName = null;
    }

    static void setMethod(String className, String methodName) {
        OJCDEBUG.className = Identifier.getIdentifier(className);
        OJCDEBUG.methodName = Identifier.getIdentifier(methodName);
    }

    static void printEmptyLine(Parser parser) {
        if (!OJCDEBUG.doDebug(parser)) {
            return;
        }
        System.out.println();
    }

    static void printLocalsInSet(Parser parser, String description, BitSet set) {
        if (!OJCDEBUG.doDebug(parser)) {
            return;
        }
        System.out.print(description + ":  ");
        if (set != null) {
            int fieldCount = parser.currentClassSymbol.cd.fieldCount;
            ArrayList localVariables = parser.currentMethodSymbol.cmd.localVariables;
            int size = set.size();
            for (int i = fieldCount; i < size; ++i) {
                MethodVariableSymbol variable;
                if (!set.get(i) || (variable = (MethodVariableSymbol)localVariables.get(i - fieldCount)) == null || variable.identifier == null) continue;
                System.out.print(variable.identifier.toString() + "  ");
            }
        }
        System.out.println();
    }
}

