/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CastExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.LocalVariableSymbol;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.StringConstantExpression;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.VariableExpression;

final class MethodVariableExpression
extends VariableExpression {
    MethodVariableSymbol variable;

    MethodVariableExpression(int pos, MethodVariableSymbol variable) {
        super(pos);
        this.variable = variable;
    }

    short getAccess() {
        return this.variable.access;
    }

    String errorName() {
        return this.variable.errorName();
    }

    Expression resolveAndCheck(Parser parser) {
        int index = parser.currentClassSymbol.cd.fieldCount + this.variable.varStackIndex;
        if (!parser.suspendDataFlowChecking && !parser.defSet.get(index)) {
            parser.error(Message.errorNotInitialized, this.pos, false, this.variable.errorName());
            parser.defSet.set(index);
            parser.posSet.set(index);
        }
        parser.useSet.set(index);
        TypeSymbol typeSymbol = this.variable.type.resolveType(parser, this.pos, false, true, false);
        this.setType(typeSymbol);
        if (this.variable instanceof LocalVariableSymbol) {
            LocalVariableSymbol localVar = (LocalVariableSymbol)this.variable;
            if (localVar.initializer != null && localVar.initializer.kind == 2) {
                Expression expr = localVar.initializer;
                if (!parser.parsingAtLeastOneFive || null == BoxingExpression.getPrimitiveType(parser, typeSymbol)) {
                    switch (expr.getType().typeKind) {
                        default: {
                            return CastExpression.castNumericConstant(expr, typeSymbol, true);
                        }
                        case 2: {
                            return new BooleanConstantExpression(expr.pos, ((BooleanConstantExpression)expr).bval);
                        }
                        case 10: 
                    }
                    if (expr instanceof StringConstantExpression) {
                        StringConstantExpression scExpr = (StringConstantExpression)expr;
                        return new StringConstantExpression(expr.pos, scExpr.getType(), scExpr.sval);
                    }
                }
            }
        }
        return this;
    }

    Expression resolveAndCheckReadBeforeWrite(Parser parser) {
        int index = parser.currentClassSymbol.cd.fieldCount + this.variable.varStackIndex;
        if (!parser.suspendDataFlowChecking) {
            if (!parser.defSet.get(index)) {
                parser.error(Message.errorNotInitialized, this.pos, false, this.variable.errorName());
            } else if ((this.getAccess() & 0x10) != 0) {
                parser.error(Message.errorFinalCannotBeAssigned, this.pos, false, this.errorName());
            }
            this.variable.pos = this.pos;
            parser.defSet.set(index);
            parser.posSet.set(index);
        }
        if (parser.innerSwitchLoop == null || !parser.innerSwitchLoop.inLoop()) {
            parser.useSet.clear(index);
        } else {
            parser.useSet.set(index);
        }
        TypeSymbol typeSymbol = this.variable.type;
        this.setType(typeSymbol);
        return this;
    }

    Expression resolveAndCheckWrite(Parser parser) {
        TypeSymbol typeSymbol = this.variable.type;
        this.setType(typeSymbol);
        return this;
    }

    void markDefined(Parser parser) {
        boolean dontClearUseSet = false;
        int index = parser.currentClassSymbol.cd.fieldCount + this.variable.varStackIndex;
        if (!parser.suspendDataFlowChecking) {
            if ((this.getAccess() & 0x10) != 0) {
                if (parser.defSet.get(index)) {
                    parser.error(Message.errorFinalCannotBeAssigned, this.pos, false, this.errorName());
                } else if (parser.posSet.get(index)) {
                    parser.error(Message.errorPossiblyInitialized, this.pos, false, this.errorName());
                } else {
                    if (parser.innerSwitchLoop != null && parser.innerSwitchLoop.inLoop()) {
                        LoopStatement loopStatement = parser.innerSwitchLoop.getLoopStatement();
                        if (parser.currentStatement == loopStatement) {
                            if (!loopStatement.bodyStatements.last.isLoopExitStatement()) {
                                parser.error(Message.errorPossiblyInitialized, this.pos, false, this.errorName());
                            }
                        } else if (this.variable.pos < loopStatement.bodyPos && !parser.currentStatement.parent.last.isLoopExitStatement()) {
                            loopStatement.possibleReinitialization(this.pos, this.variable);
                        }
                    }
                    if ((this.variable.flags & 1) != 0) {
                        dontClearUseSet = true;
                        parser.useSet.set(index);
                        int nextPos = parser.currentStatement.getEndOfStatement();
                        parser.currentClassSymbol.checkSyntheticFieldsInInnerClass(parser, this.variable, parser.currentStatement.pos, this.pos, nextPos);
                    }
                }
            }
        } else if ((this.getAccess() & 0x10) != 0 && !parser.defSet.get(index) && parser.posSet.get(index)) {
            parser.error(Message.errorPossiblyInitialized, this.pos, false, this.errorName());
        }
        this.variable.pos = this.pos;
        parser.defSet.set(index);
        parser.posSet.set(index);
        if (!(parser.innerSwitchLoop != null && parser.innerSwitchLoop.inLoop() || dontClearUseSet)) {
            parser.useSet.clear(index);
        }
    }

    void markUsed(Parser parser) {
        int index = parser.currentClassSymbol.cd.fieldCount + this.variable.varStackIndex;
        parser.useSet.set(index);
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        byteCodeGenerator.loadLocalVariable(this.getType(), this.variable.varStackIndex);
        int pc = byteCodeGenerator.generateGetPC() & 0xFFFF;
        if (pc < (this.variable.startPC & 0xFFFF)) {
            this.variable.startPC = (short)pc;
        }
    }

    void generateByteCodeReadBeforeWrite(ByteCodeGenerator byteCodeGenerator, boolean x1) {
        this.generateByteCode(byteCodeGenerator);
    }

    void generateByteCodeWrite(ByteCodeGenerator byteCodeGenerator) {
        byteCodeGenerator.storeLocalVariable(this.getType(), this.variable.varStackIndex);
        int pc = byteCodeGenerator.generateGetPC() & 0xFFFF;
        if (pc < (this.variable.startPC & 0xFFFF)) {
            this.variable.startPC = (short)pc;
        }
    }
}

