/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ArgumentVariableList;
import oracle.ojc.compiler.ArgumentVariableSymbol;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionStatement;
import oracle.ojc.compiler.FieldInitializationStatement;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.InvokeExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodVariableSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SuperExpression;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;

final class MethodSymbol
extends Symbol {
    static final short MSF_NONE = 0;
    static final short MSF_SYNTHETIC = 1;
    static final short MSF_CONSTRUCTOR_CALL_THIS = 2;
    static final short MSF_DEPRECATED = 4;
    static final short MSF_RESOLVED = 8;
    static final short MSF_USED = 16;
    static final short MSF_GENERATED = 32;
    static final short MSF_DEFAULTVALUE = 64;
    static final short MSF_HAS_PARAMETER_ANNOTATIONS = 64;
    static final short MSF_CHECK_OVERRIDE = 128;
    static final short MSF_INVOLVES_GENERICS = 256;
    static final short MSF_DEFAULT_CONSTRUCTOR = 512;
    static final short MSF_HAS_COVARIANT_RETURN = 1024;
    MethodSymbol nextWithSameName;
    MethodSymbol nextInClass;
    RawClassSymbol definingClass;
    TypeParameterList typeParameterList;
    ArgumentVariableList argumentList;
    TypeSymbol resultType;
    int tpos;
    ThrowsList throwsList;
    Object annotation;
    short access;
    short flags;
    short argCount;
    short actualArgCount;
    short localVarCount;
    CompiledMethodData cmd;
    static /* synthetic */ Class class$oracle$ojc$compiler$MethodSymbol;

    MethodSymbol(int pos, RawClassSymbol definingClass, Identifier identifier, TypeSymbol resultType, int tpos, short access, Annotation annotation, boolean compiling) {
        super((byte)8, pos, identifier);
        this.definingClass = definingClass;
        this.resultType = resultType;
        this.tpos = tpos;
        this.access = access;
        this.annotation = annotation;
        definingClass.cd.methodCount = (short)(definingClass.cd.methodCount + 1);
        if (compiling) {
            this.cmd = new CompiledMethodData();
            this.cmd.localVariables = new ArrayList(10);
        }
    }

    void deprecate() {
        this.flags = (short)(this.flags | 4);
    }

    boolean isDeprecated() {
        return (this.flags & 4) != 0;
    }

    boolean isSynthetic() {
        return (this.flags & 1) != 0;
    }

    boolean isErroneous() {
        return this.definingClass.isErroneous() || this.resultType.isErroneous() || this.argumentList != null && this.argumentList.isErroneous();
    }

    String erasedErrorName() {
        return this.errorName(true);
    }

    String errorName() {
        return this.errorName(false);
    }

    private String errorName(boolean erased) {
        StringBuffer sb;
        if (this.isErroneous()) {
            return "";
        }
        if (this.isConstructor()) {
            sb = new StringBuffer(Message.constructorString);
            sb.append(' ');
            sb.append(this.definingClass.identifier.toString());
        } else {
            if (this.identifier == Identifier.classInitializerIdentifier) {
                return Message.classInitializerString;
            }
            sb = new StringBuffer(Message.methodString);
            sb.append(' ');
            sb.append(this.identifier.toString());
        }
        sb.append('(');
        ArgumentVariableList sl = this.argumentList;
        while (sl != null) {
            TypeSymbol argType = sl.argSymbol.type;
            if (erased) {
                argType = argType.eraseType();
            }
            sb.append(argType.toString());
            if (sl.next != null) {
                sb.append(", ");
            }
            sl = sl.next;
        }
        sb.append(')');
        return sb.toString();
    }

    String kindName() {
        if (this.isConstructor()) {
            return Message.constructorString;
        }
        return Message.methodString;
    }

    char[] getSignature() {
        char[] sig;
        InnerClassSymbol innerClassSymbol;
        InnerClassSymbol.HiddenArgumentList hal;
        int argCount = this.argCount;
        if (this.isConstructor() && this.definingClass.isInnerClass()) {
            hal = ((InnerClassSymbol)this.definingClass).hiddenArgumentList;
            while (hal != null) {
                ++argCount;
                hal = hal.next;
            }
        }
        char[][] args = new char[argCount][];
        int size = 2;
        int idx = 0;
        if (this.isConstructor() && this.definingClass.isInnerClass()) {
            innerClassSymbol = (InnerClassSymbol)this.definingClass;
            hal = innerClassSymbol.hiddenArgumentList;
            while (hal != null) {
                if (hal.kind == 0 || hal.kind == 1) {
                    sig = hal.type.getSignature();
                    args[idx++] = sig;
                    size += sig.length;
                }
                hal = hal.next;
            }
        }
        ArgumentVariableList sl = this.argumentList;
        while (sl != null) {
            sig = sl.argSymbol.getSignature();
            args[idx++] = sig;
            size += sig.length;
            sl = sl.next;
        }
        if (this.isConstructor() && this.definingClass.isInnerClass()) {
            innerClassSymbol = (InnerClassSymbol)this.definingClass;
            hal = innerClassSymbol.hiddenArgumentList;
            while (hal != null) {
                if (hal.kind == 2) {
                    sig = hal.type.getSignature();
                    args[idx++] = sig;
                    size += sig.length;
                }
                hal = hal.next;
            }
        }
        TypeSymbol type = this.resultType;
        char[] resultSig = type.getSignature();
        char[] signature = new char[size += resultSig.length];
        signature[0] = 40;
        int i = 1;
        for (idx = 0; idx < argCount; ++idx) {
            char[] arg = args[idx];
            System.arraycopy(arg, 0, signature, i, arg.length);
            i += arg.length;
        }
        signature[i++] = 41;
        System.arraycopy(resultSig, 0, signature, i, resultSig.length);
        return signature;
    }

    protected void toString(StringBuffer str) {
        this.toString(str, true);
    }

    private void toString(StringBuffer str, boolean includeReturnType) {
        if (this.identifier == Identifier.initializerIdentifier) {
            str.append(this.definingClass.getClassName());
        } else {
            str.append(this.identifier.name);
        }
        str.append('(');
        ArgumentVariableList sl = this.argumentList;
        if (sl != null) {
            while (true) {
                sl.argSymbol.type.toString(str);
                sl = sl.next;
                if (sl == null) break;
                str.append(", ");
            }
        }
        str.append(')');
        if (includeReturnType && this.identifier != Identifier.initializerIdentifier) {
            str.append(" : ");
            this.resultType.toString(str);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer(80);
        this.toString(str);
        return str.toString();
    }

    Annotation getAnnotations() {
        if (this.isBridgeMethod()) {
            return null;
        }
        return (Annotation)this.annotation;
    }

    byte getAnnotationTarget() {
        if (this.isConstructor()) {
            return 16;
        }
        return 4;
    }

    public String depInfoName() {
        StringBuffer str = new StringBuffer(80);
        this.toString(str, false);
        return str.toString();
    }

    boolean isGenerated() {
        return (this.flags & 0x20) != 0;
    }

    boolean isConstructor() {
        return this.identifier == Identifier.initializerIdentifier;
    }

    boolean isClassInitializer() {
        return this.identifier == Identifier.classInitializerIdentifier;
    }

    boolean isDynamicInitializer() {
        return this.identifier == Identifier.dynamicInitializerIdentifier;
    }

    boolean isDefaultConstructor() {
        return (this.flags & 0x200) != 0;
    }

    boolean isBridgeMethod() {
        return (this.access & 0x40) != 0;
    }

    boolean involvesGenerics() {
        return (this.flags & 0x100) != 0;
    }

    ArgumentVariableSymbol addArgument(TypeSymbol typeSymbol) {
        short s = this.localVarCount;
        this.localVarCount = (short)(s + 1);
        ArgumentVariableSymbol arg = new ArgumentVariableSymbol(0, this, null, typeSymbol, 0, 0, null, s);
        this.cmd.localVariables.add(arg);
        if ((typeSymbol.typeClass & 0x28) != 0) {
            this.actualArgCount = (short)(this.actualArgCount + 1);
            this.localVarCount = (short)(this.localVarCount + 1);
            this.cmd.localVariables.add(null);
        }
        this.actualArgCount = (short)(this.actualArgCount + 1);
        this.argCount = (short)(this.argCount + 1);
        ArgumentVariableList al = new ArgumentVariableList(arg);
        if (this.argumentList == null) {
            this.argumentList = al;
        } else {
            ArgumentVariableList sl = this.argumentList;
            while (true) {
                if (sl.next == null) {
                    sl.next = al;
                    break;
                }
                sl = sl.next;
            }
        }
        return arg;
    }

    boolean isAccessible(ClassSymbol fromClass, ClassSymbol instClass) {
        if (!instClass.isAccessible(fromClass)) {
            return false;
        }
        switch (this.access & 7) {
            case 2: {
                return this.definingClass.equalTo(fromClass) && this.definingClass.equalTo(instClass);
            }
            case 1: {
                return true;
            }
            case 4: {
                if (!this.definingClass.equalTo(fromClass) && !this.definingClass.isSuperclass(fromClass)) break;
                if ((this.access & 8) != 0) {
                    return true;
                }
                if (!fromClass.equalTo(instClass) && !fromClass.isSuperclass(instClass)) break;
                return true;
            }
        }
        return this.definingClass.inSamePackage(fromClass);
    }

    boolean checkThrowsList(ClassSymbol classSymbol) {
        ThrowsList tl = this.throwsList;
        while (tl != null) {
            ClassSymbol throwType = (ClassSymbol)tl.throwsType;
            if (classSymbol.equalTo(throwType) || throwType.isSuperclass(classSymbol)) {
                return true;
            }
            tl = tl.next;
        }
        return false;
    }

    Statement getFirstStatement() {
        if (this.cmd == null || this.cmd.statementList == null) {
            return null;
        }
        return this.cmd.statementList.first;
    }

    boolean compareMethod(Identifier identifier, ArgumentVariableList argumentList, TypeSymbol resultType) {
        if (this.identifier != identifier) {
            return false;
        }
        if (argumentList == null || this.argumentList == null ? this.argumentList != argumentList : !this.argumentList.equals(argumentList)) {
            return false;
        }
        if (resultType == null) {
            return true;
        }
        return this.resultType.equalTo(resultType);
    }

    private void initLocalVariableChecking(Parser parser) {
        short fieldCount = this.definingClass.cd.fieldCount;
        int size = fieldCount + this.localVarCount;
        parser.defSet = new BitSet(size);
        parser.posSet = new BitSet(size);
        parser.useSet = new BitSet(size);
        parser.defSet.set((int)fieldCount, fieldCount + this.actualArgCount);
        parser.posSet.set((int)fieldCount, fieldCount + this.actualArgCount);
        if (this.isClassInitializer()) {
            FieldSymbol fieldSymbol = this.definingClass.cd.fieldList;
            while (fieldSymbol != null) {
                if ((fieldSymbol.access & 8) == 0 || (fieldSymbol.flags & Short.MIN_VALUE) != 0) {
                    parser.defSet.set(fieldSymbol.index);
                    parser.posSet.set(fieldSymbol.index);
                }
                fieldSymbol = fieldSymbol.nextInClass;
            }
        } else if (this.isConstructor()) {
            if ((this.flags & 2) != 0) {
                parser.defSet.set(0, fieldCount);
                parser.posSet.set(0, fieldCount);
            } else {
                FieldSymbol fieldSymbol = this.definingClass.cd.fieldList;
                while (fieldSymbol != null) {
                    if ((fieldSymbol.access & 8) != 0 || (fieldSymbol.flags & Short.MIN_VALUE) != 0) {
                        parser.defSet.set(fieldSymbol.index);
                        parser.posSet.set(fieldSymbol.index);
                    }
                    fieldSymbol = fieldSymbol.nextInClass;
                }
            }
        } else if (this.identifier == Identifier.dynamicInitializerIdentifier) {
            FieldSymbol fieldSymbol = this.definingClass.cd.fieldList;
            while (fieldSymbol != null) {
                if ((fieldSymbol.access & 8) != 0 || (fieldSymbol.flags & Short.MIN_VALUE) != 0) {
                    parser.defSet.set(fieldSymbol.index);
                    parser.posSet.set(fieldSymbol.index);
                }
                fieldSymbol = fieldSymbol.nextInClass;
            }
        } else {
            parser.defSet.set(0, fieldCount);
            parser.posSet.set(0, fieldCount);
        }
    }

    private void doneLocalVariableChecking(Parser parser) {
        FieldSymbol fieldSymbol;
        int fieldCount = this.definingClass.cd.fieldCount;
        int len = fieldCount + this.localVarCount;
        if (this.isClassInitializer()) {
            fieldSymbol = this.definingClass.cd.fieldList;
            while (fieldSymbol != null) {
                if ((fieldSymbol.access & 8) != 0 && parser.defSet.get(fieldSymbol.index)) {
                    fieldSymbol.flags = (short)(fieldSymbol.flags | Short.MIN_VALUE);
                }
                fieldSymbol = fieldSymbol.nextInClass;
            }
        } else if (this.isConstructor()) {
            if ((this.flags & 2) == 0) {
                fieldSymbol = this.definingClass.cd.fieldList;
                while (fieldSymbol != null) {
                    if ((fieldSymbol.access & 8) == 0 && (fieldSymbol.flags & Short.MIN_VALUE) == 0 && (!parser.defSet.get(fieldSymbol.index) || parser.exitDefSet != null && !parser.exitDefSet.get(fieldSymbol.index))) {
                        fieldSymbol.flags = (short)(fieldSymbol.flags | 0x4000);
                    }
                    fieldSymbol = fieldSymbol.nextInClass;
                }
            }
        } else if (this.identifier == Identifier.dynamicInitializerIdentifier) {
            fieldSymbol = this.definingClass.cd.fieldList;
            while (fieldSymbol != null) {
                if ((fieldSymbol.access & 8) == 0 && (fieldSymbol.flags & Short.MIN_VALUE) == 0) {
                    if (parser.defSet.get(fieldSymbol.index)) {
                        fieldSymbol.flags = (short)(fieldSymbol.flags | Short.MIN_VALUE);
                    } else if (parser.posSet.get(fieldSymbol.index)) {
                        fieldSymbol.flags = (short)(fieldSymbol.flags | 0x4000);
                    }
                }
                fieldSymbol = fieldSymbol.nextInClass;
            }
        }
        for (int i = fieldCount; i < len; ++i) {
            MethodVariableSymbol variable;
            if (parser.useSet.get(i) || (variable = (MethodVariableSymbol)this.cmd.localVariables.get(i - fieldCount)) == null || variable.identifier == null || (variable.flags & 8) != 0) continue;
            if (parser.defSet.get(i)) {
                if ((variable.flags & 1) != 0) continue;
                if (i < fieldCount + this.actualArgCount) {
                    parser.warning(variable, Message.warningParameterNeverRead, variable.pos, variable.identifier.toString());
                    continue;
                }
                if ((variable.flags & 4) != 0) {
                    parser.warning(variable, Message.warningCatchVarNeverRead, variable.pos, variable.identifier.toString());
                    continue;
                }
                parser.warning(variable, Message.warningVarAssignmentNeverRead, variable.pos, variable.errorName());
                continue;
            }
            if (parser.exitDefSet != null && parser.exitDefSet.get(i) || parser.posSet.get(i)) continue;
            if ((variable.flags & 4) != 0) {
                if ((variable.flags & 1) != 0) continue;
                parser.warning(variable, Message.warningCatchVarNeverRead, variable.pos, variable.identifier.toString());
                continue;
            }
            if ((variable.flags & 1) != 0) {
                if ((variable.flags & 2) != 0) continue;
                parser.error(Message.errorNotInitialized, variable.pos, variable.isErroneous(), variable.errorName());
                continue;
            }
            parser.warning(variable, Message.warningVariableNeverRead, variable.pos, variable.errorName());
        }
        parser.exitDefSet = null;
        parser.useSet = null;
        parser.defSet = null;
    }

    void resolveTypeParameters(Parser parser) {
        if (this.typeParameterList != null) {
            this.typeParameterList.resolve(parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveMethod(Parser parser) {
        StatementList statementList;
        RawClassSymbol classSymbol;
        if ((this.flags & 8) != 0) {
            return;
        }
        MethodSymbol methodSymbol = this.nextWithSameName;
        while (methodSymbol != null) {
            if (!methodSymbol.isGenerated()) {
                if ((this.access & 0x80) != 0 && Identifier.compare(methodSymbol.getSignature(), this.getSignature())) {
                    parser.error(Error.errorAlreadyDefined, this.pos, false, this.errorName());
                    break;
                }
                if (this.argCount == methodSymbol.argCount && this.identical(methodSymbol)) {
                    parser.error(Message.errorDuplicateDefinition, this.pos, this.isErroneous(), this.errorName() + " " + Message.inString + " " + this.definingClass.errorName());
                }
            }
            methodSymbol = methodSymbol.nextWithSameName;
        }
        if (this.isGenerated()) {
            return;
        }
        if (this.isConstructor() && parser.currentClassSymbol.superClass != null && (classSymbol = parser.currentClassSymbol.superClass.getClassSymbol()).isNonStaticInnerClass() && !parser.currentClassSymbol.isAnonymousInnerClass()) {
            RawClassSymbol outerClass = null;
            if (parser.currentClassSymbol.isInnerClass()) {
                classSymbol = ((ClassSymbol)classSymbol).getOuterClass();
                outerClass = parser.currentClassSymbol.getOuterClass();
                while (!classSymbol.equalTo(outerClass) && !classSymbol.isSuperclass(outerClass)) {
                    if (!outerClass.isInnerClass()) {
                        outerClass = null;
                        break;
                    }
                    outerClass = ((ClassSymbol)outerClass).getOuterClass();
                }
            }
            if (outerClass == null) {
                Statement stmt;
                Statement currentStatement = parser.currentStatement;
                parser.currentStatement = stmt = this.getFirstStatement();
                try {
                    if (stmt == null || !(stmt instanceof ExpressionStatement)) {
                        parser.error(Message.errorInstanceNotInScope, this.pos, false, parser.currentClassSymbol.superClass.errorName());
                    } else {
                        ExpressionStatement exprStmt = (ExpressionStatement)stmt;
                        if (exprStmt.expr instanceof InvokeExpression) {
                            Expression expr;
                            InvokeExpression invokeExpr = (InvokeExpression)exprStmt.expr;
                            if (!((invokeExpr.flags & 2) == 0 || (expr = invokeExpr.thisArgument) != null && expr instanceof SuperExpression && ((SuperExpression)expr).outerClassExpr != null)) {
                                parser.error(Message.errorInstanceNotInScope, this.pos, false, parser.currentClassSymbol.superClass.errorName());
                            }
                        }
                    }
                    Object var14_10 = null;
                    parser.currentStatement = currentStatement;
                }
                catch (Throwable throwable) {
                    Object var14_11 = null;
                    parser.currentStatement = currentStatement;
                    throw throwable;
                }
            }
        }
        this.resolveTypeParameters(parser);
        CompiledThrowsList ctl = (CompiledThrowsList)this.throwsList;
        while (ctl != null) {
            TypeSymbol typeSymbol = ctl.throwsType;
            if (typeSymbol != null) {
                if (typeSymbol.isTypeParameter()) {
                    typeSymbol = ((TypeParameterSymbol)typeSymbol).getClassSymbol();
                }
                if (!(typeSymbol = typeSymbol.resolveType(parser, ctl.pos, false, true, false)).isClass() || !typeSymbol.equalTo(parser.javaLangThrowableSymbol) && !parser.javaLangThrowableSymbol.isSuperclass((ClassSymbol)typeSymbol)) {
                    parser.error(Message.errorIncompatibleTypes, ctl.pos, typeSymbol.isErroneous(), typeSymbol.errorName(), "java.lang.Throwable");
                }
            }
            ctl = (CompiledThrowsList)ctl.next;
        }
        if (!((this.access & 8) == 0 || this.isClassInitializer() || this.isSynthetic() || parser.currentClassSymbol.isInterface() || !parser.currentClassSymbol.isNonStaticInnerClass() && !parser.currentClassSymbol.isLocalInnerClass())) {
            parser.error(Message.errorInnerCannotHaveStatics, this.pos, false);
        }
        if ((statementList = this.cmd.statementList) != null) {
            parser.currentMethodSymbol = this;
            this.initLocalVariableChecking(parser);
            parser.thisInitialized = !this.isConstructor();
            parser.estimatedLineCount = 0;
            statementList.resolveAndCheck(parser);
            if (!this.isDynamicInitializer()) {
                parser.addReturnStatement(this, statementList);
            }
            this.cmd.estimatedLineCount = parser.estimatedLineCount;
            this.doneLocalVariableChecking(parser);
            this.flags = (short)(this.flags | 8);
            parser.currentStatement = null;
            parser.currentMethodSymbol = null;
        }
        if (parser.options.noCodeGeneration || parser.errorFound && !parser.options.generateClassesDespiteErrors) {
            this.cmd.statementList = null;
        }
    }

    void generateMethod(Parser parser) {
        StatementList statementList = this.cmd.statementList;
        if (statementList != null) {
            parser.currentMethodSymbol = this;
            this.cmd.statementList = null;
            if (!(parser.options.noCodeGeneration || parser.errorFound && !parser.options.generateClassesDespiteErrors)) {
                boolean clinit = this.isClassInitializer();
                if (clinit) {
                    ++this.cmd.estimatedLineCount;
                }
                ByteCodeGenerator byteCodeGenerator = new ByteCodeGenerator(parser, this);
                do {
                    if (clinit) {
                        byteCodeGenerator.generateClassInitalizerPrologue();
                    }
                    if (this.isErroneous()) {
                        ErrorExpression.errorExpression.generateByteCode(byteCodeGenerator);
                        continue;
                    }
                    statementList.generateByteCode(byteCodeGenerator);
                } while (!byteCodeGenerator.finish());
            }
            parser.currentMethodSymbol = null;
        }
    }

    char[] getMethodSignature() {
        StringBuffer sb = new StringBuffer();
        TypeParameterList tpl = this.typeParameterList;
        if (tpl != null) {
            tpl.getSignature(sb);
        }
        sb.append('(');
        ArgumentVariableList sl = this.argumentList;
        while (sl != null) {
            sb.append(sl.argSymbol.type.getGenericSignature());
            sl = sl.next;
        }
        sb.append(')');
        sb.append(this.resultType.getGenericSignature());
        ThrowsList tl = this.throwsList;
        while (tl != null) {
            TypeSymbol typeSymbol = tl.throwsType;
            sb.append('^');
            sb.append(typeSymbol.getGenericSignature());
            tl = tl.next;
        }
        return sb.toString().toCharArray();
    }

    void addFieldInitializer(FieldSymbol fieldSymbol, int pos) {
        FieldInitializationStatement fieldInitializationStatement = new FieldInitializationStatement(this.cmd.statementList, pos, fieldSymbol);
        this.cmd.statementList.add(fieldInitializationStatement);
    }

    private boolean identical(MethodSymbol other) {
        if (Arrays.equals(this.getSignature(), other.getSignature())) {
            return true;
        }
        ArgumentVariableList argList1 = this.argumentList;
        ArgumentVariableList argList2 = other.argumentList;
        while (true) {
            if (argList1 == null || argList2 == null) {
                if (argList1 == null && argList2 == null) break;
                return false;
            }
            TypeSymbol type1 = argList1.argSymbol.type;
            TypeSymbol type2 = argList2.argSymbol.type;
            TypeSymbol erased1 = type1.eraseType();
            TypeSymbol erased2 = type2.eraseType();
            if (erased1.isClass() && erased2.isClass() ? ((ClassSymbol)erased1).getClassSymbol() != ((ClassSymbol)erased2).getClassSymbol() : erased1 != erased2) {
                return false;
            }
            if (this.typeParameterList == null && other.typeParameterList == null ? type1.involvesGenerics() == type2.involvesGenerics() && type1 != type2 : (this.typeParameterList != null && other.typeParameterList != null ? type1 != type2 : (this.typeParameterList != null && other.typeParameterList == null ? type2.involvesGenerics() : type1.involvesGenerics()))) {
                return false;
            }
            argList1 = argList1.next;
            argList2 = argList2.next;
        }
        TypeParameterList tpl1 = this.typeParameterList;
        TypeParameterList tpl2 = other.typeParameterList;
        if (tpl1 != null && tpl2 != null) {
            StringBuffer sig1 = new StringBuffer();
            StringBuffer sig2 = new StringBuffer();
            tpl1.getBoundsSignature(sig1, false);
            tpl2.getBoundsSignature(sig2, false);
            if (!sig1.toString().equals(sig2.toString())) {
                return false;
            }
        }
        return true;
    }

    static final class CompiledThrowsList
    extends ThrowsList {
        int pos;
        short index;

        CompiledThrowsList(TypeSymbol throwsType, int pos) {
            super(throwsType);
            this.pos = pos;
        }

        int getPos() {
            return this.pos;
        }
    }

    static class ThrowsList {
        ThrowsList next;
        TypeSymbol throwsType;
        static final /* synthetic */ boolean $assertionsDisabled;

        ThrowsList(TypeSymbol throwsType) {
            this.throwsType = throwsType;
        }

        int getPos() {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return 0;
        }

        static CompiledThrowsList copyIntoCompiledThrowsList(ThrowsList tl) {
            CompiledThrowsList ctLast = null;
            CompiledThrowsList ctList = null;
            while (tl != null) {
                CompiledThrowsList ctl = new CompiledThrowsList(tl.throwsType, 0);
                if (ctList == null) {
                    ctList = ctLast = ctl;
                } else {
                    ctLast.next = ctl;
                    ctLast = ctl;
                }
                tl = tl.next;
            }
            return ctList;
        }

        static {
            $assertionsDisabled = !(class$oracle$ojc$compiler$MethodSymbol == null ? (class$oracle$ojc$compiler$MethodSymbol = MethodSymbol.class$("oracle.ojc.compiler.MethodSymbol")) : class$oracle$ojc$compiler$MethodSymbol).desiredAssertionStatus();
        }
    }

    static final class CompiledMethodData {
        StatementList statementList;
        int estimatedLineCount;
        int maxOpStackDepth;
        short lastLine;
        byte[] lineNumberTable;
        short localVarTableLen;
        byte[] localVarTable;
        short localVarTypeTableLen;
        byte[] localVarTypeTable;
        short exceptionTableLen;
        byte[] exceptionTable;
        byte[] codeBuffer;
        ArrayList localVariables;

        CompiledMethodData() {
        }
    }
}

