/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.LabelSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.Symbol;

abstract class LoopStatement
extends Statement {
    StatementList bodyStatements;
    int bodyPos;
    SwitchLoopList loopRec;
    PossibleReinitialization possibleReinitializations;
    BitSet resultDefSet;
    BitSet resultPosSet;
    BitSet resultUseSet;
    BitSet continueDefSet;

    LoopStatement(StatementList parent, int pos, int bodyPos, byte kind, StatementList bodyStatements) {
        super(parent, pos, kind);
        this.bodyStatements = bodyStatements;
        this.bodyPos = bodyPos;
        bodyStatements.parent = this;
    }

    boolean isBogusLoop() {
        return false;
    }

    void updateDefUseSetsAfterReturn(Parser parser) {
        if (this.resultUseSet == null) {
            this.resultUseSet = parser.useSet;
        } else {
            this.resultUseSet.or(parser.useSet);
        }
        this.parent.updateDefUseSetsAfterReturn(parser);
    }

    void updateDefUseSetsAfterThrow(Parser parser, ClassSymbol thrownClass) {
        if (this.resultUseSet == null) {
            this.resultUseSet = parser.useSet;
        } else {
            this.resultUseSet.or(parser.useSet);
        }
        this.parent.updateDefUseSetsAfterThrow(parser, thrownClass);
    }

    void updateDefUseSetsAfterBreak(Parser parser, LabelSymbol labelSymbol) {
        if (labelSymbol != null) {
            this.parent.updateDefUseSetsAfterBreak(parser, labelSymbol);
        }
        if (!parser.suspendDataFlowChecking) {
            if (this.resultDefSet == null) {
                this.resultDefSet = (BitSet)parser.defSet.clone();
            } else {
                this.resultDefSet.and(parser.defSet);
            }
        }
        if (this.resultPosSet == null) {
            this.resultPosSet = (BitSet)parser.posSet.clone();
        } else {
            this.resultPosSet.or(parser.posSet);
        }
        if (this.resultUseSet == null) {
            this.resultUseSet = (BitSet)parser.useSet.clone();
        } else {
            this.resultUseSet.or(parser.useSet);
        }
    }

    void updateDefUseSetsAfterContinue(Parser parser, LabelSymbol labelSymbol) {
        if (labelSymbol != null) {
            this.parent.updateDefUseSetsAfterContinue(parser, labelSymbol);
        } else if (this.continueDefSet == null) {
            this.continueDefSet = (BitSet)parser.defSet.clone();
        } else {
            this.continueDefSet.and(parser.defSet);
        }
    }

    void possibleReinitialization(int pos, Symbol symbol) {
        PossibleReinitialization pr = new PossibleReinitialization(pos, symbol);
        pr.next = this.possibleReinitializations;
        this.possibleReinitializations = pr;
    }

    void checkPosibleReinitializations(Parser parser) {
        if (!this.isBogusLoop()) {
            PossibleReinitialization pr = this.possibleReinitializations;
            while (pr != null) {
                parser.error(Message.errorPossiblyInitialized, pr.pos, false, pr.symbol.errorName());
                pr = pr.next;
            }
            this.possibleReinitializations = null;
        }
    }

    static class PossibleReinitialization {
        PossibleReinitialization next;
        int pos;
        Symbol symbol;

        PossibleReinitialization(int pos, Symbol symbol) {
            this.pos = pos;
            this.symbol = symbol;
        }
    }
}

