/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.RelationalExpression;

final class LessExpression
extends RelationalExpression {
    static final /* synthetic */ boolean $assertionsDisabled;

    LessExpression(int pos, Expression leftOperand, Expression rightOperand) {
        super((byte)24, pos, leftOperand, rightOperand);
    }

    strictfp Expression foldExpression() {
        Expression leftOp = this.leftOperand;
        Expression rightOp = this.rightOperand;
        if (leftOp.kind == 2 && rightOp.kind == 2) {
            switch (leftOp.getType().typeClass) {
                case 4: {
                    return new BooleanConstantExpression(this.pos, ((ConstantExpression)leftOp).getIntConstValue() < ((ConstantExpression)rightOp).getIntConstValue());
                }
                case 8: {
                    return new BooleanConstantExpression(this.pos, ((LongConstantExpression)leftOp).lval < ((LongConstantExpression)rightOp).lval);
                }
                case 16: {
                    return new BooleanConstantExpression(this.pos, ((FloatConstantExpression)leftOp).fval < ((FloatConstantExpression)rightOp).fval);
                }
                case 32: {
                    return new BooleanConstantExpression(this.pos, ((DoubleConstantExpression)leftOp).dval < ((DoubleConstantExpression)rightOp).dval);
                }
            }
        }
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        byte opcode;
        this.leftOperand.generateByteCode(byteCodeGenerator);
        this.rightOperand.generateByteCode(byteCodeGenerator);
        switch (this.leftOperand.getType().typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 4: {
                opcode = -94;
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 16: {
                byteCodeGenerator.generate_8((byte)-106);
                opcode = -100;
                byteCodeGenerator.decOpStackHeight(1);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8((byte)-108);
                opcode = -100;
                byteCodeGenerator.decOpStackHeight(3);
                break;
            }
            case 32: {
                byteCodeGenerator.generate_8((byte)-104);
                opcode = -100;
                byteCodeGenerator.decOpStackHeight(3);
            }
        }
        byteCodeGenerator.generate_8_16(opcode, (short)7);
        byteCodeGenerator.generate_8((byte)4);
        byteCodeGenerator.generate_8_16((byte)-89, (short)4);
        byteCodeGenerator.generate_8((byte)3);
    }

    void generateByteCodeBranch(ByteCodeGenerator byteCodeGenerator, Label label, boolean branchIfFalse) {
        this.leftOperand.generateByteCode(byteCodeGenerator);
        this.rightOperand.generateByteCode(byteCodeGenerator);
        switch (this.leftOperand.getType().typeClass) {
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            case 4: {
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_if_icmpge(label);
                } else {
                    byteCodeGenerator.generateBranch_if_icmplt(label);
                }
                byteCodeGenerator.decOpStackHeight(2);
                break;
            }
            case 16: {
                byteCodeGenerator.generate_8((byte)-106);
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_ifge(label);
                } else {
                    byteCodeGenerator.generateBranch_iflt(label);
                }
                byteCodeGenerator.decOpStackHeight(2);
                break;
            }
            case 8: {
                byteCodeGenerator.generate_8((byte)-108);
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_ifge(label);
                } else {
                    byteCodeGenerator.generateBranch_iflt(label);
                }
                byteCodeGenerator.decOpStackHeight(4);
                break;
            }
            case 32: {
                byteCodeGenerator.generate_8((byte)-104);
                if (branchIfFalse) {
                    byteCodeGenerator.generateBranch_ifge(label);
                } else {
                    byteCodeGenerator.generateBranch_iflt(label);
                }
                byteCodeGenerator.decOpStackHeight(4);
            }
        }
    }

    public String toString() {
        return "<";
    }

    static {
        $assertionsDisabled = !LessExpression.class.desiredAssertionStatus();
    }
}

