/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.ConstantPoolClass;
import oracle.ojc.compiler.DepClassFileInfo;
import oracle.ojc.compiler.DepMemberInfo;
import oracle.ojc.compiler.DepSourceFileInfo;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.SourceFile;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.FileStorage;

public class DepInfo {
    private static final int BUFFER_SIZE = 65536;
    static final int REF_READ_4_BYTES_FLAG = -1073741824;
    static final int REF_READ_3_BYTES_FLAG = Integer.MIN_VALUE;
    static final int REF_READ_2_BYTES_FLAG = 0x40000000;
    static final int REF_READ_1_BYTE_FLAG = 0;
    static final int REF_READ_SIZE_FLAG = -1073741824;
    public static final int REF_DECLARATION_FLAG = 0x20000000;
    public static final int REF_TYPE_FLAG = 0x10000000;
    static final int REF_MIGHT_NOT_EXIST = 0x1000000;
    static final int REF_OCCURRING_FLAG = 0x2000000;
    static final int REF_SUPER_FLAG = 0x4000000;
    static final int REF_IMPLEMENTS_FLAG = 0x8000000;
    public static final int ALL_FLAGS = -16777216;
    boolean rebaseCdi = false;
    boolean writeNameReferences = false;
    boolean readNameReferences = false;
    boolean hasNameReferences = false;
    boolean dontCheckEmbeddedFileName = false;
    Hashtable sources = new Hashtable(101);
    Hashtable classes = new Hashtable(427);
    Hashtable memberNames = new Hashtable(427);
    Hashtable indexedMembers = null;
    Hashtable indexedClasses = null;
    Hashtable newlyIndexedObjects = new Hashtable(1003);
    private ArrayList newAddedClasses = new ArrayList();
    private HashMap references = new HashMap();
    private int objectCounter = 0;
    private String encoding;
    static final int MAGIC_HEADER_INVALID = 0;
    static final int MAGIC_HEADER = 305419897;
    static final int MAGIC_HEADER_9_0_2 = 0x9000200;
    static final int MAGIC_HEADER_9_0_5 = 0x9000500;
    static final int MAGIC_HEADER_11_1_1 = 0x11100100;
    static final int MAGIC_HEADER_11_1_102 = 0x11100102;
    static final int MAGIC_HEADER_11_1_103 = 0x11100103;
    static final int MAGIC_REFS_HEADER_2 = -269549566;
    static final int MAGIC_MEMBER_HEADER_2 = -336920574;
    private byte[] buffer;
    private int bufidx;
    private int totalWritten;
    private boolean invalidateOutput;
    private Storage tempNameRefStorage;
    private File tempNameRefStorageFile;
    private Storage cdiStorage;
    private Storage writeToThisStorage;
    private int mh;
    private long lastModified = -1L;
    private int currentOccurring = -1;
    private boolean depInfoInvalid = false;
    private int uniqueNumber = (int)System.currentTimeMillis();
    static final /* synthetic */ boolean $assertionsDisabled;

    private static String lowerCase(String s) {
        char[] str = s.toCharArray();
        block28: for (int i = 0; i < str.length; ++i) {
            switch (str[i]) {
                case 'A': {
                    str[i] = 97;
                    continue block28;
                }
                case 'B': {
                    str[i] = 98;
                    continue block28;
                }
                case 'C': {
                    str[i] = 99;
                    continue block28;
                }
                case 'D': {
                    str[i] = 100;
                    continue block28;
                }
                case 'E': {
                    str[i] = 101;
                    continue block28;
                }
                case 'F': {
                    str[i] = 102;
                    continue block28;
                }
                case 'G': {
                    str[i] = 103;
                    continue block28;
                }
                case 'H': {
                    str[i] = 104;
                    continue block28;
                }
                case 'I': {
                    str[i] = 105;
                    continue block28;
                }
                case 'J': {
                    str[i] = 106;
                    continue block28;
                }
                case 'K': {
                    str[i] = 107;
                    continue block28;
                }
                case 'L': {
                    str[i] = 108;
                    continue block28;
                }
                case 'M': {
                    str[i] = 109;
                    continue block28;
                }
                case 'N': {
                    str[i] = 110;
                    continue block28;
                }
                case 'O': {
                    str[i] = 111;
                    continue block28;
                }
                case 'P': {
                    str[i] = 112;
                    continue block28;
                }
                case 'Q': {
                    str[i] = 113;
                    continue block28;
                }
                case 'R': {
                    str[i] = 114;
                    continue block28;
                }
                case 'S': {
                    str[i] = 115;
                    continue block28;
                }
                case 'T': {
                    str[i] = 116;
                    continue block28;
                }
                case 'U': {
                    str[i] = 117;
                    continue block28;
                }
                case 'V': {
                    str[i] = 118;
                    continue block28;
                }
                case 'W': {
                    str[i] = 119;
                    continue block28;
                }
                case 'X': {
                    str[i] = 120;
                    continue block28;
                }
                case 'Y': {
                    str[i] = 121;
                    continue block28;
                }
                case 'Z': {
                    str[i] = 122;
                    continue block28;
                }
                default: {
                    if (str[i] < '\u0080') continue block28;
                    return s.toLowerCase();
                }
            }
        }
        return new String(str);
    }

    static String fixKey(String fname) {
        if (File.separatorChar == '\\') {
            return DepInfo.lowerCase(fname);
        }
        return fname;
    }

    void addReference(RawClassSymbol dest, RawClassSymbol src) {
        if (dest != src) {
            boolean noSet;
            HashSet<RawClassSymbol> set = (HashSet<RawClassSymbol>)this.references.get(dest);
            boolean bl = noSet = set == null;
            if (noSet) {
                set = new HashSet<RawClassSymbol>();
            }
            if (!set.contains(src)) {
                set.add(src);
            }
            if (noSet) {
                this.references.put(dest, set);
            }
        }
    }

    private static String qualName(RawClassSymbol rcs) {
        if (rcs == null) {
            return "";
        }
        return new String(rcs.getInternalName()).replace('/', '.');
    }

    void addClass(RawClassSymbol rcs, ConstantPool cp, Parser parser) {
        if (rcs != null) {
            String className = DepInfo.qualName(rcs);
            DepClassFileInfo cfi = (DepClassFileInfo)this.classes.get(className);
            if (cfi == null) {
                cfi = new DepClassFileInfo(className, rcs, -1L);
                cfi.index = ++this.objectCounter;
                this.classes.put(className, cfi);
            } else {
                cfi.depClasses.clear();
                cfi.modDate = -1L;
                cfi.rcs = rcs;
            }
            this.newAddedClasses.add(cfi);
            HashSet refs = (HashSet)this.references.get(rcs);
            this.references.remove(rcs);
            for (int i = 0; i < cp.constantPoolClassHashTable.length; ++i) {
                ConstantPoolClass cpc = cp.constantPoolClassHashTable[i];
                while (cpc != null) {
                    String rcsString;
                    String depClassName = new String(cpc.className);
                    int dollarIdx = depClassName.indexOf(36);
                    if (dollarIdx >= 0) {
                        depClassName = depClassName.substring(0, dollarIdx);
                    }
                    if ((rcs = parser.globalScope.lookupClass(depClassName).getClassSymbol()) == null) {
                        System.out.println("error in DepInfo.addClass(): can't lookup " + depClassName + " outerClassName is " + cfi.getClassName());
                        if (!$assertionsDisabled && rcs == null) {
                            throw new AssertionError();
                        }
                    }
                    if (!(rcsString = DepInfo.qualName(rcs)).equals(cfi.getClassName()) && rcs != null) {
                        this.addClassFileInfo(cfi, rcsString, rcs, this.classes);
                        if (refs != null && refs.contains(rcs)) {
                            refs.remove(rcs);
                        }
                    }
                    cpc = cpc.nextHashed;
                }
            }
            if (refs != null) {
                Iterator it = refs.iterator();
                while (it.hasNext()) {
                    rcs = (RawClassSymbol)it.next();
                    this.addClassFileInfo(cfi, DepInfo.qualName(rcs), rcs, this.classes);
                }
            }
        }
    }

    private void addClassFileInfo(DepClassFileInfo occurring, String className, RawClassSymbol rcs, Hashtable classes) {
        DepClassFileInfo cfi = (DepClassFileInfo)classes.get(className);
        if (cfi == null) {
            cfi = new DepClassFileInfo(className, rcs, -1L);
            cfi.index = ++this.objectCounter;
            classes.put(className, cfi);
        }
        occurring.addClassFileInfo(cfi);
    }

    void addClassDate(RawClassSymbol rcs, long modDate) {
        for (int i = this.newAddedClasses.size() - 1; i >= 0; --i) {
            DepClassFileInfo cfi = (DepClassFileInfo)this.newAddedClasses.get(i);
            if (cfi.rcs != rcs) continue;
            cfi.modDate = modDate;
            break;
        }
    }

    ArrayList analyzeSources(ArrayList inputs, Options options) {
        try {
            this.readCdi(options.makeFile);
        }
        catch (Exception e) {
            this.clear();
        }
        if (!options.rebuild) {
            HashMap<String, Storage> filesToMake = new HashMap<String, Storage>(inputs.size());
            HashMap<String, Storage> allFiles = new HashMap<String, Storage>(inputs.size());
            for (int i = 0; i < inputs.size(); ++i) {
                Storage s = (Storage)inputs.get(i);
                String pathName = DepInfo.fixKey(s.getPath());
                allFiles.put(pathName, s);
                if (i >= inputs.size() || filesToMake.get(pathName) != null || !this.needToMake(s, options)) continue;
                filesToMake.put(pathName, s);
            }
            HashMap toRebuild = new HashMap();
            Iterator e = filesToMake.values().iterator();
            while (e.hasNext()) {
                this.findUsedByAndDepSources((Storage)e.next(), toRebuild, options);
            }
            e = toRebuild.values().iterator();
            while (e.hasNext()) {
                File f;
                String n = (String)e.next();
                String pathName = DepInfo.fixKey(n);
                Storage s = (Storage)allFiles.get(pathName);
                if (s == null && (f = new File(n)).exists()) {
                    s = new FileStorage(f);
                }
                if (s == null) continue;
                filesToMake.put(pathName, s);
            }
            ArrayList<Storage> toCompile = new ArrayList<Storage>();
            e = filesToMake.values().iterator();
            while (e.hasNext()) {
                Storage s = (Storage)e.next();
                toCompile.add(s);
            }
            inputs = toCompile;
        }
        for (int x = 0; x < inputs.size(); ++x) {
            Storage s = (Storage)inputs.get(x);
            String n = DepInfo.fixKey(s.getPath());
            DepSourceFileInfo sfi = (DepSourceFileInfo)this.sources.get(n);
            if (sfi == null) continue;
            DepClassFileInfo[] classFiles = sfi.getClassFiles();
            for (int y = 0; y < classFiles.length; ++y) {
                classFiles[y].recompileClass = true;
                classFiles[y].existenceProven = false;
            }
        }
        if (this.readNameReferences && this.writeNameReferences) {
            try {
                this.readMembers(options.makeFile);
                this.readNameReferences(options.makeFile);
            }
            catch (Exception ex) {
                this.clear();
            }
        }
        return inputs;
    }

    int writeFile(Storage cdiStorage, String encoding) throws IOException {
        int classCnt = this.newAddedClasses.size();
        this.cdiStorage = cdiStorage;
        if (classCnt <= 0) {
            if (this.tempNameRefStorage != null) {
                this.tempNameRefStorage.close();
            }
            if (this.tempNameRefStorageFile != null) {
                this.tempNameRefStorageFile.delete();
            }
            return 0;
        }
        HashMap<SourceFile, ArrayList<DepClassFileInfo>> sourceMap = new HashMap<SourceFile, ArrayList<DepClassFileInfo>>(classCnt < 3 ? 3 : classCnt);
        for (int i = 0; i < this.newAddedClasses.size(); ++i) {
            DepClassFileInfo cfi = (DepClassFileInfo)this.newAddedClasses.get(i);
            SourceFile source = cfi.rcs.cd.ccd.sourceFile;
            ArrayList<DepClassFileInfo> classes = (ArrayList<DepClassFileInfo>)sourceMap.get(source);
            if (classes == null) {
                classes = new ArrayList<DepClassFileInfo>();
            }
            classes.add(cfi);
            sourceMap.put(source, classes);
        }
        this.newAddedClasses.clear();
        this.references.clear();
        Iterator it = sourceMap.keySet().iterator();
        while (it.hasNext()) {
            SourceFile sf = (SourceFile)it.next();
            this.addTopLevel(sf.storage, (ArrayList)sourceMap.get(sf));
        }
        return this.write(encoding);
    }

    private void addTopLevel(Storage sourceFileStore, ArrayList classSymbolList) {
        if (sourceFileStore == null || classSymbolList == null) {
            return;
        }
        String sourceFile = sourceFileStore.getPath();
        String sourceKey = DepInfo.fixKey(sourceFile);
        DepSourceFileInfo sfi = (DepSourceFileInfo)this.sources.get(sourceKey);
        if (sfi != null) {
            for (int i = 0; i < sfi.classFiles.size(); ++i) {
                ((DepClassFileInfo)sfi.classFiles.elementAt((int)i)).sfi = null;
            }
            this.sources.remove(sourceKey);
        }
        sfi = new DepSourceFileInfo(sourceFile, sourceFileStore.modDate(), classSymbolList, this.classes);
        this.sources.put(sourceKey, sfi);
    }

    private static Storage findClass(DepClassFileInfo cfi, Options options) {
        Storage store = null;
        String className = cfi.getClassName();
        className = className.replace('.', File.separatorChar) + ".class";
        if (options.destinationDir != null) {
            if (options.destinationFile == null) {
                File destFile = new File(options.destinationDir);
                if (!destFile.exists() && !destFile.mkdirs()) {
                    System.out.println("error: unable to create directory " + options.destinationDir);
                }
                options.destinationFile = new DirectoryStorage(destFile);
            }
            if ((store = options.destinationFile.open(className)) != null) {
                return store;
            }
        }
        if (options.classpath != null) {
            store = options.findStorageOfClass(cfi.getClassName());
        }
        return store;
    }

    private int findUsedByAndDepSources(Storage s, HashMap map, Options options) {
        int count = 0;
        String n = DepInfo.fixKey(s.getPath());
        DepSourceFileInfo sfi = (DepSourceFileInfo)this.sources.get(n);
        if (sfi != null) {
            Enumeration e = this.classes.elements();
            while (e.hasMoreElements()) {
                DepClassFileInfo cfi = (DepClassFileInfo)e.nextElement();
                if (cfi.sfi == null || cfi.depClasses == null) continue;
                for (int i = 0; i < cfi.depClasses.size(); ++i) {
                    File f;
                    String fn;
                    DepClassFileInfo depCls = (DepClassFileInfo)cfi.depClasses.get(i);
                    if (cfi.sfi != sfi && depCls.sfi == sfi) {
                        if (map.put(DepInfo.fixKey(cfi.sfi.fullName), cfi.sfi.fullName) != null) continue;
                        ++count;
                        continue;
                    }
                    if (cfi.sfi != sfi || depCls.sfi == null || depCls.sfi == sfi || map.get(DepInfo.fixKey(fn = depCls.sfi.fullName)) != null || !(f = new File(fn)).exists() || !this.needToMake(new FileStorage(f), options) || map.put(DepInfo.fixKey(fn), fn) != null) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private boolean needToMake(Storage s, Options options) {
        String n = DepInfo.fixKey(s.getPath());
        DepSourceFileInfo sfi = (DepSourceFileInfo)this.sources.get(n);
        if (sfi != null) {
            long sdate = s.modDate();
            for (int i = 0; i < sfi.classFiles.size(); ++i) {
                DepClassFileInfo cfi = (DepClassFileInfo)sfi.classFiles.elementAt(i);
                long cdate = cfi.modDate;
                boolean cdateRetrieved = false;
                if (cdate == -1L) {
                    Storage store = DepInfo.findClass(cfi, options);
                    if (store == null) {
                        System.out.println("findClass: couldnt find: " + cfi.getClassName());
                        return true;
                    }
                    cdate = cfi.modDate = store.modDate();
                    cdateRetrieved = true;
                }
                if (cdate >= sdate && sdate == sfi.modDate) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    void clear() {
        this.classes.clear();
        this.sources.clear();
        this.newAddedClasses.clear();
        this.references.clear();
        this.memberNames.clear();
        this.newlyIndexedObjects.clear();
        if (this.cdiStorage != null) {
            this.cdiStorage.close();
        }
        if (this.tempNameRefStorage != null) {
            this.tempNameRefStorage.close();
        }
        if (this.tempNameRefStorageFile != null) {
            this.tempNameRefStorageFile.delete();
        }
    }

    private static boolean upVersion(long v, long base) {
        return v != 305419897L && v >= base;
    }

    private byte peekByte() {
        return this.buffer[this.bufidx];
    }

    private int readByte() {
        int v = (this.buffer[this.bufidx + 0] & 0xE0) << 24;
        ++this.bufidx;
        return v += this.buffer[this.bufidx + 0] & 0x1F;
    }

    private int readShort() {
        int v = (this.buffer[this.bufidx + 0] & 0xFF) << 24;
        this.bufidx += 2;
        return v += this.buffer[this.bufidx + 1] & 0xFF;
    }

    private int read3Bytes() {
        int v = (this.buffer[this.bufidx + 0] & 0xFF) << 24;
        v += (this.buffer[this.bufidx + 1] & 0xFF) << 8;
        this.bufidx += 3;
        return v += this.buffer[this.bufidx + 2] & 0xFF;
    }

    private int readInt() {
        int v = (this.buffer[this.bufidx + 0] & 0xFF) << 24;
        v += (this.buffer[this.bufidx + 1] & 0xFF) << 16;
        v += (this.buffer[this.bufidx + 2] & 0xFF) << 8;
        this.bufidx += 4;
        return v += this.buffer[this.bufidx + 3] & 0xFF;
    }

    private long readLong() {
        long v = ((long)this.buffer[this.bufidx + 0] & 0xFFL) << 56;
        v += ((long)this.buffer[this.bufidx + 1] & 0xFFL) << 48;
        v += ((long)this.buffer[this.bufidx + 2] & 0xFFL) << 40;
        v += ((long)this.buffer[this.bufidx + 3] & 0xFFL) << 32;
        v += ((long)this.buffer[this.bufidx + 4] & 0xFFL) << 24;
        v += ((long)this.buffer[this.bufidx + 5] & 0xFFL) << 16;
        v += ((long)this.buffer[this.bufidx + 6] & 0xFFL) << 8;
        this.bufidx += 8;
        return v += (long)this.buffer[this.bufidx + 7] & 0xFFL;
    }

    private String readName() {
        int utfl = this.readInt();
        byte[] utf = new byte[utfl];
        for (int i = 0; i < utfl; ++i) {
            utf[i] = this.buffer[this.bufidx++];
        }
        if (this.encoding != null) {
            try {
                return new String(utf, this.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new String(utf);
    }

    public void read(File file) throws IOException {
        FileStorage fileStorage = new FileStorage(file);
        this.read(fileStorage);
    }

    public void read(Storage storage) throws IOException {
        this.readCdi(storage);
        if (this.readNameReferences && !this.rebaseCdi) {
            this.readMembers(storage);
            this.readNameReferences(storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCdi(Storage o) throws IOException {
        byte[] cdiBuffer;
        try {
            this.clear();
            this.lastModified = o.modDate();
            o.open();
            cdiBuffer = o.read();
            Object var4_3 = null;
            o.close();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            o.close();
            throw throwable;
        }
        this.readNameReferences = false;
        this.buffer = cdiBuffer;
        this.bufidx = 0;
        this.encoding = null;
        this.mh = this.readInt();
        if (this.mh == 0) {
            return;
        }
        if (this.mh != 305419897 && this.mh != 0x9000200 && this.mh != 0x9000500 && this.mh != 0x11100100 && this.mh != 0x11100102 && this.mh != 0x11100103) {
            throw new IOException("Missing magic header");
        }
        if (this.mh != 305419897 && !o.toString().equals(this.readName()) && !this.dontCheckEmbeddedFileName) {
            throw new IOException("Invalid DepInfo name");
        }
        switch (this.mh) {
            case 0x9000200: 
            case 0x9000500: 
            case 0x11100100: 
            case 305419897: {
                this.readFirstGeneration(this.mh);
                break;
            }
            case 0x11100102: 
            case 0x11100103: {
                this.readNameReferences = true;
                this.readSecondGeneration(o);
                break;
            }
            default: {
                throw new IOException("Invalid magic header");
            }
        }
        this.buffer = null;
    }

    void readFirstGeneration(int mh) throws IOException {
        int i;
        DepClassFileInfo cfi;
        Hashtable<Integer, DepSourceFileInfo> allObjects = new Hashtable<Integer, DepSourceFileInfo>(1003);
        int classCnt = this.readInt();
        for (int i2 = 0; i2 < classCnt; ++i2) {
            int pos = this.bufidx;
            String className = this.readName();
            cfi = this.getDepClassFileInfo(this.newlyIndexedObjects, pos);
            cfi.setClassName(className);
            this.classes.put(cfi.getClassName(), cfi);
        }
        int sourceCnt = this.readInt();
        for (i = 0; i < sourceCnt; ++i) {
            int pos = this.bufidx;
            String name = this.readName();
            long modDate = DepInfo.upVersion(mh, 0x9000500L) ? this.readLong() : -1L;
            DepSourceFileInfo sfi = new DepSourceFileInfo(name, modDate);
            this.sources.put(DepInfo.fixKey(sfi.fullName), sfi);
            allObjects.put(new Integer(pos), sfi);
            sfi.index = pos;
        }
        for (i = 0; i < classCnt; ++i) {
            Integer pos = new Integer(this.readInt());
            cfi = this.getDepClassFileInfo(this.newlyIndexedObjects, pos);
            if (cfi.getClassName() == null) {
                throw new IOException("DepInfo error, class file missing for index: " + pos);
            }
            cfi.modDate = this.readLong();
            int depClassesCnt = this.readInt();
            cfi.depClasses = new ArrayList(depClassesCnt >= 0 ? depClassesCnt : 0);
            while (depClassesCnt-- > 0) {
                pos = new Integer(this.readInt());
                if (pos != 0) {
                    DepClassFileInfo d = this.getDepClassFileInfo(this.newlyIndexedObjects, pos);
                    if (d.getClassName() != null) {
                        cfi.depClasses.add(d);
                        continue;
                    }
                    throw new IOException("DepInfo error, dependent class missing for index: " + pos);
                }
                throw new IOException("DepInfo error: " + cfi.getClassName() + ": dep class missing");
            }
        }
        while (sourceCnt-- > 0) {
            Integer pos = new Integer(this.readInt());
            DepSourceFileInfo sfi = (DepSourceFileInfo)allObjects.get(pos);
            int depClassesCnt = this.readInt();
            sfi.classFiles = new Vector(depClassesCnt);
            while (depClassesCnt-- > 0) {
                pos = new Integer(this.readInt());
                if (pos != 0) {
                    DepClassFileInfo d = this.getDepClassFileInfo(this.newlyIndexedObjects, pos);
                    if (d.getClassName() != null) {
                        d.sfi = sfi;
                        sfi.classFiles.addElement(d);
                        continue;
                    }
                    throw new IOException("DepInfo error: source file: " + sfi.fullName + " class not found at index " + pos);
                }
                throw new IOException("DepInfo error: " + sfi.fullName + ": class file missing");
            }
        }
        allObjects.clear();
    }

    private void readSecondGeneration(Storage cdiStorage) throws IOException {
        int index;
        int i;
        this.clear();
        this.encoding = this.readName();
        this.objectCounter = 0;
        int classCnt = this.readInt();
        for (int i2 = 0; i2 < classCnt; ++i2) {
            int index2 = this.readInt();
            DepClassFileInfo cfi = this.getDepClassFileInfo(this.newlyIndexedObjects, index2);
            cfi.setClassName(this.readName());
            this.classes.put(cfi.getClassName(), cfi);
        }
        int sourceCnt = this.readInt();
        int sourceCounter = Integer.MAX_VALUE;
        for (i = 0; i < sourceCnt; ++i) {
            index = --sourceCounter;
            String name = this.readName();
            long modDate = this.readLong();
            DepSourceFileInfo sfi = new DepSourceFileInfo(name, modDate);
            this.sources.put(DepInfo.fixKey(sfi.fullName), sfi);
            this.newlyIndexedObjects.put(new Integer(index), sfi);
            sfi.index = index;
        }
        for (i = 0; i < classCnt; ++i) {
            int implementsCount;
            index = this.readInt();
            DepClassFileInfo cfi = this.getDepClassFileInfo(this.newlyIndexedObjects, index);
            if (cfi.getClassName() == null) {
                throw new IOException("DepInfo error, class file missing for index: " + index);
            }
            cfi.modDate = this.readLong();
            int depClassesCnt = this.readInt();
            cfi.depClasses = new ArrayList(depClassesCnt >= 0 ? depClassesCnt : 0);
            while (depClassesCnt-- > 0) {
                index = this.readInt();
                if (index != 0) {
                    DepClassFileInfo d = this.getDepClassFileInfo(this.newlyIndexedObjects, index);
                    if (d.getClassName() != null) {
                        cfi.depClasses.add(d);
                        continue;
                    }
                    throw new IOException("DepInfo error: " + cfi.getClassName() + ": class not found at index " + index);
                }
                throw new IOException("DepInfo error: " + cfi.getClassName() + ": dep class missing");
            }
            if (this.getMagicHeader() != 0x11100103) continue;
            int superIndex = this.readInt();
            if (superIndex >= 0) {
                DepClassFileInfo d = this.getDepClassFileInfo(this.newlyIndexedObjects, superIndex);
                if (d.getClassName() != null) {
                    cfi.superClass = d;
                } else {
                    throw new IOException("DepInfo error: " + cfi.getClassName() + ": class not found at index " + superIndex);
                }
            }
            if ((implementsCount = this.readInt()) > 0) {
                cfi.implementedInterfaces = new ArrayList();
            }
            for (int x = 0; x < implementsCount; ++x) {
                int implementsIndex = this.readInt();
                DepClassFileInfo d = this.getDepClassFileInfo(this.newlyIndexedObjects, implementsIndex);
                if (d.getClassName() == null) {
                    throw new IOException("DepInfo error: " + cfi.getClassName() + ": class not found at index " + implementsIndex);
                }
                cfi.implementedInterfaces.add(d);
            }
        }
        while (sourceCnt-- > 0) {
            Integer pos = new Integer(this.readInt());
            DepSourceFileInfo sfi = (DepSourceFileInfo)this.newlyIndexedObjects.get(pos);
            int depClassesCnt = this.readInt();
            sfi.classFiles = new Vector(depClassesCnt);
            while (depClassesCnt-- > 0) {
                int index3 = this.readInt();
                if (index3 != 0) {
                    DepClassFileInfo d = this.getDepClassFileInfo(this.newlyIndexedObjects, index3);
                    if (d.getClassName() != null) {
                        d.sfi = sfi;
                        sfi.classFiles.addElement(d);
                        continue;
                    }
                    throw new IOException("DepInfo error: source file: " + sfi.fullName + " class not found at index " + index3);
                }
                throw new IOException("DepInfo error: " + sfi.fullName + ": class file missing");
            }
        }
        if (this.bufidx <= this.buffer.length - 4) {
            this.uniqueNumber = this.readInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readMembers(Storage cdiStorage) throws IOException {
        String saveEncoding;
        int saveBufidx;
        byte[] saveBuffer;
        block15: {
            block14: {
                byte[] memberNameBuffer;
                Hashtable<Integer, Integer> nameIndexTable = new Hashtable<Integer, Integer>(407);
                String memberStorageFileName = this.getCdiHelperFileName(cdiStorage, "zyxm");
                File membersStorageFile = new File(memberStorageFileName);
                if (!membersStorageFile.exists()) {
                    return;
                }
                FileStorage membersStorage = new FileStorage(membersStorageFile);
                try {
                    membersStorage.open();
                    memberNameBuffer = membersStorage.read();
                    Object var11_7 = null;
                    membersStorage.close();
                }
                catch (Throwable throwable) {
                    Object var11_8 = null;
                    membersStorage.close();
                    throw throwable;
                }
                if (memberNameBuffer.length == 0) {
                    return;
                }
                saveBuffer = this.buffer;
                this.buffer = memberNameBuffer;
                saveBufidx = this.bufidx;
                this.bufidx = 0;
                saveEncoding = this.encoding;
                this.encoding = null;
                try {
                    int classIndex;
                    int header = this.readInt();
                    if (header != -336920574) {
                        Object var20_15 = null;
                        this.buffer = saveBuffer;
                        this.bufidx = saveBufidx;
                        this.encoding = saveEncoding;
                        return;
                    }
                    this.encoding = this.readName();
                    if (this.readInt() != this.uniqueNumber) {
                        break block14;
                    }
                    block4: while ((classIndex = this.readInt()) != -1) {
                        DepClassFileInfo cfi = this.getDepClassFileInfo(this.newlyIndexedObjects, classIndex);
                        if (cfi.getClassName() == null) {
                            throw new IOException("DepInfo error during readMembers: class not found for index: " + classIndex);
                        }
                        boolean skipMembers = cfi.getClassName() == null || cfi.recompileClass;
                        int memberCount = this.readInt();
                        int x = 0;
                        while (true) {
                            if (x >= memberCount) continue block4;
                            int memberIndex = this.readInt();
                            int nameIndex = this.readInt();
                            DepMemberInfo dmi = this.getDepMemberInfo(this.newlyIndexedObjects, memberIndex);
                            dmi.nameIndex = new Integer(nameIndex);
                            dmi.definingClass = cfi;
                            if (skipMembers) {
                                dmi.existenceProven = false;
                            }
                            cfi.putMember(dmi.nameIndex, dmi);
                            nameIndexTable.put(dmi.nameIndex, dmi.nameIndex);
                            ++x;
                        }
                        break;
                    }
                    for (int nameCount = this.readInt(); nameCount > 0; --nameCount) {
                        String name = this.readName();
                        Integer nameIndex = (Integer)nameIndexTable.get(new Integer(name.hashCode()));
                        if (nameIndex == null) continue;
                        this.memberNames.put(nameIndex, name);
                    }
                    break block15;
                }
                catch (Throwable throwable) {
                    Object var20_18 = null;
                    this.buffer = saveBuffer;
                    this.bufidx = saveBufidx;
                    this.encoding = saveEncoding;
                    throw throwable;
                }
            }
            Object var20_16 = null;
            this.buffer = saveBuffer;
            this.bufidx = saveBufidx;
            this.encoding = saveEncoding;
            return;
        }
        Object var20_17 = null;
        this.buffer = saveBuffer;
        this.bufidx = saveBufidx;
        this.encoding = saveEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readNameReferences(Storage cdiStorage) throws IOException {
        int saveBufidx;
        byte[] saveBuffer;
        block17: {
            block16: {
                byte[] nameRefBuffer;
                String nameRefStorageName = this.getCdiHelperFileName(cdiStorage, "zyxr");
                File nameRefStorageFile = new File(nameRefStorageName);
                if (!nameRefStorageFile.exists()) {
                    return;
                }
                FileStorage nameRefStorage = new FileStorage(nameRefStorageFile);
                try {
                    nameRefStorage.open();
                    nameRefBuffer = nameRefStorage.read();
                    Object var9_6 = null;
                    nameRefStorage.close();
                }
                catch (Throwable throwable) {
                    Object var9_7 = null;
                    nameRefStorage.close();
                    throw throwable;
                }
                saveBuffer = this.buffer;
                this.buffer = nameRefBuffer;
                saveBufidx = this.bufidx;
                this.bufidx = 0;
                DepClassFileInfo occurringCfi = null;
                int occurring = -1;
                try {
                    int reference;
                    int header = this.readInt();
                    if (header != -269549566) {
                        Object var17_14 = null;
                        this.buffer = saveBuffer;
                        this.bufidx = saveBufidx;
                        return;
                    }
                    if (this.readInt() != this.uniqueNumber) {
                        break block16;
                    }
                    while (this.bufidx <= this.buffer.length - 12 && (reference = this.readVariableSizedInt()) != -1) {
                        if ((reference & 0x2000000) != 0) {
                            occurring = reference & 0xFFFFFF;
                            reference = this.readVariableSizedInt();
                            occurringCfi = this.getDepClassFileInfo(this.newlyIndexedObjects, occurring);
                            if (occurringCfi.recompileClass) {
                                occurringCfi.nameRefs = null;
                            }
                        }
                        int pos = this.readInt();
                        this.hasNameReferences = true;
                        if (reference == -1) {
                            occurringCfi.nameRefs = null;
                            continue;
                        }
                        if (occurringCfi.recompileClass) continue;
                        int lookupIndex = reference & 0xFFFFFF;
                        if ((reference & 0x10000000) != 0) {
                            DepClassFileInfo cfi = this.getDepClassFileInfo(this.newlyIndexedObjects, lookupIndex);
                            int finalIndex = cfi.index | 0x10000000;
                            if ((reference & 0x20000000) != 0) {
                                finalIndex |= 0x20000000;
                            }
                            if (!cfi.existenceProven) {
                                finalIndex |= 0x1000000;
                            }
                            occurringCfi.addNameReference(finalIndex, pos);
                            continue;
                        }
                        DepMemberInfo dmi = this.getDepMemberInfo(this.newlyIndexedObjects, lookupIndex);
                        int memberIndex = dmi.index;
                        if ((reference & 0x20000000) != 0) {
                            memberIndex |= 0x20000000;
                        }
                        if (!dmi.existenceProven) {
                            memberIndex |= 0x1000000;
                        }
                        occurringCfi.addNameReference(memberIndex, pos);
                    }
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var17_17 = null;
                    this.buffer = saveBuffer;
                    this.bufidx = saveBufidx;
                    throw throwable;
                }
            }
            Object var17_15 = null;
            this.buffer = saveBuffer;
            this.bufidx = saveBufidx;
            return;
        }
        Object var17_16 = null;
        this.buffer = saveBuffer;
        this.bufidx = saveBufidx;
    }

    private int readVariableSizedInt() {
        byte chunk = this.peekByte();
        switch (chunk << 24 & 0xC0000000) {
            case 0: {
                int v = this.readByte();
                return v;
            }
            case 0x40000000: {
                int v = this.readShort();
                return v;
            }
            case -2147483648: {
                int v = this.read3Bytes();
                return v;
            }
            case -1073741824: {
                int v = this.readInt();
                return v;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return this.readInt();
    }

    private void writeVariableSizedInt(int v) throws IOException {
        int flags = v & 0xFF000000 & 0x3FFFFFFF;
        int value = v & 0xFFFFFF;
        if ((v & 0x10000000) == 0 && (value & 0xFFFFFFE0) == 0) {
            if ((v & 0x20000000) == 0) {
                this.writeByte((byte)(value & 0x1F));
            } else {
                this.writeByte((byte)(0x20 | value & 0x1F));
            }
        } else if ((value & 0xFFFFFF00) == 0) {
            this.writeShort((flags | 0x40000000) >> 16 | value & 0xFF);
        } else if ((value & 0xFFFF0000) == 0) {
            this.write3Bytes((flags | Integer.MIN_VALUE) >> 8 | value & 0xFFFF);
        } else {
            this.writeInt(flags | 0xC0000000 | value & 0xFFFFFF);
        }
    }

    private void writeByte(byte b) throws IOException {
        if (this.bufidx + 1 > 65536) {
            this.flushBuffer();
        }
        this.buffer[this.bufidx + 0] = b;
        ++this.bufidx;
    }

    private void writeShort(int v) throws IOException {
        if (this.bufidx + 2 > 65536) {
            this.flushBuffer();
        }
        this.buffer[this.bufidx + 0] = (byte)(v >> 8 & 0xFF);
        this.buffer[this.bufidx + 1] = (byte)(v & 0xFF);
        this.bufidx += 2;
    }

    private void write3Bytes(int v) throws IOException {
        if (this.bufidx + 3 > 65536) {
            this.flushBuffer();
        }
        this.buffer[this.bufidx + 0] = (byte)(v >> 16 & 0xFF);
        this.buffer[this.bufidx + 1] = (byte)(v >> 8 & 0xFF);
        this.buffer[this.bufidx + 2] = (byte)(v & 0xFF);
        this.bufidx += 3;
    }

    private void writeInt(int v) throws IOException {
        if (this.bufidx + 4 > 65536) {
            this.flushBuffer();
        }
        this.buffer[this.bufidx + 0] = (byte)(v >> 24 & 0xFF);
        this.buffer[this.bufidx + 1] = (byte)(v >> 16 & 0xFF);
        this.buffer[this.bufidx + 2] = (byte)(v >> 8 & 0xFF);
        this.buffer[this.bufidx + 3] = (byte)(v & 0xFF);
        this.bufidx += 4;
    }

    private void writeLong(long v) throws IOException {
        if (this.bufidx + 8 > 65536) {
            this.flushBuffer();
        }
        this.buffer[this.bufidx + 0] = (byte)(v >>> 56 & 0xFFL);
        this.buffer[this.bufidx + 1] = (byte)(v >>> 48 & 0xFFL);
        this.buffer[this.bufidx + 2] = (byte)(v >>> 40 & 0xFFL);
        this.buffer[this.bufidx + 3] = (byte)(v >>> 32 & 0xFFL);
        this.buffer[this.bufidx + 4] = (byte)(v >>> 24 & 0xFFL);
        this.buffer[this.bufidx + 5] = (byte)(v >>> 16 & 0xFFL);
        this.buffer[this.bufidx + 6] = (byte)(v >>> 8 & 0xFFL);
        this.buffer[this.bufidx + 7] = (byte)(v >>> 0 & 0xFFL);
        this.bufidx += 8;
    }

    private byte[] encodeName(String name) {
        byte[] utf;
        try {
            utf = this.encoding != null ? name.getBytes(this.encoding) : name.getBytes();
        }
        catch (UnsupportedEncodingException ex) {
            utf = name.getBytes();
        }
        return utf;
    }

    private void writeName(String v) throws IOException {
        byte[] utf = this.encodeName(v);
        int utfl = utf.length;
        this.writeInt(utfl);
        int utfIndex = 0;
        while (utfIndex < utfl) {
            while (utfIndex < utfl && this.bufidx < 65536) {
                this.buffer[this.bufidx++] = utf[utfIndex++];
            }
            if (this.bufidx < 65536) continue;
            this.flushBuffer();
        }
    }

    private boolean validate(Storage storage) throws IOException {
        try {
            this.readCdi(storage);
            if (this.writeNameReferences) {
                this.readMembers(storage);
                this.readNameReferences(storage);
            }
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            storage.close();
            return false;
        }
    }

    void startWritingNameRefFile(Storage storage) {
        this.invalidateOutput = false;
        if (!this.writeNameReferences) {
            return;
        }
        this.uniqueNumber = (int)System.currentTimeMillis();
        this.totalWritten = 0;
        this.tempNameRefStorageFile = new File(storage.getPath() + "newrefs");
        this.tempNameRefStorageFile.deleteOnExit();
        this.writeToThisStorage = this.tempNameRefStorage = new FileStorage(this.tempNameRefStorageFile);
        this.buffer = new byte[65536];
        this.bufidx = 0;
        try {
            this.writeInt(-269549566);
            this.writeInt(this.uniqueNumber);
            this.currentOccurring = -1;
            Iterator iterator = this.classes.values().iterator();
            while (iterator.hasNext()) {
                HashSet<int[]> danglingNameRefs = null;
                DepClassFileInfo cfi = (DepClassFileInfo)iterator.next();
                if (cfi.nameRefs == null) continue;
                Iterator refIter = cfi.nameRefs.iterator();
                while (refIter.hasNext()) {
                    int[] details = (int[])refIter.next();
                    if ((details[0] & 0x1000000) != 0) {
                        if (danglingNameRefs == null) {
                            danglingNameRefs = new HashSet<int[]>();
                        }
                        details[0] = details[0] & 0xFEFFFFFF;
                        danglingNameRefs.add(details);
                        continue;
                    }
                    if (this.currentOccurring != cfi.index) {
                        this.writeVariableSizedInt(cfi.index | 0x2000000 | 0x10000000);
                        this.currentOccurring = cfi.index;
                    }
                    this.writeVariableSizedInt(details[0]);
                    this.writeInt(details[1]);
                }
                if (danglingNameRefs != null) {
                    cfi.nameRefs = danglingNameRefs;
                    continue;
                }
                cfi.nameRefs = null;
            }
        }
        catch (IOException ex) {
            this.invalidateOutput = true;
        }
    }

    private void writeHeader(String newEncoding) throws IOException {
        this.mh = 0x11100103;
        this.writeInt(this.mh);
        this.writeName(this.cdiStorage.toString());
        this.writeName(newEncoding);
    }

    private void flushBuffer() throws IOException {
        if (this.bufidx > 0) {
            this.totalWritten += this.bufidx;
            this.writeToThisStorage.write(this.buffer, 0, this.bufidx);
            this.bufidx = 0;
        }
    }

    private String getCdiHelperFileName(Storage cdiStorage, String helperSuffix) {
        String cdiStorageName = cdiStorage.getPath();
        int dotIndex = cdiStorageName.lastIndexOf(46);
        if (dotIndex > 0) {
            return cdiStorageName.substring(0, dotIndex) + helperSuffix + cdiStorageName.substring(dotIndex);
        }
        return cdiStorageName + helperSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeNameReferences() throws IOException {
        Storage finalNameRefStorage = null;
        String finalNameRefStorageName = this.getCdiHelperFileName(this.cdiStorage, "zyxr");
        File finalNameRefStorageFile = new File(finalNameRefStorageName);
        try {
            try {
                int count;
                if (!$assertionsDisabled && this.tempNameRefStorage == null) {
                    throw new AssertionError();
                }
                Iterator iterator = this.classes.values().iterator();
                while (iterator.hasNext()) {
                    DepClassFileInfo cfi = (DepClassFileInfo)iterator.next();
                    if (cfi.nameRefs == null) continue;
                    Iterator refIter = cfi.nameRefs.iterator();
                    while (refIter.hasNext()) {
                        int[] details = (int[])refIter.next();
                        int lookupIndex = details[0] & 0xFFFFFF;
                        if ((details[0] & 0x10000000) != 0) {
                            DepClassFileInfo typeCfi = this.getDepClassFileInfo(lookupIndex);
                            if (typeCfi == null) {
                                System.out.println("DepInfo error in writeNameReferences: can't find type for index: " + lookupIndex);
                                continue;
                            }
                            if (!typeCfi.existenceProven) {
                                continue;
                            }
                        } else {
                            DepMemberInfo dmi = this.getDepMemberInfo(lookupIndex);
                            if (dmi == null) {
                                System.out.println("DepInfo error in writeNameReferences: can't find member for index: " + lookupIndex);
                                continue;
                            }
                            if (!dmi.existenceProven) continue;
                        }
                        if (this.currentOccurring != cfi.index) {
                            this.writeVariableSizedInt(cfi.index | 0x2000000 | 0x10000000);
                            this.currentOccurring = cfi.index;
                        }
                        this.writeVariableSizedInt(details[0]);
                        this.writeInt(details[1]);
                    }
                }
                this.writeInt(-1);
                this.writeInt(-1);
                this.writeInt(-1);
                this.flushBuffer();
                this.tempNameRefStorage.close();
                finalNameRefStorage = new FileStorage(finalNameRefStorageFile);
                this.tempNameRefStorage.open();
                while ((count = this.tempNameRefStorage.read(this.buffer)) > 0) {
                    finalNameRefStorage.write(this.buffer, 0, count);
                }
                Object var11_12 = null;
                if (finalNameRefStorage != null) {
                    finalNameRefStorage.close();
                }
                this.tempNameRefStorage.close();
                this.tempNameRefStorageFile.delete();
            }
            catch (IOException ex) {
                this.invalidateOutput = true;
                Object var11_13 = null;
                if (finalNameRefStorage != null) {
                    finalNameRefStorage.close();
                }
                this.tempNameRefStorage.close();
                this.tempNameRefStorageFile.delete();
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (finalNameRefStorage != null) {
                finalNameRefStorage.close();
            }
            this.tempNameRefStorage.close();
            this.tempNameRefStorageFile.delete();
            throw throwable;
        }
        if (this.invalidateOutput) {
            finalNameRefStorageFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeCdiFile(String newEncoding) throws IOException {
        if (!$assertionsDisabled && this.cdiStorage == null) {
            throw new AssertionError();
        }
        try {
            try {
                int i;
                DepSourceFileInfo sfi;
                this.buffer = new byte[65536];
                this.bufidx = 0;
                this.writeToThisStorage = this.cdiStorage;
                this.invalidateOutput = false;
                this.encoding = null;
                if (newEncoding == null) {
                    newEncoding = Options.getDefaultEncoding();
                }
                this.writeHeader(newEncoding);
                this.encoding = newEncoding;
                this.writeInt(this.classes.size());
                Enumeration e = this.classes.elements();
                while (e.hasMoreElements()) {
                    DepClassFileInfo cfi = (DepClassFileInfo)e.nextElement();
                    this.writeInt(cfi.index);
                    this.writeName(cfi.getClassName());
                }
                this.writeInt(this.sources.size());
                e = this.sources.elements();
                int sourceCounter = Integer.MAX_VALUE;
                while (e.hasMoreElements()) {
                    sfi = (DepSourceFileInfo)e.nextElement();
                    sfi.index = --sourceCounter;
                    this.writeName(sfi.fullName);
                    this.writeLong(sfi.modDate);
                }
                e = this.classes.elements();
                while (e.hasMoreElements()) {
                    int x;
                    DepClassFileInfo cfi = (DepClassFileInfo)e.nextElement();
                    this.writeInt(cfi.index);
                    this.writeLong(cfi.modDate);
                    this.writeInt(cfi.depClasses.size());
                    for (i = 0; i < cfi.depClasses.size(); ++i) {
                        DepClassFileInfo d = (DepClassFileInfo)cfi.depClasses.get(i);
                        this.writeInt((d = (DepClassFileInfo)this.classes.get(d.getClassName())) != null ? d.index : 0);
                    }
                    if (this.getMagicHeader() != 0x11100103) continue;
                    int superIndex = -1;
                    if (cfi.superClass != null) {
                        cfi.superClass = (DepClassFileInfo)this.classes.get(cfi.superClass.getClassName());
                        superIndex = cfi.superClass != null ? cfi.superClass.index : -1;
                    }
                    this.writeInt(superIndex);
                    int interfaceCount = 0;
                    ArrayList<DepClassFileInfo> checkedInterfaces = new ArrayList<DepClassFileInfo>();
                    if (cfi.implementedInterfaces != null) {
                        for (x = 0; x < cfi.implementedInterfaces.size(); ++x) {
                            DepClassFileInfo interfaceCfi = (DepClassFileInfo)cfi.implementedInterfaces.get(x);
                            if ((interfaceCfi = (DepClassFileInfo)this.classes.get(interfaceCfi.getClassName())) == null) continue;
                            checkedInterfaces.add(interfaceCfi);
                        }
                        interfaceCount = checkedInterfaces.size();
                    }
                    this.writeInt(interfaceCount);
                    for (x = 0; x < checkedInterfaces.size(); ++x) {
                        DepClassFileInfo checkedCfi = (DepClassFileInfo)checkedInterfaces.get(x);
                        this.writeInt(checkedCfi.index);
                    }
                }
                e = this.sources.elements();
                while (e.hasMoreElements()) {
                    sfi = (DepSourceFileInfo)e.nextElement();
                    this.writeInt(sfi.index);
                    this.writeInt(sfi.classFiles.size());
                    for (i = 0; i < sfi.classFiles.size(); ++i) {
                        DepClassFileInfo d = (DepClassFileInfo)sfi.classFiles.elementAt(i);
                        this.writeInt((d = (DepClassFileInfo)this.classes.get(d.getClassName())) != null ? d.index : 0);
                    }
                }
                this.writeInt(this.uniqueNumber);
                this.flushBuffer();
            }
            catch (IOException ex) {
                this.invalidateOutput = true;
                Object var11_15 = null;
                this.cdiStorage.close();
            }
            Object var11_14 = null;
            this.cdiStorage.close();
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.cdiStorage.close();
            throw throwable;
        }
        if (this.invalidateOutput) {
            try {
                this.totalWritten = 0;
                this.writeToThisStorage = this.cdiStorage;
                this.writeInt(0);
                this.flushBuffer();
                Object var13_18 = null;
                this.cdiStorage.close();
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                this.cdiStorage.close();
                throw throwable;
            }
        }
        return this.totalWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMembers() throws IOException {
        String memberStorageFileName = this.getCdiHelperFileName(this.cdiStorage, "zyxm");
        File memberStorageFile = new File(memberStorageFileName);
        if (this.invalidateOutput) {
            if (memberStorageFile.exists()) {
                memberStorageFile.delete();
            }
            return;
        }
        FileStorage memberStorage = new FileStorage(memberStorageFile);
        this.bufidx = 0;
        this.invalidateOutput = false;
        try {
            try {
                this.writeToThisStorage = memberStorage;
                this.writeInt(-336920574);
                this.writeName(this.encoding);
                this.writeInt(this.uniqueNumber);
                Enumeration e = this.classes.elements();
                while (e.hasMoreElements()) {
                    DepMemberInfo dmi;
                    DepClassFileInfo cfi = (DepClassFileInfo)e.nextElement();
                    this.writeInt(cfi.index);
                    int memberCount = 0;
                    Iterator iter = cfi.members.values().iterator();
                    while (iter.hasNext()) {
                        dmi = (DepMemberInfo)iter.next();
                        if (!dmi.existenceProven) continue;
                        ++memberCount;
                    }
                    this.writeInt(memberCount);
                    iter = cfi.members.values().iterator();
                    while (iter.hasNext()) {
                        dmi = (DepMemberInfo)iter.next();
                        if (!dmi.existenceProven) continue;
                        this.writeInt(dmi.index);
                        this.writeInt(dmi.nameIndex);
                    }
                }
                this.writeInt(-1);
                this.writeInt(this.memberNames.values().size());
                Iterator memberNameIter = this.memberNames.values().iterator();
                while (memberNameIter.hasNext()) {
                    this.writeName((String)memberNameIter.next());
                }
                this.flushBuffer();
            }
            catch (IOException ex) {
                this.invalidateOutput = true;
                Object var10_11 = null;
                memberStorage.close();
            }
            Object var10_10 = null;
            memberStorage.close();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            memberStorage.close();
            throw throwable;
        }
        if (this.invalidateOutput) {
            memberStorageFile.delete();
        }
    }

    private int write(String encoding) throws IOException {
        if (!$assertionsDisabled && this.cdiStorage == null) {
            throw new AssertionError();
        }
        if (!this.writeNameReferences) {
            return this.writeFirstGeneration(this.cdiStorage);
        }
        this.writeNameReferences();
        int totalWritten = this.writeCdiFile(encoding);
        this.writeMembers();
        if (!$assertionsDisabled && !this.validate(this.cdiStorage)) {
            throw new AssertionError();
        }
        this.clear();
        return totalWritten;
    }

    void addTypeReference(RawClassSymbol occurringClass, RawClassSymbol typeClass, int pos) {
        this.addTypeReference(occurringClass, typeClass, pos, false);
    }

    void addTypeDeclaration(RawClassSymbol occurringClass, RawClassSymbol typeClass, int pos) {
        this.addTypeReference(occurringClass, typeClass, pos, true);
    }

    private void addTypeReference(RawClassSymbol occurringClass, RawClassSymbol typeClass, int pos, boolean isDeclaration) {
        try {
            DepClassFileInfo occurring = this.getDepClassFileInfo(occurringClass, true);
            DepClassFileInfo type = this.getDepClassFileInfo(typeClass, false);
            type.existenceProven = true;
            if (occurring.index != this.currentOccurring) {
                this.writeVariableSizedInt(occurring.index | 0x2000000 | 0x10000000);
                this.currentOccurring = occurring.index;
            }
            int index = type.index | 0x10000000;
            if (isDeclaration) {
                index |= 0x20000000;
            }
            this.writeVariableSizedInt(index);
            this.writeInt(pos);
        }
        catch (IOException ex) {
            this.invalidateOutput = true;
        }
    }

    void addMethodDeclaration(RawClassSymbol occurringClass, MethodSymbol methodSymbol, int pos) {
        this.addMethodReference(occurringClass, methodSymbol, pos, true);
    }

    void addMethodReference(RawClassSymbol occurringClass, MethodSymbol methodSymbol, int pos) {
        this.addMethodReference(occurringClass, methodSymbol, pos, false);
    }

    private void addMethodReference(RawClassSymbol occurringClass, MethodSymbol methodSymbol, int pos, boolean isDeclaration) {
        try {
            DepClassFileInfo occurring = this.getDepClassFileInfo(occurringClass, true);
            DepMemberInfo member = this.getDepMemberInfo(methodSymbol);
            this.addMemberReference(member, occurring.index, isDeclaration, pos);
        }
        catch (IOException ex) {
            this.invalidateOutput = true;
        }
    }

    void addFieldDeclaration(RawClassSymbol occurringClass, FieldSymbol fieldSymbol, int pos) {
        this.addFieldReference(occurringClass, fieldSymbol, pos, true);
    }

    void addFieldReference(RawClassSymbol occurringClass, FieldSymbol fieldSymbol, int pos) {
        this.addFieldReference(occurringClass, fieldSymbol, pos, false);
    }

    private void addFieldReference(RawClassSymbol occurringClass, FieldSymbol fieldSymbol, int pos, boolean isDeclaration) {
        try {
            DepClassFileInfo occurring = this.getDepClassFileInfo(occurringClass, true);
            DepMemberInfo member = this.getDepMemberInfo(fieldSymbol);
            this.addMemberReference(member, occurring.index, isDeclaration, pos);
        }
        catch (IOException ex) {
            this.invalidateOutput = true;
        }
    }

    private void addMemberReference(DepMemberInfo member, int occurringIndex, boolean isDeclaration, int pos) {
        try {
            member.existenceProven = true;
            if (occurringIndex != this.currentOccurring) {
                this.writeVariableSizedInt(occurringIndex | 0x2000000 | 0x10000000);
                this.currentOccurring = occurringIndex;
            }
            if (isDeclaration) {
                this.writeVariableSizedInt(member.index | 0x20000000);
            } else {
                this.writeVariableSizedInt(member.index);
            }
            this.writeInt(pos);
        }
        catch (IOException ex) {
            this.invalidateOutput = true;
        }
    }

    void addSuperRelation(RawClassSymbol symbol, RawClassSymbol superSymbol) {
        try {
            DepClassFileInfo superClassSymbol;
            DepClassFileInfo classSymbol = this.getDepClassFileInfo(symbol, false);
            classSymbol.superClass = superClassSymbol = this.getDepClassFileInfo(superSymbol, false);
        }
        catch (IOException ex) {
            this.invalidateOutput = true;
        }
    }

    void addImplementsRelation(RawClassSymbol symbol, RawClassSymbol implementedSymbol) {
        try {
            DepClassFileInfo cfi = this.getDepClassFileInfo(symbol, false);
            DepClassFileInfo implementedCfi = this.getDepClassFileInfo(implementedSymbol, false);
            if (cfi.implementedInterfaces == null) {
                cfi.implementedInterfaces = new ArrayList();
            }
            if (!cfi.implementedInterfaces.contains(implementedCfi)) {
                cfi.implementedInterfaces.add(implementedCfi);
            }
        }
        catch (IOException ex) {
            this.invalidateOutput = true;
        }
    }

    private DepClassFileInfo getDepClassFileInfo(RawClassSymbol rcs, boolean invalidatePrevNameRefs) throws IOException {
        String name = DepInfo.qualName(rcs);
        DepClassFileInfo cfi = (DepClassFileInfo)this.classes.get(name);
        if (cfi == null) {
            cfi = new DepClassFileInfo(name, rcs, -1L);
            cfi.index = ++this.objectCounter;
            this.classes.put(name, cfi);
            if (invalidatePrevNameRefs) {
                cfi.invalidatedPrevNameRefs = true;
            }
        } else if (invalidatePrevNameRefs && !cfi.invalidatedPrevNameRefs) {
            cfi.invalidatedPrevNameRefs = true;
            this.writeVariableSizedInt(cfi.index | 0x2000000 | 0x10000000);
            this.writeInt(-1);
            this.writeInt(-1);
        }
        return cfi;
    }

    private DepClassFileInfo getDepClassFileInfo(Map indexedObjects, int index) {
        Integer indexObject = new Integer(index);
        DepClassFileInfo cfi = (DepClassFileInfo)indexedObjects.get(indexObject);
        if (cfi == null) {
            cfi = new DepClassFileInfo(null, null, -1L);
            cfi.index = this.rebaseCdi ? index : ++this.objectCounter;
            indexedObjects.put(indexObject, cfi);
        }
        return cfi;
    }

    public DepClassFileInfo getDepClassFileInfo(String name) {
        return (DepClassFileInfo)this.classes.get(name);
    }

    public DepClassFileInfo getDepClassFileInfo(int index) {
        if (this.indexedClasses == null) {
            this.buildIndexedClasses();
        }
        return (DepClassFileInfo)this.indexedClasses.get(new Integer(index));
    }

    private void buildIndexedClasses() {
        this.indexedClasses = new Hashtable();
        Iterator classIter = this.classes.values().iterator();
        while (classIter.hasNext()) {
            DepClassFileInfo cfi = (DepClassFileInfo)classIter.next();
            this.indexedClasses.put(new Integer(cfi.index), cfi);
        }
    }

    private DepMemberInfo getDepMemberInfo(MethodSymbol methodSymbol) throws IOException {
        RawClassSymbol definingClassSymbol = methodSymbol.definingClass;
        return this.getDepMemberInfo(definingClassSymbol, methodSymbol, methodSymbol.depInfoName());
    }

    private DepMemberInfo getDepMemberInfo(FieldSymbol fieldSymbol) throws IOException {
        RawClassSymbol definingClassSymbol = fieldSymbol.definingClass;
        return this.getDepMemberInfo(definingClassSymbol, fieldSymbol, fieldSymbol.depInfoName());
    }

    private DepMemberInfo getDepMemberInfo(RawClassSymbol definingClass, Symbol memberSymbol, String memberName) throws IOException {
        DepMemberInfo dmi;
        DepClassFileInfo cfi = this.getDepClassFileInfo(definingClass, false);
        Integer memberNameIndex = new Integer(memberName.hashCode());
        if (this.memberNames.get(memberNameIndex) == null) {
            this.memberNames.put(memberNameIndex, memberName);
        }
        if ((dmi = cfi.getMember(memberNameIndex)) == null) {
            dmi = new DepMemberInfo();
            dmi.index = ++this.objectCounter;
            dmi.nameIndex = memberNameIndex;
            dmi.definingClass = cfi;
            cfi.putMember(memberNameIndex, dmi);
        }
        return dmi;
    }

    private DepMemberInfo getDepMemberInfo(Map indexedObjects, int member) {
        Integer memberObject = new Integer(member);
        DepMemberInfo dmi = (DepMemberInfo)indexedObjects.get(memberObject);
        if (dmi == null) {
            dmi = new DepMemberInfo();
            dmi.index = this.rebaseCdi ? member : ++this.objectCounter;
            indexedObjects.put(memberObject, dmi);
        }
        return dmi;
    }

    public DepMemberInfo getDepMemberInfo(int memberIndex) {
        if (this.indexedMembers == null) {
            this.buildIndexedMembers();
        }
        return (DepMemberInfo)this.indexedMembers.get(new Integer(memberIndex));
    }

    private void buildIndexedMembers() {
        this.indexedMembers = new Hashtable();
        Iterator classIter = this.classes.values().iterator();
        while (classIter.hasNext()) {
            DepClassFileInfo cfi = (DepClassFileInfo)classIter.next();
            DepMemberInfo[] members = cfi.getMembers();
            for (int x = 0; x < members.length; ++x) {
                this.indexedMembers.put(new Integer(members[x].index), members[x]);
            }
        }
    }

    public DepSourceFileInfo getSourceFileInfo(String path) {
        if (path == null) {
            return null;
        }
        DepSourceFileInfo sfi = (DepSourceFileInfo)this.sources.get(DepInfo.fixKey(path));
        if (sfi != null) {
            return sfi;
        }
        if (File.separatorChar == '\\') {
            String windowsPath = path.replace('/', '\\');
            return (DepSourceFileInfo)this.sources.get(DepInfo.fixKey(windowsPath));
        }
        return null;
    }

    String getEncoding() {
        return this.encoding;
    }

    int getMagicHeader() {
        return this.mh;
    }

    boolean isInvalid() {
        return this.depInfoInvalid;
    }

    public boolean hasNameReferences() {
        return this.hasNameReferences;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    String getMemberName(Integer memberNameIndex) {
        return (String)this.memberNames.get(memberNameIndex);
    }

    void writeRebasedCdi(FileStorage store, String encoding) throws IOException {
        switch (this.mh) {
            case 0x9000200: 
            case 0x9000500: 
            case 0x11100100: 
            case 305419897: {
                this.writeFirstGeneration(store);
                break;
            }
            case 0x11100102: 
            case 0x11100103: {
                this.cdiStorage = store;
                this.writeCdiFile(encoding);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IOException("Invalid magic header");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeFirstGeneration(Storage o) throws IOException {
        DepClassFileInfo d;
        int i;
        DepSourceFileInfo sfi;
        DepClassFileInfo cfi;
        this.buffer = new byte[65536];
        this.bufidx = 0;
        this.writeFirstGenerationInt(0x11100100);
        this.writeFirstGenerationName(o.toString());
        this.writeFirstGenerationInt(this.classes.size());
        Enumeration e = this.classes.elements();
        while (e.hasMoreElements()) {
            cfi = (DepClassFileInfo)e.nextElement();
            cfi.index = this.bufidx;
            this.writeFirstGenerationName(cfi.getClassName());
        }
        this.writeFirstGenerationInt(this.sources.size());
        e = this.sources.elements();
        while (e.hasMoreElements()) {
            sfi = (DepSourceFileInfo)e.nextElement();
            sfi.index = this.bufidx;
            this.writeFirstGenerationName(sfi.fullName);
            this.writeFirstGenerationLong(sfi.modDate);
        }
        e = this.classes.elements();
        while (e.hasMoreElements()) {
            cfi = (DepClassFileInfo)e.nextElement();
            this.writeFirstGenerationInt(cfi.index);
            this.writeFirstGenerationLong(cfi.modDate);
            this.writeFirstGenerationInt(cfi.depClasses.size());
            for (i = 0; i < cfi.depClasses.size(); ++i) {
                d = (DepClassFileInfo)cfi.depClasses.get(i);
                this.writeFirstGenerationInt((d = (DepClassFileInfo)this.classes.get(d.getClassName())) != null ? d.index : 0);
            }
        }
        e = this.sources.elements();
        while (e.hasMoreElements()) {
            sfi = (DepSourceFileInfo)e.nextElement();
            this.writeFirstGenerationInt(sfi.index);
            this.writeFirstGenerationInt(sfi.classFiles.size());
            for (i = 0; i < sfi.classFiles.size(); ++i) {
                d = (DepClassFileInfo)sfi.classFiles.elementAt(i);
                this.writeFirstGenerationInt((d = (DepClassFileInfo)this.classes.get(d.getClassName())) != null ? d.index : 0);
            }
        }
        try {
            try {
                o.write(this.buffer, 0, this.bufidx);
            }
            catch (IOException ex) {
                this.invalidateOutput = true;
                Object var7_8 = null;
                o.close();
            }
            Object var7_7 = null;
            o.close();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            o.close();
            throw throwable;
        }
        if (this.invalidateOutput) {
            try {
                this.bufidx = 0;
                this.writeFirstGenerationInt(0);
                o.write(this.buffer, 0, this.bufidx);
                Object var9_11 = null;
                o.close();
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                o.close();
                throw throwable;
            }
        } else if (!$assertionsDisabled && !this.validate(o)) {
            throw new AssertionError();
        }
        this.clear();
        return this.bufidx;
    }

    private void writeFirstGenerationInt(int v) {
        if (this.bufidx + 4 > this.buffer.length) {
            byte[] newbuf = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newbuf, 0, this.buffer.length);
            this.buffer = newbuf;
        }
        this.buffer[this.bufidx + 0] = (byte)(v >> 24 & 0xFF);
        this.buffer[this.bufidx + 1] = (byte)(v >> 16 & 0xFF);
        this.buffer[this.bufidx + 2] = (byte)(v >> 8 & 0xFF);
        this.buffer[this.bufidx + 3] = (byte)(v & 0xFF);
        this.bufidx += 4;
    }

    private void writeFirstGenerationLong(long v) {
        if (this.bufidx + 8 > this.buffer.length) {
            byte[] newbuf = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newbuf, 0, this.buffer.length);
            this.buffer = newbuf;
        }
        this.buffer[this.bufidx + 0] = (byte)(v >>> 56 & 0xFFL);
        this.buffer[this.bufidx + 1] = (byte)(v >>> 48 & 0xFFL);
        this.buffer[this.bufidx + 2] = (byte)(v >>> 40 & 0xFFL);
        this.buffer[this.bufidx + 3] = (byte)(v >>> 32 & 0xFFL);
        this.buffer[this.bufidx + 4] = (byte)(v >>> 24 & 0xFFL);
        this.buffer[this.bufidx + 5] = (byte)(v >>> 16 & 0xFFL);
        this.buffer[this.bufidx + 6] = (byte)(v >>> 8 & 0xFFL);
        this.buffer[this.bufidx + 7] = (byte)(v >>> 0 & 0xFFL);
        this.bufidx += 8;
    }

    private void writeFirstGenerationName(String v) {
        byte[] utf = v.getBytes();
        int utfl = utf.length;
        while (this.bufidx + 4 + utfl > this.buffer.length) {
            byte[] newbuf = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newbuf, 0, this.buffer.length);
            this.buffer = newbuf;
        }
        this.writeFirstGenerationInt(utfl);
        for (int i = 0; i < utfl; ++i) {
            this.buffer[this.bufidx++] = utf[i];
        }
    }

    static {
        $assertionsDisabled = !DepInfo.class.desiredAssertionStatus();
    }
}

