/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ojc.compiler.DepMemberInfo;
import oracle.ojc.compiler.DepSourceFileInfo;
import oracle.ojc.compiler.RawClassSymbol;

public class DepClassFileInfo {
    private String className;
    ArrayList depClasses;
    int index;
    long modDate;
    DepSourceFileInfo sfi;
    RawClassSymbol rcs;
    boolean invalidatedPrevNameRefs;
    Map nameReferencesTable;
    Set nameRefs;
    Hashtable members;
    boolean recompileClass;
    boolean existenceProven;
    List implementedInterfaces;
    DepClassFileInfo superClass;

    DepClassFileInfo(String n, RawClassSymbol rcs, long modDate) {
        this.setClassName(n);
        this.modDate = modDate;
        this.depClasses = new ArrayList();
        this.index = 0;
        this.sfi = null;
        this.rcs = rcs;
        this.invalidatedPrevNameRefs = false;
        this.members = new Hashtable();
        this.nameReferencesTable = null;
        this.recompileClass = false;
        this.existenceProven = true;
        this.implementedInterfaces = null;
        this.superClass = null;
        this.nameRefs = null;
    }

    void addClassFileInfo(DepClassFileInfo cfi) {
        this.depClasses.add(cfi);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className == null ? null : className.intern();
    }

    public DepClassFileInfo[] getDepClasses() {
        return this.depClasses.toArray(new DepClassFileInfo[this.depClasses.size()]);
    }

    void addNameReference(int memberIndex, int pos) {
        if (this.nameRefs == null) {
            this.nameRefs = new HashSet();
        }
        this.nameRefs.add(new int[]{memberIndex, pos});
    }

    public DepClassFileInfo getSuperClass() {
        return this.superClass;
    }

    public List getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    DepMemberInfo getMember(Integer nameIndex) {
        return (DepMemberInfo)this.members.get(nameIndex);
    }

    void putMember(Integer nameIndex, DepMemberInfo dmi) {
        this.members.put(nameIndex, dmi);
    }

    public DepMemberInfo[] getMembers() {
        ArrayList list = new ArrayList();
        list.addAll(this.members.values());
        return list.toArray(new DepMemberInfo[list.size()]);
    }

    public Set getNameReferences() {
        return this.nameRefs == null ? null : Collections.unmodifiableSet(this.nameRefs);
    }

    public int getIndex() {
        return this.index;
    }

    public DepSourceFileInfo getSourceFileInfo() {
        return this.sfi;
    }
}

