/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ConstantPoolEntry;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;

final class ConstantPoolUtf8
extends ConstantPoolEntry {
    ConstantPoolUtf8 nextHashed;
    char[] string;
    static final /* synthetic */ boolean $assertionsDisabled;

    ConstantPoolUtf8(char[] string) {
        super((byte)1);
        this.string = string;
    }

    int write(ClassFileWriter cfw) throws IOException {
        char c;
        int len;
        char[] str = this.string;
        int i = len = str.length;
        while (--i >= 0) {
            c = str[i];
            if (c != '\u0000' && c < '\u0080') continue;
            if (c >= '\u0800') {
                len += 2;
                continue;
            }
            ++len;
        }
        if (len > 65535) {
            Parser parser = cfw.parser;
            parser.error(Message.errorConstantPoolTooLarge, parser.currentClassSymbol.pos, false, parser.currentClassSymbol.errorName());
        }
        int wbIdx = cfw.ensureWriteBufferCapacity(3);
        byte[] wb = cfw.writeBuffer;
        wb[wbIdx + 2] = (byte)len;
        wb[wbIdx + 1] = (byte)(len >> 8);
        wb[wbIdx] = 1;
        cfw.writeBufferIndex = wbIdx + 3;
        for (i = 0; i < str.length; ++i) {
            wbIdx = cfw.ensureWriteBufferCapacity(3);
            c = str[i];
            if ('\u0001' <= c && c <= '\u007f') {
                wb[wbIdx++] = (byte)c;
            } else if (c == '\u0000' || '\u0080' <= c && c <= '\u07ff') {
                wb[wbIdx + 1] = (byte)(128 + (c & 0x3F));
                wb[wbIdx] = (byte)(192 + (c >> 6 & 0x1F));
                wbIdx += 2;
            } else {
                wb[wbIdx + 2] = (byte)(128 + (c & 0x3F));
                wb[wbIdx + 1] = (byte)(128 + (c >> 6 & 0x3F));
                wb[wbIdx] = (byte)(224 + (c >> 12 & 0xF));
                wbIdx += 3;
            }
            cfw.writeBufferIndex = wbIdx;
        }
        return 0;
    }

    public int hashCode() {
        if (!$assertionsDisabled && this.string == null) {
            throw new AssertionError();
        }
        if (this.hash == 0) {
            this.hash = Identifier.hashCode(this.string);
        }
        return this.hash;
    }

    static {
        $assertionsDisabled = !ConstantPoolUtf8.class.desiredAssertionStatus();
    }
}

