/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.ConstantPoolEntry;
import oracle.ojc.compiler.Identifier;

final class ConstantPoolNameAndType
extends ConstantPoolEntry {
    ConstantPoolNameAndType nextHashed;
    char[] name;
    char[] type;
    short nameIndex;
    short typeIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    ConstantPoolNameAndType(ConstantPool constantPool, char[] name, char[] type) {
        super((byte)12);
        this.name = name;
        this.type = type;
        this.nameIndex = constantPool.enterConstantPoolUtf8(name);
        this.typeIndex = constantPool.enterConstantPoolUtf8(type);
    }

    int write(ClassFileWriter cfw) throws IOException {
        int wbIdx = cfw.ensureWriteBufferCapacity(5);
        byte[] wb = cfw.writeBuffer;
        wb[wbIdx + 4] = (byte)this.typeIndex;
        wb[wbIdx + 3] = (byte)(this.typeIndex >> 8);
        wb[wbIdx + 2] = (byte)this.nameIndex;
        wb[wbIdx + 1] = (byte)(this.nameIndex >> 8);
        wb[wbIdx] = 12;
        cfw.writeBufferIndex = wbIdx + 5;
        return 0;
    }

    public int hashCode() {
        if (!($assertionsDisabled || this.name != null && this.type != null)) {
            throw new AssertionError();
        }
        if (this.hash == 0) {
            this.hash = Identifier.hashCode(this.name) + Identifier.hashCode(this.type);
        }
        return this.hash;
    }

    static {
        $assertionsDisabled = !ConstantPoolNameAndType.class.desiredAssertionStatus();
    }
}

