/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.CastExpression;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.InvokeExpression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.TypeSymbol;

final class ConditionalExpression
extends Expression {
    Expression condition;
    Expression trueExpr;
    Expression falseExpr;
    BitSet trueDefSet;
    BitSet falseDefSet;
    static final /* synthetic */ boolean $assertionsDisabled;

    ConditionalExpression(int pos, Expression condition, Expression trueExpr, Expression falseExpr) {
        super((byte)29, pos);
        this.condition = condition;
        this.trueExpr = trueExpr;
        this.falseExpr = falseExpr;
    }

    boolean takeAssignmentContext() {
        return true;
    }

    Expression foldExpression() {
        if (this.condition.kind == 2) {
            Expression expr = ((BooleanConstantExpression)this.condition).bval ? this.trueExpr : this.falseExpr;
            TypeSymbol typeSymbol = this.getType();
            if (expr.getType().equalTo(typeSymbol)) {
                return expr;
            }
            expr = new CastExpression(this.pos, expr, typeSymbol);
            expr.setType(typeSymbol);
            return expr;
        }
        return this;
    }

    Expression constantFolding(Parser parser) {
        this.condition = this.condition.constantFolding(parser);
        return this.foldExpression();
    }

    private Expression findAndSetCommonType1(Parser parser, Expression texpr, Expression fexpr) {
        TypeSymbol fexprType;
        TypeSymbol texprType = texpr.getType();
        if (texprType.equalTo(fexprType = fexpr.getType())) {
            this.setType(texprType);
            this.trueExpr = texpr;
            this.falseExpr = fexpr;
            return this.foldExpression();
        }
        if ((texprType.typeClass & 0x3C) != 0 && (fexprType.typeClass & 0x3C) != 0) {
            int val;
            byte texprTypeKind = texprType.typeKind;
            byte fexprTypeKind = fexprType.typeKind;
            if (texprTypeKind == 3 && fexprTypeKind == 5) {
                this.trueExpr = texpr.promoteType(parser, fexprType);
                this.falseExpr = fexpr;
                this.setType(fexprType);
                return this.foldExpression();
            }
            if (texprTypeKind == 5 && fexprTypeKind == 3) {
                this.trueExpr = texpr;
                this.falseExpr = fexpr.promoteType(parser, texprType);
                this.setType(texprType);
                return this.foldExpression();
            }
            if (texpr.kind == 2 && (texprType.typeClass & 4) != 0) {
                val = ((ConstantExpression)texpr).getIntConstValue();
                if (fexprTypeKind == 3 && -128 <= val && val <= 127 || fexprTypeKind == 5 && Short.MIN_VALUE <= val && val <= Short.MAX_VALUE || fexprTypeKind == 4 && 0 <= val && val <= 65535) {
                    this.trueExpr = texpr.promoteType(parser, fexprType);
                    this.falseExpr = fexpr;
                    this.setType(fexprType);
                    return this.foldExpression();
                }
            }
            if (fexpr.kind == 2 && (fexprType.typeClass & 4) != 0) {
                val = ((ConstantExpression)fexpr).getIntConstValue();
                if (texprTypeKind == 3 && -128 <= val && val <= 127 || texprTypeKind == 5 && Short.MIN_VALUE <= val && val <= Short.MAX_VALUE || texprTypeKind == 4 && 0 <= val && val <= 65535) {
                    this.trueExpr = texpr;
                    this.falseExpr = fexpr.promoteType(parser, texprType);
                    this.setType(texprType);
                    return this.foldExpression();
                }
            }
            TypeSymbol commonType = TypeSymbol.binaryNumericPromotion(parser, texprType, fexprType);
            this.setType(commonType);
            this.trueExpr = texpr.promoteType(parser, commonType);
            this.falseExpr = fexpr.promoteType(parser, commonType);
            return this.foldExpression();
        }
        return null;
    }

    private Expression findAndSetCommonType2(Parser parser, TypeSymbol assignmentContext, Expression texpr, Expression fexpr, boolean boxPrimitives) {
        TypeSymbol texprType = texpr.getType();
        TypeSymbol fexprType = fexpr.getType();
        if (boxPrimitives) {
            if (!$assertionsDisabled && !parser.parsingAtLeastOneFive) {
                throw new AssertionError();
            }
            if (BoxingExpression.isBoxableType(texprType)) {
                texprType = BoxingExpression.getBoxedType(parser, texprType);
            }
            if (BoxingExpression.isBoxableType(fexprType)) {
                fexprType = BoxingExpression.getBoxedType(parser, fexprType);
            }
        }
        if ((texprType.typeClass & 0xFFFFFFC0) != 0 && (fexprType.typeClass & 0xFFFFFFC0) != 0) {
            ReferenceTypeSymbol fRefSymbol = (ReferenceTypeSymbol)fexprType;
            ReferenceTypeSymbol tRefSymbol = (ReferenceTypeSymbol)texprType;
            TypeSymbol commonType = null;
            if (fRefSymbol == ReferenceTypeSymbol.nullTypeSymbol) {
                commonType = texprType;
            } else if (tRefSymbol == ReferenceTypeSymbol.nullTypeSymbol) {
                commonType = fexprType;
            } else if (fRefSymbol.isAssignmentCompatible(parser, tRefSymbol)) {
                commonType = texprType;
            } else if (tRefSymbol.isAssignmentCompatible(parser, fRefSymbol)) {
                commonType = fexprType;
            }
            if (commonType == null && parser.parsingAtLeastOneFive) {
                if (fexprType.involvesGenerics() && texprType.involvesGenerics()) {
                    commonType = InvokeExpression.computeLeastUpperBound(parser, (ClassSymbol)fexprType, (ClassSymbol)texprType);
                }
                if (commonType == null) {
                    commonType = ConditionalExpression.findCommonSuperclass(parser, fexprType, texprType);
                }
                if ((commonType == null || parser.javaLangObjectPcs.equalTo(commonType)) && assignmentContext != null && assignmentContext.isInterface() && fexprType.isClass() && texprType.isClass() && ((ClassSymbol)fexprType).implementsInterface((ClassSymbol)assignmentContext) && ((ClassSymbol)texprType).implementsInterface((ClassSymbol)assignmentContext)) {
                    commonType = assignmentContext;
                }
            }
            if (commonType != null) {
                this.setType(commonType);
                this.trueExpr = texpr.promoteType(parser, commonType);
                this.falseExpr = fexpr.promoteType(parser, commonType);
                return this.foldExpression();
            }
        }
        return null;
    }

    Expression resolveAndCheck(Parser parser) {
        Error error;
        TypeSymbol assignmentContext = parser.assignmentContext;
        parser.assignmentContext = null;
        Expression expr = this.condition.resolveAndCheck(parser);
        TypeSymbol exprType = expr.getType();
        byte typeKind = exprType.typeKind;
        if (typeKind != 2) {
            if (parser.parsingAtLeastOneFive && exprType.equalTo(parser.javaLangBooleanSymbol)) {
                exprType = TypeSymbol.booleanSymbol;
                expr = expr.promoteType(parser, exprType);
            } else {
                error = parser.error(Message.errorIncompatibleTypes, expr.pos, exprType.isErroneous(), exprType.errorName(), "boolean");
                expr = new ErrorExpression(error);
            }
        }
        this.condition = expr;
        BitSet defSet = (BitSet)parser.defSet.clone();
        BitSet posSet = (BitSet)parser.posSet.clone();
        BitSet useSet = (BitSet)parser.useSet.clone();
        if (expr.isLogicalExpression()) {
            parser.defSet = expr.getLogicalExpressionTrueDefSet();
        }
        boolean savedSuspendDataFlowChecking = parser.suspendDataFlowChecking;
        if (expr.isConstantBooleanExpression() && !expr.getConstantBooleanExpressionValue()) {
            parser.suspendDataFlowChecking = true;
        }
        Expression texpr = this.trueExpr.resolveAndCheck(parser);
        parser.suspendDataFlowChecking = savedSuspendDataFlowChecking;
        BitSet thenDefSet = parser.defSet;
        BitSet thenPosSet = parser.posSet;
        BitSet thenUseSet = parser.useSet;
        parser.posSet = posSet;
        parser.useSet = useSet;
        parser.defSet = expr.isLogicalExpression() ? expr.getLogicalExpressionFalseDefSet() : defSet;
        if (expr.isConstantBooleanExpression() && expr.getConstantBooleanExpressionValue()) {
            parser.suspendDataFlowChecking = true;
        }
        Expression fexpr = this.falseExpr.resolveAndCheck(parser);
        parser.suspendDataFlowChecking = savedSuspendDataFlowChecking;
        TypeSymbol texprType = texpr.getType();
        TypeSymbol fexprType = fexpr.getType();
        if (texprType.isErroneous() || fexprType.isErroneous()) {
            return ErrorExpression.errorExpression;
        }
        if (texpr.isLogicalExpression()) {
            this.trueDefSet = texpr.getLogicalExpressionTrueDefSet();
            this.falseDefSet = texpr.getLogicalExpressionFalseDefSet();
        } else {
            this.trueDefSet = (BitSet)thenDefSet.clone();
            this.falseDefSet = (BitSet)thenDefSet.clone();
        }
        if (fexpr.isLogicalExpression()) {
            this.trueDefSet.and(fexpr.getLogicalExpressionTrueDefSet());
            this.falseDefSet.and(fexpr.getLogicalExpressionFalseDefSet());
        } else {
            this.trueDefSet.and(parser.defSet);
            this.falseDefSet.and(parser.defSet);
        }
        if (expr.isConstantBooleanExpression()) {
            if (expr.getConstantBooleanExpressionValue()) {
                parser.defSet = thenDefSet;
                parser.useSet = thenUseSet;
            }
        } else {
            parser.defSet.and(thenDefSet);
            parser.posSet.or(thenPosSet);
            parser.useSet.or(thenUseSet);
        }
        if (texprType.equalTo(fexprType)) {
            this.setType(texprType);
            this.trueExpr = texpr;
            this.falseExpr = fexpr;
            return this.foldExpression();
        }
        expr = this.findAndSetCommonType1(parser, texpr, fexpr);
        if (expr != null) {
            return expr;
        }
        if (parser.parsingAtLeastOneFive) {
            TypeSymbol primitiveType;
            Expression utexpr = texpr;
            if (texprType.isReferenceType() && (primitiveType = BoxingExpression.getPrimitiveType(parser, texprType)) != null) {
                utexpr = texpr.promoteType(parser, primitiveType);
            }
            Expression ufexpr = fexpr;
            if (fexprType.isReferenceType() && (primitiveType = BoxingExpression.getPrimitiveType(parser, fexprType)) != null) {
                ufexpr = fexpr.promoteType(parser, primitiveType);
            }
            if ((texpr != utexpr || fexpr != ufexpr) && (expr = this.findAndSetCommonType1(parser, utexpr, ufexpr)) != null) {
                return expr;
            }
        }
        if ((expr = this.findAndSetCommonType2(parser, assignmentContext, texpr, fexpr, false)) != null) {
            return expr;
        }
        if (parser.parsingAtLeastOneFive && (expr = this.findAndSetCommonType2(parser, assignmentContext, texpr, fexpr, true)) != null) {
            return expr;
        }
        error = parser.error(Message.errorIncompatibleTypes, texpr.pos, fexprType.isErroneous() | texprType.isErroneous(), texprType.errorName(), fexprType.errorName());
        return new ErrorExpression(error);
    }

    boolean isConstantBooleanExpression() {
        if (this.condition.isConstantBooleanExpression()) {
            if (this.condition.getConstantBooleanExpressionValue()) {
                return this.trueExpr.isConstantBooleanExpression();
            }
            return this.falseExpr.isConstantBooleanExpression();
        }
        if (this.trueExpr.isConstantBooleanExpression() && this.falseExpr.isConstantBooleanExpression()) {
            return this.trueExpr.getConstantBooleanExpressionValue() == this.falseExpr.getConstantBooleanExpressionValue();
        }
        return false;
    }

    boolean getConstantBooleanExpressionValue() {
        if (!$assertionsDisabled && !this.isConstantBooleanExpression()) {
            throw new AssertionError();
        }
        if (this.condition.isConstantBooleanExpression()) {
            if (this.condition.getConstantBooleanExpressionValue()) {
                return this.trueExpr.getConstantBooleanExpressionValue();
            }
            return this.falseExpr.getConstantBooleanExpressionValue();
        }
        return this.trueExpr.getConstantBooleanExpressionValue();
    }

    boolean isLogicalExpression() {
        return true;
    }

    BitSet getLogicalExpressionTrueDefSet() {
        return this.trueDefSet;
    }

    BitSet getLogicalExpressionFalseDefSet() {
        return this.falseDefSet;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        if (this.condition.isConstantBooleanExpression()) {
            if (this.condition.kind != 2) {
                this.condition.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            if (this.condition.getConstantBooleanExpressionValue()) {
                this.trueExpr.generateByteCode(byteCodeGenerator);
            } else {
                this.falseExpr.generateByteCode(byteCodeGenerator);
            }
        } else {
            Label falseLabel = new Label();
            this.condition.generateByteCodeBranch(byteCodeGenerator, falseLabel, true);
            int opStackHeight = byteCodeGenerator.getOpStackHeight();
            boolean savedDoingStringConcatonation = byteCodeGenerator.doingStringConcatonation;
            byteCodeGenerator.doingStringConcatonation = false;
            this.trueExpr.generateByteCode(byteCodeGenerator);
            Label doneLabel = new Label();
            byteCodeGenerator.generateBranch_goto(doneLabel);
            byteCodeGenerator.setLabel(falseLabel);
            byteCodeGenerator.setOpStackHeight(opStackHeight);
            byteCodeGenerator.doingStringConcatonation = false;
            this.falseExpr.generateByteCode(byteCodeGenerator);
            byteCodeGenerator.doingStringConcatonation = savedDoingStringConcatonation;
            byteCodeGenerator.setLabel(doneLabel);
        }
    }

    void generateByteCodeBranch(ByteCodeGenerator byteCodeGenerator, Label label, boolean branchIfFalse) {
        if (this.condition.isConstantBooleanExpression()) {
            if (this.condition.kind != 2) {
                this.condition.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            if (this.condition.getConstantBooleanExpressionValue()) {
                this.trueExpr.generateByteCodeBranch(byteCodeGenerator, label, branchIfFalse);
            } else {
                this.falseExpr.generateByteCodeBranch(byteCodeGenerator, label, branchIfFalse);
            }
        } else {
            Label falseExprLabel = new Label();
            this.condition.generateByteCodeBranch(byteCodeGenerator, falseExprLabel, true);
            int opStackHeight = byteCodeGenerator.getOpStackHeight();
            this.trueExpr.generateByteCodeBranch(byteCodeGenerator, label, branchIfFalse);
            Label doneLabel = new Label();
            byteCodeGenerator.generateBranch_goto(doneLabel);
            byteCodeGenerator.setLabel(falseExprLabel);
            byteCodeGenerator.setOpStackHeight(opStackHeight);
            this.falseExpr.generateByteCodeBranch(byteCodeGenerator, label, branchIfFalse);
            byteCodeGenerator.setLabel(doneLabel);
        }
    }

    public String toString() {
        return "?:";
    }

    static {
        $assertionsDisabled = !ConditionalExpression.class.desiredAssertionStatus();
    }
}

