/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ClassSymbolList;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.SourceFile;
import oracle.ojc.compiler.TypeParameterList;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeVariableList;
import oracle.ojc.compiler.UnresolvedClassSymbol;
import oracle.ojc.compiler.UnresolvedSuperClassException;

abstract class ClassSymbol
extends ReferenceTypeSymbol {
    static boolean doMethodTypeParameterConversion = true;
    static boolean doClassTypeParameterConversion = true;

    ClassSymbol(int pos, Identifier identifier, byte kind, short access, Annotation annotation) {
        super(pos, identifier, kind, access, annotation);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        this.toString(sb);
        return sb.toString();
    }

    char[] getInternalName() {
        return this.getClassSymbol().getInternalName();
    }

    boolean isErroneous() {
        RawClassSymbol classSymbol = this.getClassSymbol();
        if (classSymbol != null) {
            return classSymbol.isErroneous();
        }
        return false;
    }

    boolean isClass() {
        return true;
    }

    boolean isCompiled() {
        return this.getClassSymbol().isCompiled();
    }

    TypeSymbol eraseType() {
        return this.getClassSymbol();
    }

    boolean isReifiable() {
        return false;
    }

    abstract RawClassSymbol getClassSymbol();

    abstract ClassSymbol getSuperClassSymbol();

    abstract ImplementationList getImplementationList();

    abstract void checkForOutOfPackageInnerClasses(ConstantPool var1, RawClassSymbol var2);

    boolean isSuperclass(ClassSymbol ofClass) {
        return this.isSuperclass(ofClass, null);
    }

    boolean isSuperclass(ClassSymbol ofClass, TypeSymbol recursionCheck) {
        do {
            if ((ofClass = ofClass.getSuperClassSymbol()) == null) {
                return false;
            }
            if (!(ofClass instanceof UnresolvedClassSymbol)) continue;
            throw new UnresolvedSuperClassException(ofClass);
        } while (!ofClass.equalTo(this, recursionCheck));
        return true;
    }

    ClassScope getClassScope() {
        return this.getClassSymbol().classScope;
    }

    RawClassSymbol getOuterClass() {
        return this.getClassSymbol().getOuterClass();
    }

    RawClassSymbol getTopLevelClass() {
        return this.getClassSymbol().getTopLevelClass();
    }

    boolean implementsInterface(ClassSymbol interfaceClass) {
        return this.implementsInterface(interfaceClass, null);
    }

    boolean implementsInterface(ClassSymbol interfaceClass, TypeSymbol recursionCheck) {
        block10: {
            ClassSymbol classSymbol;
            block9: {
                if (!interfaceClass.isTypeParameter()) break block9;
                ClassSymbolList csl = ((TypeParameterSymbol)interfaceClass).interfaceBounds;
                while (csl != null) {
                    RawClassSymbol rawClass = csl.classSymbol.getClassSymbol();
                    if (rawClass == this || this.implementsInterface(rawClass, recursionCheck)) {
                        return true;
                    }
                    csl = csl.next;
                }
                break block10;
            }
            RawClassSymbol rawClass = this.getClassSymbol();
            if ((rawClass.flags & Short.MIN_VALUE) == 0) {
                rawClass.propagateFlagsFromSuperclasses();
            }
            if ((rawClass.flags & 0x400) == 0) break block10;
            if (this.isParameterizedClass() && rawClass.cd.getTypeParameterList() != null && ((ParameterizedClassSymbol)this).typeVariableList == null) {
                interfaceClass = interfaceClass.getClassSymbol();
            }
            ImplementationList list = this.getImplementationList();
            while (list != null) {
                classSymbol = list.interfaceSymbol;
                if (classSymbol instanceof UnresolvedClassSymbol) {
                    throw new UnresolvedSuperClassException(classSymbol);
                }
                if (classSymbol.equalTo(interfaceClass, recursionCheck)) {
                    return true;
                }
                if (classSymbol.implementsInterface(interfaceClass, recursionCheck)) {
                    return true;
                }
                list = list.next;
            }
            for (classSymbol = this.getSuperClassSymbol(); classSymbol != null; classSymbol = classSymbol.getSuperClassSymbol()) {
                if (!classSymbol.implementsInterface(interfaceClass, recursionCheck)) continue;
                return true;
            }
        }
        return false;
    }

    boolean implementsInterfaceDirectly(ClassSymbol interfaceClass) {
        ImplementationList list = this.getImplementationList();
        while (list != null) {
            if (list.interfaceSymbol.equalTo(interfaceClass)) {
                return true;
            }
            list = list.next;
        }
        return false;
    }

    ClassSymbol getDirectInterfaceImplementation(ClassSymbol interfaceClass) {
        ImplementationList list = this.getImplementationList();
        while (list != null) {
            if (list.interfaceSymbol.equalTo(interfaceClass)) {
                return list.interfaceSymbol;
            }
            list = list.next;
        }
        return null;
    }

    boolean implementsInterfaceDirectlyIndirectly(ClassSymbol interfaceClass) {
        ImplementationList list = this.getImplementationList();
        while (list != null) {
            if (list.interfaceSymbol.equalTo(interfaceClass) || list.interfaceSymbol.implementsInterfaceDirectlyIndirectly(interfaceClass)) {
                return true;
            }
            list = list.next;
        }
        return false;
    }

    ClassSymbol getInterface(RawClassSymbol interfaceSymbol) {
        ClassSymbol classSymbol = this;
        do {
            ImplementationList implList = classSymbol.getImplementationList();
            while (implList != null) {
                if (implList.interfaceSymbol.getClassSymbol() == interfaceSymbol) {
                    return implList.interfaceSymbol;
                }
                ClassSymbol classSym = implList.interfaceSymbol.getInterface(interfaceSymbol);
                if (classSym != null) {
                    return classSym;
                }
                implList = implList.next;
            }
        } while ((classSymbol = classSymbol.getSuperClassSymbol()) != null);
        return null;
    }

    static boolean compareArgumentSignatures(MethodSymbol method1, MethodSymbol method2) {
        int len2;
        char[] signature1 = method1.getSignature();
        char[] signature2 = method2.getSignature();
        int len1 = Identifier.lastIndexOf(signature1, ')');
        if (len1 != (len2 = Identifier.lastIndexOf(signature2, ')'))) {
            return false;
        }
        return Identifier.compare(signature1, 0, signature2, 0, len1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean compareMethods(MethodSymbol thisMethod, ClassSymbol classSymbol, MethodSymbol classMethod) {
        block24: {
            block23: {
                block22: {
                    if (thisMethod.identifier != classMethod.identifier) {
                        return false;
                    }
                    if (thisMethod.argCount != classMethod.argCount) {
                        return false;
                    }
                    thisClassSymbol = this.getClassSymbol();
                    thisAvl = thisMethod.argumentList;
                    classAvl = classMethod.argumentList;
                    tpl = null;
                    tvl = null;
                    if (classSymbol.isParameterizedClass()) {
                        pcs = (ParameterizedClassSymbol)classSymbol;
                        tvl = pcs.typeVariableList;
                        if (tvl != null) {
                            tpl = pcs.genericClassSymbol.cd.getTypeParameterList();
                        }
                    }
                    thisTpl = thisMethod.typeParameterList;
                    classTpl = classMethod.typeParameterList;
                    if (thisTpl != null && classTpl != null) {
                        do {
                            if (!thisTpl.typeParameter.bound.equalTo(classTpl.typeParameter.bound)) {
                                return false;
                            }
                            thisTpl = thisTpl.next;
                            classTpl = classTpl.next;
                        } while (thisTpl != null && classTpl != null);
                        if (thisTpl != classTpl) {
                            return false;
                        }
                    }
                    if ((eraseThisMethod = this.classIsErased(this, thisMethod.definingClass, false, false)) == null) {
                        eraseThisMethod = Boolean.FALSE;
                    }
                    if ((eraseClassMethod = this.classIsErased(this, classMethod.definingClass, false, false)) == null) {
                        eraseClassMethod = Boolean.FALSE;
                    }
                    saveDoClassTypeParameterConversion = ClassSymbol.doClassTypeParameterConversion;
                    ClassSymbol.doClassTypeParameterConversion = false;
                    try lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (thisAvl == null || classAvl == null) {
                                var17_17 = thisAvl == null && classAvl == null;
                                var25_23 = null;
                                ClassSymbol.doClassTypeParameterConversion = saveDoClassTypeParameterConversion;
                                return var17_17;
                            }
                            thisArgType = eraseThisMethod != false ? thisAvl.argSymbol.type.eraseType() : thisAvl.argSymbol.type.replaceTypeParameters(thisClassSymbol, tpl, tvl, null);
                            classArgType = eraseClassMethod != false ? classAvl.argSymbol.type.eraseType() : classAvl.argSymbol.type.replaceTypeParameters(thisClassSymbol, tpl, tvl, null);
                            if (thisArgType.involvesGenerics() && !classArgType.involvesGenerics()) {
                                var17_17 = false;
                                break block22;
                            }
                            classArgTypeHasTypeParams = classArgType.containsTypeParameterDefinedBy(classMethod);
                            thisArgTypeHasTypeParams = thisArgType.containsTypeParameterDefinedBy(thisMethod);
                            saveDoMethodTypeParameterConversion = ClassSymbol.doMethodTypeParameterConversion;
                            ClassSymbol.doMethodTypeParameterConversion = classArgTypeHasTypeParams != false && thisArgTypeHasTypeParams != false;
                            try {
                                if (classArgType.equalTo(thisArgType) && thisArgType.equalTo(classArgType)) ** GOTO lbl-1000
                                if (thisArgType.involvesGenerics()) break;
                                erasedClassArgType = classArgType.eraseType();
                                if (!erasedClassArgType.equalTo(thisArgType) || !thisArgType.equalTo(erasedClassArgType)) {
                                    var21_28 = false;
                                    var23_22 = null;
                                    ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                                    break block23;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (Throwable var22_29) {
                                var23_22 = null;
                                ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                                throw var22_29;
                            }
                            break;
                        }
                        {
                            var20_21 = false;
                            var23_22 = null;
                            ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                        }
                        break block24;
lbl-1000:
                        // 2 sources

                        {
                            var23_22 = null;
                            ClassSymbol.doMethodTypeParameterConversion = saveDoMethodTypeParameterConversion;
                        }
                        thisAvl = thisAvl.next;
                        classAvl = classAvl.next;
                        ** continue;
                    }
                    catch (Throwable var24_30) {
                        var25_27 = null;
                        ClassSymbol.doClassTypeParameterConversion = saveDoClassTypeParameterConversion;
                        throw var24_30;
                    }
                }
                var25_24 = null;
                ClassSymbol.doClassTypeParameterConversion = saveDoClassTypeParameterConversion;
                return var17_17;
            }
            var25_25 = null;
            ClassSymbol.doClassTypeParameterConversion = saveDoClassTypeParameterConversion;
            return var21_28;
        }
        var25_26 = null;
        ClassSymbol.doClassTypeParameterConversion = saveDoClassTypeParameterConversion;
        return var20_21;
    }

    private Boolean classIsErased(ClassSymbol classSymbol, RawClassSymbol definingClass, boolean checkErasure, boolean isErased) {
        Boolean result;
        if (checkErasure) {
            if (classSymbol.isErasedType()) {
                isErased = true;
            } else if (!classSymbol.isGenericType()) {
                isErased = false;
            }
        }
        checkErasure = true;
        if (classSymbol.getClassSymbol() == definingClass) {
            return isErased ? Boolean.TRUE : Boolean.FALSE;
        }
        ClassSymbol superClass = classSymbol.getSuperClassSymbol();
        if (superClass != null && (result = this.classIsErased(superClass, definingClass, checkErasure, isErased)) != null) {
            return result;
        }
        if (definingClass.isInterface()) {
            ImplementationList implList = classSymbol.getImplementationList();
            while (implList != null) {
                Boolean result2 = this.classIsErased(implList.interfaceSymbol, definingClass, checkErasure, isErased);
                if (result2 != null) {
                    return result2;
                }
                implList = implList.next;
            }
        }
        return null;
    }

    boolean mergeIntoMethodTable(Parser parser, ArrayList methodArrayList, ParameterizedClassSymbol classSymbol) {
        if (this.isErroneous() || classSymbol.isErroneous()) {
            return false;
        }
        RawClassSymbol classClassSymbol = classSymbol.getClassSymbol();
        if (classClassSymbol.cd.methodTable == null) {
            classClassSymbol.buildMethodTable(parser);
        }
        SourceFile savedSourceFile = parser.sourceFile;
        RawClassSymbol thisClassSymbol = this.getClassSymbol();
        if (thisClassSymbol.cd.ccd != null) {
            parser.sourceFile = thisClassSymbol.cd.ccd.sourceFile;
        }
        MethodSymbol[] classMethodArray = classClassSymbol.getMethodTable(parser);
        boolean covariantReturnFound = false;
        Object state = null;
        if (thisClassSymbol.isCompiled()) {
            state = parser.saveResolutionState(thisClassSymbol);
        }
        HashSet<MethodSymbol> checkForNameClashSet = new HashSet<MethodSymbol>();
        int i = classMethodArray.length;
        block0: while (--i >= 0) {
            MethodSymbol classMethodSymbol = classMethodArray[i];
            if (classMethodSymbol.isConstructor() || classMethodSymbol.isClassInitializer() || classMethodSymbol.isSynthetic()) continue;
            if (this.isInterface() && classClassSymbol == parser.javaLangObjectSymbol) {
                if (thisClassSymbol != parser.javaLangAnnotationAnnotationSymbol && (classMethodSymbol.access & 1) == 0) {
                    continue;
                }
            } else if (!classMethodSymbol.isAccessible(this, this)) {
                if ((classMethodSymbol.access & 0x400) == 0) continue;
                methodArrayList.add(classMethodSymbol);
                continue;
            }
            int j = methodArrayList.size();
            while (--j >= 0) {
                MethodSymbol thisMethodSymbol = (MethodSymbol)methodArrayList.get(j);
                if (thisMethodSymbol == classMethodSymbol) continue block0;
                if (thisMethodSymbol.identifier != classMethodSymbol.identifier || thisMethodSymbol.argCount != classMethodSymbol.argCount || thisMethodSymbol.isBridgeMethod()) continue;
                int pos = thisClassSymbol.pos;
                if (thisMethodSymbol.definingClass == thisClassSymbol) {
                    pos = thisMethodSymbol.pos;
                }
                if (this.compareMethods(thisMethodSymbol, classSymbol, classMethodSymbol)) {
                    if (parser.parsingAtLeastOneFive && !ClassSymbol.compareArgumentSignatures(classMethodSymbol, thisMethodSymbol)) {
                        if (thisClassSymbol.isCompiled() && thisMethodSymbol.definingClass == classMethodSymbol.definingClass) {
                            parser.error(Message.errorDuplicateDefinition, pos, classMethodSymbol.isErroneous() | thisMethodSymbol.isErroneous(), thisMethodSymbol.errorName() + " " + Message.inString + " " + thisMethodSymbol.definingClass.errorName());
                        }
                        if (!classMethodSymbol.definingClass.isInterface()) {
                            MethodSymbol methodSymbol = (MethodSymbol)this.getClassSymbol().classScope.lookupSpecificSymbolInScope(thisMethodSymbol.identifier, 8, true);
                            while (methodSymbol != null && !this.compareMethods(methodSymbol, classSymbol, classMethodSymbol)) {
                                methodSymbol = methodSymbol.nextWithSameName;
                            }
                            if (methodSymbol == null) {
                                methodArrayList.add(classMethodSymbol);
                                continue block0;
                            }
                            thisMethodSymbol = methodSymbol;
                        }
                    }
                    if ((classMethodSymbol.access & 0x400) != 0 && (classMethodSymbol.flags & 0x400) != 0) {
                        covariantReturnFound = true;
                    }
                    boolean lookingForErrors = false;
                    if (thisClassSymbol.isCompiled() && (thisMethodSymbol.definingClass == thisClassSymbol || classMethodSymbol.definingClass.isInterface() && (thisClassSymbol.implementsInterfaceDirectly(classMethodSymbol.definingClass) || !thisClassSymbol.getSuperClassSymbol().implementsInterface(classMethodSymbol.definingClass)))) {
                        lookingForErrors = true;
                    }
                    if (lookingForErrors) {
                        if ((classMethodSymbol.access & 8) != (thisMethodSymbol.access & 8)) {
                            if ((classMethodSymbol.access & 8) != 0) {
                                parser.error(Message.errorCannotBeOverridden, pos, classMethodSymbol.isErroneous() | thisMethodSymbol.isErroneous(), "static " + classMethodSymbol.errorName() + " " + Message.inString + " " + classMethodSymbol.definingClass.errorName(), thisMethodSymbol.errorName() + " " + Message.inString + " " + thisMethodSymbol.definingClass.errorName());
                            } else {
                                parser.error(classSymbol.isInterface() ? Message.errorCannotImplement : Message.errorCannotOverride, pos, classMethodSymbol.isErroneous() | thisMethodSymbol.isErroneous(), thisMethodSymbol.errorName() + " " + Message.inString + " " + thisMethodSymbol.definingClass.errorName(), classMethodSymbol.errorName() + " " + Message.inString + " " + classMethodSymbol.definingClass.errorName(), classMethodSymbol.resultType.errorName());
                            }
                        }
                        if (classSymbol.equalTo(this.getSuperClassSymbol()) && (classMethodSymbol.access & 0x10) != 0) {
                            parser.error(Message.errorCannotBeOverridden, pos, classMethodSymbol.isErroneous() | thisMethodSymbol.isErroneous(), "final " + classMethodSymbol.errorName() + " " + Message.inString + " " + classMethodSymbol.definingClass.errorName(), thisMethodSymbol.errorName() + " " + Message.inString + " " + thisMethodSymbol.definingClass.errorName());
                        }
                        if (thisClassSymbol.isAnnotation() && classClassSymbol == parser.javaLangAnnotationAnnotationSymbol && (classMethodSymbol.access & 5) != 0) {
                            parser.error(Message.errorCannotBeOverridden, pos, classMethodSymbol.isErroneous() | thisMethodSymbol.isErroneous(), classMethodSymbol.errorName() + " " + Message.inString + " " + classMethodSymbol.definingClass.errorName(), thisMethodSymbol.errorName() + " " + Message.inString + " " + thisMethodSymbol.definingClass.errorName());
                        }
                    }
                    if (lookingForErrors || (thisMethodSymbol.access & 0x400) != 0) {
                        TypeParameterList tpl = null;
                        TypeVariableList tvl = classSymbol.typeVariableList;
                        if (tvl != null) {
                            tpl = classSymbol.genericClassSymbol.cd.getTypeParameterList();
                        }
                        TypeSymbol thisResultType = thisMethodSymbol.resultType.replaceTypeParameters(thisClassSymbol, tpl, tvl, null);
                        TypeSymbol classResultType = classMethodSymbol.resultType.replaceTypeParameters(thisClassSymbol, tpl, tvl, null);
                        boolean giveError = false;
                        if (tvl != null && classResultType.isTypeParameter() && !classResultType.isMethodTypeParameter() && thisResultType != classResultType) {
                            giveError = true;
                        } else if (!thisResultType.equalTo(classResultType)) {
                            if (!(parser.parsingAtLeastOneFive && classResultType.isReferenceType() && thisResultType.isReferenceType())) {
                                giveError = true;
                            } else {
                                ReferenceTypeSymbol classRefType = (ReferenceTypeSymbol)classResultType;
                                ReferenceTypeSymbol thisRefType = (ReferenceTypeSymbol)thisResultType;
                                if (thisMethodSymbol.definingClass == thisClassSymbol) {
                                    if (!classRefType.isReturnSubstitutable(parser, thisRefType)) {
                                        giveError = true;
                                    }
                                } else if (!classRefType.isReturnSubstitutable(parser, thisRefType) && !thisRefType.isReturnSubstitutable(parser, classRefType)) {
                                    giveError = true;
                                }
                                if (!giveError) {
                                    if (thisClassSymbol.isCompiled()) {
                                        if (thisMethodSymbol.definingClass != thisClassSymbol && classClassSymbol.isInterface() && (thisMethodSymbol.access & 0x400) == 0 && !thisMethodSymbol.definingClass.implementsInterface(classClassSymbol) && !thisClassSymbol.findBridgeMethod(classMethodSymbol)) {
                                            thisClassSymbol.createBridgeMethod(classMethodSymbol, thisMethodSymbol);
                                        }
                                        covariantReturnFound = true;
                                    }
                                    thisMethodSymbol.flags = (short)(thisMethodSymbol.flags | 0x400);
                                }
                            }
                        }
                        if (lookingForErrors) {
                            if (giveError) {
                                parser.error(classSymbol.isInterface() ? Message.errorDifferentReturnImplement : Message.errorDifferentReturnOverride, pos, classMethodSymbol.isErroneous() | thisMethodSymbol.isErroneous(), thisMethodSymbol.errorName() + " " + Message.inString + " " + thisMethodSymbol.definingClass.errorName(), classMethodSymbol.errorName() + " " + Message.inString + " " + classMethodSymbol.definingClass.errorName(), classResultType.errorName());
                            } else if (thisResultType.eraseType() == classResultType.eraseType()) {
                                classResultType.checkForUncheckedConversion(parser, thisResultType.pos, thisResultType, false);
                            }
                        }
                    }
                    if (lookingForErrors) {
                        this.checkThrowsList(parser, thisClassSymbol, classSymbol, thisMethodSymbol, classMethodSymbol);
                        if (ClassSymbol.getAccessStrength(classMethodSymbol.access) > ClassSymbol.getAccessStrength(thisMethodSymbol.access)) {
                            parser.error(classSymbol.isInterface() ? Message.errorWeakerAccessImplement : Message.errorWeakerAccessOverride, pos, classMethodSymbol.isErroneous() | thisMethodSymbol.isErroneous(), thisMethodSymbol.errorName() + " " + Message.inString + " " + thisMethodSymbol.definingClass.errorName(), classMethodSymbol.errorName() + " " + Message.inString + " " + classMethodSymbol.definingClass.errorName(), ClassSymbol.accessToString((short)(classMethodSymbol.access & 7)));
                        }
                        if (classMethodSymbol.isDeprecated() && !thisMethodSymbol.isDeprecated() && thisMethodSymbol.definingClass == thisClassSymbol) {
                            parser.warning(thisMethodSymbol, Message.warningOverridesDeprecated, pos, classMethodSymbol.errorName(), classSymbol.isInterface() ? Message.implementedString : Message.overriddenString, Message.methodString);
                        }
                    }
                    thisMethodSymbol.flags = (short)(thisMethodSymbol.flags & 0xFFFFFF7F);
                    continue block0;
                }
                if (thisClassSymbol.isInterface() || !thisClassSymbol.isCompiled() || !parser.parsingAtLeastOneFive) continue;
                checkForNameClashSet.add(thisMethodSymbol);
            }
            methodArrayList.add(classMethodSymbol);
        }
        if (!checkForNameClashSet.isEmpty()) {
            this.checkForNameClashes(parser, thisClassSymbol, checkForNameClashSet, classSymbol);
        }
        if (thisClassSymbol.isCompiled()) {
            parser.restoreResolutionState(state);
        }
        parser.sourceFile = savedSourceFile;
        return covariantReturnFound;
    }

    private void checkThrowsList(Parser parser, ClassSymbol thisClassSymbol, ClassSymbol classSymbol, MethodSymbol thisMethodSymbol, MethodSymbol classMethodSymbol) {
        MethodSymbol.ThrowsList thisTl = thisMethodSymbol.throwsList;
        while (thisTl != null) {
            block11: {
                if (!thisTl.throwsType.isErroneous()) {
                    ClassSymbol thisThrowClassSymbol = (ClassSymbol)thisTl.throwsType;
                    if (thisThrowClassSymbol.isTypeParameter()) {
                        thisThrowClassSymbol = ((TypeParameterSymbol)thisThrowClassSymbol).bound;
                    }
                    if (thisThrowClassSymbol.isCheckedException(parser)) {
                        MethodSymbol.ThrowsList classTl = classMethodSymbol.throwsList;
                        while (classTl != null) {
                            if (!classTl.throwsType.isErroneous()) {
                                ClassSymbol classThrowClassSymbol = (ClassSymbol)classTl.throwsType;
                                if (classThrowClassSymbol.isTypeParameter()) {
                                    classThrowClassSymbol = ((TypeParameterSymbol)classThrowClassSymbol).bound;
                                }
                                if (thisThrowClassSymbol.equalTo(classThrowClassSymbol) || classThrowClassSymbol.isSuperclass(thisThrowClassSymbol)) break block11;
                            }
                            classTl = classTl.next;
                        }
                        if (!thisMethodSymbol.definingClass.isInterface() || !classMethodSymbol.definingClass.isInterface() || thisMethodSymbol.definingClass == thisClassSymbol) {
                            if (parser.options.verbose) {
                                parser.error(classSymbol.isInterface() ? Message.errorMoreThrowsImplement : Message.errorMoreThrowsOverride, this.pos, classMethodSymbol.isErroneous() | thisMethodSymbol.isErroneous(), thisMethodSymbol.errorName() + " " + Message.inString + " " + thisMethodSymbol.definingClass.errorNameWithPath(), classMethodSymbol.errorName() + " " + Message.inString + " " + classMethodSymbol.definingClass.errorNameWithPath(), thisThrowClassSymbol.errorName());
                            } else {
                                parser.error(classSymbol.isInterface() ? Message.errorMoreThrowsImplement : Message.errorMoreThrowsOverride, this.pos, classMethodSymbol.isErroneous() | thisMethodSymbol.isErroneous(), thisMethodSymbol.errorName() + " " + Message.inString + " " + thisMethodSymbol.definingClass.errorName(), classMethodSymbol.errorName() + " " + Message.inString + " " + classMethodSymbol.definingClass.errorName(), thisThrowClassSymbol.errorName());
                            }
                        }
                    }
                }
            }
            thisTl = thisTl.next;
        }
    }

    private boolean checkForNameClashes(Parser parser, ClassSymbol thisClass, Set methodSet, ClassSymbol otherClass) {
        Iterator methodIter = methodSet.iterator();
        while (methodIter.hasNext()) {
            MethodSymbol thisMethod = (MethodSymbol)methodIter.next();
            MethodSymbol classMethod = (MethodSymbol)otherClass.getClassScope().lookupSpecificSymbolInScope(thisMethod.identifier, 8, true);
            while (classMethod != null) {
                if (!classMethod.isBridgeMethod() && Identifier.compare(classMethod.getSignature(), thisMethod.getSignature()) && !thisClass.compareMethods(thisMethod, otherClass, classMethod)) {
                    int pos;
                    int n = pos = thisMethod.definingClass == thisClass ? thisMethod.pos : thisClass.pos;
                    if ((thisMethod.access & 0x400) == (classMethod.access & 0x400)) {
                        parser.error(Message.errorNameClashOverride, pos, classMethod.isErroneous() | thisMethod.isErroneous(), thisMethod.errorName(), classMethod.errorName(), otherClass.errorName());
                    } else {
                        parser.error(Message.errorNameClashImplement, pos, classMethod.isErroneous() | thisMethod.isErroneous(), thisMethod.errorName(), classMethod.errorName(), otherClass.errorName());
                    }
                    return true;
                }
                classMethod = classMethod.nextWithSameName;
            }
        }
        ClassSymbol superClass = otherClass.getSuperClassSymbol();
        if (superClass != null && this.checkForNameClashes(parser, thisClass, methodSet, superClass)) {
            return true;
        }
        ImplementationList implList = otherClass.getImplementationList();
        while (implList != null) {
            if (this.checkForNameClashes(parser, thisClass, methodSet, implList.interfaceSymbol)) {
                return true;
            }
            implList = implList.next;
        }
        return false;
    }

    void getSuperTypes(Set set) {
        ClassSymbol classSymbol = this;
        if (classSymbol.isInterface()) {
            set.add(classSymbol.getSuperClassSymbol());
            ImplementationList implList = classSymbol.getImplementationList();
            while (implList != null) {
                set.add(implList.interfaceSymbol);
                implList.interfaceSymbol.getSuperTypes(set);
                implList = implList.next;
            }
        }
        while ((classSymbol = classSymbol.getSuperClassSymbol()) != null) {
            set.add(classSymbol);
        }
    }

    void getErasedSuperclasses(Set set) {
        ClassSymbol classSymbol = this;
        if (classSymbol.isInterface()) {
            set.add(classSymbol.getSuperClassSymbol().getClassSymbol());
            ImplementationList implList = classSymbol.getImplementationList();
            while (implList != null) {
                set.add(implList.interfaceSymbol.getClassSymbol());
                implList.interfaceSymbol.getErasedSuperclasses(set);
                implList = implList.next;
            }
        }
        while ((classSymbol = classSymbol.getSuperClassSymbol()) != null) {
            set.add(classSymbol.getClassSymbol());
        }
    }

    boolean isCheckedException(Parser parser) {
        if (parser.javaLangThrowableSymbol.equalTo(this) || parser.javaLangThrowableSymbol.isSuperclass(this)) {
            if (parser.javaLangRuntimeExceptionSymbol.equalTo(this) || parser.javaLangRuntimeExceptionSymbol.isSuperclass(this)) {
                return false;
            }
            return !parser.javaLangErrorSymbol.equalTo(this) && !parser.javaLangErrorSymbol.isSuperclass(this);
        }
        return false;
    }
}

