/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.AutoBoxingExpression;
import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.CharConstantExpression;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.CompiledImplementationList;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.DoubleConstantExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.FloatConstantExpression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LongConstantExpression;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.Options;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.StringConstantExpression;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.TypeParameterSymbol;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeSymbolList;
import oracle.ojc.interfaces.Storage;

final class ClassFileWriter {
    Parser parser;
    byte[] writeBuffer;
    int writeBufferIndex;
    RawClassSymbol classSymbol;
    Storage classFile;
    private short constantValueAttrIndex;
    private short codeAttrIndex;
    private short lineNumberAttrIndex;
    private short localVarsAttrIndex;
    private short localVarsTypesAttrIndex;
    private short exceptionsAttrIndex;
    private short syntheticAttrIndex;
    private short deprecatedAttrIndex;
    private short sourceFileAttrIndex;
    private short innerClassesAttrIndex;
    private short signatureAttrIndex;
    short runtimeVisibleAnnotationAttrIndex;
    short runtimeInvisibleAnnotationAttrIndex;
    short runtimeVisibleParameterAnnotationAttrIndex;
    short runtimeInvisibleParameterAnnotationAttrIndex;
    short annotationDefaultAttrIndex;
    private short enclosingMethodAttrIndex;
    private short enclosingMethodClassIndex;
    private short enclosingMethodMethodIndex;
    private short thisClassIndex;
    private short superClassIndex;
    private int implementationCount;
    private int fieldCount;
    private FieldSymbolList fieldList;
    private int methodCount;
    private MethodSymbolList methodList;
    private short sourceFileIndex;
    private short innerClassesCount;
    private InnerClassesList innerClassesList;
    private short classSignatureIndex;
    private short compilerAttrIndex;
    private short lineColumnInfoAttrIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    ClassFileWriter(Parser parser, RawClassSymbol classSymbol, Storage classFile, byte[] writeBuffer) {
        this.parser = parser;
        this.classSymbol = classSymbol;
        this.classFile = classFile;
        this.writeBuffer = writeBuffer;
        this.writeBufferIndex = 0;
    }

    private void flush() throws IOException {
        this.classFile.write(this.writeBuffer, 0, this.writeBufferIndex);
        this.writeBufferIndex = 0;
    }

    private void writeByteArray(byte[] byteArray, int len) throws IOException {
        int wbIdx = this.writeBufferIndex;
        byte[] wb = this.writeBuffer;
        if (len > wb.length) {
            this.flush();
            this.writeBufferIndex = 0;
            this.classFile.write(byteArray, 0, len);
        } else {
            if (wbIdx + len > wb.length) {
                this.flush();
                wbIdx = 0;
            }
            System.arraycopy(byteArray, 0, wb, wbIdx, len);
            this.writeBufferIndex = wbIdx + len;
        }
    }

    int ensureWriteBufferCapacity(int sizeRequired) throws IOException {
        int wbIdx = this.writeBufferIndex;
        if (wbIdx + sizeRequired >= this.writeBuffer.length) {
            this.flush();
            wbIdx = 0;
        }
        return wbIdx;
    }

    private void writeHeader() {
        byte[] wb = this.writeBuffer;
        switch (this.parser.options.targetJDKVersion) {
            case 150: {
                wb[7] = 49;
                wb[6] = 0;
                wb[5] = 0;
                wb[4] = 0;
                break;
            }
            case 170: {
                wb[7] = 51;
                wb[6] = 0;
                wb[5] = 0;
                wb[4] = 0;
                break;
            }
            default: {
                wb[7] = 50;
                wb[6] = 0;
                wb[5] = 0;
                wb[4] = 0;
                break;
            }
            case 140: {
                wb[7] = 48;
                wb[6] = 0;
                wb[5] = 0;
                wb[4] = 0;
                break;
            }
            case 130: {
                wb[7] = 47;
                wb[6] = 0;
                wb[5] = 0;
                wb[4] = 0;
                break;
            }
            case 120: {
                wb[7] = 46;
                wb[6] = 0;
                wb[5] = 0;
                wb[4] = 0;
                break;
            }
            case 110: {
                wb[7] = 45;
                wb[6] = 0;
                wb[5] = 3;
                wb[4] = 0;
            }
        }
        wb[0] = -54;
        wb[1] = -2;
        wb[2] = -70;
        wb[3] = -66;
        this.writeBufferIndex = 8;
    }

    private void writeAccessThisAndSuper() throws IOException {
        short access;
        if (this.classSymbol.isInnerClass()) {
            if (this.classSymbol.isAnonymousInnerClass()) {
                access = (short)(this.classSymbol.access & 0xFFFFFFF0);
            } else {
                boolean makePublic = (this.classSymbol.access & 5) != 0;
                access = (short)(this.classSymbol.access & 0xFFFFFFF0);
                if (makePublic) {
                    access = (short)(access | 1);
                }
            }
        } else {
            access = (short)(this.classSymbol.access & 0xFFFFFFF1);
        }
        if (this.parser.options.targetJDKVersion >= 120 && (this.classSymbol.access & 0x200) == 0) {
            access = (short)(access | 0x20);
        }
        access = (short)(access & 0xFFFFF7FF);
        int wbIdx = this.ensureWriteBufferCapacity(6);
        byte[] wb = this.writeBuffer;
        wb[wbIdx + 5] = (byte)this.superClassIndex;
        wb[wbIdx + 4] = (byte)(this.superClassIndex >> 8);
        wb[wbIdx + 3] = (byte)this.thisClassIndex;
        wb[wbIdx + 2] = (byte)(this.thisClassIndex >> 8);
        wb[wbIdx + 1] = (byte)access;
        wb[wbIdx] = (byte)(access >> 8);
        this.writeBufferIndex = wbIdx + 6;
    }

    private void writeImplementedInterfaces() throws IOException {
        int wbIdx = this.ensureWriteBufferCapacity(2);
        byte[] wb = this.writeBuffer;
        wb[wbIdx + 1] = (byte)this.implementationCount;
        wb[wbIdx] = (byte)(this.implementationCount >> 8);
        this.writeBufferIndex = wbIdx + 2;
        CompiledImplementationList list = (CompiledImplementationList)this.classSymbol.getImplementationList();
        while (list != null) {
            wbIdx = this.ensureWriteBufferCapacity(2);
            wb[wbIdx + 1] = (byte)list.index;
            wb[wbIdx] = (byte)(list.index >> 8);
            this.writeBufferIndex = wbIdx + 2;
            list = (CompiledImplementationList)list.next;
        }
    }

    private void writeSyntheticAttribute() throws IOException {
        int wbIdx = this.ensureWriteBufferCapacity(6);
        byte[] wb = this.writeBuffer;
        wb[wbIdx + 5] = 0;
        wb[wbIdx + 4] = 0;
        wb[wbIdx + 3] = 0;
        wb[wbIdx + 2] = 0;
        wb[wbIdx + 1] = (byte)this.syntheticAttrIndex;
        wb[wbIdx] = (byte)(this.syntheticAttrIndex >> 8);
        this.writeBufferIndex = wbIdx + 6;
    }

    private void writeDeprecatedAttribute() throws IOException {
        int wbIdx = this.ensureWriteBufferCapacity(6);
        byte[] wb = this.writeBuffer;
        wb[wbIdx + 5] = 0;
        wb[wbIdx + 4] = 0;
        wb[wbIdx + 3] = 0;
        wb[wbIdx + 2] = 0;
        wb[wbIdx + 1] = (byte)this.deprecatedAttrIndex;
        wb[wbIdx] = (byte)(this.deprecatedAttrIndex >> 8);
        this.writeBufferIndex = wbIdx + 6;
    }

    private void writeConstantValueAttribute(short constantValueIndex) throws IOException {
        int wbIdx = this.ensureWriteBufferCapacity(8);
        byte[] wb = this.writeBuffer;
        wb[wbIdx + 7] = (byte)constantValueIndex;
        wb[wbIdx + 6] = (byte)(constantValueIndex >> 8);
        wb[wbIdx + 5] = 2;
        wb[wbIdx + 4] = 0;
        wb[wbIdx + 3] = 0;
        wb[wbIdx + 2] = 0;
        wb[wbIdx + 1] = (byte)this.constantValueAttrIndex;
        wb[wbIdx] = (byte)(this.constantValueAttrIndex >> 8);
        this.writeBufferIndex = wbIdx + 8;
    }

    private void writeSignatureAttribute(short signatureIndex) throws IOException {
        int wbIdx = this.ensureWriteBufferCapacity(8);
        byte[] wb = this.writeBuffer;
        wb[wbIdx + 7] = (byte)signatureIndex;
        wb[wbIdx + 6] = (byte)(signatureIndex >> 8);
        wb[wbIdx + 5] = 2;
        wb[wbIdx + 4] = 0;
        wb[wbIdx + 3] = 0;
        wb[wbIdx + 2] = 0;
        wb[wbIdx + 1] = (byte)this.signatureAttrIndex;
        wb[wbIdx] = (byte)(this.signatureAttrIndex >> 8);
        this.writeBufferIndex = wbIdx + 8;
    }

    private void writeFields() throws IOException {
        int wbIdx = this.ensureWriteBufferCapacity(2);
        byte[] wb = this.writeBuffer;
        wb[wbIdx + 1] = (byte)this.fieldCount;
        wb[wbIdx] = (byte)(this.fieldCount >> 8);
        this.writeBufferIndex = wbIdx + 2;
        FieldSymbolList fsl = this.fieldList;
        while (fsl != null) {
            FieldSymbol fieldSymbol = fsl.fieldSymbol;
            short access = fieldSymbol.access;
            int attrCount = 0;
            if (fieldSymbol.isSynthetic()) {
                if (this.syntheticAttrIndex > 0) {
                    attrCount = (short)(attrCount + 1);
                }
            } else {
                if (this.parser.options.lineColumnInfo) {
                    attrCount = (short)(attrCount + 1);
                }
                if (fieldSymbol.isDeprecated()) {
                    attrCount = (short)(attrCount + 1);
                }
                if (fsl.signatureAttrIndex != 0) {
                    attrCount = (short)(attrCount + 1);
                }
            }
            if (fsl.constantValueIndex != 0) {
                attrCount = (short)(attrCount + 1);
            }
            if (fieldSymbol.annotation != null) {
                attrCount = (short)(attrCount + fieldSymbol.annotation.getAttibuteCount());
            }
            wbIdx = this.ensureWriteBufferCapacity(8);
            wb[wbIdx + 7] = (byte)attrCount;
            wb[wbIdx + 6] = (byte)(attrCount >> 8);
            wb[wbIdx + 5] = (byte)fsl.signatureIndex;
            wb[wbIdx + 4] = (byte)(fsl.signatureIndex >> 8);
            wb[wbIdx + 3] = (byte)fsl.nameIndex;
            wb[wbIdx + 2] = (byte)(fsl.nameIndex >> 8);
            wb[wbIdx + 1] = (byte)access;
            wb[wbIdx] = (byte)(access >> 8);
            this.writeBufferIndex = wbIdx + 8;
            if (fieldSymbol.isSynthetic()) {
                if (this.syntheticAttrIndex > 0) {
                    this.writeSyntheticAttribute();
                }
            } else {
                if (fsl.signatureAttrIndex != 0) {
                    this.writeSignatureAttribute(fsl.signatureAttrIndex);
                }
                if (this.parser.options.lineColumnInfo) {
                    this.writeLineColumnInfo(fieldSymbol);
                }
                if (fieldSymbol.isDeprecated()) {
                    this.writeDeprecatedAttribute();
                }
            }
            if (fsl.constantValueIndex > 0) {
                this.writeConstantValueAttribute(fsl.constantValueIndex);
            }
            if (fieldSymbol.annotation != null) {
                fieldSymbol.annotation.write(this);
            }
            fsl = fsl.next;
        }
    }

    private void writeMethods() throws IOException {
        int wbIdx = this.ensureWriteBufferCapacity(2);
        byte[] wb = this.writeBuffer;
        wb[wbIdx + 1] = (byte)this.methodCount;
        wb[wbIdx] = (byte)(this.methodCount >> 8);
        this.writeBufferIndex = wbIdx + 2;
        MethodSymbolList msl = this.methodList;
        while (msl != null) {
            int attrLen;
            Annotation annot;
            MethodSymbol methodSymbol = msl.methodSymbol;
            short access = methodSymbol.access;
            if (this.classSymbol.isInterface()) {
                access = (short)(access & 0xFFFFF7FF);
            }
            int attrCount = 0;
            if (methodSymbol.cmd.codeBuffer != null) {
                attrCount = (short)(attrCount + 1);
            }
            if (methodSymbol.throwsList != null) {
                attrCount = (short)(attrCount + 1);
            }
            if (methodSymbol.isSynthetic()) {
                if (this.syntheticAttrIndex > 0) {
                    attrCount = (short)(attrCount + 1);
                }
            } else {
                if (msl.signatureAttrIndex != 0) {
                    attrCount = (short)(attrCount + 1);
                }
                if (methodSymbol.isDeprecated()) {
                    attrCount = (short)(attrCount + 1);
                }
                if (!(methodSymbol.isGenerated() || methodSymbol.isDefaultConstructor() || methodSymbol.isBridgeMethod() || this.classSymbol.isSynthetic() || !this.parser.options.lineColumnInfo)) {
                    attrCount = (short)(attrCount + 1);
                }
            }
            if ((annot = methodSymbol.getAnnotations()) != null) {
                attrCount = (short)(attrCount + annot.getAttibuteCount());
            }
            if ((methodSymbol.flags & 0x40) != 0) {
                attrCount = (short)(attrCount + Annotation.getAttibuteCount(methodSymbol));
            }
            wbIdx = this.ensureWriteBufferCapacity(8);
            wb[wbIdx + 7] = (byte)attrCount;
            wb[wbIdx + 6] = (byte)(attrCount >> 8);
            wb[wbIdx + 5] = (byte)msl.signatureIndex;
            wb[wbIdx + 4] = (byte)(msl.signatureIndex >> 8);
            wb[wbIdx + 3] = (byte)msl.nameIndex;
            wb[wbIdx + 2] = (byte)(msl.nameIndex >> 8);
            wb[wbIdx + 1] = (byte)access;
            wb[wbIdx] = (byte)(access >> 8);
            this.writeBufferIndex = wbIdx + 8;
            if (methodSymbol.cmd.codeBuffer != null) {
                int codeLen = methodSymbol.cmd.codeBuffer.length;
                short exceptionTableLen = methodSymbol.cmd.exceptionTableLen;
                attrLen = 8 + codeLen + 2 + exceptionTableLen + 2;
                int lineNumberCount = 0;
                int lineNumberLen = 0;
                if (this.parser.options.lineNumbers) {
                    if (methodSymbol.cmd.lineNumberTable == null) {
                        this.addLineNumberTableToMethodSymbol(methodSymbol);
                    }
                    if ((lineNumberCount = methodSymbol.cmd.lineNumberTable.length / 4) != 0) {
                        lineNumberLen = 2 + lineNumberCount * 4;
                        attrLen += 6 + lineNumberLen;
                    }
                }
                short localVarsCount = 0;
                int localVarsLen = 0;
                short localVarsTypeCount = 0;
                int localVarsTypeLen = 0;
                if (this.parser.options.localVariables && (localVarsCount = methodSymbol.cmd.localVarTableLen) != 0) {
                    localVarsLen = 2 + localVarsCount * 10;
                    attrLen += 6 + localVarsLen;
                    localVarsTypeCount = methodSymbol.cmd.localVarTypeTableLen;
                    if (localVarsTypeCount != 0) {
                        localVarsTypeLen = 2 + localVarsTypeCount * 10;
                        attrLen += 6 + localVarsTypeLen;
                    }
                }
                short maxLocals = methodSymbol.localVarCount;
                short maxStack = (short)methodSymbol.cmd.maxOpStackDepth;
                wbIdx = this.ensureWriteBufferCapacity(14);
                wb[wbIdx + 13] = (byte)codeLen;
                wb[wbIdx + 12] = (byte)(codeLen >> 8);
                wb[wbIdx + 11] = (byte)(codeLen >> 16);
                wb[wbIdx + 10] = (byte)(codeLen >> 24);
                wb[wbIdx + 9] = (byte)maxLocals;
                wb[wbIdx + 8] = (byte)(maxLocals >> 8);
                wb[wbIdx + 7] = (byte)maxStack;
                wb[wbIdx + 6] = (byte)(maxStack >> 8);
                wb[wbIdx + 5] = (byte)attrLen;
                wb[wbIdx + 4] = (byte)(attrLen >> 8);
                wb[wbIdx + 3] = (byte)(attrLen >> 16);
                wb[wbIdx + 2] = (byte)(attrLen >> 24);
                wb[wbIdx + 1] = (byte)this.codeAttrIndex;
                wb[wbIdx] = (byte)(this.codeAttrIndex >> 8);
                this.writeBufferIndex = wbIdx + 14;
                this.writeByteArray(methodSymbol.cmd.codeBuffer, codeLen);
                wbIdx = this.ensureWriteBufferCapacity(2);
                wb[wbIdx + 1] = (byte)(exceptionTableLen >> 3);
                wb[wbIdx] = (byte)(exceptionTableLen >> 11);
                this.writeBufferIndex = wbIdx + 2;
                if (exceptionTableLen > 0) {
                    this.writeByteArray(methodSymbol.cmd.exceptionTable, exceptionTableLen);
                }
                attrCount = 0;
                if (lineNumberLen > 0) {
                    attrCount = (short)(attrCount + 1);
                }
                if (localVarsLen > 0) {
                    attrCount = (short)(attrCount + 1);
                    if (localVarsTypeLen > 0) {
                        attrCount = (short)(attrCount + 1);
                    }
                }
                wbIdx = this.ensureWriteBufferCapacity(2);
                wb[wbIdx + 1] = (byte)attrCount;
                wb[wbIdx] = (byte)(attrCount >> 8);
                this.writeBufferIndex = wbIdx + 2;
                if (lineNumberLen > 0) {
                    wbIdx = this.ensureWriteBufferCapacity(8);
                    wb[wbIdx + 7] = (byte)lineNumberCount;
                    wb[wbIdx + 6] = (byte)(lineNumberCount >> 8);
                    wb[wbIdx + 5] = (byte)lineNumberLen;
                    wb[wbIdx + 4] = (byte)(lineNumberLen >> 8);
                    wb[wbIdx + 3] = (byte)(lineNumberLen >> 16);
                    wb[wbIdx + 2] = (byte)(lineNumberLen >> 24);
                    wb[wbIdx + 1] = (byte)this.lineNumberAttrIndex;
                    wb[wbIdx] = (byte)(this.lineNumberAttrIndex >> 8);
                    this.writeBufferIndex = wbIdx + 8;
                    this.writeByteArray(methodSymbol.cmd.lineNumberTable, lineNumberLen - 2);
                }
                if (localVarsLen > 0) {
                    wbIdx = this.ensureWriteBufferCapacity(8);
                    wb[wbIdx + 7] = (byte)localVarsCount;
                    wb[wbIdx + 6] = (byte)(localVarsCount >> 8);
                    wb[wbIdx + 5] = (byte)localVarsLen;
                    wb[wbIdx + 4] = (byte)(localVarsLen >> 8);
                    wb[wbIdx + 3] = (byte)(localVarsLen >> 16);
                    wb[wbIdx + 2] = (byte)(localVarsLen >> 24);
                    wb[wbIdx + 1] = (byte)this.localVarsAttrIndex;
                    wb[wbIdx] = (byte)(this.localVarsAttrIndex >> 8);
                    this.writeBufferIndex = wbIdx + 8;
                    this.writeByteArray(methodSymbol.cmd.localVarTable, localVarsLen - 2);
                    if (localVarsTypeLen > 0) {
                        wbIdx = this.ensureWriteBufferCapacity(8);
                        wb[wbIdx + 7] = (byte)localVarsTypeCount;
                        wb[wbIdx + 6] = (byte)(localVarsTypeCount >> 8);
                        wb[wbIdx + 5] = (byte)localVarsTypeLen;
                        wb[wbIdx + 4] = (byte)(localVarsTypeLen >> 8);
                        wb[wbIdx + 3] = (byte)(localVarsTypeLen >> 16);
                        wb[wbIdx + 2] = (byte)(localVarsTypeLen >> 24);
                        wb[wbIdx + 1] = (byte)this.localVarsTypesAttrIndex;
                        wb[wbIdx] = (byte)(this.localVarsTypesAttrIndex >> 8);
                        this.writeBufferIndex = wbIdx + 8;
                        this.writeByteArray(methodSymbol.cmd.localVarTypeTable, localVarsTypeLen - 2);
                    }
                }
            }
            if (methodSymbol.throwsList != null) {
                wbIdx = this.ensureWriteBufferCapacity(8);
                attrLen = 2 + msl.exceptionCount * 2;
                wb[wbIdx + 7] = (byte)msl.exceptionCount;
                wb[wbIdx + 6] = (byte)(msl.exceptionCount >> 8);
                wb[wbIdx + 5] = (byte)attrLen;
                wb[wbIdx + 4] = (byte)(attrLen >> 8);
                wb[wbIdx + 3] = (byte)(attrLen >> 16);
                wb[wbIdx + 2] = (byte)(attrLen >> 24);
                wb[wbIdx + 1] = (byte)this.exceptionsAttrIndex;
                wb[wbIdx] = (byte)(this.exceptionsAttrIndex >> 8);
                this.writeBufferIndex = wbIdx + 8;
                MethodSymbol.CompiledThrowsList ctl = (MethodSymbol.CompiledThrowsList)methodSymbol.throwsList;
                do {
                    wbIdx = this.ensureWriteBufferCapacity(2);
                    wb[wbIdx + 1] = (byte)ctl.index;
                    wb[wbIdx] = (byte)(ctl.index >> 8);
                    this.writeBufferIndex = wbIdx + 2;
                } while ((ctl = (MethodSymbol.CompiledThrowsList)ctl.next) != null);
            }
            if (methodSymbol.isSynthetic()) {
                if (this.syntheticAttrIndex > 0) {
                    this.writeSyntheticAttribute();
                }
            } else {
                if (msl.signatureAttrIndex != 0) {
                    this.writeSignatureAttribute(msl.signatureAttrIndex);
                }
                if (!(methodSymbol.isGenerated() || methodSymbol.isDefaultConstructor() || methodSymbol.isBridgeMethod() || this.classSymbol.isSynthetic() || !this.parser.options.lineColumnInfo)) {
                    this.writeLineColumnInfo(methodSymbol);
                }
                if (methodSymbol.isDeprecated()) {
                    this.writeDeprecatedAttribute();
                }
            }
            if (annot != null) {
                annot.write(this);
            }
            if ((methodSymbol.flags & 0x40) != 0) {
                Annotation.write(methodSymbol, this);
            }
            methodSymbol.cmd = null;
            msl = msl.next;
        }
    }

    private int getClassLineNumber(ClassSymbol cs) {
        int line = Scanner.positionToLine(cs.pos);
        while (line == 0 && cs != null) {
            if ((cs = cs.getOuterClass()) == null) continue;
            line = Scanner.positionToLine(cs.pos);
        }
        if (line == 0) {
            line = 1;
        }
        return line;
    }

    private void addLineNumberTableToMethodSymbol(MethodSymbol methodSymbol) {
        int line = this.getClassLineNumber(methodSymbol.definingClass);
        methodSymbol.cmd.estimatedLineCount = 1;
        methodSymbol.cmd.lineNumberTable = new byte[4];
        methodSymbol.cmd.lineNumberTable[3] = (byte)line;
        methodSymbol.cmd.lineNumberTable[2] = (byte)(line >> 8);
        methodSymbol.cmd.lineNumberTable[1] = 0;
        methodSymbol.cmd.lineNumberTable[0] = 0;
    }

    private void writeLineColumnInfo(Symbol symbol) throws IOException {
        byte[] wb = this.writeBuffer;
        int wbIdx = this.ensureWriteBufferCapacity(10);
        short column = (short)(Scanner.positionToColumn(symbol.pos) + 1);
        short line = (short)Scanner.positionToLine(symbol.pos);
        wb[wbIdx + 9] = (byte)column;
        wb[wbIdx + 8] = (byte)(column >> 8);
        wb[wbIdx + 7] = (byte)line;
        wb[wbIdx + 6] = (byte)(line >> 8);
        wb[wbIdx + 5] = 4;
        wb[wbIdx + 4] = 0;
        wb[wbIdx + 3] = 0;
        wb[wbIdx + 2] = 0;
        wb[wbIdx + 1] = (byte)this.lineColumnInfoAttrIndex;
        wb[wbIdx] = (byte)(this.lineColumnInfoAttrIndex >> 8);
        this.writeBufferIndex = wbIdx + 10;
    }

    private void writeClassAttributes() throws IOException {
        int attrCount = 1;
        if (this.enclosingMethodAttrIndex != 0) {
            attrCount = (short)(attrCount + 1);
        }
        if (this.sourceFileAttrIndex != 0) {
            attrCount = (short)(attrCount + 1);
        }
        if (this.innerClassesAttrIndex != 0) {
            attrCount = (short)(attrCount + 1);
        }
        if (this.classSymbol.isSynthetic()) {
            if (this.syntheticAttrIndex > 0) {
                attrCount = (short)(attrCount + 1);
            }
        } else {
            if (this.classSymbol.isDeprecated()) {
                attrCount = (short)(attrCount + 1);
            }
            if (this.parser.options.lineColumnInfo) {
                attrCount = (short)(attrCount + 1);
            }
        }
        if (this.classSymbol.annotation != null) {
            attrCount = (short)(attrCount + this.classSymbol.annotation.getAttibuteCount());
        }
        if (this.classSignatureIndex != 0) {
            attrCount = (short)(attrCount + 1);
        }
        int wbIdx = this.ensureWriteBufferCapacity(2);
        byte[] wb = this.writeBuffer;
        wb[wbIdx + 1] = (byte)attrCount;
        wb[wbIdx] = (byte)(attrCount >> 8);
        this.writeBufferIndex = wbIdx + 2;
        if (this.classSymbol.isSynthetic()) {
            if (this.syntheticAttrIndex > 0) {
                this.writeSyntheticAttribute();
            }
        } else {
            if (this.classSignatureIndex != 0) {
                this.writeSignatureAttribute(this.classSignatureIndex);
            }
            if (this.classSymbol.isDeprecated()) {
                this.writeDeprecatedAttribute();
            }
            if (this.parser.options.lineColumnInfo) {
                this.writeLineColumnInfo(this.classSymbol);
            }
        }
        if (this.classSymbol.annotation != null) {
            this.classSymbol.annotation.write(this);
        }
        if (this.sourceFileAttrIndex != 0) {
            wbIdx = this.ensureWriteBufferCapacity(8);
            wb[wbIdx + 7] = (byte)this.sourceFileIndex;
            wb[wbIdx + 6] = (byte)(this.sourceFileIndex >> 8);
            wb[wbIdx + 5] = 2;
            wb[wbIdx + 4] = 0;
            wb[wbIdx + 3] = 0;
            wb[wbIdx + 2] = 0;
            wb[wbIdx + 1] = (byte)this.sourceFileAttrIndex;
            wb[wbIdx] = (byte)(this.sourceFileAttrIndex >> 8);
            this.writeBufferIndex = wbIdx + 8;
        }
        if (this.innerClassesAttrIndex != 0) {
            wbIdx = this.ensureWriteBufferCapacity(8);
            int attrLen = 2 + this.innerClassesCount * 8;
            wb[wbIdx + 7] = (byte)this.innerClassesCount;
            wb[wbIdx + 6] = (byte)(this.innerClassesCount >> 8);
            wb[wbIdx + 5] = (byte)attrLen;
            wb[wbIdx + 4] = (byte)(attrLen >> 8);
            wb[wbIdx + 3] = (byte)(attrLen >> 16);
            wb[wbIdx + 2] = (byte)(attrLen >> 24);
            wb[wbIdx + 1] = (byte)this.innerClassesAttrIndex;
            wb[wbIdx] = (byte)(this.innerClassesAttrIndex >> 8);
            this.writeBufferIndex = wbIdx + 8;
            InnerClassesList icl = this.innerClassesList;
            while (icl != null) {
                wbIdx = this.ensureWriteBufferCapacity(8);
                wb[wbIdx + 7] = (byte)icl.innerClassAccess;
                wb[wbIdx + 6] = (byte)(icl.innerClassAccess >> 8);
                wb[wbIdx + 5] = (byte)icl.innerNameIndex;
                wb[wbIdx + 4] = (byte)(icl.innerNameIndex >> 8);
                wb[wbIdx + 3] = (byte)icl.outerClassInfoIndex;
                wb[wbIdx + 2] = (byte)(icl.outerClassInfoIndex >> 8);
                wb[wbIdx + 1] = (byte)icl.innerClassInfoIndex;
                wb[wbIdx] = (byte)(icl.innerClassInfoIndex >> 8);
                this.writeBufferIndex = wbIdx + 8;
                icl = icl.next;
            }
        }
        if (this.enclosingMethodAttrIndex != 0) {
            wbIdx = this.ensureWriteBufferCapacity(10);
            wb[wbIdx + 9] = (byte)this.enclosingMethodMethodIndex;
            wb[wbIdx + 8] = (byte)(this.enclosingMethodMethodIndex >> 8);
            wb[wbIdx + 7] = (byte)this.enclosingMethodClassIndex;
            wb[wbIdx + 6] = (byte)(this.enclosingMethodClassIndex >> 8);
            wb[wbIdx + 5] = 4;
            wb[wbIdx + 4] = 0;
            wb[wbIdx + 3] = 0;
            wb[wbIdx + 2] = 0;
            wb[wbIdx + 1] = (byte)this.enclosingMethodAttrIndex;
            wb[wbIdx] = (byte)(this.enclosingMethodAttrIndex >> 8);
            this.writeBufferIndex = wbIdx + 10;
        }
        int attr_len = 9;
        wbIdx = this.ensureWriteBufferCapacity(attr_len);
        wb[wbIdx + 8] = 1;
        wb[wbIdx + 7] = 1;
        wb[wbIdx + 6] = 11;
        wb[wbIdx + 5] = (byte)(attr_len - 6);
        wb[wbIdx + 4] = 0;
        wb[wbIdx + 3] = 0;
        wb[wbIdx + 2] = 0;
        wb[wbIdx + 1] = (byte)this.compilerAttrIndex;
        wb[wbIdx] = (byte)(this.compilerAttrIndex >> 8);
        this.writeBufferIndex = wbIdx + attr_len;
    }

    void createClassFile(String sourceFileName) throws IOException {
        InnerClassesList icl;
        InnerClassSymbol innerClassSymbol;
        TypeSymbol typeSymbol;
        short signatureIndex;
        RawClassSymbol classSym;
        Options options = this.parser.options;
        ConstantPool constantPool = this.classSymbol.cd.ccd.constantPool;
        this.classSymbol.cd.ccd.constantPool = null;
        this.thisClassIndex = constantPool.enterConstantPoolClass(this.classSymbol.getInternalName());
        this.superClassIndex = 0;
        ClassSymbol superClass = this.classSymbol.superClass;
        if (superClass != null) {
            classSym = superClass.getClassSymbol();
            this.superClassIndex = constantPool.enterConstantPoolClass(classSym.getInternalName());
            constantPool.checkForOutOfPackageInnerClass(this.classSymbol, classSym);
        }
        boolean foundSynthetic = false;
        boolean foundDeprecated = false;
        boolean foundSignature = false;
        if (this.classSymbol.isSynthetic()) {
            foundSynthetic = true;
        } else {
            if (this.classSymbol.isDeprecated()) {
                foundDeprecated = true;
            }
            if (this.classSymbol.involvesGenerics()) {
                foundSignature = true;
                this.classSignatureIndex = constantPool.enterConstantPoolUtf8(this.classSymbol.getClassSignature());
            }
        }
        CompiledImplementationList implList = (CompiledImplementationList)this.classSymbol.getImplementationList();
        while (implList != null) {
            ++this.implementationCount;
            classSym = implList.interfaceSymbol.getClassSymbol();
            implList.index = constantPool.enterConstantPoolClass(classSym.getInternalName());
            constantPool.checkForOutOfPackageInnerClass(this.classSymbol, classSym);
            implList = (CompiledImplementationList)implList.next;
        }
        Annotation annotation = this.classSymbol.annotation;
        if (annotation != null) {
            annotation.generateConstantPoolEntries(this, constantPool);
        }
        if ((this.classSymbol.flags & 2) != 0) {
            this.constantValueAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.constantValueAttribute.name);
        }
        this.fieldCount = this.classSymbol.cd.fieldCount;
        this.fieldList = null;
        FieldSymbol fieldSymbol = this.classSymbol.cd.fieldList;
        while (fieldSymbol != null) {
            signatureIndex = 0;
            if (fieldSymbol.isSynthetic()) {
                foundSynthetic = true;
            } else {
                if (fieldSymbol.isDeprecated()) {
                    foundDeprecated = true;
                }
                if (fieldSymbol.involvesGenerics()) {
                    foundSignature = true;
                    signatureIndex = constantPool.enterConstantPoolUtf8(fieldSymbol.getFieldSignature());
                }
            }
            FieldSymbolList fsl = new FieldSymbolList(fieldSymbol, constantPool.enterConstantPoolUtf8(fieldSymbol.identifier.name), constantPool.enterConstantPoolUtf8(fieldSymbol.getSignature()), signatureIndex);
            annotation = fieldSymbol.annotation;
            if (annotation != null) {
                annotation.generateConstantPoolEntries(this, constantPool);
            }
            if ((fieldSymbol.flags & 2) != 0) {
                int typeClass;
                Expression expr = fieldSymbol.initializer;
                if (!$assertionsDisabled && (fieldSymbol.access & 8) == 0) {
                    throw new AssertionError();
                }
                if (expr.kind == 2) {
                    typeClass = fieldSymbol.type.typeClass;
                } else if (expr.kind == 53) {
                    expr = ((AutoBoxingExpression)expr).operand;
                    typeClass = expr.getType().typeClass;
                } else {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    typeClass = -1;
                }
                switch (typeClass) {
                    case 2: {
                        BooleanConstantExpression bcExpr = (BooleanConstantExpression)expr;
                        fsl.constantValueIndex = constantPool.enterConstantPoolInteger(bcExpr.bval ? 1 : 0);
                        break;
                    }
                    case 4: {
                        if (expr.getType().typeKind == 4) {
                            CharConstantExpression ccExpr = (CharConstantExpression)expr;
                            fsl.constantValueIndex = constantPool.enterConstantPoolInteger(ccExpr.cval);
                            break;
                        }
                        IntConstantExpression icExpr = (IntConstantExpression)expr;
                        fsl.constantValueIndex = constantPool.enterConstantPoolInteger(icExpr.ival);
                        break;
                    }
                    case 8: {
                        LongConstantExpression lcExpr = (LongConstantExpression)expr;
                        fsl.constantValueIndex = constantPool.enterConstantPoolLong(lcExpr.lval);
                        break;
                    }
                    case 16: {
                        FloatConstantExpression fcExpr = (FloatConstantExpression)expr;
                        fsl.constantValueIndex = constantPool.enterConstantPoolFloat(fcExpr.fval);
                        break;
                    }
                    case 32: {
                        DoubleConstantExpression dcExpr = (DoubleConstantExpression)expr;
                        fsl.constantValueIndex = constantPool.enterConstantPoolDouble(dcExpr.dval);
                        break;
                    }
                    case 64: {
                        if (!$assertionsDisabled && !(expr instanceof StringConstantExpression)) {
                            throw new AssertionError();
                        }
                        StringConstantExpression scExpr = (StringConstantExpression)expr;
                        fsl.constantValueIndex = constantPool.enterConstantPoolString(scExpr.sval);
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }
            fsl.next = this.fieldList;
            this.fieldList = fsl;
            fieldSymbol = fieldSymbol.nextInClass;
        }
        boolean foundCode = false;
        boolean foundExceptions = false;
        boolean foundLocalVarsTypes = false;
        boolean foundLocalVars = false;
        this.methodCount = 0;
        this.methodList = null;
        MethodSymbol methodSymbol = this.classSymbol.cd.methodList;
        while (methodSymbol != null) {
            ++this.methodCount;
            if (methodSymbol.cmd.codeBuffer != null) {
                foundCode = true;
            }
            if (methodSymbol.cmd.localVarTableLen > 0) {
                foundLocalVars = true;
            }
            if (methodSymbol.cmd.localVarTypeTableLen > 0) {
                foundLocalVarsTypes = true;
            }
            if ((annotation = methodSymbol.getAnnotations()) != null) {
                annotation.generateConstantPoolEntries(this, constantPool);
            }
            if ((methodSymbol.flags & 0x40) != 0) {
                Annotation.generateConstantPoolEntries(methodSymbol, this, constantPool);
            }
            short exceptionCount = 0;
            if (methodSymbol.throwsList != null) {
                foundExceptions = true;
                MethodSymbol.CompiledThrowsList ctl = (MethodSymbol.CompiledThrowsList)methodSymbol.throwsList;
                do {
                    if ((typeSymbol = ctl.throwsType).isTypeParameter()) {
                        typeSymbol = ((TypeParameterSymbol)typeSymbol).getClassSymbol();
                    }
                    ctl.index = constantPool.enterConstantPoolClass(typeSymbol.getInternalName());
                    exceptionCount = (short)(exceptionCount + 1);
                } while ((ctl = (MethodSymbol.CompiledThrowsList)ctl.next) != null);
            }
            signatureIndex = 0;
            if (methodSymbol.isSynthetic()) {
                foundSynthetic = true;
            } else {
                if (methodSymbol.isDeprecated()) {
                    foundDeprecated = true;
                }
                if (methodSymbol.involvesGenerics()) {
                    foundSignature = true;
                    signatureIndex = constantPool.enterConstantPoolUtf8(methodSymbol.getMethodSignature());
                }
            }
            MethodSymbolList msl = new MethodSymbolList(methodSymbol, constantPool.enterConstantPoolUtf8(methodSymbol.identifier.name), constantPool.enterConstantPoolUtf8(methodSymbol.getSignature()), exceptionCount, signatureIndex);
            msl.next = this.methodList;
            this.methodList = msl;
            methodSymbol = methodSymbol.nextInClass;
        }
        if (foundCode) {
            this.codeAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.codeAttribute.name);
        }
        if (options.lineNumbers) {
            this.lineNumberAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.lineNumberTableAttribute.name);
        }
        if (options.sourceFile) {
            this.sourceFileAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.sourceFileAttribute.name);
            this.sourceFileIndex = constantPool.enterConstantPoolUtf8(sourceFileName.toCharArray());
        }
        if (foundLocalVars) {
            this.localVarsAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.localVarsTableAttribute.name);
        }
        if (foundLocalVarsTypes) {
            this.localVarsTypesAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.localVarsTypeTableAttribute.name);
        }
        if (foundSynthetic && !this.parser.targetingAtLeastOneFive) {
            this.syntheticAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.syntheticAttribute.name);
        }
        if (foundExceptions) {
            this.exceptionsAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.exceptionsAttribute.name);
        }
        if (foundDeprecated) {
            this.deprecatedAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.deprecatedAttribute.name);
        }
        if (foundSignature) {
            this.signatureAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.signatureAttribute.name);
        }
        this.innerClassesList = null;
        if (this.classSymbol.isInnerClass()) {
            innerClassSymbol = (InnerClassSymbol)this.classSymbol;
            RawClassSymbol outerClass = innerClassSymbol.getOuterClass();
            if (this.parser.targetingAtLeastOneFive && innerClassSymbol.isLocalInnerClass()) {
                this.enclosingMethodAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.enclosingMethodAttribute.name);
                this.enclosingMethodClassIndex = constantPool.enterConstantPoolClass(outerClass.getInternalName());
                methodSymbol = innerClassSymbol.getEnclosingMethod();
                if (methodSymbol != null) {
                    this.enclosingMethodMethodIndex = constantPool.enterConstantPoolNameAndType(methodSymbol.identifier.name, methodSymbol.getSignature());
                }
            }
            while (true) {
                icl = new InnerClassesList();
                icl.innerClassInfoIndex = constantPool.enterConstantPoolClass(innerClassSymbol.getInternalName());
                icl.outerClassInfoIndex = constantPool.enterConstantPoolClass(outerClass.getInternalName());
                icl.innerClassAccess = innerClassSymbol.access;
                if (!innerClassSymbol.isAnonymousInnerClass()) {
                    icl.innerNameIndex = constantPool.enterConstantPoolUtf8(innerClassSymbol.identifier.name);
                }
                icl.next = this.innerClassesList;
                this.innerClassesList = icl;
                this.innerClassesCount = (short)(this.innerClassesCount + 1);
                if (!outerClass.isInnerClass()) break;
                innerClassSymbol = (InnerClassSymbol)outerClass;
                outerClass = innerClassSymbol.getOuterClass();
            }
        }
        TypeSymbolList tsl = this.classSymbol.cd.innerClassList;
        while (tsl != null) {
            typeSymbol = tsl.typeSymbol;
            icl = new InnerClassesList();
            icl.innerClassInfoIndex = constantPool.enterConstantPoolClass(typeSymbol.getInternalName());
            icl.outerClassInfoIndex = this.thisClassIndex;
            icl.innerClassAccess = typeSymbol.access;
            if (!typeSymbol.isAnonymousInnerClass()) {
                icl.innerNameIndex = constantPool.enterConstantPoolUtf8(typeSymbol.identifier.name);
            }
            icl.next = this.innerClassesList;
            this.innerClassesList = icl;
            this.innerClassesCount = (short)(this.innerClassesCount + 1);
            tsl = tsl.next;
        }
        this.classSymbol.checkForOutOfPackageInnerClasses(constantPool, this.classSymbol);
        tsl = constantPool.outOfPackageInnerClassList;
        while (tsl != null) {
            innerClassSymbol = (InnerClassSymbol)tsl.typeSymbol;
            icl = new InnerClassesList();
            icl.innerClassInfoIndex = constantPool.enterConstantPoolClass(innerClassSymbol.getInternalName());
            icl.outerClassInfoIndex = constantPool.enterConstantPoolClass(innerClassSymbol.getOuterClass().getInternalName());
            icl.innerNameIndex = constantPool.enterConstantPoolUtf8(innerClassSymbol.identifier.name);
            icl.innerClassAccess = innerClassSymbol.access;
            icl.next = this.innerClassesList;
            this.innerClassesList = icl;
            this.innerClassesCount = (short)(this.innerClassesCount + 1);
            tsl = tsl.next;
        }
        if (this.innerClassesCount > 0) {
            this.innerClassesAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.innerClassesAttribute.name);
        }
        this.compilerAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.ojcAttribute.name);
        this.lineColumnInfoAttrIndex = constantPool.enterConstantPoolUtf8(Identifier.getIdentifier((String)"LineColumnInfo").name);
        this.writeHeader();
        constantPool.writeConstantPool(this);
        this.writeAccessThisAndSuper();
        this.writeImplementedInterfaces();
        this.writeFields();
        this.writeMethods();
        this.writeClassAttributes();
        if (this.parser.options.makeFile != null) {
            this.parser.depInfo.addClass(this.classSymbol, constantPool, this.parser);
        }
        this.classSymbol.cd.ccd.constantPool = null;
        this.flush();
    }

    static {
        $assertionsDisabled = !ClassFileWriter.class.desiredAssertionStatus();
    }

    private static class MethodSymbolList {
        MethodSymbolList next;
        MethodSymbol methodSymbol;
        short nameIndex;
        short signatureIndex;
        short exceptionCount;
        short signatureAttrIndex;

        MethodSymbolList(MethodSymbol methodSymbol, short nameIndex, short signatureIndex, short exceptionCount, short signatureAttrIndex) {
            this.methodSymbol = methodSymbol;
            this.nameIndex = nameIndex;
            this.signatureIndex = signatureIndex;
            this.exceptionCount = exceptionCount;
            this.signatureAttrIndex = signatureAttrIndex;
        }
    }

    private static class FieldSymbolList {
        FieldSymbolList next;
        FieldSymbol fieldSymbol;
        short nameIndex;
        short signatureIndex;
        short constantValueIndex;
        short signatureAttrIndex;

        FieldSymbolList(FieldSymbol fieldSymbol, short nameIndex, short signatureIndex, short signatureAttrIndex) {
            this.fieldSymbol = fieldSymbol;
            this.nameIndex = nameIndex;
            this.signatureIndex = signatureIndex;
            this.signatureAttrIndex = signatureAttrIndex;
        }
    }

    private static class InnerClassesList {
        InnerClassesList next;
        short innerClassInfoIndex;
        short outerClassInfoIndex;
        short innerNameIndex;
        short innerClassAccess;

        private InnerClassesList() {
        }
    }
}

