/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.CharConstantExpression;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantExpression;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.IntConstantExpression;
import oracle.ojc.compiler.LabelStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;
import oracle.ojc.compiler.SwitchStatement;
import oracle.ojc.compiler.Symbol;
import oracle.ojc.compiler.ThisExpression;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.UnresolvedSymbol;

final class CaseStatement
extends LabelStatement {
    Expression caseExpr;
    int caseValue;

    CaseStatement(StatementList parent, int pos, Expression caseExpr) {
        super(parent, pos, (byte)5, null);
        this.caseExpr = caseExpr;
    }

    void resolveAndCheck(Parser parser) {
        SwitchLoopList switchRec = parser.innerSwitchLoop;
        while (switchRec != null && switchRec.switchStmt == null) {
            switchRec = switchRec.outerSwitchLoop;
        }
        if (switchRec == null) {
            parser.error(Message.errorOrphanedSymbol, this.pos, false, "case");
        } else {
            Expression expr = this.caseExpr;
            this.caseExpr = null;
            if (expr != null) {
                ClassSymbol classSymbol;
                FieldExpression fieldExpr;
                int exprPos = expr.pos;
                Expression orgExpr = expr;
                TypeSymbol switchExprType = switchRec.switchStmt.switchExpr.getType();
                if (switchExprType.isEnum() && expr instanceof FieldExpression) {
                    fieldExpr = (FieldExpression)expr;
                    if (fieldExpr.qualification == null && fieldExpr.thisArgument == null && fieldExpr.field instanceof UnresolvedSymbol && ((UnresolvedSymbol)fieldExpr.field).qualifierList == null) {
                        classSymbol = (ClassSymbol)switchExprType;
                        Symbol symbol = classSymbol.getClassScope().lookupSpecificSymbolInScope(fieldExpr.field.identifier, 2, true);
                        if (symbol != null) {
                            fieldExpr.field = symbol;
                            fieldExpr.setType(switchExprType);
                        } else {
                            expr = expr.resolveAndCheck(parser);
                        }
                    } else {
                        parser.error(Message.errorQualifiedEnumCaseLabel, exprPos, false);
                        expr = ErrorExpression.errorExpression;
                    }
                } else {
                    expr = expr.resolveAndCheck(parser);
                }
                TypeSymbol exprType = expr.getType();
                byte typeClass = exprType.typeClass;
                if ((typeClass & 4) == 0) {
                    if (exprType.isEnum()) {
                        if (!exprType.equalTo(switchExprType)) {
                            parser.error(Message.errorIncompatibleTypes, exprPos, false, exprType.errorName(), switchExprType.errorName());
                            return;
                        }
                    } else {
                        parser.error(Message.errorIncompatibleTypes, exprPos, exprType.isErroneous(), exprType.errorName(), "int");
                        return;
                    }
                }
                if (exprType.isEnum()) {
                    if (!(expr instanceof FieldExpression)) {
                        parser.error(Message.errorConstantRequired, this.pos, false);
                    } else {
                        fieldExpr = (FieldExpression)expr;
                        FieldSymbol enumField = (FieldSymbol)fieldExpr.field;
                        if ((enumField.access & 0x4000) == 0) {
                            parser.error(Message.errorConstantRequired, this.pos, false);
                        } else {
                            classSymbol = (ClassSymbol)exprType;
                            this.caseValue = switchRec.switchStmt.emc.getEnumConst(classSymbol.getClassSymbol(), enumField);
                        }
                    }
                } else {
                    Expression finalInitializer;
                    ConstantExpression constantExpr = null;
                    if (expr.kind == 2) {
                        constantExpr = (ConstantExpression)expr;
                    } else if (expr instanceof FieldExpression && (finalInitializer = this.getFinalInitializer(expr)) instanceof ConstantExpression) {
                        constantExpr = (ConstantExpression)finalInitializer;
                    }
                    if (constantExpr != null && orgExpr instanceof FieldExpression) {
                        FieldExpression fieldExpression = (FieldExpression)orgExpr;
                        if (fieldExpression.thisArgument != null) {
                            if (fieldExpression.thisArgument instanceof ThisExpression) {
                                ThisExpression thisExpression = (ThisExpression)fieldExpression.thisArgument;
                                if (thisExpression.classSymbol != parser.currentClassSymbol) {
                                    constantExpr = null;
                                }
                            } else {
                                constantExpr = null;
                            }
                        }
                    }
                    if (constantExpr == null) {
                        if (expr.kind != 0) {
                            parser.error(Message.errorConstantRequired, this.pos, false);
                        }
                        return;
                    }
                    if (constantExpr.getType().typeKind == 4) {
                        CharConstantExpression ccExpr = (CharConstantExpression)constantExpr;
                        this.caseValue = ccExpr.cval;
                    } else {
                        IntConstantExpression icExpr = (IntConstantExpression)constantExpr;
                        this.caseValue = icExpr.ival;
                    }
                    switch (switchExprType.typeKind) {
                        case 3: {
                            if (this.caseValue >= -128 && 127 >= this.caseValue) break;
                            parser.error(Message.errorIncompatibleTypes, exprPos, false, exprType.errorName(), switchExprType.errorName());
                            break;
                        }
                        case 5: {
                            if (this.caseValue >= Short.MIN_VALUE && Short.MAX_VALUE >= this.caseValue) break;
                            parser.error(Message.errorIncompatibleTypes, exprPos, false, exprType.errorName(), switchExprType.errorName());
                            break;
                        }
                        case 4: {
                            if (this.caseValue >= 0 && 65535 >= this.caseValue) break;
                            parser.error(Message.errorIncompatibleTypes, exprPos, false, exprType.errorName(), switchExprType.errorName());
                        }
                    }
                }
                switchRec.caseStmts.add(this);
                SwitchStatement switchStmt = switchRec.switchStmt;
                if (switchStmt.bodyStatements != this.parent) {
                    parser.error(Message.errorOrphanedSymbol, this.pos, false, "case");
                }
            }
            parser.defSet = (BitSet)switchRec.defSet.clone();
            if (this.prev != null) {
                if (!this.prev.canReachNextStatement(false)) {
                    parser.posSet = (BitSet)switchRec.posSet.clone();
                } else if (this.prev.kind != 5 && this.prev.kind != 6) {
                    parser.warning(null, Message.warningFallThrough, this.prev.pos);
                }
            }
        }
    }

    private Expression getFinalInitializer(Expression expression) {
        if (expression instanceof FieldExpression) {
            FieldExpression fieldExpression = (FieldExpression)expression;
            if (fieldExpression.field.kind == 2) {
                FieldSymbol fieldSymbol = (FieldSymbol)fieldExpression.field;
                if ((fieldSymbol.access & 0x10) != 0) {
                    return fieldSymbol.initializer;
                }
            }
        }
        return null;
    }
}

