/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.ArrayExpression;
import oracle.ojc.compiler.BinaryExpression;
import oracle.ojc.compiler.BoxingExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.Error;
import oracle.ojc.compiler.ErrorExpression;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.FieldExpression;
import oracle.ojc.compiler.FieldSymbol;
import oracle.ojc.compiler.LocalVariableSymbol;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodVariableExpression;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.ReferenceTypeSymbol;
import oracle.ojc.compiler.ThisExpression;
import oracle.ojc.compiler.TypeSymbol;

final class AssignmentExpression
extends BinaryExpression {
    AssignmentExpression(int pos, Expression leftOperand, Expression rightOperand) {
        super((byte)5, pos, leftOperand, rightOperand);
    }

    /*
     * Enabled aggressive block sorting
     */
    Expression resolveAndCheck(Parser parser) {
        Expression rightOp;
        Expression leftOp;
        block28: {
            block27: {
                TypeSymbol leftOpType;
                block26: {
                    leftOp = this.leftOperand;
                    byte kind = leftOp.kind;
                    if (kind != 1 && kind != 3) {
                        Error error = parser.error(Message.errorDifferentKindRequired, leftOp.pos, kind == 0, Message.variableString, Message.valueString);
                        return new ErrorExpression(error);
                    }
                    leftOp = leftOp.resolveAndCheckWrite(parser);
                    kind = leftOp.kind;
                    if (kind != 1 && kind != 3) {
                        Error error = parser.error(Message.errorDifferentKindRequired, this.leftOperand.pos, kind == 0 | leftOp.kind == 0, Message.variableString, Message.valueString);
                        return new ErrorExpression(error);
                    }
                    leftOpType = leftOp.getType();
                    rightOp = this.rightOperand;
                    if (rightOp.takeAssignmentContext()) {
                        parser.assignmentContext = leftOpType;
                    }
                    rightOp = rightOp.resolveAndCheck(parser);
                    leftOp.markDefined(parser);
                    TypeSymbol rightOpType = rightOp.getType();
                    if (leftOpType.isErroneous()) return ErrorExpression.errorExpression;
                    if (rightOpType.isErroneous()) {
                        return ErrorExpression.errorExpression;
                    }
                    if (leftOpType.isReferenceType()) {
                        if (!rightOpType.isReferenceType()) {
                            if (parser.parsingAtLeastOneFive && rightOpType.isPrimitiveType()) {
                                this.rightOperand = rightOp.promoteType(parser, leftOpType);
                                if (this.rightOperand instanceof ErrorExpression) {
                                    return this.rightOperand;
                                }
                                break block26;
                            } else {
                                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, rightOpType.isErroneous() | leftOpType.isErroneous(), this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
                                return new ErrorExpression(error);
                            }
                        }
                        rightOpType.resolveType(parser, this.pos, false, true, false);
                        ReferenceTypeSymbol lRefSymbol = (ReferenceTypeSymbol)leftOpType;
                        ReferenceTypeSymbol rRefSymbol = (ReferenceTypeSymbol)rightOpType;
                        if (!rRefSymbol.isAssignmentCompatible(parser, lRefSymbol)) {
                            Error error = parser.error(Message.errorIncompatibleTypes, this.pos, false, rightOpType.errorName(), leftOpType.errorName());
                            return new ErrorExpression(error);
                        }
                        leftOpType.checkForUncheckedConversion(parser, this.pos, rightOpType, false);
                        this.rightOperand = rightOp.promoteType(parser, leftOpType);
                        if (rRefSymbol == ReferenceTypeSymbol.nullTypeSymbol && leftOp instanceof MethodVariableExpression) {
                            int index = parser.currentClassSymbol.cd.fieldCount + ((MethodVariableExpression)leftOp).variable.varStackIndex;
                            parser.useSet.set(index);
                        }
                    } else if ((leftOpType.typeClass & 2) != 0) {
                        if ((rightOpType.typeClass & 2) == 0) {
                            if (parser.parsingAtLeastOneFive && rightOpType.equalTo(parser.javaLangBooleanSymbol)) {
                                rightOp = rightOp.promoteType(parser, leftOpType);
                            } else {
                                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, false, this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
                                return new ErrorExpression(error);
                            }
                        }
                        this.rightOperand = rightOp;
                    } else {
                        if ((rightOpType.typeClass & 0xFFFFFFC2) != 0) {
                            if (!parser.parsingAtLeastOneFive || !rightOpType.isReferenceType() || BoxingExpression.getPrimitiveType(parser, rightOpType) == null) {
                                Error error = parser.error(Message.errorOperatorNotApplicable, this.pos, false, this.toString(), leftOpType.errorName() + " " + Message.andString + " " + rightOpType.errorName());
                                return new ErrorExpression(error);
                            }
                        } else if (rightOp.kind == 2 && this.rightOperand instanceof FieldExpression && ((FieldExpression)this.rightOperand).thisArgument != null && (leftOpType.typeClass & rightOpType.typeClass & 4) != 0 && !leftOpType.equalTo(rightOpType)) {
                            Error error = parser.error(Message.errorLossOfPrecision, this.pos, false, rightOpType.errorName(), leftOpType.errorName());
                            return new ErrorExpression(error);
                        }
                        this.rightOperand = rightOp.promoteType(parser, leftOpType);
                    }
                }
                this.leftOperand = leftOp;
                this.setType(leftOpType);
                if (!(leftOp instanceof MethodVariableExpression)) break block27;
                MethodVariableExpression methVarExpr = (MethodVariableExpression)leftOp;
                if ((methVarExpr.getAccess() & 0x10) == 0 || !(methVarExpr.variable instanceof LocalVariableSymbol)) break block28;
                LocalVariableSymbol localVar = (LocalVariableSymbol)methVarExpr.variable;
                if ((localVar.flags & 2) == 0) {
                    localVar.flags = (byte)(localVar.flags | 2);
                    if (localVar.initializer != null) {
                        localVar.initializer = rightOp;
                    }
                }
                break block28;
            }
            if (leftOp instanceof FieldExpression) {
                FieldSymbol fieldSymbol = (FieldSymbol)((FieldExpression)leftOp).field;
                if ((fieldSymbol.access & 0x10) != 0 && parser.currentFieldSymbol != null) {
                    fieldSymbol.initializer = rightOp;
                    fieldSymbol.flags = (short)(fieldSymbol.flags | 0xFFFF8004);
                }
            }
        }
        if (leftOp.kind != rightOp.kind) return this;
        if (leftOp instanceof MethodVariableExpression && rightOp instanceof MethodVariableExpression) {
            MethodVariableExpression leftVar = (MethodVariableExpression)leftOp;
            MethodVariableExpression rightVar = (MethodVariableExpression)rightOp;
            if (leftVar.variable != rightVar.variable) return this;
            parser.warning(leftVar.variable, Message.warningSelfAssignment, this.pos, leftVar.variable.errorName());
            return this;
        }
        if (!(leftOp instanceof FieldExpression)) return this;
        if (!(rightOp instanceof FieldExpression)) return this;
        FieldExpression leftField = (FieldExpression)leftOp;
        FieldExpression rightField = (FieldExpression)rightOp;
        if (leftField.field != rightField.field) return this;
        if (!(leftField.thisArgument instanceof ThisExpression)) return this;
        if (!(rightField.thisArgument instanceof ThisExpression)) return this;
        ThisExpression rightThisExpr = (ThisExpression)rightField.thisArgument;
        ThisExpression leftThisExpr = (ThisExpression)leftField.thisArgument;
        if (leftThisExpr.outerClassSymbol != rightThisExpr.outerClassSymbol) return this;
        parser.warning(leftField.field, Message.warningSelfAssignment, this.pos, leftField.field.errorName());
        return this;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        Expression leftOp = this.leftOperand;
        if (leftOp instanceof FieldExpression) {
            FieldExpression fieldExpr = (FieldExpression)leftOp;
            FieldSymbol fieldVar = (FieldSymbol)fieldExpr.field;
            RawClassSymbol fieldClass = fieldVar.definingClass;
            Expression thisArg = fieldExpr.thisArgument;
            if (thisArg != null) {
                fieldClass = ((ClassSymbol)thisArg.getType()).getClassSymbol();
                if (!byteCodeGenerator.methodSymbol.isConstructor() || !fieldClass.isInnerClass() || fieldVar.definingClass.equalTo(fieldClass) || fieldVar.definingClass.isSuperclass(fieldClass)) {
                    thisArg.generateByteCode(byteCodeGenerator);
                }
            } else if (fieldExpr.qualification != null) {
                fieldClass = fieldExpr.qualification.getClassSymbol();
            }
            if (fieldClass.isInnerClass() && !fieldVar.definingClass.equalTo(fieldClass) && !fieldVar.definingClass.isSuperclass(fieldClass)) {
                byteCodeGenerator.generateOuterClassFieldAccessor(fieldVar.definingClass, fieldClass, false);
            }
        } else if (leftOp.kind == 3) {
            ArrayExpression arrayExpr = (ArrayExpression)leftOp;
            arrayExpr.arrayExpr.generateByteCode(byteCodeGenerator);
            arrayExpr.indexExpr.generateByteCode(byteCodeGenerator);
        }
        this.rightOperand.generateByteCode(byteCodeGenerator);
        this.generateByteCodeForAssignmentExpression(byteCodeGenerator, leftOp);
    }

    public String toString() {
        return "=";
    }
}

