/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import oracle.ojc.compiler.BooleanConstantExpression;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.Statement;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.TypeSymbol;

final class AssertStatement
extends Statement {
    Expression assertion;
    Expression detail;

    AssertStatement(StatementList parent, int pos, Parser parser, Expression assertion, Expression detail) {
        super(parent, pos, (byte)18);
        this.assertion = assertion;
        this.detail = detail;
        RawClassSymbol classSymbol = parser.currentClassSymbol;
        if ((classSymbol.flags & 1) == 0) {
            classSymbol.flags = (short)(classSymbol.flags | 1);
            if (parser.targetingAtLeastOneFive) {
                Identifier.assertionsDisabledInternal = Identifier.getIdentifier(Identifier.dollarString + "assertionsDisabled");
            }
            parser.addSyntheticField(classSymbol, Identifier.assertionsDisabledInternal, TypeSymbol.booleanSymbol, (short)24);
            if (!parser.targetingAtLeastOneFive) {
                parser.addSyntheticField(classSymbol, Identifier.classObjectInternal, parser.javaLangClassSymbol, (short)8);
                classSymbol.flags = (short)(classSymbol.flags | 8);
            }
            classSymbol.getClassInitializer();
        }
    }

    void resolveAndCheck(Parser parser) {
        Expression expr = this.assertion;
        expr = expr.resolveAndCheck(parser);
        this.assertion = expr = this.checkForBooleanExpression(parser, expr, this.assertion.pos);
        expr = this.detail;
        if (expr != null) {
            TypeSymbol exprType = (expr = expr.resolveAndCheck(parser)).getType();
            if (exprType == TypeSymbol.voidSymbol) {
                parser.error(Message.errorTypeNotAllowed, expr.pos, false, exprType.errorName());
            }
            this.detail = expr;
        }
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        int depth;
        BooleanConstantExpression bcExpr = null;
        Expression expr = this.assertion;
        if (expr.kind == 2) {
            bcExpr = (BooleanConstantExpression)expr;
            if (bcExpr.bval) {
                return;
            }
        }
        Label label = new Label();
        RawClassSymbol classSymbol = byteCodeGenerator.methodSymbol.definingClass;
        short index = byteCodeGenerator.constantPool.enterConstantPoolFieldRef(classSymbol.getInternalName(), Identifier.assertionsDisabledInternal.name, Identifier.booleanSignature.name);
        byteCodeGenerator.generate_8_16((byte)-78, index);
        byteCodeGenerator.generateBranch_ifne(label);
        if (bcExpr == null) {
            expr.generateByteCodeBranch(byteCodeGenerator, label, false);
        }
        index = byteCodeGenerator.constantPool.enterConstantPoolClass(Identifier.javaLangAssertionErrorInternal.name);
        byteCodeGenerator.generate_8_16_8((byte)-69, index, (byte)89);
        byteCodeGenerator.incOpStackHeight(2);
        if (this.detail != null) {
            char[] signature;
            this.detail.generateByteCode(byteCodeGenerator);
            switch (this.detail.getType().typeKind) {
                default: {
                    signature = Identifier.voidMethodObjectSignature.name;
                    depth = 3;
                    break;
                }
                case 2: {
                    signature = Identifier.voidMethodBooleanSignature.name;
                    depth = 3;
                    break;
                }
                case 4: {
                    signature = Identifier.voidMethodCharSignature.name;
                    depth = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    signature = Identifier.voidMethodIntSignature.name;
                    depth = 3;
                    break;
                }
                case 7: {
                    signature = Identifier.voidMethodLongSignature.name;
                    depth = 4;
                    break;
                }
                case 8: {
                    signature = Identifier.voidMethodFloatSignature.name;
                    depth = 3;
                    break;
                }
                case 9: {
                    signature = Identifier.voidMethodDoubleSignature.name;
                    depth = 4;
                }
            }
            index = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(Identifier.javaLangAssertionErrorInternal.name, Identifier.initializerIdentifier.name, signature);
        } else {
            index = byteCodeGenerator.constantPool.enterConstantPoolMethodRef(Identifier.javaLangAssertionErrorInternal.name, Identifier.initializerIdentifier.name, Identifier.voidMethodSignature.name);
            depth = 2;
        }
        byteCodeGenerator.generate_8_16_8((byte)-73, index, (byte)-65);
        byteCodeGenerator.setLabel(label);
        byteCodeGenerator.decOpStackHeight(depth);
    }
}

