/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import java.util.ArrayList;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.ElementValue;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;

final class ArrayElementValue
extends ElementValue {
    ArrayList arrayElements;

    ArrayElementValue(Identifier elementName, ArrayList arrayElements, int pos, boolean defaultValue, boolean arrayElement) {
        super(elementName, pos, defaultValue, arrayElement);
        this.arrayElements = arrayElements;
    }

    ElementValue resolveAndCheck(Parser parser, Annotation annotation) {
        super.resolveAndCheck(parser, annotation);
        RawClassSymbol annotationType = ((ClassSymbol)annotation.annotationType).getClassSymbol();
        if (!this.typeSymbol.isArrayType()) {
            parser.error(Message.errorArrayRequired, this.pos, this.typeSymbol.isErroneous(), this.typeSymbol.errorName());
            annotationType.flags = (short)(annotationType.flags | 0x10);
        } else {
            int count = this.arrayElements.size();
            while (--count >= 0) {
                ElementValue ev = (ElementValue)this.arrayElements.get(count);
                ev.resolveAndCheck(parser, annotation);
            }
        }
        return this;
    }

    int getAttributeLength() {
        int size = super.getAttributeLength() + 2;
        int count = this.arrayElements.size();
        while (--count >= 0) {
            ElementValue ev = (ElementValue)this.arrayElements.get(count);
            size += ev.getAttributeLength();
        }
        return size;
    }

    void generateConstantPoolEntries(ClassFileWriter cfw, ConstantPool cp) {
        super.generateConstantPoolEntries(cfw, cp);
        int count = this.arrayElements.size();
        while (--count >= 0) {
            ElementValue ev = (ElementValue)this.arrayElements.get(count);
            ev.generateConstantPoolEntries(cfw, cp);
        }
        this.tag = (byte)91;
    }

    void write(ClassFileWriter cfw) throws IOException {
        super.write(cfw);
        int count = this.arrayElements.size();
        int wbIdx = cfw.ensureWriteBufferCapacity(2);
        byte[] wb = cfw.writeBuffer;
        wb[wbIdx + 1] = (byte)count;
        wb[wbIdx] = (byte)(count >> 8);
        cfw.writeBufferIndex = wbIdx + 2;
        for (int i = 0; i < count; ++i) {
            ElementValue ev = (ElementValue)this.arrayElements.get(i);
            ev.write(cfw);
        }
    }
}

