/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.ArgumentVariableList;
import oracle.ojc.compiler.ArgumentVariableSymbol;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassResolutionList;
import oracle.ojc.compiler.ClassScope;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.CompiledImplementationList;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.ExpressionList;
import oracle.ojc.compiler.ExpressionStatement;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.ImplementationList;
import oracle.ojc.compiler.InnerClassSymbol;
import oracle.ojc.compiler.InvokeExpression;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.MethodSymbol;
import oracle.ojc.compiler.MethodVariableExpression;
import oracle.ojc.compiler.ParameterizedClassSymbol;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SuperExpression;
import oracle.ojc.compiler.TypeSymbol;
import oracle.ojc.compiler.TypeSymbolList;
import oracle.ojc.compiler.UnresolvedSymbol;

class AnonymousClassSymbol
extends InnerClassSymbol {
    MethodSymbol constructorSymbol;
    InvokeExpression superInvokeExpr;
    InvokeExpression invokeExpr;
    ClassResolutionList resolutionList;
    static final /* synthetic */ boolean $assertionsDisabled;

    AnonymousClassSymbol(int pos, short access) {
        super(pos, Identifier.getIdentifier(""), access, null, null, true);
    }

    protected void toString(StringBuffer sb) {
        this.getOuterClass().toString(sb);
        sb.append('.');
        ClassSymbol overriddenClass = this.getOverriddenClass();
        sb.append(overriddenClass.identifier);
    }

    String errorName() {
        return Message.anonymousClassString;
    }

    String kindName() {
        return Message.anonymousClassString;
    }

    TypeSymbol resolveType(Parser parser, int pos, boolean mustBePublic, boolean checkActualTypeParameters, boolean lazy) {
        return this;
    }

    boolean isLocalInnerClass() {
        return true;
    }

    boolean isAnonymousInnerClass() {
        return true;
    }

    boolean isNonAnonymousInnerClass() {
        return false;
    }

    void fixConstructors(Parser parser) {
        if (this.isSynthetic() || this.isEnum()) {
            return;
        }
        Object state = parser.saveResolutionState(this);
        parser.suspendDataFlowChecking = true;
        this.constructorSymbol.resolveMethod(parser);
        if (!(this.superInvokeExpr.method instanceof MethodSymbol)) {
            if (!$assertionsDisabled && !parser.errorFound) {
                throw new AssertionError();
            }
        } else {
            MethodSymbol superConstructorSymbol = (MethodSymbol)this.superInvokeExpr.method;
            boolean varArgCount = false;
            boolean hasVarargs = (superConstructorSymbol.access & 0x80) != 0;
            ArgumentVariableList lastList = superConstructorSymbol.argumentList;
            ArgumentVariableList asl = this.constructorSymbol.argumentList;
            ArgumentVariableList ssl = superConstructorSymbol.argumentList;
            while (asl != null) {
                TypeSymbol scArgType;
                if (hasVarargs && ssl.next == null) {
                    ArraySymbol arraySymbol = (ArraySymbol)ssl.argSymbol.type;
                    scArgType = ArraySymbol.getArrayType(arraySymbol.baseType, arraySymbol.dimension - 1);
                } else {
                    scArgType = ssl.argSymbol.type;
                }
                if ((scArgType.typeClass & 0xFFFFFFC0) != 0) {
                    asl.argSymbol.type = scArgType;
                }
                asl = asl.next;
                ssl = ssl.next == null ? ssl : ssl.next;
            }
            int size = this.cd.fieldCount + this.constructorSymbol.localVarCount;
            parser.defSet = new BitSet(size);
            parser.posSet = new BitSet(size);
            parser.useSet = new BitSet(size);
            parser.currentClassSymbol = this;
            parser.currentMethodSymbol = this.constructorSymbol;
            super.fixConstructors(parser);
        }
        parser.restoreResolutionState(state);
    }

    void completeAnonymousClass(Parser parser) {
        if (!this.isEnum()) {
            TypeSymbol typeSymbol = this.superClass.resolveType(parser, this.pos, false, true, false);
            this.superClass = typeSymbol.isErroneous() ? parser.javaLangObjectPcs : (typeSymbol.isRawClass() ? ParameterizedClassSymbol.getParameterizedClassSymbol((RawClassSymbol)typeSymbol, null, null) : (ClassSymbol)typeSymbol);
            if (this.superClass.isInterface()) {
                this.flags = (short)(this.flags | 0x400);
                if (parser.javaIoSerializableSymbol != null && this.superClass.equalTo(parser.javaIoSerializableSymbol)) {
                    this.flags = (short)(this.flags | 0x800);
                }
                this.setImplementationList(new CompiledImplementationList(this.superClass));
                this.superClass = parser.javaLangObjectPcs;
            } else {
                this.flags = (short)(this.flags | this.superClass.getClassSymbol().flags & 0xC00);
            }
            if ((this.flags & 0x40) == 0) {
                if ((this.superClass.access & 0x10) != 0) {
                    parser.error(Message.errorFinalCannotBeInherited, this.pos, this.superClass.isErroneous(), this.superClass.errorName());
                }
                if (this.superClass.isNonStaticInnerClass()) {
                    this.addHiddenSuperOuterThisArgument((InnerClassSymbol)this.superClass.getClassSymbol());
                }
                MethodSymbol anonConstructorSymbol = this.constructorSymbol;
                ExpressionList superConstructorArgLast = null;
                ExpressionList superConstructorArgList = null;
                InvokeExpression invokeExpr = this.invokeExpr;
                invokeExpr.resolvedArguments = true;
                ExpressionList actualArgs = invokeExpr.arguments;
                while (actualArgs != null) {
                    Expression expr = actualArgs.expr;
                    expr = expr.resolveAndCheck(parser);
                    ArgumentVariableSymbol arg = anonConstructorSymbol.addArgument(expr.getType());
                    ExpressionList scActualArg = new ExpressionList(new MethodVariableExpression(0, arg));
                    if (superConstructorArgList == null) {
                        superConstructorArgList = superConstructorArgLast = scActualArg;
                    } else {
                        superConstructorArgLast.next = scActualArg;
                        superConstructorArgLast = scActualArg;
                    }
                    actualArgs.expr = expr;
                    actualArgs = actualArgs.next;
                }
                StatementList stmtList = anonConstructorSymbol.cmd.statementList;
                if (stmtList == null) {
                    anonConstructorSymbol.cmd.statementList = stmtList = new StatementList();
                }
                UnresolvedSymbol unresolvedSymbol = new UnresolvedSymbol(0, this.classScope, Identifier.initializerIdentifier);
                this.superInvokeExpr = new InvokeExpression(0, unresolvedSymbol, null, new SuperExpression(0, this, null), superConstructorArgList);
                this.superInvokeExpr.flags = (byte)(this.superInvokeExpr.flags | 2);
                this.superInvokeExpr.typeArguments = invokeExpr.typeArguments;
                invokeExpr.typeArguments = null;
                ExpressionStatement stmt = new ExpressionStatement(stmtList, 0, this.superInvokeExpr);
                if (stmtList.first != null) {
                    stmtList.first.insertBefore(stmt);
                } else {
                    stmtList.add(stmt);
                }
                parser.addReturnStatement(anonConstructorSymbol, stmtList);
                anonConstructorSymbol.flags = (short)(anonConstructorSymbol.flags | 1);
                if (this.superClass.isInnerClass()) {
                    InnerClassSymbol.HiddenArgumentList hal = ((InnerClassSymbol)this.superClass.getClassSymbol()).hiddenArgumentList;
                    while (hal != null) {
                        if (hal.kind == 2) {
                            this.addHiddenFinalLocalArgument(hal.localVar, null);
                        }
                        hal = hal.next;
                    }
                }
            }
        }
        this.flags = (short)(this.flags | 0x40);
        if (this.resolutionList == null) {
            this.resolutionList = new ClassResolutionList(true, parser.thisInitialized);
            this.resolutionList.classSymbolList.add(this);
            parser.classResolutionList.classSymbolList.add(this);
            TypeSymbolList tsl = this.cd.innerClassList;
            while (tsl != null) {
                if (!tsl.typeSymbol.isAnonymousInnerClass()) {
                    this.resolutionList.classSymbolList.add(tsl.typeSymbol);
                    parser.classResolutionList.classSymbolList.add(tsl.typeSymbol);
                }
                tsl = tsl.next;
            }
        }
        if (parser.parsingAtLeastOneFive) {
            parser.resolveClassAnnotationsAndBounds(this.resolutionList);
        }
        parser.resolveInnerClasses(this.resolutionList);
        parser.finishClassResolutions(this.resolutionList);
        parser.resolveFields(this.resolutionList);
        parser.resolveMethods(this.resolutionList);
        parser.buildMethodTables(this.resolutionList);
        parser.resolveFieldInitializers(this.resolutionList);
    }

    static AnonymousClassSymbol createDummyClass(Parser parser, RawClassSymbol outerClass) {
        AnonymousClassSymbol anonClass = new AnonymousClassSymbol(0, 17);
        anonClass.superClass = parser.javaLangObjectPcs;
        anonClass.flags = (short)(anonClass.flags | 0x20);
        anonClass.cd.ccd.sourceFile = outerClass.cd.ccd.sourceFile;
        anonClass.scope = outerClass.classScope;
        anonClass.classScope = new ClassScope(anonClass, outerClass.classScope, parser);
        anonClass.cd.ccd.constantPool = new ConstantPool(parser);
        if (parser.targetingAtLeastOneFive) {
            anonClass.access = (short)(anonClass.access | 0x1000);
        } else {
            anonClass.flags = (short)(anonClass.flags | 0x100);
        }
        parser.classResolutionList.classSymbolList.add(anonClass);
        outerClass.addInnerClass(anonClass);
        return anonClass;
    }

    ClassSymbol getOverriddenClass() {
        ImplementationList implList = this.getImplementationList();
        if (implList != null) {
            return implList.interfaceSymbol;
        }
        return this.superClass;
    }

    static {
        $assertionsDisabled = !AnonymousClassSymbol.class.desiredAssertionStatus();
    }
}

