/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import java.util.ArrayList;
import oracle.ojc.compiler.Annotation;
import oracle.ojc.compiler.ArrayElementValue;
import oracle.ojc.compiler.ArraySymbol;
import oracle.ojc.compiler.ClassFileWriter;
import oracle.ojc.compiler.ClassSymbol;
import oracle.ojc.compiler.ConstantPool;
import oracle.ojc.compiler.ElementValue;
import oracle.ojc.compiler.Identifier;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.RawClassSymbol;

final class AnnotationElementValue
extends ElementValue {
    private Annotation annotation;

    AnnotationElementValue(Identifier elementName, Annotation annotation, int pos, boolean defaultValue, boolean arrayElement) {
        super(elementName, pos, defaultValue, arrayElement);
        this.annotation = annotation;
    }

    ElementValue resolveAndCheck(Parser parser, Annotation annot) {
        super.resolveAndCheck(parser, annot);
        this.annotation.resolveAndCheck(parser, null);
        RawClassSymbol annotationType = ((ClassSymbol)this.annotation.annotationType).getClassSymbol();
        ElementValue ev = this;
        if (this.typeSymbol.isArrayType()) {
            ArrayList<AnnotationElementValue> list = new ArrayList<AnnotationElementValue>(1);
            list.add(this);
            ev = new ArrayElementValue(this.elementName, list, this.pos, (this.flags & 1) != 0, false);
            ev.typeSymbol = this.typeSymbol;
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
            this.flags = (byte)(this.flags | 2);
            this.typeSymbol = ((ArraySymbol)this.typeSymbol).baseType;
        }
        if (!this.annotation.annotationType.equalTo(this.typeSymbol)) {
            parser.error(Message.errorIncompatibleTypes, this.pos, this.annotation.annotationType.isErroneous() | this.typeSymbol.isErroneous(), this.annotation.annotationType.errorName(), this.typeSymbol.errorName());
            annotationType.flags = (short)(annotationType.flags | 0x10);
        }
        return ev;
    }

    int getAttributeLength() {
        return super.getAttributeLength() + this.annotation.getAttributeLength();
    }

    void generateConstantPoolEntries(ClassFileWriter cfw, ConstantPool cp) {
        super.generateConstantPoolEntries(cfw, cp);
        this.annotation.generateConstantPoolEntries(cfw, cp);
        this.tag = (byte)64;
    }

    void write(ClassFileWriter cfw) throws IOException {
        super.write(cfw);
        this.annotation.writeAnnotation(cfw);
    }
}

