/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlmonitor.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.RaptorGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.sqlmonitor.SqlMonitorArb;
import oracle.dbtools.sqlmonitor.editor.SqlMonitorEditor;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.db.DBException;
import oracle.sql.CHAR;
import oracle.sql.NUMBER;

public class ListPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static String LIST_SQL;
    ResultSetTable table = new ResultSetTable();
    Connection _conn;
    SqlMonitorEditor _editor = null;
    private ListMenuListener _menu;
    public static final String LIST_DETAIL_CMD = "SqlMonitor.DETAILS";
    public static final int LIST_DETAIL;
    public static final IdeAction DETAILS;

    private void getQueries(Connection connection) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)"/oracle/dbtools/sqlmonitor/queries/ListQueries.xml");
        Query query = queryXMLSupport.getQuery("list_sql", connection);
        LIST_SQL = query.getSql();
    }

    public ListPanel(String string, String string2, String string3, String string4, SqlMonitorEditor sqlMonitorEditor) {
        this._editor = sqlMonitorEditor;
        try {
            this._conn = Connections.getInstance().getConnection(string);
        }
        catch (DBException dBException) {
            this._conn = null;
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
            return;
        }
        this.getQueries(this._conn);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object var7_8 = null;
        hashMap.put("SQL_ID", string2);
        hashMap.put("SID", string3);
        hashMap.put("SERIAL", string4);
        try {
            this.table.setQuery(string, LIST_SQL, null, hashMap);
            this.table.setName("LISTTABLE");
            this.table.setAutoResizeMode(4);
            this.table.open(new RaptorGridTaskWrapper(SqlMonitorArb.getString("REFRESH"), IRaptorTaskRunMode.MODAL, false, null, null, null));
            this.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView((Component)this.table);
            this.add((Component)jScrollPane, "Center");
            this._menu = new ListMenuListener();
            RaptorGridTable.addGridContextMenu((GridContextMenuItem)this._menu);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void close() {
        if (this._menu != null) {
            this._menu.close();
        }
    }

    public String getSQL() {
        return LIST_SQL;
    }

    public void refresh() {
        try {
            this.table.refresh();
            if (this.table.getRowCount() < 2) {
                // empty if block
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    static {
        LIST_DETAIL = Ide.findOrCreateCmdID((String)LIST_DETAIL_CMD);
        DETAILS = IdeAction.get((int)LIST_DETAIL, (String)StringUtils.stripMnemonic((String)SqlMonitorArb.getString("DETAIL_MENU")), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)SqlMonitorArb.getString("DETAIL_MENU"))));
    }

    class ListMenuListener
    extends GridContextMenuItem {
        private boolean _closed = false;
        private int _currRow = -1;

        public ListMenuListener() {
            DETAILS.addController((Controller)this);
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            this.getTableFromContext(context);
            if (this._currRow >= 0) {
                try {
                    final String string = ((CHAR)this._table.getModel().getValueAt(this._currRow, 2)).stringValue();
                    final int n = ((NUMBER)this._table.getModel().getValueAt(this._currRow, 3)).intValue();
                    final int n2 = ((NUMBER)this._table.getModel().getValueAt(this._currRow, 4)).intValue();
                    RaptorTask raptorTask = new RaptorTask(SqlMonitorArb.getString("OPENING")){

                        protected Object doWork() throws TaskException {
                            ListPanel.this._editor.updateDetail(ListPanel.this._conn, string, n, n2, ListPanel.this._editor);
                            return null;
                        }
                    };
                    raptorTask.setCancellable(false);
                    RaptorTaskManager.getInstance().addTask(raptorTask);
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }

        protected boolean canShow(ContextMenu contextMenu) {
            this.getTableFromContext(contextMenu.getContext());
            if (this._table != null && this._table.getName() != null) {
                return this._table.getName().equals("LISTTABLE");
            }
            return false;
        }

        protected void createAndShowMenu(ContextMenu contextMenu) {
            if (!this._closed) {
                JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)DETAILS);
                contextMenu.add((Component)jMenuItem);
                this._currRow = this._table.rowAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
            }
        }

        public void close() {
            DETAILS.removeController((Controller)this);
            this._closed = true;
        }
    }
}

