/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlmonitor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URLStreamHandlerFactory;
import java.sql.Connection;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.LicenseUtils;
import oracle.dbtools.sqlmonitor.SqlMonitorArb;
import oracle.dbtools.sqlmonitor.SqlMonitorConnectionListener;
import oracle.dbtools.sqlmonitor.editor.SqlMonitorEditor;
import oracle.dbtools.sqlmonitor.editor.SqlMonitorEditorAddin;
import oracle.dbtools.sqlmonitor.net.SqlMonitorUrlFileSystemHelper;
import oracle.dbtools.sqlmonitor.net.SqlMonitorUrlStreamHandler;
import oracle.dbtools.sqlmonitor.nodes.SqlMonitorEditorNode;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Version;

public class SqlMonitorAddin
implements Addin {
    public static final int OPEN_MONITOR = Ide.findOrCreateCmdID((String)"openMonitor");
    private ActionListener _openReport = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SqlMonitorAddin.this.openMonitor(null);
        }
    };

    public void initialize() {
        URLFileSystem.addURLStreamHandlerFactory((URLStreamHandlerFactory)new SqlMonitorUrlStreamHandler());
        URLFileSystem.registerHelper((String)SqlMonitorUrlFileSystemHelper.PROTOCOL, (URLFileSystemHelper)new SqlMonitorUrlFileSystemHelper());
        EditorManager.getEditorManager().registerDynamic((EditorAddin)new SqlMonitorEditorAddin());
        this.addMenuItem(SqlMonitorArb.getString("MAIN_MENU"));
        Connections.getInstance().addConnectionListener((ConnectionListener)new SqlMonitorConnectionListener());
    }

    public void addMenuItem(String string) {
        String string2 = StringUtils.stripMnemonic((String)string);
        IdeAction ideAction = IdeAction.get((int)OPEN_MONITOR, null, (String)string2, (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)string)), (ResourceBundle)RaptorImage.getInstance(), null, null, (boolean)true);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 9.9f);
        jMenuItem.addActionListener(this._openReport);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    public static void showOracleOnlyMessage(Component component) {
        MessageDialog.information((Component)component, (Object)SqlMonitorArb.getString("ORACLE_ONLY_DIALOG_MSG"), (String)SqlMonitorArb.getString("ORACLE_ONLY_DIALOG_TITLE"), (String)"f1_sqlmonitororacleonly_html");
    }

    public void openMonitor(String string) {
        SqlMonitorEditorNode sqlMonitorEditorNode;
        Context context;
        Object object;
        SqlMonitorEditor sqlMonitorEditor = null;
        if (EditorManager.getEditorManager().getAllEditors().size() > 0) {
            object = EditorManager.getEditorManager().getAllEditors();
            context = object.iterator();
            while (context.hasNext()) {
                sqlMonitorEditorNode = (Editor)context.next();
                if (!(sqlMonitorEditorNode instanceof SqlMonitorEditor)) continue;
                sqlMonitorEditor = (SqlMonitorEditor)((Object)sqlMonitorEditorNode);
            }
        }
        object = null;
        context = null;
        if (sqlMonitorEditor != null) {
            sqlMonitorEditorNode = (SqlMonitorEditorNode)sqlMonitorEditor.getContext().getNode();
            if (string != null && !Connections.getInstance().isOracle(string)) {
                SqlMonitorAddin.showOracleOnlyMessage(sqlMonitorEditor.getGUI());
                return;
            }
            context = Context.newIdeContext((Node)sqlMonitorEditorNode);
        } else {
            object = string != null ? string : ConnectionSelectorUI.getConnection((String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_TITLE"), (String)ConnectionArb.getString((String)"SQL_VIEWER_CONNECTION_CHOICE_LABEL"), null, (boolean)true, (boolean)false);
            if (object == null) {
                return;
            }
            if (object != null) {
                sqlMonitorEditorNode = new SqlMonitorEditorNode();
                sqlMonitorEditorNode.setConn((String)object);
                context = Context.newIdeContext((Node)sqlMonitorEditorNode);
            }
        }
        if (!LicenseUtils.requiresTuning((String)object)) {
            return;
        }
        if (context != null) {
            sqlMonitorEditorNode = (SqlMonitorEditorNode)context.getNode();
            final Context context2 = context;
            RaptorTask<Object> raptorTask = new RaptorTask<Object>(SqlMonitorArb.getString("OPENING")){
                private SqlMonitorEditor _ed;

                protected void setEditor(SqlMonitorEditor sqlMonitorEditor) {
                    this._ed = sqlMonitorEditor;
                }

                protected Object doWork() throws TaskException {
                    String string = sqlMonitorEditorNode.getConn();
                    Connection connection = null;
                    try {
                        connection = Connections.getInstance().getConnection(string);
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                    if (!DBUtil.checkVersion((Connection)connection, null, (Version)new Version("11.0"))) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)SqlMonitorArb.getString("BAD_VERSION_DIALOG_MSG"), (String)SqlMonitorArb.getString("BAD_VERSION_DIALOG_TITLE"), (String)"f1_sqlmonitorbadversion_html");
                        return null;
                    }
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context2);
                                openEditorOptions.setFlags(1);
                                SqlMonitorEditor sqlMonitorEditor = (SqlMonitorEditor)EditorManager.getEditorManager().openEditor(openEditorOptions);
                                this.setEditor(sqlMonitorEditor);
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        // empty catch block
                    }
                    this._ed.updateList();
                    return null;
                }
            };
            raptorTask.setCancellable(false);
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
    }
}

