/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.Context;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.editor.EditorManager;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteModelListener;
import oracle.ide.palette.PalettePage;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.ideimpl.palette.PaletteArb;
import oracle.ideimpl.palette.PaletteCommands;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.wizard.ChangeImageDialog;
import oracle.ideimpl.palette.wizard.EditItemWizard;
import oracle.ideimpl.palette.wizard.ListIconRenderer;
import oracle.ideimpl.palette.wizard.NewPageWizard;
import oracle.ideimpl.palette.wizard.RenamePalettePageWizard;
import oracle.ideimpl.palette2.PaletteWindowImpl;

public class PagePanel
extends JPanel
implements ListSelectionListener,
PaletteModelListener,
ActionListener {
    private DefaultListModel _pageModel = new DefaultListModel();
    private DefaultListModel _componentModel = new DefaultListModel();
    private PaletteImpl _palette = PaletteImpl.getInstance();
    private PaletteController _controller = PaletteController.getInstance();
    private PaletteCommands _commands = new PaletteCommands();
    private RenamePalettePageWizard _renameWizard = null;
    private EditItemWizard _editItemWizard = null;
    private GridBagLayout _mainLayout = new GridBagLayout();
    private JSplitPane _splitPane = new JSplitPane();
    private JPanel _pagePanel = new JPanel();
    private JPanel _componentPanel = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JScrollPane _pageScrollPane = new JScrollPane();
    private JScrollPane _componentScrollPane = new JScrollPane();
    private JList _pageList = new JList(this._pageModel);
    private JList _componentList = new JList(this._componentModel);
    private JButton _addPageBtn = new JButton();
    private JButton _removePageBtn = new JButton();
    private ListIconRenderer renderer = new ListIconRenderer();
    private JPanel _pageBtnPanel = new JPanel();
    private JPanel _componentBtnPanel = new JPanel();
    private GridLayout _pageBtnLayout = new GridLayout();
    private GridLayout _componentBtnLayout = new GridLayout();
    private JButton _addComponentBtn = new JButton();
    private JButton _removeItemBtn = new JButton();
    private JLabel _pageTypeLbl = new JLabel();
    private JComboBox _pageTypeBox;
    private GridBagLayout _pagePanelLayout = new GridBagLayout();
    private GridBagLayout _componentPanelLayout = new GridBagLayout();
    private Context _context;
    private JButton _renamePageBtn = new JButton();
    private JButton _editComponentBtn = new JButton();
    static String TYPE_JAVA = "java";
    static String TYPE_CSS = "css";
    static String TYPE_JSP = "jsp";
    static String TYPE_HTML = "html";
    static String TYPE_SNIPPET = "snippet";
    static String OK = "ok";
    static String[] editableComponentTypes = new String[]{TYPE_JAVA, TYPE_CSS, TYPE_JSP, TYPE_HTML, TYPE_SNIPPET};

    public PagePanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this._pageTypeBox = new JComboBox(this._controller.getList());
        this._pageTypeBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        ResourceUtils.resLabel((JLabel)this.jLabel1, (Component)this._pageList, (String)PaletteArb.getString(45));
        ResourceUtils.resLabel((JLabel)this.jLabel2, (Component)this._componentList, (String)PaletteArb.getString(46));
        ResourceUtils.resButton((AbstractButton)this._addPageBtn, (String)PaletteArb.getString(47));
        ResourceUtils.resButton((AbstractButton)this._removePageBtn, (String)PaletteArb.getString(48));
        ResourceUtils.resButton((AbstractButton)this._addComponentBtn, (String)PaletteArb.getString(49));
        ResourceUtils.resButton((AbstractButton)this._removeItemBtn, (String)PaletteArb.getString(50));
        ResourceUtils.resLabel((JLabel)this._pageTypeLbl, (Component)this._pageTypeBox, (String)PaletteArb.getString(51));
        ResourceUtils.resButton((AbstractButton)this._renamePageBtn, (String)PaletteArb.getString(63));
        ResourceUtils.resButton((AbstractButton)this._editComponentBtn, (String)PaletteArb.getString(79));
        AccessibleUtils.updateAccessibleName((Accessible)this._addPageBtn, (String)"Add Palette Page", (boolean)true);
        AccessibleUtils.updateAccessibleName((Accessible)this._removePageBtn, (String)"Remove Palette Page", (boolean)true);
        AccessibleUtils.updateAccessibleName((Accessible)this._renamePageBtn, (String)"Rename Palette Page", (boolean)true);
        AccessibleUtils.updateAccessibleName((Accessible)this._removeItemBtn, (String)"Remove Component", (boolean)true);
        AccessibleUtils.updateAccessibleName((Accessible)this._addComponentBtn, (String)"Add Component", (boolean)true);
        AccessibleUtils.updateAccessibleName((Accessible)this._editComponentBtn, (String)"Edit Component", (boolean)true);
        this._pageList.setSelectionMode(0);
        this._addPageBtn.addActionListener(this);
        this._removePageBtn.addActionListener(this);
        this._removeItemBtn.addActionListener(this);
        this._addComponentBtn.addActionListener(this);
        this._addComponentBtn.setEnabled(false);
        this.setLayout(this._mainLayout);
        this._splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._pagePanel.setLayout(this._pagePanelLayout);
        this._componentPanel.setLayout(this._componentPanelLayout);
        this._pageBtnPanel.setLayout(this._componentBtnLayout);
        this._componentBtnPanel.setLayout(this._pageBtnLayout);
        this._pageBtnLayout.setHgap(5);
        this._componentBtnLayout.setHgap(5);
        this.add((Component)this._pageTypeLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._pageTypeBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this._pageScrollPane.getViewport().add((Component)this._pageList, null);
        this._pagePanel.add((Component)this._pageScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 2), 0, 0));
        this._pagePanel.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 2), 0, 0));
        this._pageBtnPanel.add((Component)this._addPageBtn, null);
        this._pageBtnPanel.add((Component)this._removePageBtn, null);
        this._pageBtnPanel.add((Component)this._renamePageBtn, null);
        this._pagePanel.add((Component)this._pageBtnPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 2), 0, 0));
        this._splitPane.add((Component)this._pagePanel, "left");
        this._componentScrollPane.getViewport().add((Component)this._componentList, null);
        this._componentPanel.add((Component)this._componentScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 2, 0, 0), 0, 0));
        this._componentPanel.add((Component)this.jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
        this._componentBtnPanel.add((Component)this._addComponentBtn, null);
        this._componentBtnPanel.add((Component)this._removeItemBtn, null);
        this._componentBtnPanel.add((Component)this._editComponentBtn, null);
        this._componentPanel.add((Component)this._componentBtnPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 2, 0, 0), 0, 0));
        this._splitPane.add((Component)this._componentPanel, "right");
        this.add((Component)this._splitPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this._renamePageBtn.addActionListener(this);
        this._renamePageBtn.setEnabled(false);
        this._removePageBtn.setEnabled(false);
        this._componentList.setCellRenderer(this.renderer);
        this._pageTypeBox.addActionListener(this);
        this._pageList.setSelectedIndex(0);
        this._editComponentBtn.addActionListener(this);
    }

    protected void populatePageList() {
        if (!this._palette.getHasPopulated()) {
            this._palette.populate();
        }
        this.showPages("All");
    }

    public void populateComponents(String page) {
        if (page != null) {
            Iterator iter;
            boolean canRemove;
            this._componentList.removeListSelectionListener(this);
            this._componentModel.removeAllElements();
            PalettePage palettePage = this._palette.getPalettePage(page);
            boolean bl = canRemove = palettePage != null && palettePage.getCanRemove();
            if (!canRemove) {
                this._removePageBtn.setEnabled(false);
                this._renamePageBtn.setEnabled(false);
            } else {
                this._removePageBtn.setEnabled(true);
                this._renamePageBtn.setEnabled(true);
            }
            PalettePage pg = this._palette.getPalettePage(page);
            Iterator iterator = iter = pg != null ? pg.getPaletteItems().iterator() : null;
            if (iter != null) {
                while (iter.hasNext()) {
                    PaletteItem item = (PaletteItem)iter.next();
                    ImageIcon icon = (ImageIcon)item.getIcon();
                    if (icon == null) continue;
                    String name = item.getShortLabel();
                    icon.setDescription(name);
                    this._componentModel.addElement(icon);
                }
            }
            this._componentList.addListSelectionListener(this);
            this._editComponentBtn.setEnabled(false);
            this._removeItemBtn.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Object o = e.getSource();
        if (o == this._pageList) {
            if (this._pageModel.getSize() > 0) {
                String pageSelected = this.getSelectedPage();
                if (pageSelected != null) {
                    PalettePage activePage = this._palette.getPalettePage(pageSelected);
                    boolean hasEditor = this.hasEditor(activePage);
                    if (hasEditor) {
                        this._addComponentBtn.setEnabled(true);
                    } else {
                        this._addComponentBtn.setEnabled(false);
                    }
                    this._palette.setEditPage(activePage);
                    this.populateComponents(pageSelected);
                    this._removeItemBtn.setEnabled(false);
                    this._editComponentBtn.setEnabled(false);
                    if (activePage != null && activePage.getCanRemove()) {
                        this._removePageBtn.setEnabled(true);
                        this._renamePageBtn.setEnabled(true);
                    }
                } else {
                    this._removePageBtn.setEnabled(false);
                    this._renamePageBtn.setEnabled(false);
                    this._addComponentBtn.setEnabled(false);
                }
            }
        } else {
            PalettePage activePage;
            ImageIcon icon = (ImageIcon)this._componentList.getSelectedValue();
            boolean canRemove = false;
            if (icon != null) {
                PaletteItemImpl item = (PaletteItemImpl)this._palette.getPaletteItem(icon.getDescription(), this.getSelectedPage());
                canRemove = item.getCanRemove();
            }
            if ((activePage = this._palette.getPalettePage(this.getSelectedPage())) != null) {
                canRemove = canRemove ? activePage.isPersistent() : false;
                String type = activePage.getType();
                if (activePage.isPersistent() && this.isEditableComponentType(type)) {
                    this._editComponentBtn.setEnabled(true);
                } else {
                    this._editComponentBtn.setEnabled(false);
                }
            }
            this._removeItemBtn.setEnabled(canRemove);
        }
    }

    private boolean hasEditor(PalettePage page) {
        return page != null && page.isPersistent() && PaletteCommands.hasEditor(page.getType());
    }

    private void addPage() {
        try {
            String selectedType;
            String type = selectedType = (String)this._pageTypeBox.getSelectedItem();
            if (selectedType.equals("All") && this._pageList.getModel().getSize() > 0 && this._pageList.getSelectedValue() != null) {
                PalettePage palettePage = this._palette.getPalettePage(this.getSelectedPage());
                type = palettePage.getType();
            }
            NewPageWizard npw = new NewPageWizard();
            npw.invoke(type, this._context, this._controller.getList());
            this.showPages(selectedType);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removePage() {
        String pageSelected = this.getSelectedPage();
        if (pageSelected != null) {
            PalettePage palettePage = this._palette.getPalettePage(pageSelected);
            boolean canRemove = palettePage.getCanRemove();
            if (canRemove) {
                int selectedIndex = this._pageList.getSelectedIndex();
                if (pageSelected != null) {
                    PalettePage activePage = this._palette.getPalettePage(pageSelected);
                    this._palette.setActivePage(activePage);
                    try {
                        boolean removed = this._commands.removePalettePage();
                        if (removed) {
                            this._componentModel.removeAllElements();
                            this.validate();
                            this._pageList.setSelectedIndex(Math.max(0, selectedIndex - 1));
                            if (this._pageList.getModel().getSize() == 0) {
                                this._renamePageBtn.setEnabled(false);
                                this._removePageBtn.setEnabled(false);
                                this._addComponentBtn.setEnabled(false);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            } else {
                MessageDialog.error((Component)this, (Object)PaletteArb.getString(66), (String)PaletteArb.getString(65), null);
            }
        }
    }

    private void addItem() {
        try {
            String pageSelected = this.getSelectedPage();
            PalettePage activePage = this._palette.getPalettePage(pageSelected);
            if (activePage != null) {
                this._commands.invokeItemWizard(activePage);
                this.populateComponents(this.getSelectedPage());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSelectedPage() {
        String str = null;
        try {
            str = (String)this._pageList.getSelectedValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    public String getSelectedItem() {
        ImageIcon icon = (ImageIcon)this._componentList.getSelectedValue();
        return icon.getDescription();
    }

    private void removeItem() {
        ImageIcon icon = (ImageIcon)this._componentList.getSelectedValue();
        PalettePage palettePage = this._palette.getPalettePage(this.getSelectedPage());
        PaletteItemImpl item = (PaletteItemImpl)this._palette.getPaletteItem(icon.getDescription(), this.getSelectedPage());
        boolean canRemove = item.getCanRemove();
        if (!canRemove) {
            MessageDialog.error((Component)this, (Object)PaletteArb.getString(64), (String)PaletteArb.getString(65), null);
        } else if (icon != null) {
            boolean ok = false;
            ok = this._componentList.getSelectedValues().length > 1 ? MessageDialog.confirm((Component)this, (Object)PaletteArb.format(97, "\"" + icon.getDescription() + "\"", "\"" + palettePage.getShortLabel() + "\""), (String)PaletteArb.getString(96), null) : MessageDialog.confirm((Component)this, (Object)PaletteArb.format(95, "\"" + icon.getDescription() + "\"", "\"" + palettePage.getShortLabel() + "\""), (String)PaletteArb.getString(94), null);
            if (ok) {
                Object[] objs = this._componentList.getSelectedValues();
                int count = objs != null ? objs.length : 0;
                for (int i = 0; i < count; ++i) {
                    ImageIcon ico = (ImageIcon)objs[i];
                    String name = ico.getDescription();
                    this._palette.removeItem(name, this.getSelectedPage());
                    this._componentModel.removeElement(ico);
                    this._editComponentBtn.setEnabled(false);
                    this._removeItemBtn.setEnabled(false);
                }
                this.repaint();
            }
        }
    }

    @Override
    public void palettePageAdded(PalettePage page) {
        String type = (String)this._pageTypeBox.getSelectedItem();
        if (type.equals("All") || type.equals(page.getType())) {
            this._pageModel.addElement(page.getShortLabel());
            this._pageList.setSelectedIndex(this._pageModel.getSize() - 1);
            String pageSelected = this.getSelectedPage();
            this.populateComponents(pageSelected);
            this._pageList.ensureIndexIsVisible(this._pageModel.getSize() - 1);
        }
    }

    @Override
    public void palettePageRemoved(PalettePage page) {
        this._pageModel.removeElement(this._pageList.getSelectedValue());
    }

    @Override
    public void paletteItemAdded(PaletteItem item) {
        this._controller.refreshPalette();
    }

    @Override
    public void paletteItemRemoved(PaletteItem item) {
        this._controller.refreshPalette();
    }

    @Override
    public void palettePageRenamed(String oldname, PalettePage page) {
    }

    @Override
    public void paletteItemRenamed(String oldname, PaletteItem item) {
        ImageIcon icon = (ImageIcon)this._componentList.getSelectedValue();
        int in = this._componentList.getSelectedIndex();
        icon = (ImageIcon)item.getIcon();
        icon.setDescription(item.getShortLabel());
        String pageName = this.getSelectedPage();
        if (pageName != null) {
            this.populateComponents(pageName);
        }
        this._componentList.setSelectedIndex(in);
        PaletteItemImpl i = (PaletteItemImpl)item;
        PalettePage page = this._palette.getPalettePage(this.getSelectedPage());
        if (this._controller.getPaletteUI() != null) {
            this._controller.getPaletteUI().updateItem(page, i);
            this._controller.refreshPalette();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent comp = (JComponent)e.getSource();
        if (comp == this._addPageBtn) {
            this.addPage();
        } else if (comp == this._removePageBtn) {
            this.removePage();
        } else if (comp == this._removeItemBtn) {
            this.removeItem();
        } else if (comp == this._pageTypeBox) {
            String selectedItem = (String)this._pageTypeBox.getSelectedItem();
            this._removeItemBtn.setEnabled(false);
            this._editComponentBtn.setEnabled(false);
            this.showPages(selectedItem);
            if (this._pageList.getModel().getSize() > 0) {
                String pageName = this.getSelectedPage();
                if (pageName == null && this._pageList.getModel().getSize() > 0) {
                    this._pageList.setSelectedIndex(0);
                    pageName = this.getSelectedPage();
                }
                if (pageName != null) {
                    this.populateComponents(pageName);
                    PalettePage page = this._palette.getPalettePage(pageName);
                    boolean removeable = true;
                    if (!page.getCanRemove()) {
                        removeable = false;
                    }
                    this._removePageBtn.setEnabled(removeable);
                    this._renamePageBtn.setEnabled(removeable);
                    this._addComponentBtn.setEnabled(page.isPersistent() && PaletteCommands.hasEditor(page.getType()));
                }
            } else {
                this._removePageBtn.setEnabled(false);
                this._renamePageBtn.setEnabled(false);
                this._addComponentBtn.setEnabled(false);
            }
        } else if (comp == this._addComponentBtn) {
            if (this._pageModel.getSize() > 0) {
                String pageSelected = this.getSelectedPage();
                PalettePage activePage = this._palette.getPalettePage(pageSelected);
                String type = activePage.getType();
                this._commands.invokeItemWizard(activePage);
                this._palette.setEditPage(activePage);
                this.populateComponents(this.getSelectedPage());
            }
        } else if (comp == this._renamePageBtn) {
            if (this._pageModel.getSize() > 0) {
                String pageSelected = this.getSelectedPage();
                PalettePage activePage = this._palette.getPalettePage(pageSelected);
                boolean canRemove = activePage.getCanRemove();
                if (!canRemove) {
                    MessageDialog.error((Component)this, (Object)PaletteArb.getString(98), (String)PaletteArb.getString(99), null);
                    return;
                }
                this._renameWizard = new RenamePalettePageWizard();
                String newName = this._renameWizard.invoke(activePage);
                if (newName != null) {
                    activePage.setName(newName);
                    this._palette.firePalettePageRenamed(pageSelected, activePage);
                    int index = this._pageList.getSelectedIndex();
                    this._pageModel.set(index, newName);
                }
            }
        } else if (comp == this._editComponentBtn) {
            String name = this.getSelectedItem();
            this._editItemWizard = new EditItemWizard();
            PaletteItem item = this._palette.getPaletteItem(name, this.getSelectedPage());
            PalettePage activePage = this._palette.getPalettePage(this.getSelectedPage());
            String type = activePage.getType();
            if (this.isEditableComponentType(type)) {
                boolean ok = this._editItemWizard.invoke(activePage, item);
                if (ok) {
                    item = this._editItemWizard.getItem();
                    this._palette.firePaletteItemRenamed(name, item);
                }
            } else {
                MessageDialog.error((Component)this, (Object)PaletteArb.getString(100), (String)PaletteArb.getString(99), null);
            }
        } else {
            ChangeImageDialog _dlg = new ChangeImageDialog();
            ImageIcon icon = (ImageIcon)this._componentList.getSelectedValue();
            if (icon != null) {
                String componentName = this.getSelectedItem();
                PaletteItemImpl item = (PaletteItemImpl)this._palette.getPaletteItem(componentName, this.getSelectedPage());
                _dlg.invoke(componentName, item);
            }
        }
    }

    private void showPages(String type) {
        Iterator iter = this._palette.getChildren();
        this._pageModel.removeAllElements();
        this._componentModel.removeAllElements();
        this._palette.removePaletteModelListener(this);
        this._pageList.removeListSelectionListener(this);
        while (iter.hasNext()) {
            PalettePage page = (PalettePage)iter.next();
            if (!page.canShow() || !this.hasEditor(page)) continue;
            String name = page.getName();
            String pageType = page.getType();
            if (type.equals("All")) {
                this._pageModel.addElement(page.getShortLabel());
                continue;
            }
            if (!pageType.equalsIgnoreCase(type)) continue;
            this._pageModel.addElement(page.getShortLabel());
        }
        this._editComponentBtn.setEnabled(false);
        this._removeItemBtn.setEnabled(false);
        this._pageList.addListSelectionListener(this);
        if (this._palette.getActivePage() != null) {
            String pageName = this._palette.getActivePage().getShortLabel();
            this._pageList.setSelectedValue(pageName, true);
        } else {
            this._pageList.setSelectedIndex(0);
        }
        this._palette.addPaletteModelListener(this);
    }

    public void setup(Context context) {
        this._context = context;
        this.populatePageList();
        this._palette.addPaletteModelListener(this);
    }

    public void cleanup() {
        this._palette.removePaletteModelListener(this);
        if (this._palette.getEditPage() != null) {
            this._palette.getEditPage().setIsPersistent(true);
        }
        if (this._context.getBoolean(OK)) {
            this.refreshPalette();
        }
    }

    private void refreshPalette() {
        PaletteWindowImpl pWindow = (PaletteWindowImpl)PaletteWindowImpl.getInstance();
        pWindow.showType(true, (View)EditorManager.getEditorManager().getCurrentEditor());
    }

    private void makeSameSize(JButton[] buttons) {
        if (buttons.length == 0) {
            return;
        }
        int max = 0;
        for (int i = 0; i < buttons.length; ++i) {
            int w = buttons[i].getPreferredSize().width;
            max = w > max ? w : max;
        }
        Dimension dim = new Dimension(max, buttons[0].getPreferredSize().height);
        for (int i = 0; i < buttons.length; ++i) {
            buttons[i].setPreferredSize(dim);
        }
    }

    private boolean isEditableComponentType(String type) {
        return Arrays.asList(editableComponentTypes).indexOf(type) != -1;
    }
}

