/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette.pageprovider;

import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.palette.Invokable;
import oracle.ide.palette.Palette;
import oracle.ide.palette.PaletteContext;
import oracle.ide.palette.PaletteEvent;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PaletteModelListener;
import oracle.ide.palette.PalettePage;
import oracle.ide.palette.PaletteTransferable;
import oracle.ide.palette2.DefaultPaletteGroup;
import oracle.ide.palette2.DefaultPaletteItem;
import oracle.ide.palette2.DefaultPalettePage;
import oracle.ide.palette2.PaletteGroup;
import oracle.ide.palette2.PaletteListener;
import oracle.ide.palette2.PalettePages;
import oracle.ide.palette2.PalettePagesListener;
import oracle.ide.palette2.PaletteSection;
import oracle.ide.palette2.PaletteWindow;
import oracle.ide.view.View;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PalettePageImpl;
import oracle.ideimpl.palette.PaletteWindowImpl;
import oracle.ideimpl.palette.pageprovider.DeclaredPalette1PageProvider;
import oracle.ideimpl.palette.pageprovider.DefaultPalette1Section;
import oracle.ideimpl.palette2.Palette1Provider;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteItemUI;

public class DeclaredPalette1Pages
extends PalettePages
implements PaletteModelListener,
PaletteListener,
oracle.ide.palette.PaletteListener,
DragSourceListener,
Palette1Provider {
    public static final String DECLAREDPROVIDER_ID = DeclaredPalette1PageProvider.class.getName();
    public static final String ITEM_PALETTE1PAGENAME = "palette1PageName";
    private static DeclaredPalette1Pages _singleton = new DeclaredPalette1Pages();
    protected List<PalettePagesListener> palettePagesListeners;
    protected List<String> palette1PageExclusions;
    protected List<oracle.ide.palette2.PalettePage> palettePages = new ArrayList<oracle.ide.palette2.PalettePage>();
    protected Context context;
    private PaletteItemImpl palette1ItemImpl;
    private Object _droppedObject = null;
    private PaletteItem palette1PointerItem;
    private Map<String, String> defaultPageMap = new HashMap<String, String>();

    private DeclaredPalette1Pages() {
        oracle.ideimpl.palette2.PaletteWindowImpl pWindow = (oracle.ideimpl.palette2.PaletteWindowImpl)oracle.ideimpl.palette2.PaletteWindowImpl.getInstance();
        pWindow.addPaletteListener((PaletteListener)this);
        this.palette1PageExclusions = pWindow.getPalette1PageExclusions();
        this.palette1PointerItem = new PaletteItemImpl(true);
    }

    public static DeclaredPalette1Pages getInstance() {
        return _singleton;
    }

    public void setPageAsDefault(String docExtension, String pageName) {
        this.defaultPageMap.put(docExtension, pageName);
    }

    public String getDefaultPage(String docExtension) {
        return this.defaultPageMap.get(docExtension);
    }

    public void initialize(Context ctxt) {
        Palette palette1;
        PaletteManager palette1Manager;
        this.context = new Context(ctxt);
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor != null) {
            PaletteContext.setEditor(this.context, editor);
        }
        if ((palette1Manager = PaletteManager.getPaletteManager()) != null) {
            palette1Manager.removePaletteListener(this);
            palette1 = palette1Manager.getPalette();
            if (palette1 != null) {
                palette1.removePaletteModelListener(this);
            }
        }
        this.palettePages.clear();
        this.initPages();
        if (palette1Manager != null) {
            palette1Manager.addPaletteListener(this);
            palette1 = palette1Manager.getPalette();
            if (palette1 != null) {
                palette1.addPaletteModelListener(this);
            }
        }
    }

    private void initPages() {
        Palette palette1;
        PaletteManager palette1Manager = PaletteManager.getPaletteManager();
        if (palette1Manager != null && (palette1 = palette1Manager.getPalette()) != null) {
            Iterator iter = palette1.getPalettePages(this.context);
            while (iter.hasNext()) {
                PalettePageImpl page = (PalettePageImpl)iter.next();
                if (this.excludePage(page)) continue;
                this.addPage(page);
            }
        }
    }

    private boolean excludePage(PalettePageImpl page) {
        boolean ret = false;
        if (page.isPalette1Only()) {
            ret = true;
        } else if (!page.canShow()) {
            ret = true;
        } else {
            String name = page.getShortLabel();
            if (this.palette1PageExclusions != null) {
                for (String p1PageName : this.palette1PageExclusions) {
                    if (!p1PageName.equalsIgnoreCase(name)) continue;
                    ret = true;
                    break;
                }
            }
            if (!ret) {
                oracle.ideimpl.palette2.PaletteWindowImpl pWindow = (oracle.ideimpl.palette2.PaletteWindowImpl)oracle.ideimpl.palette2.PaletteWindowImpl.getInstance();
                List pagesList = pWindow.getPageList();
                for (String pageList : pagesList) {
                    if (!pageList.equalsIgnoreCase(name)) continue;
                    ret = true;
                    break;
                }
            }
        }
        return ret;
    }

    public Collection<oracle.ide.palette2.PalettePage> getPages() {
        return Collections.unmodifiableList(this.palettePages);
    }

    public oracle.ide.palette2.PaletteItem getItem(String providerId, String itemId) {
        oracle.ide.palette2.PaletteItem paletteItem;
        block2: {
            oracle.ide.palette2.PalettePage palettePage;
            DefaultPalettePage defPage;
            if (providerId == null || providerId.length() == 0 || itemId == null || itemId.length() == 0) {
                return null;
            }
            paletteItem = null;
            if (!providerId.equals(DECLAREDPROVIDER_ID)) break block2;
            Iterator<oracle.ide.palette2.PalettePage> i$ = this.palettePages.iterator();
            while (i$.hasNext() && (paletteItem = (defPage = (DefaultPalettePage)(palettePage = i$.next())).getItem(itemId)) == null) {
            }
        }
        return paletteItem;
    }

    public void addPalettePagesListener(PalettePagesListener listener) {
        if (this.palettePagesListeners == null) {
            this.palettePagesListeners = new ArrayList<PalettePagesListener>();
        }
        if (!this.palettePagesListeners.contains(listener)) {
            this.palettePagesListeners.add(listener);
        }
    }

    public void removePalettePagesListener(PalettePagesListener listener) {
        if (this.palettePagesListeners != null) {
            this.palettePagesListeners.remove(listener);
            if (this.palettePagesListeners.size() == 0) {
                this.context = null;
            }
        }
    }

    private List<String> tokenizeString(String text) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (text != null) {
            StringTokenizer tkn = new StringTokenizer(text, ";");
            while (tkn.hasMoreTokens()) {
                String token = tkn.nextToken();
                tokens.add(token);
            }
        }
        return Collections.unmodifiableList(tokens);
    }

    private List<DefaultPalettePage.ShowForTypeRecord> tokenizeShowForTypes(String text) {
        ArrayList<DefaultPalettePage.ShowForTypeRecord> tokens = new ArrayList<DefaultPalettePage.ShowForTypeRecord>();
        if (text != null) {
            StringTokenizer tkn = new StringTokenizer(text, ";");
            while (tkn.hasMoreTokens()) {
                String token = tkn.nextToken();
                tokens.add(new DefaultPalettePage.ShowForTypeRecord(token));
            }
        }
        return Collections.unmodifiableList(tokens);
    }

    private void addPage(PalettePage palette1Page) {
        DefaultPalettePage page = this.transformPalette1Page(palette1Page);
        this.palettePages.add((oracle.ide.palette2.PalettePage)page);
    }

    private void removePage(PalettePage palette1Page) {
        for (oracle.ide.palette2.PalettePage palettePage : this.palettePages) {
            if (!palettePage.getName().equals(palette1Page.getShortLabel())) continue;
            this.palettePages.remove(palettePage);
            break;
        }
    }

    private DefaultPalettePage transformPalette1Page(PalettePage palette1Page) {
        String types = palette1Page.getShowForTypes();
        List<DefaultPalettePage.ShowForTypeRecord> records = this.tokenizeShowForTypes(types);
        String technologyScopes = palette1Page.getTechnologyScope();
        List<String> scopes = this.tokenizeString(technologyScopes);
        String pageName = palette1Page.getName();
        String pageId = DECLAREDPROVIDER_ID + "." + "page" + "." + pageName;
        DefaultPalettePage page = new DefaultPalettePage(new DefaultPalettePage.PageRecord(pageName, palette1Page.getLongLabel(), null, pageId, palette1Page.getPageEditor(), palette1Page.getProjectConfigurator(), records, scopes, palette1Page.getType(), palette1Page.getPaletteContext()));
        String groupId = pageId + "." + "group" + "." + pageName;
        DefaultPaletteGroup dfltGroup = new DefaultPaletteGroup(pageName, palette1Page.getLongLabel(), null, groupId, null, null, null, null, null);
        page.addGroup((PaletteGroup)dfltGroup);
        String sectionId = groupId + "." + "section" + "." + pageName;
        DefaultPalette1Section dfltSection = new DefaultPalette1Section(null, sectionId);
        dfltSection.setData("pageType", palette1Page.getType());
        dfltGroup.addSection((PaletteSection)dfltSection);
        for (PaletteItem item : palette1Page.getPaletteItems()) {
            int comPos;
            if (!item.canShow()) continue;
            String classPath = null;
            String className = null;
            String info = item.getItemInfo();
            if (info != null && (comPos = info.indexOf(",")) != -1) {
                classPath = info.substring(0, comPos);
                if (info.length() > comPos) {
                    className = info.substring(comPos + 1);
                }
            }
            if (className == null) {
                className = item.getLongLabel();
            }
            String itemTechnologyScopes = item.getTechnologyScope();
            List<String> itemScopes = this.tokenizeString(itemTechnologyScopes);
            String weight = String.valueOf(item.getItemWeight());
            String itemId = sectionId + "." + "item" + "." + item.getShortLabel();
            DefaultPaletteItem dfltItem = new DefaultPaletteItem(item.getShortLabel(), item.getLongLabel(), item.getIcon(), itemId, DECLAREDPROVIDER_ID, item.getEditor(), itemScopes, item.getItemType(), info, classPath, className, item.getLibrary(), weight, item.getItemHelpable(), null);
            dfltItem.setData((Object)ITEM_PALETTE1PAGENAME, (Object)pageName);
            dfltSection.addItem((oracle.ide.palette2.PaletteItem)dfltItem);
        }
        return page;
    }

    @Override
    public void palettePageAdded(PalettePage palette1Page) {
        if (!this.excludePage((PalettePageImpl)palette1Page)) {
            this.addPage(palette1Page);
            this.refreshPalette();
        }
    }

    @Override
    public void palettePageRemoved(PalettePage palette1Page) {
        if (!this.excludePage((PalettePageImpl)palette1Page)) {
            this.removePage(palette1Page);
            this.refreshPalette();
        }
    }

    public void refreshPalette() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor != null) {
            oracle.ideimpl.palette2.PaletteWindowImpl pWindow = (oracle.ideimpl.palette2.PaletteWindowImpl)oracle.ideimpl.palette2.PaletteWindowImpl.getInstance();
            pWindow.showType(false, (View)editor);
        }
    }

    @Override
    public void paletteItemAdded(PaletteItem item) {
    }

    @Override
    public void paletteItemRemoved(PaletteItem item) {
    }

    @Override
    public void palettePageRenamed(String oldname, PalettePage page) {
    }

    @Override
    public void paletteItemRenamed(String oldname, PaletteItem item) {
    }

    public void paletteOpened(oracle.ide.palette2.PaletteEvent event) {
    }

    public void paletteClosed(oracle.ide.palette2.PaletteEvent event) {
    }

    public void selectionChanged(oracle.ide.palette2.PaletteEvent event) {
    }

    public void itemSelected(oracle.ide.palette2.PaletteEvent event) {
        Palette palette1;
        PaletteManager palette1Manager;
        oracle.ideimpl.palette2.PaletteWindowImpl window = (oracle.ideimpl.palette2.PaletteWindowImpl)oracle.ideimpl.palette2.PaletteWindowImpl.getInstance();
        oracle.ide.palette2.PaletteItem item = window.getSelectedItem();
        if (item != null && item.getProviderId().equals(DECLAREDPROVIDER_ID) && (palette1Manager = PaletteManager.getPaletteManager()) != null && (palette1 = PaletteManager.getPaletteManager().getPalette()) != null) {
            String pageName = (String)((DefaultPaletteItem)item).getData((Object)ITEM_PALETTE1PAGENAME);
            PalettePage palette1Page = palette1.getPalettePage(pageName);
            PaletteItem palette1Item = palette1.getPaletteItem(item.getName(), pageName);
            if (palette1Item == null) {
                if (item.getName().equals("Pointer")) {
                    palette1Item = this.palette1PointerItem;
                } else {
                    return;
                }
            }
            palette1.setActivePage(palette1Page);
            palette1.setActiveItem(palette1Item);
            this.firePalette1ItemPressed(event.getAction());
            PaletteItem element = palette1Item;
            if (element != null) {
                Context context = new Context((Element)element);
                View editor = window.getEditor();
                if (editor != null && editor.getContext() != null && editor.getContext().getNode() != null) {
                    context.setNode(editor.getContext().getNode());
                    context.setProject(editor.getContext().getProject());
                    context.setWorkspace(editor.getContext().getWorkspace());
                }
                try {
                    Invokable invoke = (Invokable)Class.forName("oracle.jdevimpl.palette.PaletteProxy").newInstance();
                    invoke.invoke(context, new String[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void escapeKeyPressed(oracle.ide.palette2.PaletteItem item) {
        Palette palette1;
        PaletteManager palette1Manager;
        if (item != null && item.getProviderId().equals(DECLAREDPROVIDER_ID) && (palette1Manager = PaletteManager.getPaletteManager()) != null && (palette1 = PaletteManager.getPaletteManager().getPalette()) != null) {
            String pageName = (String)((DefaultPaletteItem)item).getData((Object)ITEM_PALETTE1PAGENAME);
            PalettePage palette1Page = palette1.getPalettePage(pageName);
            palette1.setActivePage(palette1Page);
            palette1.setActiveItem(this.palette1PointerItem);
            this.firePalette1ItemPressed("PALETTE2_ITEM_SELECTED");
        }
    }

    private void firePalette1ItemPressed(String action) {
        Palette palette1;
        PaletteManager palette1Manager = PaletteManager.getPaletteManager();
        if (palette1Manager != null && (palette1 = palette1Manager.getPalette()) != null) {
            PaletteWindowImpl palette1Window = (PaletteWindowImpl)palette1Manager.getPaletteWindow();
            if (action.equals("PALETTE2_ITEM_SELECTED")) {
                palette1Window.fireItemPressed(new PaletteEvent(palette1, "ITEM_PRESSED"));
            } else if (action.equals("PALETTE2_ITEM_DEFAULTCREATE")) {
                palette1Window.fireDefaultCreate(new PaletteEvent(palette1, "CREATE_DEFAULT"));
            }
        }
    }

    public void itemUnselected(oracle.ide.palette2.PaletteEvent event) {
    }

    public void stickyModeActivated(oracle.ide.palette2.PaletteEvent event) {
        this.firePalette1StickyMode(true);
    }

    public void stickyModeDeactivated(oracle.ide.palette2.PaletteEvent event) {
        this.firePalette1StickyMode(false);
    }

    private void firePalette1StickyMode(boolean activate) {
        oracle.ideimpl.palette2.PaletteWindowImpl window = (oracle.ideimpl.palette2.PaletteWindowImpl)oracle.ideimpl.palette2.PaletteWindowImpl.getInstance();
        oracle.ide.palette2.PaletteItem item = window.getSelectedItem();
        if (item != null && item.getProviderId().equals(DECLAREDPROVIDER_ID)) {
            Palette palette1;
            if (item.getName().equals("Pointer")) {
                return;
            }
            PaletteManager palette1Manager = PaletteManager.getPaletteManager();
            if (palette1Manager != null && (palette1 = palette1Manager.getPalette()) != null) {
                String pageName = (String)((DefaultPaletteItem)item).getData((Object)ITEM_PALETTE1PAGENAME);
                PalettePage palette1Page = palette1.getPalettePage(pageName);
                PaletteItem palette1Item = palette1.getPaletteItem(item.getName(), pageName);
                palette1.setActivePage(palette1Page);
                palette1.setActiveItem(palette1Item);
                PaletteWindowImpl palette1Window = (PaletteWindowImpl)palette1Manager.getPaletteWindow();
                PaletteController palette1Controller = (PaletteController)palette1Window.getController();
                palette1Controller.setStickyMode(activate);
            }
        }
    }

    public void dragGestureRecognized(DragSource dragSource, DragGestureEvent dge) {
        oracle.ideimpl.palette2.PaletteWindowImpl window;
        oracle.ide.palette2.PaletteItem item;
        boolean rightClick = false;
        InputEvent triggerEvent = dge.getTriggerEvent();
        if (4 == triggerEvent.getModifiers() || 8 == triggerEvent.getModifiers()) {
            rightClick = true;
        }
        if ((item = (window = (oracle.ideimpl.palette2.PaletteWindowImpl)oracle.ideimpl.palette2.PaletteWindowImpl.getInstance()).getSelectedItem()) != null && item.getProviderId().equals(DECLAREDPROVIDER_ID)) {
            Palette palette1;
            if (item.getName().equals("Pointer")) {
                return;
            }
            PaletteManager palette1Manager = PaletteManager.getPaletteManager();
            if (palette1Manager != null && (palette1 = palette1Manager.getPalette()) != null) {
                String pageName = (String)((DefaultPaletteItem)item).getData((Object)ITEM_PALETTE1PAGENAME);
                PalettePage palette1Page = palette1.getPalettePage(pageName);
                PaletteItem palette1Item = palette1.getPaletteItem(item.getName(), pageName);
                this.palette1ItemImpl = (PaletteItemImpl)palette1Item;
                palette1.setActivePage(palette1Page);
                palette1.setActiveItem(palette1Item);
                this._droppedObject = null;
                dragSource.startDrag(dge, null, this.palette1ItemImpl, this);
            }
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        PaletteControllerUI controller;
        PaletteItemUI itemUI;
        oracle.ideimpl.palette2.PaletteWindowImpl window = (oracle.ideimpl.palette2.PaletteWindowImpl)oracle.ideimpl.palette2.PaletteWindowImpl.getInstance();
        if (dsde.getDropSuccess()) {
            PaletteItemImpl element = this.palette1ItemImpl;
            Element[] elems = new Element[]{this.palette1ItemImpl};
            Context context = new Context((Element)element);
            context.setSelection(elems);
            View editor = window.getEditor();
            if (editor != null && editor.getContext() != null && editor.getContext().getNode() != null) {
                context.setNode(editor.getContext().getNode());
                context.setProject(editor.getContext().getProject());
                context.setWorkspace(editor.getContext().getWorkspace());
            }
            this.palette1ItemImpl.paletteInvokeConfigure(context);
            if (this._droppedObject != null && this._droppedObject instanceof PaletteTransferable) {
                ((PaletteTransferable)this._droppedObject).postConfigure(context);
            }
        }
        if ((itemUI = (controller = PaletteControllerUI.getInstance()).getSelectedItemUI()) != null) {
            itemUI.showAsUnselected();
        }
        controller.setSelectedWindowUI((PaletteItemUI)null);
    }

    @Override
    public void paletteOpened(PaletteEvent event) {
    }

    @Override
    public void paletteClosed(PaletteEvent event) {
    }

    @Override
    public void selectionChanged(PaletteEvent event) {
    }

    @Override
    public void itemPressed(PaletteEvent event) {
        if (event.getAction().equals("ITEM_UNPRESSED")) {
            PaletteWindow window = oracle.ideimpl.palette2.PaletteWindowImpl.getInstance();
            window.unSelectSelectedItem();
        }
    }

    @Override
    public void stickyModeActivated(PaletteEvent event) {
    }

    @Override
    public void stickyModeDeactivated(PaletteEvent event) {
    }

    public oracle.ide.palette2.PalettePage getPreferredPage() {
        return super.getPreferredPage();
    }

    public float getPreferredPageRank() {
        return super.getPreferredPageRank();
    }
}

