/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette.model;

import java.util.ArrayList;
import oracle.ideimpl.palette.model.Item;

public class Page {
    private String _paletteContext;
    private String _technologyScope;
    private boolean _draggable = true;
    private String _name;
    private boolean _canRemove = true;
    private String _icon;
    private String _type;
    public String _showForTypes;
    private String _pageEditor;
    private String _view;
    private Item[] _item;
    private String _canShow = "true";
    private String _projectConfiguration;

    public Page() {
    }

    public Page(Page page) {
        this();
        if (page != null) {
            Page.copy(page, this);
        }
    }

    public static void copy(Page src, Page dst) {
        dst._name = src._name;
        dst._canRemove = src._canRemove;
        dst._icon = src._icon;
        dst._showForTypes = src._showForTypes;
        dst._canShow = src._canShow;
        dst._paletteContext = src._paletteContext;
        dst._projectConfiguration = src._projectConfiguration;
        dst._technologyScope = src._technologyScope;
        dst._draggable = src._draggable;
        if (src._item != null) {
            int n = src._item.length;
            dst._item = new Item[n];
            for (int i = 0; i < n; ++i) {
                dst._item[i] = new Item(src._item[i]);
            }
        }
    }

    public void setDraggable(boolean draggable) {
        this._draggable = draggable;
    }

    public boolean getDraggable() {
        return this._draggable;
    }

    public String getTechnologyScope() {
        return this._technologyScope;
    }

    public void setTechnologyScope(String technologyScope) {
        this._technologyScope = technologyScope;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public boolean getCanRemove() {
        return this._canRemove;
    }

    public void setCanRemove(boolean canRemove) {
        this._canRemove = canRemove;
    }

    public void setIcon(String icon) {
        this._icon = icon;
    }

    public String getIcon() {
        return this._icon;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getType() {
        if (this._type == null) {
            this._type = "java";
        }
        return this._type;
    }

    public void setShowForTypes(String s) {
        this._showForTypes = s;
    }

    public String getShowForTypes() {
        return this._showForTypes;
    }

    public void setPageEditor(String pageEditor) {
        this._pageEditor = pageEditor;
    }

    public String getPageEditor() {
        return this._pageEditor;
    }

    public void setView(String view) {
        this._view = view;
    }

    public String getView() {
        return this._view;
    }

    public Item[] getItem() {
        return this._item;
    }

    public void setItem(Item[] item) {
        this._item = item;
    }

    public int addItem(Item newItem) {
        if (newItem == null) {
            return -1;
        }
        Item[] curItems = this.getItem();
        if (curItems == null) {
            this.setItem(new Item[]{newItem});
            return 0;
        }
        int index = -1;
        float weight = newItem.getWeight();
        for (int i = 0; i < curItems.length; ++i) {
            Item sibling = curItems[i];
            if (sibling == newItem) {
                return -1;
            }
            if (Float.compare(weight, sibling.getWeight()) >= 0) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = curItems.length;
        }
        Item[] revisedItems = new Item[curItems.length + 1];
        System.arraycopy(curItems, 0, revisedItems, 0, index);
        revisedItems[index] = newItem;
        System.arraycopy(curItems, index, revisedItems, index + 1, curItems.length - index);
        this.setItem(revisedItems);
        return index;
    }

    public void removeItem(Item oldItem) {
        int numItems;
        Item[] curItems = this.getItem();
        ArrayList<Item> list = new ArrayList<Item>();
        int n = numItems = curItems != null ? curItems.length : 0;
        if (curItems != null) {
            for (int i = 0; i < numItems; ++i) {
                list.add(curItems[i]);
            }
            list.remove(oldItem);
            int size = list.size();
            Item[] newItems = new Item[size];
            for (int j = 0; j < size; ++j) {
                newItems[j] = (Item)list.get(j);
            }
            this.setItem(newItems);
        }
    }

    public void removeAll() {
        this.setItem(null);
    }

    public void setCanShow(String canShow) {
        this._canShow = canShow;
    }

    public String getCanShow() {
        return this._canShow;
    }

    public void setPaletteContext(String paletteContext) {
        this._paletteContext = paletteContext;
    }

    public String getPaletteContext() {
        return this._paletteContext;
    }

    public void setProjectConfiguration(String projectConfiguration) {
        this._projectConfiguration = projectConfiguration;
    }

    public String getProjectConfiguration() {
        return this._projectConfiguration;
    }
}

