/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.model.Element;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.net.URLFileSystem;
import oracle.ide.palette.PaletteContext;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PaletteModelListener;
import oracle.ide.palette.PalettePage;
import oracle.ide.util.ModelUtil;
import oracle.ideimpl.palette.IconPanel;
import oracle.ideimpl.palette.PageNotFoundPanel;
import oracle.ideimpl.palette.PaletteArb;
import oracle.ideimpl.palette.PaletteComboBox;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteItemUI;
import oracle.ideimpl.palette.PaletteManagerImpl;
import oracle.ideimpl.palette.PalettePageImpl;
import oracle.ideimpl.palette.PanelFactory;
import oracle.ideimpl.palette.model.History;
import oracle.ideimpl.palette.model.Palette;
import oracle.ideimpl.palette.palettexml.PaletteXML;
import oracle.javatools.data.PropertyStorage;

public class PaletteUI
extends JPanel
implements ComponentListener,
PaletteModelListener {
    private final BorderLayout _defaultLayout = new BorderLayout();
    private SortedSet _pageItems = new TreeSet(String.CASE_INSENSITIVE_ORDER);
    private final PaletteComboBox _pageComboBox = new PaletteComboBox(PaletteUI.getComboBoxModel(Collections.EMPTY_LIST));
    private final ButtonGroup _buttonGroup = new ButtonGroup();
    private JPanel _displayPanel = new JPanel();
    private final PaletteController _controller = PaletteController.getInstance();
    private final PaletteImpl _palette = PaletteImpl.getInstance();
    private PaletteItemUI _paletteItemUI;
    private IconPanel _activeIconPanel;
    private PanelFactory _panelFactory = new PanelFactory();
    private boolean _vertical = true;
    private final HashMap _pageMap = new HashMap();
    private Context _currentContext;
    public static boolean FILTERED = true;
    private boolean hasInitialized;

    public PaletteUI() {
        super.setPreferredSize(new Dimension(20, 20));
        this.setBorder(BorderFactory.createEmptyBorder());
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this._defaultLayout);
        this._displayPanel.setLayout(new BorderLayout());
        this._palette.addPaletteModelListener(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PaletteUI.this.this_keyPressed(e);
            }
        });
        this.add((Component)this._displayPanel, "Center");
        this._controller.setPaletteUI(this);
        this.addComponentListener(this);
        AccessibleContext ac = this._pageComboBox.getAccessibleContext();
        if (ac != null) {
            String s = PaletteArb.getString(27);
            ac.setAccessibleName(s);
        }
        this._setupDisplayPanel();
    }

    protected void initialize() {
        Palette palette;
        if (!this.hasInitialized && (palette = PaletteXML.getPalette()) != null) {
            History[] history = palette.getHistory();
            if (history != null) {
                int numHistorys = history != null ? history.length : 0;
                for (int j = 0; j < numHistorys; ++j) {
                    this._controller.addToHistoryHash(history[j].getPageType(), history[j].getPalettePage());
                }
            }
            this.hasInitialized = true;
        }
    }

    public void showType(Context context, String pageType, boolean newProject) {
        this.initialize();
        pageType = PaletteUI.convertAlias(pageType);
        this._currentContext = context;
        this._palette.setPageType(pageType);
        String lastPageName = this._controller.getPalettePageName(pageType);
        PalettePage palettePage = this._palette.getPalettePage(lastPageName);
        Collection pageTypeList = this._getPalettePagesForActiveAddins(pageType, context);
        this._pageItems.clear();
        this._pageItems.addAll(pageTypeList);
        int size = this._pageItems.size();
        if (size > 0) {
            this._pageComboBox.setModel(PaletteUI.getComboBoxModel(this._pageItems));
            String pageToShow = this._pageComboBox.getItemAt(0).toString();
            if (lastPageName != null && palettePage != null && this._pageItems.contains(lastPageName)) {
                pageToShow = lastPageName;
            }
            this.showPanelAndSelect(pageToShow);
        } else {
            this.showPagesNotFound();
        }
    }

    protected boolean showPalettePage(String pageName) {
        if (this._pageItems.contains(pageName)) {
            this.showPanelAndSelect(pageName);
            return true;
        }
        return false;
    }

    public void comboBoxChanged() {
        String pageName = this._pageComboBox.getSelectedString();
        if (pageName == null) {
            return;
        }
        PalettePage selectedPage = this._palette.getPalettePage(pageName);
        if (this.getActiveIconPanel() == null || this.getActiveIconPanel()._palettePage != selectedPage) {
            this._controller.addToHistoryHash(PaletteUI.getSuffix(this._currentContext), pageName);
            this.showPanel(pageName, this.getIfVertical());
            this._palette.setDirty(true);
        }
    }

    protected JComboBox getPageComboBox() {
        return this._pageComboBox;
    }

    public void setActivePaletteItemUI(PaletteItemUI paletteItemUI) {
        this._paletteItemUI = paletteItemUI;
    }

    public PaletteItemUI getActivePaletteItemUI() {
        return this._paletteItemUI;
    }

    public void setActiveIconPanel(IconPanel activeIconPanel) {
        this._activeIconPanel = activeIconPanel;
    }

    public IconPanel getActiveIconPanel() {
        return this._activeIconPanel;
    }

    protected HashMap getPageMap() {
        return this._pageMap;
    }

    private boolean _checkTechnologyScopes(String[] keys, String technologyScope) {
        if (technologyScope == null) {
            return false;
        }
        List<String> keyList = Arrays.asList(keys);
        StringTokenizer tkn = new StringTokenizer(technologyScope, ";");
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken();
            if (!keyList.contains(token) && FILTERED) continue;
            return true;
        }
        return false;
    }

    private boolean _checkForPaletteContext(Collection list, PalettePage page, Context context) {
        Element[] elems = new Element[]{page};
        context.setSelection(elems);
        String paletteContext = page.getPaletteContext();
        if (paletteContext != null) {
            try {
                PaletteContext pc = (PaletteContext)Class.forName(paletteContext).newInstance();
                if (pc.canShowPage(context)) {
                    list.add(page.getShortLabel());
                    return true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return false;
    }

    private void _checkSyntaxContext(Collection list, PalettePage page, Context context) {
        Element[] elems = new Element[]{page};
        context.setSelection(elems);
        try {
            PaletteContext pc = this.getSyntaxContext();
            if (pc.canShowPage(context)) {
                list.add(page.getShortLabel());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean _checkForShowForTypes(PalettePage page, String pageType) {
        String typeString = page.getShowForTypes();
        if (typeString == null) {
            typeString = PaletteUI.getType(page);
        }
        StringTokenizer tkn = new StringTokenizer(typeString, ";");
        while (tkn.hasMoreTokens()) {
            String token = tkn.nextToken();
            boolean ok = this.isCorrectNode(token, pageType);
            if (!ok || !page.canShow()) continue;
            try {
                return true;
            }
            catch (Exception ex) {
            }
        }
        return false;
    }

    private Collection _getPalettePagesForActiveAddins(String pageType, Context context) {
        Iterator iter = this._getPalettePages(pageType, context);
        ArrayList<String> pageTypeList = new ArrayList<String>();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            pageTypeList.add(name);
        }
        return pageTypeList;
    }

    private Iterator _getPalettePages(String pageType, Context context) {
        HashSet<String> pageTypeList = new HashSet<String>();
        if (context == null || context.getProject() == null) {
            return pageTypeList.iterator();
        }
        Iterator iter = this._palette.getChildren();
        while (iter.hasNext()) {
            boolean scopeFound;
            int nuScopes;
            PalettePage page = (PalettePage)iter.next();
            String technologyScope = page instanceof PalettePageImpl ? ((PalettePageImpl)page).getTechnologyScope() : null;
            String[] keys = TechnologyScopeConfiguration.getInstance((PropertyStorage)context.getProject()).getTechnologyScope().getTechnologyKeys();
            int n = nuScopes = keys != null ? keys.length : 0;
            if (this.getSyntaxContext() != null) {
                this._checkSyntaxContext(pageTypeList, page, context);
            }
            if (page.getShowForTypes() != null || page.getType() != null) {
                boolean used = this._checkForShowForTypes(page, pageType);
                if (used) {
                    if (nuScopes == 0 || technologyScope == null) {
                        pageTypeList.add(page.getShortLabel());
                    } else {
                        boolean techDefined = this._checkTechnologyScopes(keys, technologyScope);
                        if (page.getShortLabel().equals("HTML") && (pageType.equals("jsp") || pageType.equals("html"))) {
                            pageTypeList.add(page.getShortLabel());
                        } else if (techDefined) {
                            pageTypeList.add(page.getShortLabel());
                        }
                    }
                }
            } else if (nuScopes > 0 && (scopeFound = this._checkTechnologyScopes(keys, technologyScope))) {
                pageTypeList.add(page.getShortLabel());
            }
            this._checkForPaletteContext(pageTypeList, page, context);
        }
        Iterator i = pageTypeList.iterator();
        ArrayList<String> finalList = new ArrayList<String>();
        while (i.hasNext()) {
            finalList.add((String)i.next());
        }
        Collections.sort(finalList);
        return finalList.iterator();
    }

    private boolean isPageShownForType(PalettePage page, String pageType, Context context) {
        boolean scopeFound;
        int nuScopes;
        if (context == null || context.getProject() == null) {
            return true;
        }
        String technologyScope = page instanceof PalettePageImpl ? ((PalettePageImpl)page).getTechnologyScope() : null;
        String[] keys = TechnologyScopeConfiguration.getInstance((PropertyStorage)context.getProject()).getTechnologyScope().getTechnologyKeys();
        int n = nuScopes = keys != null ? keys.length : 0;
        if (this.getSyntaxContext() != null && this._checkSyntaxContext(page, context)) {
            return true;
        }
        if (page.getShowForTypes() != null || page.getType() != null) {
            boolean used = this._checkForShowForTypes(page, pageType);
            if (used) {
                if (nuScopes == 0 || technologyScope == null) {
                    return true;
                }
                boolean techDefined = this._checkTechnologyScopes(keys, technologyScope);
                if (page.getShortLabel().equals("HTML") && (pageType.equals("jsp") || pageType.equals("html"))) {
                    return true;
                }
                if (techDefined) {
                    return true;
                }
            }
        } else if (nuScopes > 0 && (scopeFound = this._checkTechnologyScopes(keys, technologyScope))) {
            return true;
        }
        return this._checkForPaletteContext(page, context);
    }

    private boolean _checkSyntaxContext(PalettePage page, Context context) {
        Element[] elems = new Element[]{page};
        context.setSelection(elems);
        try {
            PaletteContext pc = this.getSyntaxContext();
            if (pc.canShowPage(context)) {
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private boolean _checkForPaletteContext(PalettePage page, Context context) {
        Element[] elems = new Element[]{page};
        context.setSelection(elems);
        String paletteContext = page.getPaletteContext();
        if (paletteContext != null) {
            try {
                PaletteContext pc = (PaletteContext)Class.forName(paletteContext).newInstance();
                if (pc.canShowPage(context)) {
                    return true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        int width = this.getWidth();
        int height = this.getHeight();
        boolean oldView = this.getIfVertical();
        if (height < 80) {
            this.setIfVertical(false);
        } else {
            this.setIfVertical(true);
        }
        if (!(SwingUtilities.getWindowAncestor(this) instanceof IdeMainWindow)) {
            this.setIfVertical(true);
        }
        if (oldView != this.getIfVertical()) {
            if (this._palette.getActivePage() != null) {
                PalettePage palPage = this._palette.getActivePage();
                String paletteName = palPage.getShortLabel();
                this._setupDisplayPanel();
                this.showPanel(paletteName, this.getIfVertical());
            } else {
                this.showPagesNotFound();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PaletteUI.this.getActiveIconPanel() != null) {
                    PaletteUI.this.getActiveIconPanel().validateScroll();
                    PaletteUI.this.validate();
                    PaletteUI.this.repaint();
                }
            }
        });
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void setIfVertical(boolean vertical) {
        this._vertical = vertical;
    }

    public boolean getIfVertical() {
        return this._vertical;
    }

    protected void showPanelAndSelect(String pageName) {
        this.showPanel(pageName, this.getIfVertical());
        this._pageComboBox.setSelectedItem(pageName);
    }

    protected void showPanel(String paletteName, boolean vertical) {
        Component focusOwner;
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        boolean hadFocus = false;
        if (kfm != null && (focusOwner = kfm.getFocusOwner()) != null && SwingUtilities.isDescendingFrom(focusOwner, this)) {
            if (focusOwner != this._pageComboBox) {
                this.requestFocus();
            }
            hadFocus = true;
        }
        if (this.getActiveIconPanel() != null) {
            this._displayPanel.remove(this.getActiveIconPanel());
        }
        PalettePage palettePage = this._palette.getPalettePage(paletteName);
        IconPanel iconPanel = this._panelFactory.getIconPanel(palettePage, vertical);
        iconPanel.setup(this._pageComboBox);
        String view = palettePage.getView();
        if (view == null || view.equals("list")) {
            iconPanel.useListView(true);
        } else {
            iconPanel.useListView(false);
        }
        this._palette.setActivePage(palettePage);
        this._addPageComboBoxToPanel();
        this._displayPanel.add((Component)iconPanel, "Center");
        this.setActiveIconPanel(iconPanel);
        if (hadFocus) {
            this._pageComboBox.requestFocus();
        }
        this.validateTree();
        this.repaint();
        iconPanel.validateScroll();
        this._pageComboBox.setToolTipText(PaletteArb.getString(109));
    }

    private void _setupDisplayPanel() {
        this._displayPanel.setLayout(new BorderLayout());
        this.add((Component)this._displayPanel, "Center");
        this._displayPanel.removeAll();
        this._addPageComboBoxToPanel();
    }

    private void _addPageComboBoxToPanel() {
        if (this._pageComboBox.getParent() == null) {
            if (this.getIfVertical()) {
                this._displayPanel.add((Component)this._pageComboBox, "North");
            } else {
                this._displayPanel.setLayout(new BoxLayout(this.getDisplayPanel(), 0));
                this._pageComboBox.setMaximumSize(new Dimension(1000, 20));
                this._displayPanel.add(this._pageComboBox);
            }
        }
    }

    protected ButtonGroup getButtonGroup() {
        return this._buttonGroup;
    }

    @Override
    public void paletteItemRemoved(PaletteItem palItem) {
        if (this.getActiveIconPanel() == null) {
            return;
        }
        PaletteItemImpl item = (PaletteItemImpl)palItem;
        if (this.getActiveIconPanel() != null) {
            this.getActiveIconPanel().removeItem(item.getItem());
            if (!(this.getActiveIconPanel() instanceof PageNotFoundPanel)) {
                this._panelFactory.removeItem(this.getActiveIconPanel().getPalettePage().getShortLabel(), item);
                this.getActiveIconPanel().invalidate();
                this.getActiveIconPanel().repaint();
            }
        }
    }

    @Override
    public void palettePageAdded(PalettePage page) {
        if (this._currentContext != null) {
            this.getActiveIconPanel().revalidate();
            this.revalidate();
            String currentType = PaletteUI.getSuffix(this._currentContext);
            if (this.isPageShownForType(page, currentType, this._currentContext)) {
                String lastPageName;
                boolean selectPage;
                String pageName = page.getShortLabel();
                this._pageItems.add(pageName);
                boolean bl = selectPage = this._pageComboBox.getItemCount() == 0;
                if (!selectPage && ModelUtil.areEqual((Object)pageName, (Object)(lastPageName = this._controller.getPalettePageName(currentType)))) {
                    selectPage = true;
                }
                this._pageComboBox.addItem(pageName);
                if (selectPage) {
                    this.showPanelAndSelect(pageName);
                }
            }
        }
    }

    @Override
    public void palettePageRemoved(PalettePage page) {
        String name = page.getShortLabel();
        boolean pageDisplayed = this._pageItems.contains(name);
        if (pageDisplayed) {
            this._pageMap.remove(name);
            this._pageItems.remove(name);
            if (this._pageComboBox.getItemCount() > 1 && ModelUtil.areEqual((Object)this._pageComboBox.getSelectedString(), (Object)name)) {
                Object firstItem = this._pageComboBox.getItemAt(0);
                String selectPageName = ModelUtil.areEqual(firstItem, (Object)name) ? (String)this._pageComboBox.getItemAt(1) : (String)this._pageComboBox.getItemAt(0);
                this.showPanelAndSelect(selectPageName);
            }
            this._pageComboBox.removeItem(name);
            if (this._pageComboBox.getItemCount() == 0) {
                this.showPagesNotFound();
            }
        }
    }

    @Override
    public void paletteItemAdded(PaletteItem palItem) {
        PaletteItemImpl item = (PaletteItemImpl)palItem;
        this.getActiveIconPanel().addItem(item.getItem());
    }

    @Override
    public void palettePageRenamed(String oldname, PalettePage page) {
        Object list;
        if (this._pageItems.contains(oldname)) {
            this._pageItems.remove(oldname);
            String itemName = page.getShortLabel();
            this._pageItems.add(itemName);
            this._pageComboBox.removeItem(oldname);
            this._pageComboBox.addItem(itemName);
            this._pageComboBox.setSelectedItem(page.getShortLabel());
        }
        if ((list = this._pageMap.get(oldname)) != null) {
            this._pageMap.put(page.getShortLabel(), list);
        }
    }

    @Override
    public void paletteItemRenamed(String oldname, PaletteItem item) {
    }

    public void updateItem(PalettePage page, PaletteItemImpl item) {
        for (PaletteItemUI ui : this._panelFactory.getPageIcons(page)) {
            if (ui.getItem() != item) continue;
            ui.setItem(item);
            ui.setIcon(item.getIcon());
            if (!(page instanceof PalettePageImpl) || !((PalettePageImpl)page).isListView()) break;
            ui.setText(item.getShortLabel());
            break;
        }
        this.invalidate();
        this.repaint();
    }

    protected void showPagesNotFound() {
        PageNotFoundPanel panel = new PageNotFoundPanel(null);
        this._palette.setActivePage(null);
        this._displayPanel.removeAll();
        this._displayPanel.setLayout(new BorderLayout());
        this.setActiveIconPanel(panel);
        this._palette.setPageType(null);
        this._displayPanel.add((Component)panel, "Center");
        this.validateTree();
        this.repaint();
    }

    public void setDisplayPanel(JPanel displayPanel) {
        this._displayPanel = displayPanel;
    }

    public JPanel getDisplayPanel() {
        return this._displayPanel;
    }

    public void refreshCombo() {
        String pageName = this._pageComboBox.getSelectedString();
        if (pageName == null) {
            return;
        }
        this.showPanel(pageName, this.getIfVertical());
    }

    public void clearContext() {
        this._currentContext = null;
    }

    private void this_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            PaletteManager.getPaletteManager().resetPalette();
        }
    }

    private PaletteContext getSyntaxContext() {
        return PaletteManagerImpl.getInstance().getUniversalContext();
    }

    private boolean isCorrectNode(String suffix, String pageType) {
        if (suffix == null || pageType == null) {
            return false;
        }
        DocumentExtensions ext = (DocumentExtensions)Ide.getSettings().getData("document-extensions-options");
        DocumentExtensions.DocRecord rec = ext.findDocumentFromExtension("." + pageType);
        if (rec == null) {
            return false;
        }
        for (DocumentExtensions.ExtInfo info : rec.getExtensions()) {
            String extension = info.getExtension();
            if (!extension.equals("." + suffix)) continue;
            return true;
        }
        return false;
    }

    private static String getSuffix(Context context) {
        if (context == null || context.getNode() == null) {
            return "";
        }
        URL url = context.getNode().getURL();
        String suffix = URLFileSystem.getSuffix((URL)url);
        int period = suffix.lastIndexOf(".");
        if (period != -1) {
            return PaletteUI.convertAlias(suffix.substring(period + 1));
        }
        return "";
    }

    private static String getType(PalettePage page) {
        return PaletteUI.convertAlias(page.getType());
    }

    private static String convertAlias(String pageType) {
        if (pageType.startsWith("jsp") || pageType.startsWith("tag")) {
            return "jsp";
        }
        return pageType;
    }

    private static ComboBoxModel getComboBoxModel(Collection initialData) {
        SortedComboBoxModel comboBoxModel = new SortedComboBoxModel();
        Iterator data = initialData.iterator();
        while (data.hasNext()) {
            comboBoxModel.addElement(data.next());
        }
        return comboBoxModel;
    }
}

