/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.palette.PaletteInvokable;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteTransferable;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteSubject;
import oracle.ideimpl.palette.model.Item;
import oracle.javatools.icons.OracleIcons;

public class PaletteItemImpl
extends PaletteSubject
implements PaletteItem,
Transferable {
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{PaletteItem.PALETTE_ITEM_FLAVOR, DataFlavor.stringFlavor};
    private static final String DEFAULT_ICON = "/oracle/ideimpl/icons/images/palette/missingdefault.png";
    private boolean reset = false;
    private Item _item;
    private String _info;
    private boolean _isPointer = false;
    private PaletteInvokable paletteInvokable = null;
    private final PaletteController _controller = PaletteController.getInstance();
    private boolean _canShow = true;
    private String initializer;
    private String _iconURL;
    private Icon _icon;

    public PaletteItemImpl(Item item) {
        this.setItem(item);
        try {
            this.setProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PaletteItemImpl(boolean reset) {
        if (reset) {
            this.reset = reset;
            this.setIcon(OracleIcons.getIcon((String)"palArrow.png"));
            this.setShortLabel("Pointer");
            this.setLongLabel("Pointer");
            this.setIsPointer(true);
        }
    }

    private void setProperties() throws Exception {
        this.setLongLabel(this.getItem().getLongLabel());
        this.setShortLabel(this.getItem().getShortLabel());
        if (this.getItem().getBeanInfo() != null) {
            this.useBeanInfo();
        } else {
            this.setIcon(this.getItem().getIcon());
        }
        this.setInitializer(this.getItem().getInfo());
    }

    @Override
    public String getClassName() {
        return this.getLongLabel();
    }

    @Override
    public String getClassPath() {
        String info = this.getItem().getInfo();
        if (info == null) {
            return null;
        }
        int comPos = info.indexOf(",");
        if (comPos != -1) {
            return info.substring(0, comPos);
        }
        return info;
    }

    @Override
    public String getLibrary() {
        return this.getItem().getLibrary();
    }

    @Override
    public boolean isResetItem() {
        return this.reset;
    }

    @Override
    public boolean mayHaveChildren() {
        return false;
    }

    private void setInfo(String _info) {
        this._info = _info;
    }

    public String getInfo() {
        return this._info;
    }

    @Override
    public Icon getIcon() {
        if (this._iconURL != null) {
            this.useDefinedImage(this._iconURL);
            if (this._icon == null) {
                this.useDefinedImage(DEFAULT_ICON);
            }
            this._iconURL = null;
        }
        return this._icon;
    }

    @Override
    public void setIcon(Icon icon) {
        this._icon = icon;
    }

    public void setIcon(String iconURL) {
        this._iconURL = iconURL;
    }

    public void setItem(Item item) {
        this._item = item;
    }

    public Item getItem() {
        return this._item;
    }

    private void useBeanInfo() {
        try {
            Class<?> newClass = Class.forName(this.getItem().getLongLabel());
            BeanInfo info = Introspector.getBeanInfo(newClass);
            ImageIcon icon = new ImageIcon(info.getIcon(1));
            if (icon != null) {
                this.setIcon(icon);
            }
        }
        catch (Exception ex) {
            String icon = this.getItem().getIcon();
            if (icon == null) {
                icon = DEFAULT_ICON;
            }
            this.useDefinedImage(icon);
        }
    }

    private void useDefinedImage(String iconURL) {
        if (iconURL == null) {
            return;
        }
        try {
            Toolkit toolkit;
            Image image;
            File file;
            URL url = null;
            int index = iconURL.indexOf("!");
            url = index != -1 ? ((iconURL = iconURL.replace('\\', '/')).indexOf("file:") == -1 ? new URL("jar:file:/" + iconURL) : new URL("jar:" + iconURL)) : this.getClass().getResource(iconURL);
            if (url == null && (file = new File(iconURL)).exists()) {
                url = file.toURL();
            }
            if (url != null && (image = (toolkit = Toolkit.getDefaultToolkit()).getImage(url)) != null) {
                this.setIcon(new ImageIcon(image));
            }
        }
        catch (Exception ex) {
            this.useDefaultIcon();
        }
    }

    private void useDefaultIcon() {
        URL url = this.getClass().getResource(DEFAULT_ICON);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage(url);
        if (image != null) {
            this.setIcon(new ImageIcon(image));
        }
    }

    private void setIsPointer(boolean isPointer) {
        this._isPointer = isPointer;
    }

    @Override
    public boolean isPointer() {
        return this._isPointer;
    }

    @Override
    public void setCanShow(boolean canShow) {
        this._canShow = canShow;
        this.notifyObservers(this, null);
    }

    @Override
    public boolean canShow() {
        return this._canShow;
    }

    @Override
    public void setEditor(String editor) {
        this._item.setEditor(editor);
    }

    @Override
    public String getEditor() {
        return this._item.getEditor();
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == DataFlavor.stringFlavor) {
            Transferable t = this.getTrans(false, null);
            if (t == null) {
                return "";
            }
            return t.getTransferData(flavor);
        }
        if (this.isDataFlavorSupported(flavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor == DataFlavor.stringFlavor) {
            return true;
        }
        return PaletteItem.PALETTE_ITEM_FLAVOR == flavor;
    }

    public Transferable getTrans(boolean rightClick, InputEvent triggerEvent) {
        Context context = this._controller.getPaletteWindow().getContext();
        Element[] elems = new Element[]{this};
        context.setSelection(elems);
        String info = "";
        info = this._item.getInfo() == null ? "No Info!" : this._item.getInfo();
        try {
            Object o;
            String editor = this.getItem().getEditor();
            if (editor != null && (o = Class.forName(editor).newInstance()) instanceof PaletteTransferable) {
                PaletteTransferable t = (PaletteTransferable)o;
                t.setContext(context);
                if (rightClick) {
                    return t.getOptionalTransferable();
                }
                return t;
            }
        }
        catch (Exception noEx) {
            // empty catch block
        }
        return null;
    }

    protected PaletteInvokable getPaletteInvokable() {
        return this.paletteInvokable;
    }

    public void paletteInvokeConfigure(Context context) {
        if (this.paletteInvokable != null) {
            this.paletteInvokable.configure(context);
        }
    }

    @Override
    public void setTechnologyScope(String techScope) {
        this._item.setTechnologyScope(techScope);
    }

    @Override
    public String getTechnologyScope() {
        return this._item.getTechnologyScope();
    }

    public boolean getCanRemove() {
        return this._item.getCanRemove();
    }

    @Override
    public boolean hasItem() {
        return this._item != null;
    }

    @Override
    public String getItemIcon() {
        return this._item.getIcon();
    }

    @Override
    public void setItemIcon(String icon) {
        this._item.setIcon(icon);
    }

    @Override
    public String getItemShortLabel() {
        return this._item.getShortLabel();
    }

    @Override
    public void setItemShortLabel(String shortLabel) {
        this._item.setShortLabel(shortLabel);
    }

    @Override
    public String getItemLongLabel() {
        return this._item.getLongLabel();
    }

    @Override
    public void setItemLongLabel(String longLabel) {
        this._item.setLongLabel(longLabel);
    }

    @Override
    public String getItemInfo() {
        return this._item.getInfo();
    }

    @Override
    public void setItemInfo(String info) {
        this._item.setInfo(info);
    }

    @Override
    public String getItemType() {
        return this._item.getType();
    }

    @Override
    public void setItemType(String type) {
        this._item.setType(type);
    }

    @Override
    public float getItemWeight() {
        return this._item.getWeight();
    }

    @Override
    public void setItemWeight(float weight) {
        this._item.setWeight(weight);
    }

    @Override
    public String getItemEditor() {
        return this._item.getEditor();
    }

    @Override
    public void setItemEditor(String editor) {
        this._item.setEditor(editor);
    }

    @Override
    public String getItemLibrary() {
        return this._item.getLibrary();
    }

    @Override
    public void setItemLibrary(String library) {
        this._item.setLibrary(library);
    }

    @Override
    public String getItemBeanInfo() {
        return this._item.getBeanInfo();
    }

    @Override
    public void setItemBeanInfo(String beanInfo) {
        this._item.setBeanInfo(beanInfo);
    }

    @Override
    public String getItemCodeSnippet() {
        return this._item.getCodeSnippet();
    }

    @Override
    public void setItemCodeSnippet(String s) {
        this._item.setCodeSnippet(s);
    }

    @Override
    public boolean getItemIsPersistent() {
        return this._item.getIsPersistent();
    }

    @Override
    public void setItemIsPersistent(boolean persist) {
        this._item.setIsPersistent(persist);
    }

    @Override
    public String getItemHelpable() {
        return this._item.getHelpable();
    }

    @Override
    public void setItemHelpable(String help) {
        this._item.setHelpable(help);
    }

    @Override
    public String getItemProjectConfiguration() {
        return this._item.getProjectConfiguration();
    }

    @Override
    public void setItemProjectConfiguration(String projectConfiguration) {
        this._item.setProjectConfiguration(projectConfiguration);
    }

    @Override
    public String getItemTechnologyScope() {
        return this._item.getTechnologyScope();
    }

    @Override
    public void setItemTechnologyScope(String techScope) {
        this._item.setTechnologyScope(techScope);
    }

    @Override
    public boolean getItemCanRemove() {
        return this._item.getCanRemove();
    }

    @Override
    public void setItemCanRemove(boolean cr) {
        this._item.setCanRemove(cr);
    }

    @Override
    public String getInitializer() {
        return this.initializer;
    }

    @Override
    public void setInitializer(String preInitializer) {
        try {
            if (preInitializer != null) {
                int semiPos = preInitializer.indexOf(";");
                int lastBracket = preInitializer.indexOf("]");
                if (semiPos >= 0) {
                    this.initializer = preInitializer.substring(semiPos + 1, lastBracket);
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }
}

