/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.Component;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Element;
import oracle.ide.palette.Invokable;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PalettePage;
import oracle.ideimpl.palette.PaletteArb;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteImpl;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.ideimpl.palette.PaletteManagerImpl;
import oracle.ideimpl.palette.palettexml.PaletteXML;
import oracle.ideimpl.palette.wizard.WizardManager;

public final class PaletteCommands {
    private static final WizardManager _wizardManager = WizardManager.getInstance();
    private final PaletteController _controller = PaletteController.getInstance();
    private final PaletteImpl _palette = PaletteImpl.getInstance();

    public void invokeItemWizard(PalettePage palettePage) {
        this._palette.setEditPage(palettePage);
        String type = palettePage.getType();
        String[] params = new String[]{"palette"};
        Invokable invokable = _wizardManager.getWizard(type);
        Context context = Ide.getMainWindow().getIdeMainWindowView().getContext();
        Element[] elems = new Element[]{palettePage};
        context.setSelection(elems);
        if (invokable != null) {
            invokable.invoke(context, params);
            PaletteManagerImpl mgr = PaletteManagerImpl.getInstance();
            ((PaletteManager)mgr).updatePaletteUI();
        } else {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)("There is no editor associated with " + type + " pages."), (String)"Error", null);
        }
    }

    public static boolean hasEditor(String type) {
        Invokable invokable = _wizardManager.getWizard(type);
        return invokable != null;
    }

    public boolean removePaletteItem() {
        String page;
        String name = this._controller.getPalette().getActiveItem().getShortLabel();
        PaletteItemImpl paletteItem = (PaletteItemImpl)this._palette.getPaletteItem(name, page = this._controller.getPalette().getActivePage().getShortLabel());
        boolean canRemove = paletteItem.getCanRemove();
        if (!canRemove) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"This item must not be removed from the Component Palette.", (String)"Error", null);
            return false;
        }
        boolean ok = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)PaletteArb.format(95, "\"" + name + "\"", "\"" + page + "\""), (String)PaletteArb.getString(94), null, (boolean)true);
        if (ok) {
            this._palette.removeItem(name, page);
            return true;
        }
        return false;
    }

    public boolean removePalettePage() {
        PalettePage palettePage = this._palette.getActivePage();
        String name = palettePage.getShortLabel();
        boolean canRemove = palettePage.getCanRemove();
        if (canRemove) {
            boolean ok = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)PaletteArb.format(93, "\"" + name + "\""), (String)PaletteArb.getString(92), null, (boolean)true);
            if (ok) {
                this._palette.remove((Element)this._palette.getActivePage());
                return true;
            }
        } else {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)"This page must not be removed from the Component Palette.", (String)"Error", null);
        }
        return false;
    }

    public PaletteImpl getPalette() {
        return this._palette;
    }

    public URL getURLFromPackage(String packageName) {
        URL url = null;
        try {
            url = this.getClass().getResource(packageName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }

    public boolean pageIsValid(String name, Component parent) {
        if (PaletteXML.getPage(name) != null) {
            MessageDialog.information((Component)parent, (Object)("Palette page \"" + name + "\" exists.  Please use a different name."), (String)"Error", null);
            return false;
        }
        String newName = name.trim();
        if (newName.length() == 0) {
            MessageDialog.information((Component)parent, (Object)"You must provide a name for your palette page.", (String)"Error", null);
            return false;
        }
        return true;
    }
}

