/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.palette;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.ide.palette.PaletteLoader;

public class PaletteUtil {
    private static final String _loaderClass = "oracle.ideimpl.palette.PaletteLoaderImpl";

    private PaletteUtil() {
    }

    public static void usage() {
        System.out.println("Palette Util Jdeveloper 9i");
        System.out.println("Usage:  <palette.xml> <palette entry properties file>");
        System.out.println("");
        System.exit(0);
    }

    public static void loadPaletteItems(URL xmlURL, URL propURL) {
        PaletteUtil.getLoader().loadPaletteItems(xmlURL, propURL);
    }

    private static PaletteLoader getLoader() {
        try {
            Class<?> clazz = Class.forName(_loaderClass);
            return (PaletteLoader)clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private static URL getFileURL(String filePath) {
        URL url = null;
        File file = new File(filePath);
        if (file.exists()) {
            try {
                url = file.toURL();
            }
            catch (MalformedURLException muEx) {
                System.out.println("ERROR: URL [" + url.toString() + "] is not valid");
            }
        }
        return url;
    }

    private static void abort(String errorText) {
        System.out.println("ERROR: " + errorText);
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            PaletteUtil.usage();
        }
        URL xmlURL = PaletteUtil.getFileURL(args[0]);
        URL propURL = PaletteUtil.getFileURL(args[1]);
        if (xmlURL == null || propURL == null) {
            PaletteUtil.abort("Invalid Command Line Arguments Given");
        }
        PaletteUtil.loadPaletteItems(xmlURL, propURL);
        System.exit(0);
    }
}

