/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ForwardedTCPIPDaemon;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.Util;
import java.io.PipedOutputStream;
import java.net.Socket;
import java.util.Vector;

public class ChannelForwardedTCPIP
extends Channel {
    static Vector pool = new Vector();
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    private static final int TIMEOUT = 10000;
    SocketFactory factory = null;
    private Socket socket = null;
    private ForwardedTCPIPDaemon daemon = null;
    String target;
    int lport;
    int rport;

    ChannelForwardedTCPIP() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
        this.io = new IO();
        this.connected = true;
    }

    @Override
    public void run() {
        try {
            if (this.lport == -1) {
                Class<?> c = Class.forName(this.target);
                this.daemon = (ForwardedTCPIPDaemon)c.newInstance();
                PipedOutputStream out = new PipedOutputStream();
                this.io.setInputStream(new Channel.PassiveInputStream(out, 32768), false);
                this.daemon.setChannel(this, this.getInputStream(), out);
                Object[] foo = ChannelForwardedTCPIP.getPort(this.getSession(), this.rport);
                this.daemon.setArg((Object[])foo[3]);
                new Thread(this.daemon).start();
            } else {
                this.socket = this.factory == null ? Util.createSocket(this.target, this.lport, 10000) : this.factory.createSocket(this.target, this.lport);
                this.socket.setTcpNoDelay(true);
                this.io.setInputStream(this.socket.getInputStream());
                this.io.setOutputStream(this.socket.getOutputStream());
            }
            this.sendOpenConfirmation();
        }
        catch (Exception e) {
            this.sendOpenFailure(1);
            this.close = true;
            this.disconnect();
            return;
        }
        this.thread = Thread.currentThread();
        Buffer buf = new Buffer(this.rmpsize);
        Packet packet = new Packet(buf);
        int i = 0;
        try {
            while (this.thread != null && this.io != null && this.io.in != null) {
                i = this.io.in.read(buf.buffer, 14, buf.buffer.length - 14 - 84);
                if (i <= 0) {
                    this.eof();
                } else {
                    packet.reset();
                    if (!this.close) {
                        buf.putByte((byte)94);
                        buf.putInt(this.recipient);
                        buf.putInt(i);
                        buf.skip(i);
                        this.getSession().write(packet, this, i);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void getData(Buffer buf) {
        this.setRecipient(buf.getInt());
        this.setRemoteWindowSize(buf.getUInt());
        this.setRemotePacketSize(buf.getInt());
        byte[] addr = buf.getString();
        int port = buf.getInt();
        byte[] orgaddr = buf.getString();
        int orgport = buf.getInt();
        Session _session = null;
        try {
            _session = this.getSession();
        }
        catch (JSchException e) {
            // empty catch block
        }
        Vector vector = pool;
        synchronized (vector) {
            for (int i = 0; i < pool.size(); ++i) {
                Object[] foo = (Object[])pool.elementAt(i);
                if (foo[0] != _session || (Integer)foo[1] != port) continue;
                this.rport = port;
                this.target = (String)foo[2];
                this.lport = foo[3] == null || foo[3] instanceof Object[] ? -1 : (Integer)foo[3];
                if (foo.length < 6) break;
                this.factory = (SocketFactory)foo[5];
                break;
            }
            if (this.target == null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object[] getPort(Session session, int rport) {
        Vector vector = pool;
        synchronized (vector) {
            for (int i = 0; i < pool.size(); ++i) {
                Object[] bar = (Object[])pool.elementAt(i);
                if (bar[0] != session || (Integer)bar[1] != rport) continue;
                return bar;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String[] getPortForwarding(Session session) {
        int i;
        Vector<String> foo = new Vector<String>();
        Vector vector = pool;
        synchronized (vector) {
            for (i = 0; i < pool.size(); ++i) {
                Object[] bar = (Object[])pool.elementAt(i);
                if (bar[0] != session) continue;
                if (bar[3] == null) {
                    foo.addElement(bar[1] + ":" + bar[2] + ":");
                    continue;
                }
                foo.addElement(bar[1] + ":" + bar[2] + ":" + bar[3]);
            }
        }
        String[] bar = new String[foo.size()];
        for (i = 0; i < foo.size(); ++i) {
            bar[i] = (String)foo.elementAt(i);
        }
        return bar;
    }

    static String normalize(String address) {
        if (address == null) {
            return "localhost";
        }
        if (address.length() == 0 || address.equals("*")) {
            return "";
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPort(Session session, String _address_to_bind, int port, String target, int lport, SocketFactory factory) throws JSchException {
        String address_to_bind = ChannelForwardedTCPIP.normalize(_address_to_bind);
        Vector vector = pool;
        synchronized (vector) {
            if (ChannelForwardedTCPIP.getPort(session, port) != null) {
                throw new JSchException("PortForwardingR: remote port " + port + " is already registered.");
            }
            Object[] foo = new Object[]{session, new Integer(port), target, new Integer(lport), address_to_bind, factory};
            pool.addElement(foo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addPort(Session session, String _address_to_bind, int port, String daemon, Object[] arg) throws JSchException {
        String address_to_bind = ChannelForwardedTCPIP.normalize(_address_to_bind);
        Vector vector = pool;
        synchronized (vector) {
            if (ChannelForwardedTCPIP.getPort(session, port) != null) {
                throw new JSchException("PortForwardingR: remote port " + port + " is already registered.");
            }
            Object[] foo = new Object[]{session, new Integer(port), daemon, arg, address_to_bind};
            pool.addElement(foo);
        }
    }

    static void delPort(ChannelForwardedTCPIP c) {
        Session _session = null;
        try {
            _session = c.getSession();
        }
        catch (JSchException jSchException) {
            // empty catch block
        }
        if (_session != null) {
            ChannelForwardedTCPIP.delPort(_session, c.rport);
        }
    }

    static void delPort(Session session, int rport) {
        ChannelForwardedTCPIP.delPort(session, null, rport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session, String address_to_bind, int rport) {
        Vector vector = pool;
        synchronized (vector) {
            Object[] foo = null;
            for (int i = 0; i < pool.size(); ++i) {
                Object[] bar = (Object[])pool.elementAt(i);
                if (bar[0] != session || (Integer)bar[1] != rport) continue;
                foo = bar;
                break;
            }
            if (foo == null) {
                return;
            }
            pool.removeElement(foo);
            if (address_to_bind == null) {
                address_to_bind = (String)foo[4];
            }
            if (address_to_bind == null) {
                address_to_bind = "0.0.0.0";
            }
        }
        Buffer buf = new Buffer(100);
        Packet packet = new Packet(buf);
        try {
            packet.reset();
            buf.putByte((byte)80);
            buf.putString(Util.str2byte("cancel-tcpip-forward"));
            buf.putByte((byte)0);
            buf.putString(Util.str2byte(address_to_bind));
            buf.putInt(rport);
            session.write(packet);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delPort(Session session) {
        int[] rport = null;
        int count = 0;
        Vector vector = pool;
        synchronized (vector) {
            rport = new int[pool.size()];
            for (int i = 0; i < pool.size(); ++i) {
                Object[] bar = (Object[])pool.elementAt(i);
                if (bar[0] != session) continue;
                rport[count++] = (Integer)bar[1];
            }
        }
        for (int i = 0; i < count; ++i) {
            ChannelForwardedTCPIP.delPort(session, rport[i]);
        }
    }

    public int getRemotePort() {
        return this.rport;
    }

    void setSocketFactory(SocketFactory factory) {
        this.factory = factory;
    }
}

