/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.IO;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Packet;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.Util;
import java.io.InputStream;
import java.io.OutputStream;

public class ChannelDirectTCPIP
extends Channel {
    private static final int LOCAL_WINDOW_SIZE_MAX = 131072;
    private static final int LOCAL_MAXIMUM_PACKET_SIZE = 16384;
    String host;
    int port;
    String originator_IP_address = "127.0.0.1";
    int originator_port = 0;

    ChannelDirectTCPIP() {
        this.setLocalWindowSizeMax(131072);
        this.setLocalWindowSize(131072);
        this.setLocalPacketSize(16384);
    }

    @Override
    void init() {
        try {
            this.io = new IO();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws JSchException {
        block20: {
            try {
                Session _session = this.getSession();
                if (!_session.isConnected()) {
                    throw new JSchException("session is down");
                }
                Buffer buf = new Buffer(150);
                Packet packet = new Packet(buf);
                packet.reset();
                buf.putByte((byte)90);
                buf.putString(Util.str2byte("direct-tcpip"));
                buf.putInt(this.id);
                buf.putInt(this.lwsize);
                buf.putInt(this.lmpsize);
                buf.putString(Util.str2byte(this.host));
                buf.putInt(this.port);
                buf.putString(Util.str2byte(this.originator_IP_address));
                buf.putInt(this.originator_port);
                _session.write(packet);
                int retry = 10;
                long start = System.currentTimeMillis();
                long timeout = this.connectTimeout;
                if (timeout != 0L) {
                    retry = 1;
                }
                ChannelDirectTCPIP channelDirectTCPIP = this;
                synchronized (channelDirectTCPIP) {
                    while (this.getRecipient() == -1 && _session.isConnected() && retry > 0) {
                        if (timeout > 0L && System.currentTimeMillis() - start > timeout) {
                            retry = 0;
                            continue;
                        }
                        try {
                            long t = timeout == 0L ? 5000L : timeout;
                            this.notifyme = 1;
                            this.wait(t);
                        }
                        catch (InterruptedException e) {
                        }
                        finally {
                            this.notifyme = 0;
                        }
                        --retry;
                    }
                }
                if (!_session.isConnected()) {
                    throw new JSchException("session is down");
                }
                if (this.getRecipient() == -1) {
                    throw new JSchException("channel is not opened.");
                }
                if (!this.open_confirmation) {
                    throw new JSchException("channel is not opened.");
                }
                this.connected = true;
                if (this.io.in != null) {
                    this.thread = new Thread(this);
                    this.thread.setName("DirectTCPIP thread " + _session.getHost());
                    if (_session.daemon_thread) {
                        this.thread.setDaemon(_session.daemon_thread);
                    }
                    this.thread.start();
                }
            }
            catch (Exception e) {
                this.io.close();
                this.io = null;
                Channel.del(this);
                if (!(e instanceof JSchException)) break block20;
                throw (JSchException)e;
            }
        }
    }

    @Override
    public void run() {
        Buffer buf = new Buffer(this.rmpsize);
        Packet packet = new Packet(buf);
        int i = 0;
        try {
            Session _session = this.getSession();
            while (this.isConnected() && this.thread != null && this.io != null && this.io.in != null) {
                i = this.io.in.read(buf.buffer, 14, buf.buffer.length - 14 - 84);
                if (i <= 0) {
                    this.eof();
                } else if (!this.close) {
                    packet.reset();
                    buf.putByte((byte)94);
                    buf.putInt(this.recipient);
                    buf.putInt(i);
                    buf.skip(i);
                    _session.write(packet, this, i);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.disconnect();
    }

    @Override
    public void setInputStream(InputStream in) {
        this.io.setInputStream(in);
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.io.setOutputStream(out);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setOrgIPAddress(String foo) {
        this.originator_IP_address = foo;
    }

    public void setOrgPort(int foo) {
        this.originator_port = foo;
    }
}

