/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.xspi;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import oracle.ide.Ide;
import oracle.ide.feedback.FeedbackManager;
import oracle.jdevimpl.vcs.xspi.ALMCommitContext;
import oracle.jdevimpl.vcs.xspi.ALMCommitFile;
import oracle.jdevimpl.vcs.xspi.ALMCommitManager;

public class ALMCommitWorker
extends SwingWorker<ALMCommitContext, Object> {
    private final ALMCommitContext _context;
    private final Collection<ALMCommitFile> _files;
    private boolean _started;

    public ALMCommitWorker(ALMCommitContext context) {
        this(context, null);
    }

    public ALMCommitWorker(ALMCommitContext context, Collection<ALMCommitFile> files) {
        this._context = context;
        this._files = files;
    }

    final void start() {
        this._started = true;
        Ide.getWaitCursor().show(0);
        this.execute();
    }

    @Override
    protected final ALMCommitContext doInBackground() throws Exception {
        if (!this._started) {
            throw new IllegalStateException("Worker not executed through the ALMCommitManager");
        }
        this._started = false;
        ALMCommitManager.getALMCommitManager().commitToALM(this._context, this.getFiles());
        return this._context;
    }

    @Override
    protected final void done() {
        Ide.getWaitCursor().hide();
        try {
            this.get();
        }
        catch (InterruptedException ie) {
        }
        catch (ExecutionException ee) {
            FeedbackManager.reportException((Throwable)ee);
        }
    }

    protected Collection<ALMCommitFile> getFiles() {
        return this._files;
    }
}

