/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.xspi;

import java.util.Collection;
import java.util.Map;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.xspi.ALMCommitManager;

public final class ALMCommitContext {
    private final String _vcsId;
    private final Map<String, String> _vcsConnectionCriteria;
    private Long _vcsCommitTime;
    private String _vcsRevisionName;
    private VCSOptionsCustomizer _uiOptionsCustomizer;
    private Collection<Map<String, String>> _uiWorkitems;
    private String _almTeamId;
    private String _almUserId;
    private String _almSourceControlId;
    private String _almConnectorId;
    private String _almConnectorType;
    private Map<String, String> _almConnectionCriteria;
    private boolean _configured;

    public ALMCommitContext(String vcsId, Map<String, String> connectionCriteria) {
        this._vcsId = vcsId;
        this._vcsConnectionCriteria = connectionCriteria;
    }

    public final String getVCSId() {
        return this._vcsId;
    }

    public final Map<String, String> getVCSConnectionCriteria() {
        return this._vcsConnectionCriteria;
    }

    protected String getCommentsFromUI() {
        return this._uiOptionsCustomizer != null ? (String)this._uiOptionsCustomizer.getOptions().get("setting_comments") : null;
    }

    public final void setVCSCommitTime(long commitTime) {
        this._vcsCommitTime = commitTime;
    }

    public final void setVCSRevisionName(String revisionName) {
        this._vcsRevisionName = revisionName;
    }

    public final boolean canCommitToALM() {
        return ALMCommitManager.getALMCommitManager().isConnectedToALM() && (this._uiWorkitems == null || !this._uiWorkitems.isEmpty());
    }

    final void setConfigured(boolean configured) {
        this._configured = configured;
    }

    final boolean isConfigured() {
        return this._configured;
    }

    final void setUIOptionsCustomizer(VCSOptionsCustomizer optionsCustomizer) {
        this._uiOptionsCustomizer = optionsCustomizer;
    }

    final void setALMTeamId(String teamId) {
        this._almTeamId = teamId;
    }

    final String getALMTeamId() {
        return this._almTeamId;
    }

    final void setALMUserId(String userId) {
        this._almUserId = userId;
    }

    final String getALMUserId() {
        return this._almUserId;
    }

    final void setALMConnectionCriteria(Map<String, String> connectionCriteria) {
        this._almConnectionCriteria = connectionCriteria;
    }

    final Map<String, String> getALMConnectionCriteria() {
        return this._almConnectionCriteria;
    }

    final Long getVCSCommitTime() {
        return this._vcsCommitTime;
    }

    final String getVCSRevisionName() {
        return this._vcsRevisionName;
    }

    final void setUIWorkitems(Collection<Map<String, String>> workitems) {
        this._uiWorkitems = workitems;
    }

    final Collection<Map<String, String>> getUIWorkitems() {
        return this._uiWorkitems;
    }

    final String getUIComments() {
        return this.getCommentsFromUI();
    }

    final void setALMSourceControlId(String sourceControlId) {
        this._almSourceControlId = sourceControlId;
    }

    final String getALMSourceControlId() {
        return this._almSourceControlId;
    }

    final void setALMConnectorType(String connectorType) {
        this._almConnectorType = connectorType;
    }

    final String getALMConnectorType() {
        return this._almConnectorType;
    }

    final void setALMConnectorId(String connectorId) {
        this._almConnectorId = connectorId;
    }

    final String getALMConnectorId() {
        return this._almConnectorId;
    }
}

