/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.VirtualFileSystemHelper;
import oracle.ide.util.Assert;

public class ListFilesUtil {
    public static final int OPTION_LIST_FILES = 1;
    public static final int OPTION_LIST_DIRECTORIES = 2;
    public static final int OPTION_RECURSIVE = 4;

    private ListFilesUtil() {
    }

    public static final List<URL> listFiles(URL directoryUrl, int options, String adminFileName) {
        Assert.precondition((boolean)URLFileSystem.isDirectoryPath((URL)directoryUrl));
        if ((options & 4) <= 0) {
            VirtualFileSystemHelper.invalidateDirectory((URL)directoryUrl);
        } else {
            VirtualFileSystemHelper.invalidateDirectoryTree((URL)directoryUrl);
        }
        ArrayList<URL> c = new ArrayList<URL>();
        ListFilesUtil._listFiles(directoryUrl, options, c, adminFileName);
        return c;
    }

    private static final void _listFiles(URL directoryUrl, int options, List<URL> c, String adminFileName) {
        Assert.precondition((boolean)URLFileSystem.isDirectoryPath((URL)directoryUrl));
        URL[] urls = URLFileSystem.list((URL)directoryUrl);
        if (urls == null) {
            return;
        }
        for (int i = 0; i < urls.length; ++i) {
            boolean isDirectoryPath = URLFileSystem.isDirectoryPath((URL)urls[i]);
            if (adminFileName != null && URLFileSystem.getFileName((URL)urls[i]).equals(adminFileName)) continue;
            if ((options & 2) > 0 && isDirectoryPath) {
                c.add(urls[i]);
            }
            if ((options & 1) > 0 && !isDirectoryPath) {
                c.add(urls[i]);
            }
            if (!isDirectoryPath || (options & 4) <= 0) continue;
            ListFilesUtil._listFiles(urls[i], options, c, adminFileName);
        }
    }
}

