/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.ContentType;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.MenuSpec;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.properties.PropertiesPanel;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.util.AccessibleLabel;

public class GeneralPropertiesPanel
extends PropertiesPanel {
    private Element _element;
    private URL _url;
    private Component _component;
    private JLabel _fileIconLabel;
    private JLabel _fileTypeLabel;
    private JLabel _opensWithEditorLabel;
    private JLabel _locationLabel;
    private JLabel _sizeLabel;
    private JLabel _containsLabel;
    private JLabel _modifiedLabel;
    private JLabel _contentTypeLabel;
    private JLabel _attributesLabel;
    private JTextField _fileNameTextField;
    private JTextField _fileTypeTextField;
    private JLabel _opensWithEditorValueLabel;
    private JTextField _locationTextField;
    private JTextField _sizeTextField;
    private JTextField _containsTextField;
    private JTextField _modifiedTextField;
    private JTextField _contentTypeTextField;
    private JTextField _attributesTextField;
    private long _sizeBytes;
    private int _fileCount;
    private int _directoryCount;
    private boolean _stopped;

    public GeneralPropertiesPanel(Element element, URL url) {
        this._element = element;
        this._url = url;
    }

    @Override
    public Component getComponent() {
        if (this._component != null) {
            return this._component;
        }
        boolean isDirectory = URLFileSystem.isDirectory((URL)this._url);
        this.createComponents(this._url, isDirectory);
        this.resComponents(this._url, isDirectory);
        this.initializeComponents(this._url, isDirectory);
        LayoutBuilder layoutBuilder = this.layoutComponents(this._url, isDirectory);
        JPanel panel = new JPanel();
        layoutBuilder.addToPanel((Container)panel);
        Box box = Box.createVerticalBox();
        box.add(panel);
        box.add(Box.createHorizontalStrut(350));
        this._component = box;
        this.populatePropertyComponents(this._url);
        return this._component;
    }

    @Override
    public void stopWorkerThreads() {
        this._stopped = true;
    }

    private void createComponents(URL url, boolean isDirectory) {
        this._fileIconLabel = new JLabel();
        if (!isDirectory) {
            this._opensWithEditorLabel = new JLabel();
            this._contentTypeLabel = new JLabel();
        } else {
            this._containsLabel = new JLabel();
        }
        this._fileTypeLabel = new JLabel();
        this._locationLabel = new JLabel();
        this._sizeLabel = new JLabel();
        this._modifiedLabel = new JLabel();
        this._attributesLabel = new JLabel();
        this._fileNameTextField = new JTextField();
        if (!isDirectory) {
            this._opensWithEditorValueLabel = new AccessibleLabel();
            this._contentTypeTextField = new JTextField();
        } else {
            this._containsTextField = new JTextField();
        }
        this._fileTypeTextField = new JTextField();
        this._locationTextField = new JTextField();
        this._sizeTextField = new JTextField();
        this._modifiedTextField = new JTextField();
        this._attributesTextField = new JTextField();
    }

    private void resComponents(URL url, boolean isDirectory) {
        if (!isDirectory) {
            ResourceUtils.resLabel((JLabel)this._opensWithEditorLabel, (Component)this._opensWithEditorValueLabel, (String)VCSArb.getString(126));
            ResourceUtils.resLabel((JLabel)this._contentTypeLabel, (Component)this._contentTypeTextField, (String)VCSArb.getString(132));
        } else {
            ResourceUtils.resLabel((JLabel)this._containsLabel, (Component)this._containsTextField, (String)VCSArb.getString(129));
        }
        ResourceUtils.resLabel((JLabel)this._fileTypeLabel, (Component)this._fileTypeTextField, (String)VCSArb.getString(125));
        ResourceUtils.resLabel((JLabel)this._locationLabel, (Component)this._locationTextField, (String)VCSArb.getString(127));
        ResourceUtils.resLabel((JLabel)this._sizeLabel, (Component)this._sizeTextField, (String)VCSArb.getString(128));
        ResourceUtils.resLabel((JLabel)this._modifiedLabel, (Component)this._modifiedTextField, (String)VCSArb.getString(130));
        ResourceUtils.resLabel((JLabel)this._attributesLabel, (Component)this._attributesTextField, (String)VCSArb.getString(131));
    }

    private void initializeComponents(URL url, boolean isDirectory) {
        if (!isDirectory) {
            this.initializePropertyComponents(this._contentTypeLabel, this._contentTypeTextField);
        } else {
            this.initializePropertyComponents(this._containsLabel, this._containsTextField);
        }
        this.initializePropertyComponents(null, this._fileNameTextField);
        this.initializePropertyComponents(this._fileTypeLabel, this._fileTypeTextField);
        this.initializePropertyComponents(this._locationLabel, this._locationTextField);
        this.initializePropertyComponents(this._sizeLabel, this._sizeTextField);
        this.initializePropertyComponents(this._modifiedLabel, this._modifiedTextField);
        this.initializePropertyComponents(this._attributesLabel, this._attributesTextField);
    }

    private LayoutBuilder layoutComponents(URL url, boolean isDirectory) {
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets i = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)this._fileIconLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._fileNameTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._fileTypeLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._fileTypeTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        if (!isDirectory && this._element instanceof Node) {
            layoutBuilder.add((Component)this._opensWithEditorLabel, i, 1, false, false);
            layoutBuilder.addHGap();
            layoutBuilder.add((Component)this._opensWithEditorValueLabel, i, 1, false, true);
            layoutBuilder.nl();
            layoutBuilder.addVGap(8);
            layoutBuilder.nl();
        }
        layoutBuilder.add((Component)this._locationLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._locationTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._sizeLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._sizeTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        if (isDirectory) {
            layoutBuilder.add((Component)this._containsLabel, i, 1, false, false);
            layoutBuilder.addHGap();
            layoutBuilder.add((Component)this._containsTextField, i, 1, false, true);
            layoutBuilder.nl();
            layoutBuilder.addVGap(8);
            layoutBuilder.nl();
        }
        layoutBuilder.add((Component)this._modifiedLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._modifiedTextField, i, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap(8);
        layoutBuilder.nl();
        if (!isDirectory) {
            layoutBuilder.add((Component)this._contentTypeLabel, i, 1, false, false);
            layoutBuilder.addHGap();
            layoutBuilder.add((Component)this._contentTypeTextField, i, 1, false, true);
            layoutBuilder.nl();
            layoutBuilder.addVGap(8);
            layoutBuilder.nl();
        }
        layoutBuilder.add((Component)this._attributesLabel, i, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._attributesTextField, i, 1, false, true);
        layoutBuilder.nl();
        return layoutBuilder;
    }

    private void initializePropertyComponents(JLabel label, JComponent propertyComponent) {
        if (propertyComponent instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)propertyComponent;
            textComponent.setBorder(BorderFactory.createEmptyBorder());
            textComponent.setBackground(UIManager.getColor("control"));
            textComponent.setEditable(false);
        }
        if (label == null) {
            return;
        }
        int height = Math.max(label.getPreferredSize().height, propertyComponent.getPreferredSize().height);
        label.setPreferredSize(new Dimension(label.getPreferredSize().width, height));
        propertyComponent.setPreferredSize(new Dimension(propertyComponent.getPreferredSize().width, height));
    }

    private void populatePropertyComponents(URL url) {
        Icon icon;
        boolean isDirectory = URLFileSystem.isDirectory((URL)url);
        this._fileNameTextField.setText(URLFileSystem.getFileName((URL)url));
        this._locationTextField.setText(URLFileSystem.getPlatformPathName((URL)url));
        DocumentInfo docInfo = Recognizer.getDocumentInfo(this._element.getClass());
        Icon icon2 = icon = docInfo != null ? docInfo.getIcon() : null;
        if (icon == null && URLFileSystem.isDirectory((URL)url)) {
            icon = UIManager.getIcon("Tree.openIcon");
        }
        if (icon != null && icon instanceof ImageIcon) {
            icon = new ImageIcon(((ImageIcon)icon).getImage().getScaledInstance(48, 48, 4));
        }
        if (icon != null) {
            this._fileIconLabel.setIcon(icon);
        }
        if (isDirectory) {
            this._fileTypeTextField.setText(VCSArb.getString(137));
        } else {
            this._fileTypeTextField.setText(this.getNodeLabel(docInfo, this._element.getClass()));
        }
        if (!isDirectory && this._element instanceof Node) {
            EditorAddin bestEditorAddin = EditorManager.getEditorManager().getBestEditorAddin((Node)this._element);
            MenuSpec menuSpec = null;
            if (bestEditorAddin != null) {
                menuSpec = bestEditorAddin.getMenuSpecification();
            }
            if (menuSpec != null && menuSpec.label != null) {
                this._opensWithEditorValueLabel.setIcon(menuSpec.getIcon());
                this._opensWithEditorValueLabel.setText(menuSpec.label);
                this._opensWithEditorValueLabel.getAccessibleContext().setAccessibleDescription(menuSpec.label);
            }
        }
        if (!isDirectory) {
            this._sizeBytes = URLFileSystem.getLength((URL)url);
            this.updateAsynchronousValueComponents();
        } else {
            this._sizeBytes = 0L;
            new Thread((Runnable)new AsynchronousValueWorker(url), "GeneralPropertiesPanel").start();
        }
        this._attributesTextField.setText(URLFileSystem.isReadOnly((URL)url) ? VCSArb.getString(133) : VCSArb.getString(134));
        this._modifiedTextField.setText(DateFormat.getDateTimeInstance().format(new Date(URLFileSystem.lastModified((URL)url))));
        if (!isDirectory) {
            ContentType contentType = DocumentExtensions.findContentTypeFromExtension((String)URLFileSystem.getSuffix((URL)url));
            this._contentTypeTextField.setText(contentType == ContentType.TEXT ? VCSArb.getString(135) : VCSArb.getString(136));
        }
    }

    private String getNodeLabel(DocumentInfo docInfo, Class nodeClass) {
        String label;
        String string = label = docInfo != null ? docInfo.getLabel() : null;
        if (label != null) {
            return label;
        }
        label = nodeClass.getName();
        int i = label.lastIndexOf(46);
        return i < 0 || i >= label.length() - 1 ? label : label.substring(i + 1);
    }

    private void updateAsynchronousValueComponents() {
        if (this._sizeTextField != null) {
            this._sizeTextField.setText(this.createSizeString());
        }
        if (this._containsTextField != null) {
            this._containsTextField.setText(this.createContainsString());
        }
    }

    private String createSizeString() {
        long sizeBytes = this._sizeBytes;
        float sizeKilobytes = sizeBytes / 1024L;
        float sizeMegabytes = sizeKilobytes / 1024.0f;
        NumberFormat f = NumberFormat.getInstance();
        String bytesString = VCSArb.format(141, f.format(new Long(sizeBytes)));
        if (sizeMegabytes >= 1.0f) {
            return VCSArb.format(143, f.format(new Float(sizeMegabytes)), bytesString);
        }
        if (sizeKilobytes >= 1.0f) {
            return VCSArb.format(142, f.format(new Float(sizeKilobytes)), bytesString);
        }
        return bytesString;
    }

    private String createContainsString() {
        int fileCount = this._fileCount;
        int directoryCount = this._directoryCount;
        if (fileCount > 0 && directoryCount == 0) {
            return VCSArb.format(138, Integer.toString(fileCount));
        }
        if (fileCount == 0 && directoryCount > 0) {
            return VCSArb.format(140, Integer.toString(directoryCount));
        }
        if (fileCount > 0 && directoryCount > 0) {
            return VCSArb.format(139, Integer.toString(fileCount), Integer.toString(directoryCount));
        }
        return "";
    }

    private class AsynchronousValueWorker
    implements Runnable {
        private final URL _directoryUrl;

        AsynchronousValueWorker(URL directoryUrl) {
            this._directoryUrl = directoryUrl;
        }

        @Override
        public void run() {
            this._run(this._directoryUrl);
        }

        private void _run(URL directoryUrl) {
            if (GeneralPropertiesPanel.this._stopped) {
                return;
            }
            URLFileSystem.FileInfo[] fileInfo = URLFileSystem.ls((URL)directoryUrl, (URLFilter)VCSURLFilters.createNullFilter());
            for (int i = 0; i < fileInfo.length; ++i) {
                if (GeneralPropertiesPanel.this._stopped) {
                    return;
                }
                if (fileInfo[i].isDirectory()) {
                    GeneralPropertiesPanel.this._directoryCount++;
                    this._run(fileInfo[i].getURL());
                    continue;
                }
                GeneralPropertiesPanel.this._fileCount++;
                GeneralPropertiesPanel.this._sizeBytes += fileInfo[i].length();
            }
            GeneralPropertiesPanel.this.updateAsynchronousValueComponents();
        }
    }
}

