/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.util.VCSIgnoreFilters;
import oracle.jdevimpl.vcs.util.CreateFilterPanel;
import oracle.jdevimpl.vcs.util.DefaultCreateFilterPanel;
import oracle.jdevimpl.vcs.util.FileOrFolderFilter;
import oracle.jdevimpl.vcs.util.res.UtilArb;

public class FilterPanel
extends JPanel {
    private Shuttle _shuttle = new Shuttle();
    private JList _availableList = new JList();
    private JList _selectedList = new JList();
    private JLabel _labelAvailable = new JLabel();
    private JLabel _labelSelected = new JLabel();
    private JButton _newFilterButton = new JButton();
    private Class _filterPanelClass = DefaultCreateFilterPanel.class;

    public FilterPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._newFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    CreateFilterPanel pan = (CreateFilterPanel)FilterPanel.this._filterPanelClass.newInstance();
                    URLFilter filter = pan.runDialog(FilterPanel.this);
                    if (filter != null) {
                        ((DefaultListModel)FilterPanel.this._selectedList.getModel()).addElement(filter);
                        VCSIgnoreFilters.addFilterPattern(((FileOrFolderFilter)filter).getFilter());
                    }
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
        });
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        ResourceUtils.resLabel((JLabel)this._labelAvailable, (Component)this._availableList, (String)UtilArb.getString(1));
        ResourceUtils.resLabel((JLabel)this._labelSelected, (Component)this._selectedList, (String)UtilArb.getString(2));
        ResourceUtils.resButton((AbstractButton)this._newFilterButton, (String)UtilArb.getString(3));
        this._shuttle.setFromPicker((ItemPicker)new ListPicker(this._availableList));
        this._shuttle.setToPicker((ItemPicker)new ListPicker(this._selectedList));
        this._labelAvailable.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this._labelSelected.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this._shuttle.add((Component)this._labelAvailable, (Object)"FromHeader");
        this._shuttle.add((Component)this._labelSelected, (Object)"ToHeader");
        String proto = UtilArb.format(8, "*.www");
        this._availableList.setPrototypeCellValue(proto);
        this._availableList.setPrototypeCellValue(proto);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)this._newFilterButton, "East");
        buttonPanel.add(Box.createVerticalStrut(5), "North");
        this._shuttle.add((Component)buttonPanel, (Object)"ToFooter");
        int height = this._newFilterButton.getPreferredSize().height + 5;
        this._shuttle.add(Box.createVerticalStrut(height), (Object)"FromFooter");
        this.add((Component)this._shuttle, "Center");
    }

    public void setFilterPanelClass(Class filterPanelClass) {
        this._filterPanelClass = filterPanelClass;
    }

    public Class getFilterPanelClass() {
        return this._filterPanelClass;
    }

    public Collection getSelectedFilters() {
        ListModel listModel = this._selectedList.getModel();
        int size = listModel.getSize();
        ArrayList al = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            al.add(listModel.getElementAt(i));
        }
        return al;
    }

    public Collection getAvailableFilters() {
        ListModel listModel = this._availableList.getModel();
        int size = listModel.getSize();
        ArrayList al = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            al.add(listModel.getElementAt(i));
        }
        return al;
    }

    public Collection getAllFilters() {
        Collection all = this.getAvailableFilters();
        all.addAll(this.getSelectedFilters());
        return all;
    }

    public void setAvailableFilters(Collection filters) {
        this._availableList.setModel(FilterPanel.createListModel(filters));
    }

    public void setSelectedFilters(Collection filters) {
        this._selectedList.setModel(FilterPanel.createListModel(filters));
    }

    public void setFilterPatterns(Collection filterPatterns, boolean sort) {
        this.setSelectedFilters(this.createFileOrFolderFilters(filterPatterns, sort));
    }

    public Collection<FileOrFolderFilter> createFileOrFolderFilters(Collection<String> filterPatterns, boolean sort) {
        if (sort) {
            Collator stringCollator = (Collator)Collator.getInstance().clone();
            stringCollator.setStrength(0);
            ArrayList<String> l = new ArrayList<String>(filterPatterns);
            Collections.sort(l, stringCollator);
            filterPatterns = l;
        }
        ArrayList<FileOrFolderFilter> importFilters = new ArrayList<FileOrFolderFilter>();
        Iterator<String> itr = filterPatterns.iterator();
        while (itr.hasNext()) {
            String filterPattern = itr.next().toString();
            importFilters.add(new FileOrFolderFilter(this.getPrefixText(filterPattern), filterPattern, true, true));
        }
        return importFilters;
    }

    public Collection getFilterPatterns() {
        Collection importFilters = this.getSelectedFilters();
        ArrayList<String> importFilterPatterns = new ArrayList<String>();
        Iterator itr = importFilters.iterator();
        while (itr.hasNext()) {
            importFilterPatterns.add(((FileOrFolderFilter)itr.next()).getFilter());
        }
        return importFilterPatterns;
    }

    public void setNewFilterButtonText(String text) {
        ResourceUtils.resButton((AbstractButton)this._newFilterButton, (String)text);
    }

    private static ListModel createListModel(Collection coll) {
        DefaultListModel listModel = new DefaultListModel();
        if (coll != null) {
            Iterator i = coll.iterator();
            while (i.hasNext()) {
                listModel.addElement(i.next());
            }
        }
        return listModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runDialog(Component parent) {
        JEWTDialog dialog = JEWTDialog.createDialog((Component)parent, (String)UtilArb.getString(0), (int)7);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_scmdfilterfiles_html");
        dialog.setContent((Component)this);
        dialog.setPreferredSize(400, 300);
        dialog.setResizable(true);
        try {
            dialog.runDialog();
        }
        finally {
            dialog.dispose();
        }
        return !dialog.isCancelled();
    }

    protected String getPrefixText(String text) {
        return UtilArb.format(13, text);
    }
}

