/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.util.HashMap;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.PropertyResolver;
import oracle.ideri.util.BundlePropertyResolver;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSMenuConstants;

public final class ActionUtil {
    private ActionUtil() {
    }

    public static IdeAction getAction(Class resourceClass, int cmdId, String command, String baseRes, final int sharedIconId) {
        IdeAction action = ActionUtil.getAction(resourceClass, cmdId, command, baseRes);
        if (sharedIconId < 0) {
            return action;
        }
        action.addPropertyResolver(new PropertyResolver(){

            public Object get(String key) {
                if ("SmallIcon" != key) {
                    return null;
                }
                try {
                    return VCSIconArb.getInstance().getIconImpl(sharedIconId);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
        return action;
    }

    public static IdeAction getAction(Class resourceClass, int cmdId, String command, String baseRes) {
        IdeAction action = IdeAction.find((int)cmdId);
        if (action == null) {
            action = IdeAction.get((int)cmdId);
            HashMap<String, String> actionToBundle = new HashMap<String, String>();
            actionToBundle.put("SmallIcon", baseRes + "_ICON");
            actionToBundle.put("Name", baseRes + "_NAME");
            actionToBundle.put("NoCtxName", baseRes + "_INDEPENDENT_NAME");
            actionToBundle.put("MnemonicKey", baseRes + "_MNEMONIC");
            actionToBundle.put("ShortDescription", baseRes + "_TOOLTIP");
            action.addPropertyResolver((PropertyResolver)new BundlePropertyResolver(resourceClass.getName(), resourceClass.getClassLoader(), actionToBundle));
            action.putValue("Category", (Object)VCSMenuConstants.ACTION_CATEGORY_VERSIONING);
            action.setEnabled(true);
            action.setCommand(command);
        }
        return action;
    }
}

