/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.profile;

import java.util.HashMap;
import java.util.Map;
import javax.ide.Identifiable;
import javax.ide.util.MetaClass;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdevimpl.vcs.generic.profile.FileSystemInfo;
import oracle.jdevimpl.vcs.generic.profile.InitializableProfileObject;
import oracle.jdevimpl.vcs.generic.profile.StatusInfo;

public final class StatusesInfo
implements InitializableProfileObject {
    private FileSystemInfo _fsInfo;
    private MetaClass _resolverClass;
    private MetaClass _overlayClass;
    private final Map _statuses = new HashMap(20);
    private final Map _statusFilters = new HashMap(20);

    public void setResolverClass(String className) {
        this._resolverClass = new MetaClass(Thread.currentThread().getContextClassLoader(), className);
    }

    public Class getResolverClass() throws ClassNotFoundException {
        return this._resolverClass != null ? this._resolverClass.toClass() : null;
    }

    public void setOverlayProducerClass(String className) {
        this._overlayClass = new MetaClass(Thread.currentThread().getContextClassLoader(), className);
    }

    public Class getOverlayProducerClass() throws ClassNotFoundException {
        return this._overlayClass != null ? this._overlayClass.toClass() : null;
    }

    public void addStatus(Object status) {
        if (!(status instanceof StatusInfo)) {
            throw new IllegalArgumentException();
        }
        this._statuses.put(((StatusInfo)status).getID(), status);
    }

    public StatusInfo getStatus(String id) {
        return (StatusInfo)this._statuses.get(id);
    }

    public void addStatusFilter(Object filter) {
        if (!(filter instanceof VCSStatusFilter)) {
            throw new IllegalArgumentException();
        }
        this._statusFilters.put(filter instanceof Identifiable ? ((Identifiable)filter).getID() : filter.getClass().getName(), filter);
    }

    public VCSStatusFilter getStatusFilter(String id) {
        return (VCSStatusFilter)this._statusFilters.get(id);
    }

    @Override
    public void preInitialize(Object parent) {
        if (!(parent instanceof FileSystemInfo)) {
            throw new IllegalArgumentException();
        }
        this._fsInfo = (FileSystemInfo)parent;
    }

    @Override
    public void postInitialize() {
    }

    protected FileSystemInfo getFileSystemInfo() {
        return this._fsInfo;
    }
}

