/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.profile;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ide.Identifiable;
import javax.swing.Icon;
import oracle.ide.explorer.IconOverlay;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.changelist.ChangeListStatus;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.generic.profile.InitializableProfileObject;
import oracle.jdevimpl.vcs.generic.profile.StatusesInfo;
import oracle.jdevimpl.vcs.generic.util.AbstractIdentifiable;

public class StatusInfo
extends AbstractIdentifiable
implements InitializableProfileObject,
VCSStatus,
ChangeListStatus {
    private static final Logger sLogger = Logger.getLogger(StatusInfo.class.getName());
    private static final Map sIconReferences = new HashMap(7);
    private StatusesInfo _statusesInfo;
    private boolean _isVersioned;
    private boolean _highlightChangelist;
    private String _shortLabelKey;
    private String _overlayIconKey;
    private String _overlayIconRef;
    private IconOverlay _overlay;
    private boolean _isConflicts;

    public void setConflicts(String isConflicts) {
        this._isConflicts = Boolean.valueOf(isConflicts);
    }

    public boolean isConflicts() {
        return this._isConflicts;
    }

    public void setVersioned(String isVersioned) {
        this._isVersioned = Boolean.valueOf(isVersioned);
    }

    public void setShortLabelKey(String labelKey) {
        this._shortLabelKey = labelKey;
    }

    public void setOverlayIconKey(String iconKey) {
        this._overlayIconKey = iconKey;
    }

    public void setOverlayIconRef(Object o) {
        if (!(o instanceof OverlayIconRefInfo)) {
            throw new IllegalArgumentException("required type: " + OverlayIconRefInfo.class.getName());
        }
        this._overlayIconRef = ((Identifiable)o).getID();
    }

    public void setHighlightChangelist(String trueOrFalse) {
        this._highlightChangelist = Boolean.valueOf(trueOrFalse);
    }

    @Override
    public void preInitialize(Object parent) {
        if (!(parent instanceof StatusesInfo)) {
            throw new IllegalArgumentException();
        }
        this._statusesInfo = (StatusesInfo)parent;
    }

    @Override
    public void postInitialize() {
    }

    @Override
    public boolean isVersioned() {
        return this._isVersioned;
    }

    @Override
    public boolean isCandidate() {
        return !this._isVersioned;
    }

    @Override
    public IconOverlay getOverlay() {
        if (this._overlay == null) {
            ResourcePicker picker = this.getResourcePicker();
            String shortLabel = null;
            Icon iconOverlay = null;
            if (picker != null) {
                shortLabel = this._shortLabelKey != null ? picker.getString(this._shortLabelKey) : null;
                Icon icon = iconOverlay = this._overlayIconKey != null ? picker.getImage(this._overlayIconKey) : null;
            }
            if (iconOverlay == null) {
                iconOverlay = this.resolveIconReference(this._overlayIconRef);
            }
            this._overlay = new IconOverlay(iconOverlay, null, shortLabel);
        }
        return this._overlay;
    }

    @Override
    public String getChangeListLabel() {
        IconOverlay overlay = this.getOverlay();
        if (overlay != null) {
            return overlay.getToolTipText();
        }
        return null;
    }

    @Override
    public boolean isChangeListCellHighlighted() {
        return this._highlightChangelist;
    }

    private ResourcePicker getResourcePicker() {
        try {
            Class rsClass = this._statusesInfo.getFileSystemInfo().getProfileInfo().getRsbundleClass();
            return new ResourcePicker(ResourceBundle.getBundle(rsClass.getName()));
        }
        catch (ClassNotFoundException cnfe) {
            sLogger.severe("unable to load resource bundle class. " + cnfe.getMessage());
            return null;
        }
    }

    private Icon resolveIconReference(String iconRef) {
        int[] id = (int[])sIconReferences.get(iconRef);
        if (id != null) {
            return VCSIconArb.getInstance().getIconImpl(id[0]);
        }
        return null;
    }

    static {
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_ADDED", new int[]{5});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CHECKED_IN", new int[]{3});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CHECKED_OUT", new int[]{1});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CONFLICTS", new int[]{7});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_MODIFIED", new int[]{6});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_REMOVED", new int[]{0});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_UNADDED", new int[]{4});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_UNVERSIONED", new int[]{4});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_NOT_AUTHENTICATED", new int[]{8});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_IGNORED", new int[]{9});
    }

    public static final class OverlayIconRefInfo
    extends AbstractIdentifiable {
        public void setIconId(String id) {
            this.setID(id);
        }

        public String getIconId() {
            return this.getID();
        }
    }
}

