/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.changelist;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import oracle.ide.layout.ViewId;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListDockableFactory;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.VCSProfile;

public class GenericChangeListDockableFactory
extends ChangeListDockableFactory {
    private final String _windowID;
    private final String _windowClassName;
    private final VCSProfile _profile;

    public GenericChangeListDockableFactory(String windowID, String className, VCSProfile profile) {
        super(windowID, null, className);
        this._windowID = ViewId.validate((String)windowID);
        this._windowClassName = className;
        this._profile = profile;
    }

    @Override
    protected ChangeListWindow createChangeListWindow(ChangeList changeList) {
        if (this._windowClassName == null) {
            return new ChangeListWindow(changeList, this._windowID);
        }
        try {
            Class<?> c = Class.forName(this._windowClassName);
            Constructor<?> constructor = c.getConstructor(String.class, VCSProfile.class);
            return (ChangeListWindow)((Object)constructor.newInstance(this.getWindowId(), this._profile));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            e.getTargetException().printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }
}

