/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.jdevimpl.vcs.generic.GenericClient;
import oracle.jdevimpl.vcs.generic.profile.ProfileInfo;
import oracle.jdevimpl.vcs.generic.profile.VCSHookInfo;

public class VCSGenericRegistry {
    private static final VCSGenericRegistry _instance = new VCSGenericRegistry();
    private final Map<String, GenericClient> _registry = new HashMap<String, GenericClient>(10);

    public static final VCSGenericRegistry getInstance() {
        return _instance;
    }

    public void register(String id, GenericClient c) {
        this._registry.put(id, c);
    }

    public void deregister(String id) {
        this._registry.remove(id);
    }

    public GenericClient lookup(String id) {
        return this._registry.get(id);
    }

    public Iterator getRegisteredClients() {
        final Iterator<Map.Entry<String, GenericClient>> it = this._registry.entrySet().iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            public Object next() {
                return ((Map.Entry)it.next()).getValue();
            }

            @Override
            public void remove() {
                it.remove();
            }
        };
    }

    public void addVcsHook(Object o) {
        if (!(o instanceof VCSHookInfo)) {
            throw new IllegalArgumentException();
        }
        VCSHookInfo vcsHook = (VCSHookInfo)o;
        ProfileInfo vcsProfile = vcsHook.getProfile();
        if (vcsProfile != null) {
            this.register(vcsProfile.getID(), new GenericClient(vcsProfile));
        }
    }
}

